/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.ui.itest;

import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.jboss.tools.batch.core.BatchArtifactType;
import org.jboss.tools.batch.ui.BatchUIPlugin;
import org.jboss.tools.batch.ui.internal.wizard.NewBatchArtifactWizard;
import org.jboss.tools.batch.ui.internal.wizard.NewBatchArtifactWizardPage;
import org.jboss.tools.batch.ui.internal.wizard.NewJobXMLCreationWizard;
import org.jboss.tools.common.EclipseUtil;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.test.util.JUnitUtils;
import org.jboss.tools.test.util.WorkbenchUtils;

public class NewBatchWizardTest
extends TestCase {
    public void testNewBeansXMLWizard() throws CoreException {
        context.init("org.jboss.tools.batch.ui.internal.wizard.NewJobXMLCreationWizard");
        try (NewBeansXMLWizardContext context = new NewBeansXMLWizardContext();){
            WizardNewFileCreationPage page = (WizardNewFileCreationPage)((NewJobXMLCreationWizard)context.wizard).getPage("newJobFilePage");
            String s = page.getFileName();
            NewBatchWizardTest.assertEquals((String)"job.xml", (String)s);
            NewBatchWizardTest.assertFalse((boolean)((NewJobXMLCreationWizard)context.wizard).canFinish());
            page.setFileName("job222.xml");
            NewBatchWizardTest.assertTrue((boolean)((NewJobXMLCreationWizard)context.wizard).canFinish());
            String c = page.getContainerFullPath().toString();
            NewBatchWizardTest.assertEquals((String)"/BatchTestProject/src/META-INF/batch-jobs", (String)c);
            NewBatchWizardTest.assertEquals((String)"1.0", (String)((NewJobXMLCreationWizard)context.wizard).getVersion());
            ((NewJobXMLCreationWizard)context.wizard).setID("myNewJob");
            ((NewJobXMLCreationWizard)context.wizard).performFinish();
            IFile f = context.project.getParent().getFile(page.getContainerFullPath().append(page.getFileName()));
            NewBatchWizardTest.assertTrue((boolean)f.exists());
            String text = FileUtil.readStream((InputStream)f.getContents());
            NewBatchWizardTest.assertTrue((text.indexOf("http://xmlns.jcp.org/xml/ns/javaee") > 0 ? 1 : 0) != 0);
            NewBatchWizardTest.assertTrue((text.indexOf("id=\"myNewJob\"") > 0 ? 1 : 0) != 0);
        }
    }

    public void testNewBatchletWizard1() throws CoreException {
        this.doTestNewBatchArtifactWizard(BatchArtifactType.BATCHLET, "SomeBatchlet1", false, null, Arrays.asList("prop1", "prop2"));
    }

    public void testNewBatchletWizard2() throws CoreException {
        this.doTestNewBatchArtifactWizard(BatchArtifactType.BATCHLET, "SomeBatchlet2", true, null, Arrays.asList("prop1"));
    }

    public void testNewDeciderWizard() throws CoreException {
        this.doTestNewBatchArtifactWizard(BatchArtifactType.DECIDER, "SomeDecider", false, null, Arrays.asList("prop1", "prop2"));
    }

    public void testNewItemReaderWizard() throws CoreException {
        this.doTestNewBatchArtifactWizard(BatchArtifactType.ITEM_READER, "SomeReader", false, "aReader", Arrays.asList("prop1", "prop2"));
    }

    public void testNewItemWriterWizard() throws CoreException {
        this.doTestNewBatchArtifactWizard(BatchArtifactType.ITEM_WRITER, "SomeWriter", false, "someGoodWriter", Arrays.asList("prop1", "prop2"));
    }

    public void testNewItemProcessorWizard1() throws CoreException {
        this.doTestNewBatchArtifactWizard(BatchArtifactType.ITEM_PROCESSOR, "SomeProcessor1", false, "fastProcessor1", Arrays.asList("prop1", "prop2"));
    }

    public void testNewItemProcessorWizard2() throws CoreException {
        this.doTestNewBatchArtifactWizard(BatchArtifactType.ITEM_PROCESSOR, "SomeProcessor2", true, "fastProcessor2", Arrays.asList("prop1", "prop2"));
    }

    public void testNewCheckpointAlgorithmWizard() throws CoreException {
        this.doTestNewBatchArtifactWizard(BatchArtifactType.CHECKPOINT_ALGORITHM, "SomeCheckpointAlgorithm", false, "efficient", Arrays.asList("prop1", "prop2"));
    }

    public void testNewPartitionMapperWizard() throws CoreException {
        this.doTestNewBatchArtifactWizard(BatchArtifactType.PARTITION_MAPPER, "SomeMapper", false, "aGoodMapper", Arrays.asList("prop1", "prop2"));
    }

    public void testNewPartitionReducerWizard() throws CoreException {
        this.doTestNewBatchArtifactWizard(BatchArtifactType.PARTITION_REDUCER, "SomeMapper", false, "aGoodReducer", Arrays.asList("prop1", "prop2"));
    }

    public void testNewPartitionCollectorWizard() throws CoreException {
        this.doTestNewBatchArtifactWizard(BatchArtifactType.PARTITION_COLLECTOR, "SomeCollector", false, "aGoodCollector", Arrays.asList("prop1", "prop2"));
    }

    public void testNewPartitionAnalyzerWizard() throws CoreException {
        this.doTestNewBatchArtifactWizard(BatchArtifactType.PARTITION_ANALYZER, "SomeAnalyzer", false, "aGoodAnalyzer", Arrays.asList("prop1", "prop2"));
    }

    public void testNewJobListenerWizard() throws CoreException {
        this.doTestNewBatchArtifactWizard(BatchArtifactType.JOB_LISTENER, "SomeJobListener", false, "aGoodJobListener", Arrays.asList("prop1", "prop2"));
    }

    public void testNewStepListenerWizard() throws CoreException {
        this.doTestNewBatchArtifactWizard(BatchArtifactType.STEP_LISTENER, "SomeStepListener", false, "aGoodStepListener", Arrays.asList("prop1", "prop2"));
    }

    public void testNewChunkListenerWizard() throws CoreException {
        this.doTestNewBatchArtifactWizard(BatchArtifactType.CHUNK_LISTENER, "SomeChunkListener", false, "aGoodChunkListener", Arrays.asList("prop1", "prop2"));
    }

    public void testNewItemReadListenerWizard() throws CoreException {
        this.doTestNewBatchArtifactWizard(BatchArtifactType.ITEM_READ_LISTENER, "SomeItemReadListener", false, "aGoodItemReadListener", Arrays.asList("prop1", "prop2"));
    }

    public void testNewItemWriteListenerWizard() throws CoreException {
        this.doTestNewBatchArtifactWizard(BatchArtifactType.ITEM_WRITE_LISTENER, "SomeItemWriteListener", false, "aGoodItemWriteListener", Arrays.asList("prop1", "prop2"));
    }

    public void testNewItemProcessListenerWizard() throws CoreException {
        this.doTestNewBatchArtifactWizard(BatchArtifactType.ITEM_PROCESS_LISTENER, "SomeItemProcessListener", false, "aGoodItemProcessListener", Arrays.asList("prop1", "prop2"));
    }

    public void testNewSkipReadListenerWizard() throws CoreException {
        this.doTestNewBatchArtifactWizard(BatchArtifactType.SKIP_READ_LISTENER, "SomeSkipReadListener", false, "aGoodSkipReadListener", Arrays.asList("prop1", "prop2"));
    }

    public void testNewSkipWriteListenerWizard() throws CoreException {
        this.doTestNewBatchArtifactWizard(BatchArtifactType.SKIP_WRITE_LISTENER, "SomeSkipWriteListener", false, "aGoodSkipWriteListener", Arrays.asList("prop1", "prop2"));
    }

    public void testNewSkipProcessListenerWizard() throws CoreException {
        this.doTestNewBatchArtifactWizard(BatchArtifactType.SKIP_PROCESS_LISTENER, "SomeSkipProcessListener", false, "aGoodSkipProcessListener", Arrays.asList("prop1", "prop2"));
    }

    public void testNewRetryReadListenerWizard() throws CoreException {
        this.doTestNewBatchArtifactWizard(BatchArtifactType.RETRY_READ_LISTENER, "SomeRetryReadListener", false, "aGoodRetryReadListener", Arrays.asList("prop1", "prop2"));
    }

    public void testNewRetryWriteListenerWizard() throws CoreException {
        this.doTestNewBatchArtifactWizard(BatchArtifactType.RETRY_WRITE_LISTENER, "SomeRetryWriteListener", false, "aGoodRetryWriteListener", Arrays.asList("prop1", "prop2"));
    }

    public void testNewRetryProcessListenerWizard() throws CoreException {
        this.doTestNewBatchArtifactWizard(BatchArtifactType.RETRY_PROCESS_LISTENER, "SomeRetryProcessListener", false, "aGoodRetryProcessListener", Arrays.asList("prop1", "prop2"));
    }

    private void doTestNewBatchArtifactWizard(BatchArtifactType type, String typeName, boolean deriveFromInterface, String artifactName, List<String> properties) throws CoreException {
        context.init("org.jboss.tools.batch.ui.internal.wizard.NewBatchArtifactWizard", "batch", typeName);
        try (NewBatchArtifactWizardContext context = new NewBatchArtifactWizardContext();){
            NewBatchArtifactWizardPage page = ((NewBatchArtifactWizard)context.wizard).getPage();
            page.setArtifact(type, true);
            if (deriveFromInterface) {
                page.setDeriveFromInterface();
            }
            if (artifactName != null) {
                page.setArtifactName(artifactName);
            }
            if (properties != null && !properties.isEmpty()) {
                page.setProperties(properties);
            }
            ((NewBatchArtifactWizard)context.wizard).performFinish();
            String text = context.getNewTypeContent();
            if (type.getClassName() != null && !deriveFromInterface) {
                NewBatchWizardTest.assertTrue((boolean)text.contains("extends " + this.getElememtName(type.getClassName())));
            } else {
                NewBatchWizardTest.assertTrue((boolean)text.contains("implements " + this.getElememtName(type.getInterfaceName())));
            }
            NewBatchWizardTest.assertTrue((boolean)text.contains("@Named"));
            if (artifactName != null) {
                NewBatchWizardTest.assertTrue((boolean)text.contains("@Named(\"" + artifactName + "\")"));
            }
            if (properties != null && !properties.isEmpty()) {
                NewBatchWizardTest.assertTrue((boolean)text.contains("@Inject"));
                NewBatchWizardTest.assertTrue((boolean)text.contains("@BatchProperty"));
                for (String s : properties) {
                    NewBatchWizardTest.assertTrue((boolean)text.contains("String " + s + ";"));
                }
            }
            context.findType().getResource().delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private String getElememtName(String qName) {
        return qName.substring(qName.lastIndexOf(46) + 1);
    }

    static class NewBatchArtifactWizardContext
    extends NewWizardContext<NewBatchArtifactWizard> {
        String packName;
        String typeName;
        NewTypeWizardPage page;

        NewBatchArtifactWizardContext() {
        }

        public void init(String wizardId, String packName, String typeName) {
            this.wizard = (NewBatchArtifactWizard)WorkbenchUtils.findWizardByDefId((String)wizardId);
            ((NewBatchArtifactWizard)this.wizard).init(BatchUIPlugin.getDefault().getWorkbench(), (IStructuredSelection)new StructuredSelection((Object)this.jp));
            ((NewBatchArtifactWizard)this.wizard).setOpenEditorAfterFinish(false);
            this.open();
            this.page = (NewTypeWizardPage)this.dialog.getSelectedPage();
            this.setTypeName(packName, typeName);
        }

        public void setTypeName(String packName, String typeName) {
            this.packName = packName;
            this.typeName = typeName;
            this.page.setTypeName(typeName, true);
            IPackageFragment pack = this.page.getPackageFragmentRoot().getPackageFragment(packName);
            this.page.setPackageFragment(pack, true);
        }

        public String getNewTypeContent() {
            IType type = this.findType();
            IFile file = (IFile)type.getResource();
            NewBatchWizardTest.assertNotNull((Object)file);
            String text = null;
            try {
                text = FileUtil.readStream((InputStream)file.getContents());
            }
            catch (CoreException e) {
                JUnitUtils.fail((String)("Cannot read from " + file), (Exception)((Object)e));
            }
            return text;
        }

        IType findType() {
            IType type = null;
            try {
                String tn = this.typeName;
                int q = tn.indexOf("<");
                if (q >= 0) {
                    tn = tn.substring(0, q);
                }
                type = this.jp.findType(String.valueOf(this.packName) + "." + tn);
            }
            catch (JavaModelException e) {
                JUnitUtils.fail((String)("Cannot find type " + this.typeName), (Exception)((Object)e));
            }
            return type;
        }
    }

    static class NewBeansXMLWizardContext
    extends NewWizardContext<NewJobXMLCreationWizard> {
        NewBeansXMLWizardContext() {
        }

        public void init(String wizardId) {
            this.wizard = (NewJobXMLCreationWizard)WorkbenchUtils.findWizardByDefId((String)wizardId);
            ((NewJobXMLCreationWizard)this.wizard).init(BatchUIPlugin.getDefault().getWorkbench(), (IStructuredSelection)new StructuredSelection((Object)this.jp));
            ((NewJobXMLCreationWizard)this.wizard).setOpenEditorAfterFinish(false);
            this.open();
        }
    }

    static class NewWizardContext<W extends Wizard> {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("BatchTestProject");
        IJavaProject jp = EclipseUtil.getJavaProject((IProject)this.project);
        WizardDialog dialog;
        W wizard;

        public void open() {
            this.dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.wizard);
            this.dialog.setBlockOnOpen(false);
            this.dialog.open();
        }

        public void close() {
            this.dialog.close();
        }
    }
}

