/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.ui.itest.ca;

import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.contentassist.CustomCompletionProposal;
import org.jboss.tools.batch.ui.editor.internal.model.JobXMLEditor;
import org.jboss.tools.common.base.test.contentassist.AbstractContentAssistantTestCase;
import org.jboss.tools.test.util.ProjectImportTestSetup;

public class ContentAssistantTestCase
extends AbstractContentAssistantTestCase {
    private static final String PROJECT_NAME = "BatchTestProject";
    protected JobXMLEditor jobEditor = null;
    protected StructuredTextEditor jobTextEditor = null;

    public void setUp() throws Exception {
        this.project = ProjectImportTestSetup.loadProject((String)this.getProjectName());
    }

    protected String getProjectName() {
        return PROJECT_NAME;
    }

    protected void obtainTextEditor(IEditorPart editorPart) {
        if (editorPart instanceof JobXMLEditor) {
            this.jobEditor = (JobXMLEditor)editorPart;
        }
        ContentAssistantTestCase.assertNotNull((String)("Cannot get the Job XML Text Editor instance for page \"" + this.fileName + "\""), (Object)this.jobEditor);
        while (Display.getCurrent().readAndDispatch()) {
        }
        this.jobTextEditor = this.jobEditor.getSourceEditor();
        this.textEditor = this.jobTextEditor;
    }

    protected ISourceViewer getTextViewer() {
        return ((StructuredTextEditor)this.textEditor).getTextViewer();
    }

    protected boolean isRelevantProposal(ICompletionProposal proposal) {
        return proposal instanceof CustomCompletionProposal;
    }

    public JobXMLEditor getJobEditor() {
        return this.jobEditor;
    }

    public void setJobEditor(JobXMLEditor jobEditor) {
        this.jobEditor = jobEditor;
    }

    public StructuredTextEditor getJobTextEditor() {
        return this.jobTextEditor;
    }

    public void setJobTextEditor(StructuredTextEditor jobTextEditor) {
        this.jobTextEditor = jobTextEditor;
    }

    public ICompletionProposal[] checkProposals(String fileName, String substring, int offset, String[] proposals, String[] noproposals) {
        ContentAssistantTestCase.assertNotNull((String)("Test project \"" + this.getProjectName() + "\" is not loaded"), (Object)this.project);
        ICompletionProposal[] result = this.checkProposals(fileName, substring, offset, proposals, false);
        int i = 0;
        while (i < noproposals.length) {
            boolean found = this.compareProposal(noproposals[i], null, result);
            ContentAssistantTestCase.assertFalse((String)("Proposal " + noproposals[i] + " should not be found!"), (boolean)found);
            ++i;
        }
        return result;
    }
}

