/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.ui.itest.ca.sapphire;

import org.eclipse.sapphire.ElementList;
import org.jboss.tools.batch.ui.editor.internal.model.Batchlet;
import org.jboss.tools.batch.ui.editor.internal.model.Chunk;
import org.jboss.tools.batch.ui.editor.internal.model.FlowElement;
import org.jboss.tools.batch.ui.editor.internal.model.RefAttributeElement;
import org.jboss.tools.batch.ui.editor.internal.model.Step;
import org.jboss.tools.batch.ui.editor.internal.services.contentproposal.RefProposalService;
import org.jboss.tools.batch.ui.itest.AbstractBatchSapphireEditorTest;

public class ContentProposalTest
extends AbstractBatchSapphireEditorTest {
    public void test() {
        this.editor = this.openEditor("/src/META-INF/batch-jobs/job-ca-2.xml");
        ElementList elements = this.editor.getSchema().getFlowElements();
        for (FlowElement flowElement : elements) {
            if (((String)flowElement.getId().content()).equals("step1")) {
                this.checkStep1((Step)flowElement);
                continue;
            }
            if (!((String)flowElement.getId().content()).equals("step2")) continue;
            this.checkStep2((Step)flowElement);
        }
    }

    private void checkStep1(Step step) {
        this.checkProposals((RefAttributeElement)((Batchlet)step.getBatchletOrChunk().get(0)), 5);
    }

    private void checkStep2(Step step) {
        Chunk chunk = (Chunk)step.getBatchletOrChunk().get(0);
        this.checkProposals((RefAttributeElement)chunk.getReader(), 2);
        this.checkProposals((RefAttributeElement)chunk.getWriter(), 2);
        this.checkProposals((RefAttributeElement)chunk.getProcessor().content(), 1);
    }

    private void checkProposals(RefAttributeElement element, int count) {
        RefProposalService service = (RefProposalService)element.getRef().service(RefProposalService.class);
        ContentProposalTest.assertNotNull((Object)service);
        ContentProposalTest.assertEquals((int)count, (int)service.session().proposals().size());
    }
}

