/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.ui.itest.diagram;

import java.util.List;
import org.eclipse.sapphire.ElementList;
import org.jboss.tools.batch.ui.editor.internal.model.Step;
import org.jboss.tools.batch.ui.editor.internal.services.diagram.connection.BatchDiagramConnectionService;
import org.jboss.tools.batch.ui.itest.AbstractBatchSapphireEditorTest;

public class BatchDiagramConnectionsTest
extends AbstractBatchSapphireEditorTest {
    public void testNextAttributeConnections() {
        this.checkConnections("src/META-INF/batch-jobs/job-connections-next-step.xml", 4);
        this.checkConnections("src/META-INF/batch-jobs/job-connections-next-flow.xml", 4);
        this.checkConnections("src/META-INF/batch-jobs/job-connections-next-split.xml", 4);
    }

    public void testAddAndRemoveConnection() {
        this.editor = this.openEditor("src/META-INF/batch-jobs/job-connections-no-connections.xml");
        BatchDiagramConnectionService cs = this.getConnectionService();
        List connections = cs.list();
        BatchDiagramConnectionsTest.assertEquals((int)0, (int)connections.size());
        ElementList elements = this.editor.getSchema().getFlowElements();
        Step step1 = (Step)elements.get(0);
        Step step2 = (Step)elements.get(1);
        step1.setNext((String)step2.getId().content());
        connections = cs.list();
        BatchDiagramConnectionsTest.assertEquals((int)1, (int)connections.size());
        step1.setNext(null);
        connections = cs.list();
        BatchDiagramConnectionsTest.assertEquals((int)0, (int)connections.size());
    }

    public void testConnectionsOnNewNodes() {
        this.editor = this.openEditor("src/META-INF/batch-jobs/job-connections-empty.xml");
        BatchDiagramConnectionService cs = this.getConnectionService();
        List connections = cs.list();
        BatchDiagramConnectionsTest.assertEquals((int)0, (int)connections.size());
        ElementList elements = this.editor.getSchema().getFlowElements();
        Step step1 = (Step)elements.insert(Step.class);
        Step step2 = (Step)elements.insert(Step.class);
        step1.setId("step1");
        step2.setId("step2");
        step1.setNext("step2");
        connections = cs.list();
        BatchDiagramConnectionsTest.assertEquals((int)1, (int)connections.size());
        step1.setNext(null);
        connections = cs.list();
        BatchDiagramConnectionsTest.assertEquals((int)0, (int)connections.size());
    }

    private void checkConnections(String file, int count) {
        this.editor = this.openEditor(file);
        BatchDiagramConnectionService cs = this.getConnectionService();
        List connections = cs.list();
        BatchDiagramConnectionsTest.assertNotNull((Object)connections);
        BatchDiagramConnectionsTest.assertEquals((int)count, (int)connections.size());
    }

    private BatchDiagramConnectionService getConnectionService() {
        BatchDiagramConnectionService connService = (BatchDiagramConnectionService)this.getDiagramPage().service(BatchDiagramConnectionService.class);
        BatchDiagramConnectionsTest.assertNotNull((Object)connService);
        return connService;
    }
}

