/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.ui.itest.diagram;

import java.io.File;
import java.util.List;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ui.diagram.DiagramConnectionPart;
import org.jboss.tools.batch.ui.editor.internal.model.Step;
import org.jboss.tools.batch.ui.editor.internal.services.diagram.connection.BatchDiagramConnectionService;
import org.jboss.tools.batch.ui.editor.internal.services.diagram.layout.persistence.BatchDiagramLayoutPersistenceService;
import org.jboss.tools.batch.ui.itest.AbstractBatchSapphireEditorTest;
import org.jboss.tools.common.util.FileUtil;

public class BatchDiagramLayoutTest
extends AbstractBatchSapphireEditorTest {
    public void testAddAndRemoveConnection() throws Exception {
        this.editor = this.openEditor("src/META-INF/batch-jobs/job-layout.xml");
        BatchDiagramConnectionService cs = this.getConnectionService();
        List connections = cs.list();
        BatchDiagramLayoutTest.assertEquals((int)0, (int)connections.size());
        ElementList elements = this.editor.getSchema().getFlowElements();
        Step step1 = (Step)elements.get(0);
        Step step2 = (Step)elements.get(1);
        step1.setNext((String)step2.getId().content());
        connections = cs.list();
        BatchDiagramLayoutTest.assertEquals((int)1, (int)connections.size());
        DiagramConnectionPart c = (DiagramConnectionPart)connections.get(0);
        c.addBendpoint(0, 101, 102);
        BatchDiagramLayoutPersistenceService s = (BatchDiagramLayoutPersistenceService)this.getDiagramPage().service(BatchDiagramLayoutPersistenceService.class);
        BatchDiagramLayoutTest.assertNotNull((Object)s);
        File file = s.getLayoutPersistenceFile();
        BatchDiagramLayoutTest.assertNotNull((Object)s);
        s.save();
        BatchDiagramLayoutTest.assertTrue((boolean)file.exists());
        String content = FileUtil.readFile((File)file);
        BatchDiagramLayoutTest.assertTrue((content.indexOf("x=\"101\"") > 0 ? 1 : 0) != 0);
        BatchDiagramLayoutTest.assertTrue((content.indexOf("y=\"102\"") > 0 ? 1 : 0) != 0);
        file.delete();
    }

    private BatchDiagramConnectionService getConnectionService() {
        BatchDiagramConnectionService connService = (BatchDiagramConnectionService)this.getDiagramPage().service(BatchDiagramConnectionService.class);
        BatchDiagramLayoutTest.assertNotNull((Object)connService);
        return connService;
    }
}

