/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.ui.itest.diagram;

import java.util.List;
import org.jboss.tools.batch.ui.editor.internal.model.Flow;
import org.jboss.tools.batch.ui.editor.internal.model.FlowElementsContainer;
import org.jboss.tools.batch.ui.editor.internal.model.Job;
import org.jboss.tools.batch.ui.editor.internal.model.Split;
import org.jboss.tools.batch.ui.itest.AbstractBatchSapphireEditorTest;

public class BatchDiagramNavigationTest
extends AbstractBatchSapphireEditorTest {
    public void testTwoEditorTabs() {
        this.editor = this.openEditor("src/META-INF/batch-jobs/job-nested-flows.xml");
        List editorParts = this.editor.getEditorPageParts();
        BatchDiagramNavigationTest.assertEquals((String)"Unexpected number of editor tabs.", (int)2, (int)editorParts.size());
    }

    public void testNestedFlowsTraversal() {
        this.editor = this.openEditor("src/META-INF/batch-jobs/job-nested-flows.xml");
        this.editor.setActivePage("Diagram");
        BatchDiagramNavigationTest.assertEquals((String)"/myJob", (String)this.getDiagramPage().getPageHeaderText());
        Job job = this.editor.getSchema();
        Flow flow1 = (Flow)job.getFlowElements().get(0);
        this.editor.changeDiagramContent((FlowElementsContainer)flow1);
        BatchDiagramNavigationTest.assertEquals((String)"/myJob/flow1", (String)this.getDiagramPage().getPageHeaderText());
        Split split = (Split)flow1.getFlowElements().get(0);
        Flow flowNested1 = (Flow)split.getFlows().get(0);
        this.editor.changeDiagramContent((FlowElementsContainer)flowNested1);
        BatchDiagramNavigationTest.assertEquals((String)"/myJob/flow1/split1/flowNested1", (String)this.getDiagramPage().getPageHeaderText());
        this.editor.changeDiagramContent((FlowElementsContainer)flow1);
        BatchDiagramNavigationTest.assertEquals((String)"/myJob/flow1", (String)this.getDiagramPage().getPageHeaderText());
        this.editor.changeDiagramContent((FlowElementsContainer)job);
        BatchDiagramNavigationTest.assertEquals((String)"/myJob", (String)this.getDiagramPage().getPageHeaderText());
    }
}

