/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.seam.config.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.cdi.core.CDICoreNature;
import org.jboss.tools.cdi.core.extension.ICDIExtension;
import org.jboss.tools.cdi.core.extension.feature.IBuildParticipantFeature;
import org.jboss.tools.cdi.core.extension.feature.IValidatorFeature;
import org.jboss.tools.cdi.internal.core.impl.CDIProject;
import org.jboss.tools.cdi.internal.core.impl.definition.TypeDefinition;
import org.jboss.tools.cdi.internal.core.scanner.FileSet;
import org.jboss.tools.cdi.internal.core.validation.CDICoreValidator;
import org.jboss.tools.cdi.seam.config.core.CDISeamConfigCorePlugin;
import org.jboss.tools.cdi.seam.config.core.CDISeamConfigPreferences;
import org.jboss.tools.cdi.seam.config.core.ConfigDefinitionContext;
import org.jboss.tools.cdi.seam.config.core.definition.ConfigTypeDefinition;
import org.jboss.tools.cdi.seam.config.core.definition.SAXNodeProblem;
import org.jboss.tools.cdi.seam.config.core.definition.SeamBeanDefinition;
import org.jboss.tools.cdi.seam.config.core.definition.SeamBeansDefinition;
import org.jboss.tools.cdi.seam.config.core.definition.SeamFieldDefinition;
import org.jboss.tools.cdi.seam.config.core.definition.SeamFieldValueDefinition;
import org.jboss.tools.cdi.seam.config.core.definition.TextSourceReference;
import org.jboss.tools.cdi.seam.config.core.scanner.ConfigFileSet;
import org.jboss.tools.cdi.seam.config.core.scanner.SeamDefinitionBuilder;
import org.jboss.tools.cdi.seam.config.core.validation.SeamConfigValidationMessages;
import org.jboss.tools.cdi.seam.config.core.xml.SAXNode;
import org.jboss.tools.common.EclipseUtil;
import org.jboss.tools.common.java.IParametedType;
import org.jboss.tools.common.java.ParametedType;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.FileAnyImpl;
import org.jboss.tools.common.model.filesystems.impl.FolderImpl;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.preferences.SeverityPreferences;
import org.jboss.tools.common.text.ITextSourceReference;

public class CDISeamConfigExtension
implements ICDIExtension,
IBuildParticipantFeature,
IValidatorFeature {
    private static String ID = "org.jboss.solder.config.xml.bootstrap.XmlConfigExtension";
    private static String ID_30 = "org.jboss.seam.config.xml.bootstrap.XmlConfigExtension";
    ConfigDefinitionContext context = new ConfigDefinitionContext();
    ConfigFileSet fileSet = new ConfigFileSet();

    public static CDISeamConfigExtension getExtension(CDICoreNature project) {
        ICDIExtension result = project.getExtensionManager().getExtensionByRuntime(ID);
        if (result == null) {
            result = project.getExtensionManager().getExtensionByRuntime(ID_30);
        }
        if (result instanceof CDISeamConfigExtension) {
            return (CDISeamConfigExtension)result;
        }
        return null;
    }

    public ConfigDefinitionContext getContext() {
        return this.context;
    }

    public void beginVisiting() {
        this.fileSet = new ConfigFileSet();
    }

    public void visit(IFile file, IPath src, IPath webinf) {
        IPath path = file.getFullPath();
        if (src != null && path.segmentCount() == src.segmentCount() + 2 && "META-INF".equals(path.segments()[path.segmentCount() - 2])) {
            this.addBeansXML(file, this.fileSet);
        } else if (webinf != null && webinf.isPrefixOf(path) && webinf.segmentCount() == path.segmentCount() - 1) {
            this.addBeansXML(file, this.fileSet);
        } else if (src != null && file.getName().endsWith(".java")) {
            try {
                ICompilationUnit unit = EclipseUtil.getCompilationUnit((IFile)file);
                if (unit != null) {
                    IType[] ts;
                    IType[] iTypeArray = ts = unit.getTypes();
                    int n = ts.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IFile f;
                        IType t = iTypeArray[n2];
                        String type = t.getFullyQualifiedName();
                        IPath p = this.context.getWorkingCopy().getPathForPossibleType(type);
                        if (p != null && this.fileSet.getBeanXML(p) == null && (f = this.context.getRootContext().getProject().getProject().getWorkspace().getRoot().getFile(p)).exists()) {
                            this.addBeansXML(f, this.fileSet);
                        }
                        ++n2;
                    }
                }
            }
            catch (CoreException e) {
                CDISeamConfigCorePlugin.getDefault().logError(e);
            }
        }
    }

    public void visitJar(IPath path, IPackageFragmentRoot root, XModelObject beansXML) {
        if (beansXML != null) {
            this.fileSet.setBeanXML(path, beansXML);
            XModelObject seamBeanXML = beansXML.getParent().getChildByPath("seam-beans.xml");
            if (seamBeanXML != null) {
                this.fileSet.setSeamBeanXML(path, seamBeanXML);
            }
        }
    }

    public void buildDefinitions() {
        ArrayList<SeamBeansDefinition> newDefinitions = new ArrayList<SeamBeansDefinition>();
        for (IPath p : this.fileSet.getAllPaths()) {
            boolean isSeamBeans = false;
            XModelObject o = this.fileSet.getBeanXML(p);
            if (o == null) {
                o = this.fileSet.getSeamBeanXML(p);
                isSeamBeans = true;
            }
            if (!(o instanceof FileAnyImpl)) continue;
            FileAnyImpl f = (FileAnyImpl)o;
            if (f.getParent() instanceof FolderImpl) {
                ((FolderImpl)f.getParent()).update();
            }
            String text = f.getAsText();
            IResource resource = (IResource)o.getAdapter(IResource.class);
            Document document = new Document();
            SeamDefinitionBuilder builder = new SeamDefinitionBuilder();
            document.set(text);
            SeamBeansDefinition def = builder.createDefinition(resource, (IDocument)document, this.context.getRootContext().getProject(), this.context.getWorkingCopy());
            def.setFileObject(o);
            newDefinitions.add(def);
            if (isSeamBeans) {
                this.context.getWorkingCopy().addSeamBeanXML(p, def);
                continue;
            }
            this.context.getWorkingCopy().addBeanXML(p, def);
        }
        for (SeamBeansDefinition def : newDefinitions) {
            def.buildTypeDefinitions(this.context.getWorkingCopy());
        }
    }

    public void buildDefinitions(FileSet fileSet) {
    }

    public void buildBeans(CDIProject target) {
    }

    private void addBeansXML(IFile f, ConfigFileSet fileSet) {
        XModelObject beansXML;
        if (f.getName().equals("beans.xml")) {
            XModelObject beansXML2 = this.getObject(f);
            if (beansXML2 != null) {
                fileSet.setBeanXML(f.getFullPath(), beansXML2);
            }
        } else if (f.getName().equals("seam-beans.xml") && (beansXML = this.getObject(f)) != null) {
            fileSet.setSeamBeanXML(f.getFullPath(), beansXML);
        }
    }

    private XModelObject getObject(IFile f) {
        XModelObject o = EclipseResourceUtil.getObjectByResource((IResource)f);
        if (o == null) {
            o = EclipseResourceUtil.createObjectForResource((IResource)f);
        }
        return o;
    }

    public void validateResource(IFile file, CDICoreValidator validator) {
        SeamBeansDefinition def = this.context.getDefinition(file.getFullPath());
        if (def != null) {
            for (SAXNodeProblem problem : def.getUnresolvedNodes()) {
                SAXNode node = problem.getNode();
                String problemId = problem.getProblemId();
                String message = problem.getMessage();
                TextSourceReference ref = new TextSourceReference(def.getFileObject(), (IResource)file, node);
                if ("Unresolved type".equals(problemId)) {
                    validator.addError(message, CDISeamConfigPreferences.UNRESOLVED_TYPE, (ITextSourceReference)ref, (IResource)file);
                    continue;
                }
                if ("Unresolved member".equals(problemId)) {
                    validator.addError(message, CDISeamConfigPreferences.UNRESOLVED_MEMBER, (ITextSourceReference)ref, (IResource)file);
                    continue;
                }
                if ("Unresolved method".equals(problemId)) {
                    validator.addError(message, CDISeamConfigPreferences.UNRESOLVED_METHOD, (ITextSourceReference)ref, (IResource)file);
                    continue;
                }
                if ("Unresolved constructor".equals(problemId)) {
                    validator.addError(message, CDISeamConfigPreferences.UNRESOLVED_CONSTRUCTOR, (ITextSourceReference)ref, (IResource)file);
                    continue;
                }
                if (!"Annotation expected".equals(problemId)) continue;
                validator.addError(message, CDISeamConfigPreferences.ANNOTATION_EXPECTED, (ITextSourceReference)ref, (IResource)file);
            }
            for (SeamBeanDefinition b : def.getBeanDefinitions()) {
                List<SeamFieldDefinition> fs = b.getFields();
                for (SeamFieldDefinition f : fs) {
                    List<SeamFieldValueDefinition> vs = f.getValueDefinitions();
                    if (vs.isEmpty()) continue;
                    for (SeamFieldValueDefinition v : vs) {
                        IParametedType requiredType = v.getRequiredType();
                        SeamBeanDefinition inline = v.getInlineBean();
                        ConfigTypeDefinition d = inline.getConfigType();
                        ParametedType actualType = d.getParametedType();
                        if (requiredType == null || actualType == null || actualType.isAssignableTo((ParametedType)requiredType, true)) continue;
                        String actual = actualType.getSimpleName();
                        String required = requiredType.getSimpleName();
                        String message = NLS.bind((String)SeamConfigValidationMessages.INLINE_BEAN_TYPE_MISMATCH, (Object)actual, (Object)required);
                        validator.addError(message, CDISeamConfigPreferences.INLINE_BEAN_TYPE_MISMATCH, (ITextSourceReference)new TextSourceReference(def.getFileObject(), (IResource)file, inline.getNode()), (IResource)file);
                    }
                }
            }
            List<TypeDefinition> ds = def.getTypeDefinitions();
            for (TypeDefinition d : ds) {
                String message;
                if (d.hasBeanConstructor()) continue;
                ConfigTypeDefinition cd = (ConfigTypeDefinition)d;
                SAXNode n = cd.getConfig().getNode();
                if (d.isAbstract()) {
                    message = NLS.bind((String)SeamConfigValidationMessages.TYPE_IS_ABSTRACT, (Object)cd.getParametedType().getSimpleName());
                    validator.addError(message, CDISeamConfigPreferences.ABSTRACT_TYPE_IS_CONFIGURED_AS_BEAN, (ITextSourceReference)new TextSourceReference(def.getFileObject(), (IResource)file, n), (IResource)file);
                    continue;
                }
                message = NLS.bind((String)SeamConfigValidationMessages.NO_BEAN_CONSTRUCTOR, (Object)cd.getParametedType().getSimpleName());
                validator.addError(message, CDISeamConfigPreferences.BEAN_CONSTRUCTOR_IS_MISSING, (ITextSourceReference)new TextSourceReference(def.getFileObject(), (IResource)file, n), (IResource)file);
            }
        }
    }

    public SeverityPreferences getSeverityPreferences() {
        return CDISeamConfigPreferences.getInstance();
    }
}

