/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.core;

import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.jboss.tools.common.el.core.resolver.TypeInfoCollector;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.internal.core.SeamProject;
import org.jboss.tools.seam.internal.core.SeamResourceVisitor;
import org.jboss.tools.seam.internal.core.scanner.IFileScanner;
import org.jboss.tools.seam.internal.core.scanner.java.JavaScanner;
import org.jboss.tools.seam.internal.core.scanner.lib.LibraryScanner;
import org.jboss.tools.seam.internal.core.scanner.xml.XMLScanner;

public class SeamCoreBuilder
extends IncrementalProjectBuilder {
    public static String BUILDER_ID = "org.jboss.tools.seam.core.seambuilder";

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        SeamProject seamProject = (SeamProject)SeamCorePlugin.getSeamProject(this.getProject(), false);
        SeamResourceVisitor resourceVisitor = new SeamResourceVisitor(seamProject);
        long begin = System.currentTimeMillis();
        seamProject.postponeFiring();
        try {
            seamProject.build();
            TypeInfoCollector.cleanCache();
            IResourceDelta delta = this.getDelta(this.getProject());
            if (seamProject.hasNoStorage() && !seamProject.isBuilt() || delta == null) {
                this.getProject().accept((IResourceVisitor)resourceVisitor);
            } else {
                delta.accept((IResourceDeltaVisitor)resourceVisitor);
            }
            long end = System.currentTimeMillis();
            seamProject.fullBuildTime += end - begin;
            seamProject.setBuilt(true);
            seamProject.postBuild();
        }
        finally {
            seamProject.fireChanges();
        }
        return null;
    }

    public static IFileScanner createXMLScanner() {
        return new XMLScanner();
    }

    public static IFileScanner createJavaScanner() {
        return new JavaScanner();
    }

    public static IFileScanner createLibraryScanner() {
        return new LibraryScanner();
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        ((SeamProject)SeamCorePlugin.getSeamProject(this.getProject(), false)).clean();
    }
}

