/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core;

import java.util.List;
import java.util.Properties;
import org.jboss.tools.common.model.project.ext.IValueInfo;
import org.jboss.tools.common.model.project.ext.event.Change;
import org.jboss.tools.seam.core.ISeamContextVariable;
import org.jboss.tools.seam.core.ISeamElement;
import org.jboss.tools.seam.core.ScopeType;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.internal.core.AbstractSeamDeclaration;
import org.w3c.dom.Element;

public abstract class AbstractContextVariable
extends AbstractSeamDeclaration
implements ISeamContextVariable {
    protected ScopeType scopeType;
    protected String scope;

    @Override
    public ScopeType getScope() {
        if (this.scopeType == null) {
            return ScopeType.UNSPECIFIED;
        }
        return this.scopeType;
    }

    @Override
    public void setScope(ScopeType type) {
        this.scopeType = type;
        this.scope = this.scopeType == null ? null : this.scopeType.toString();
    }

    public void setScopeAsString(String scope) {
        if (scope != null && scope.indexOf(46) >= 0) {
            scope = scope.substring(scope.lastIndexOf(46) + 1);
        }
        this.scope = scope;
        try {
            this.scopeType = scope == null || scope.length() == 0 ? ScopeType.UNSPECIFIED : ScopeType.valueOf(scope.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            SeamCorePlugin.getDefault().logError(e);
        }
    }

    @Override
    public List<Change> merge(ISeamElement s) {
        List changes = super.merge(s);
        AbstractContextVariable f = (AbstractContextVariable)s;
        if (!this.stringsEqual(this.name, f.name)) {
            changes = Change.addChange(changes, (Change)new Change((Object)this, "name", (Object)this.name, (Object)f.name));
            this.name = f.name;
        }
        if (!this.stringsEqual(this.scope, f.scope)) {
            changes = Change.addChange((List)changes, (Change)new Change((Object)this, "scope", (Object)this.scope, (Object)f.scope));
            this.scope = f.scope;
            this.scopeType = f.scopeType;
        }
        return changes;
    }

    public void setScope(IValueInfo value) {
        this.attributes.put("scope", value);
        this.setScopeAsString(value == null ? null : value.getValue());
    }

    @Override
    public AbstractContextVariable clone() throws CloneNotSupportedException {
        AbstractContextVariable c = (AbstractContextVariable)super.clone();
        return c;
    }

    @Override
    public Element toXML(Element parent, Properties context) {
        Element element = super.toXML(parent, context);
        if (this.scope != null) {
            element.setAttribute("scope", this.scope);
        }
        return element;
    }

    @Override
    public void loadXML(Element element, Properties context) {
        super.loadXML(element, context);
        if (element.hasAttribute("scope")) {
            this.scope = element.getAttribute("scope");
            this.setScopeAsString(this.scope);
        }
    }
}

