/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.jboss.tools.common.model.project.ext.event.Change;
import org.jboss.tools.common.xml.XMLUtilities;
import org.jboss.tools.seam.core.ISeamElement;
import org.jboss.tools.seam.core.event.ISeamValueList;
import org.jboss.tools.seam.core.event.ISeamValueString;
import org.jboss.tools.seam.internal.core.SeamObject;
import org.jboss.tools.seam.internal.core.SeamValueString;
import org.w3c.dom.Element;

public class SeamValueList
extends SeamObject
implements ISeamValueList {
    List<ISeamValueString> values = new ArrayList<ISeamValueString>();

    @Override
    public List<ISeamValueString> getValues() {
        return this.values;
    }

    public void addValue(ISeamValueString value) {
        this.values.add(value);
        this.adopt(value);
    }

    @Override
    public List<Change> merge(ISeamElement s) {
        List changes = super.merge(s);
        SeamValueList v = (SeamValueList)s;
        if (this.values.size() != v.values.size()) {
            changes = Change.addChange(changes, (Change)new Change((Object)this, "value", this.values, v.values));
        }
        this.values = v.values;
        int i = 0;
        while (i < this.values.size()) {
            this.adopt((SeamObject)((Object)this.values.get(i)));
            ++i;
        }
        return changes;
    }

    @Override
    public SeamValueList clone() throws CloneNotSupportedException {
        SeamValueList c = (SeamValueList)super.clone();
        c.values = new ArrayList<ISeamValueString>();
        for (ISeamValueString v : this.values) {
            c.addValue(v.clone());
        }
        return c;
    }

    @Override
    public String getXMLName() {
        return "value";
    }

    @Override
    public String getXMLClass() {
        return "list";
    }

    @Override
    public Element toXML(Element parent, Properties context) {
        Element element = super.toXML(parent, context);
        for (ISeamValueString entry : this.values) {
            SeamObject o = (SeamObject)((Object)entry);
            o.toXML(element, context);
        }
        return element;
    }

    @Override
    public void loadXML(Element element, Properties context) {
        super.loadXML(element, context);
        Element[] cs = XMLUtilities.getChildren((Element)element, (String)"value");
        int i = 0;
        while (i < cs.length) {
            SeamValueString entry = new SeamValueString();
            entry.loadXML(cs[i], context);
            this.addValue(entry);
            ++i;
        }
    }
}

