/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core;

import java.util.List;
import java.util.Properties;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.project.ext.IValueInfo;
import org.jboss.tools.common.model.project.ext.event.Change;
import org.jboss.tools.common.model.util.NamespaceMapping;
import org.jboss.tools.seam.core.ISeamElement;
import org.jboss.tools.seam.core.ISeamXmlComponentDeclaration;
import org.jboss.tools.seam.core.ScopeType;
import org.jboss.tools.seam.internal.core.SeamProject;
import org.jboss.tools.seam.internal.core.SeamPropertiesDeclaration;
import org.jboss.tools.seam.internal.core.scanner.xml.XMLScanner;
import org.w3c.dom.Element;

public class SeamXmlComponentDeclaration
extends SeamPropertiesDeclaration
implements ISeamXmlComponentDeclaration {
    String autoCreate = null;
    String className = null;
    String installed = null;
    String jndiName = null;
    String precedence = "20";
    String scope = null;
    boolean isClassNameGuessed = false;

    @Override
    public String getAutoCreateAsString() {
        return this.autoCreate;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public boolean isClassNameGuessed() {
        return this.isClassNameGuessed;
    }

    @Override
    public boolean getInstalledAsString() {
        return !"false".equals(this.installed);
    }

    @Override
    public String getJndiName() {
        return this.jndiName;
    }

    @Override
    public String getPrecedence() {
        return this.precedence;
    }

    @Override
    public ScopeType getScope() {
        if (this.scope == null || this.scope.length() == 0) {
            return ScopeType.UNSPECIFIED;
        }
        try {
            return ScopeType.valueOf(this.scope.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return ScopeType.UNSPECIFIED;
        }
    }

    @Override
    public String getScopeAsString() {
        return this.scope;
    }

    @Override
    public boolean isAutoCreate() {
        return "true".equals(this.autoCreate);
    }

    @Override
    public boolean isInstalled() {
        return !"false".equals(this.installed);
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setClassName(IValueInfo value) {
        this.attributes.put("class", value);
        this.setClassName(value == null ? null : value.getValue());
    }

    public void setClassNameGuessed(boolean b) {
        this.isClassNameGuessed = b;
    }

    public void setAutoCreate(String autoCreate) {
        this.autoCreate = autoCreate;
    }

    public void setAutoCreate(IValueInfo value) {
        this.attributes.put("auto-create", value);
        this.setAutoCreate(value == null ? null : value.getValue());
    }

    public void setInstalled(String installed) {
        this.installed = installed;
    }

    public void setInstalled(IValueInfo value) {
        this.attributes.put("installed", value);
        this.setInstalled(value == null ? null : value.getValue());
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public void setJndiName(IValueInfo value) {
        this.attributes.put("jndi-name", value);
        this.setJndiName(value == null ? null : value.getValue());
    }

    public void setPrecedence(String precedence) {
        this.precedence = precedence;
        if (precedence == null || precedence.length() == 0) {
            this.precedence = "20";
        }
    }

    public void setPrecedence(IValueInfo value) {
        this.attributes.put("precedence", value);
        this.setPrecedence(value == null ? null : value.getValue());
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setScope(IValueInfo value) {
        this.attributes.put("scope", value);
        this.setScope(value == null ? null : value.getValue());
    }

    @Override
    public List<Change> merge(ISeamElement s) {
        List changes = super.merge(s);
        SeamXmlComponentDeclaration xd = (SeamXmlComponentDeclaration)s;
        if (!this.stringsEqual(this.className, xd.className)) {
            changes = Change.addChange(changes, (Change)new Change((Object)this, "class", (Object)this.className, (Object)xd.className));
            this.className = xd.className;
        }
        this.isClassNameGuessed = xd.isClassNameGuessed;
        if (!this.stringsEqual(this.autoCreate, xd.autoCreate)) {
            changes = Change.addChange((List)changes, (Change)new Change((Object)this, "auto-create", (Object)this.autoCreate, (Object)xd.autoCreate));
            this.autoCreate = xd.autoCreate;
        }
        if (!this.stringsEqual(this.installed, xd.installed)) {
            changes = Change.addChange((List)changes, (Change)new Change((Object)this, "installed", (Object)this.installed, (Object)xd.installed));
            this.installed = xd.installed;
        }
        if (!this.stringsEqual(this.jndiName, xd.jndiName)) {
            changes = Change.addChange((List)changes, (Change)new Change((Object)this, "jndi-name", (Object)this.jndiName, (Object)xd.jndiName));
            this.jndiName = xd.jndiName;
        }
        if (!this.stringsEqual(this.precedence, xd.precedence)) {
            changes = Change.addChange((List)changes, (Change)new Change((Object)this, "precedence", (Object)this.precedence, (Object)xd.precedence));
            this.precedence = xd.precedence;
        }
        if (!this.stringsEqual(this.scope, xd.scope)) {
            changes = Change.addChange((List)changes, (Change)new Change((Object)this, "scope", (Object)this.scope, (Object)xd.scope));
            this.scope = xd.scope;
        }
        return changes;
    }

    @Override
    public SeamXmlComponentDeclaration clone() throws CloneNotSupportedException {
        SeamXmlComponentDeclaration c = (SeamXmlComponentDeclaration)super.clone();
        return c;
    }

    @Override
    public String getXMLClass() {
        return "xml";
    }

    @Override
    public Element toXML(Element parent, Properties context) {
        Element element = super.toXML(parent, context);
        if (this.isClassNameGuessed) {
            element.setAttribute("isClassNameGuessed", "true");
        }
        return element;
    }

    @Override
    public void loadXML(Element element, Properties context) {
        super.loadXML(element, context);
        this.setAutoCreate((IValueInfo)this.attributes.get("auto-create"));
        this.setInstalled((IValueInfo)this.attributes.get("installed"));
        this.setJndiName((IValueInfo)this.attributes.get("jndi-name"));
        this.setPrecedence((IValueInfo)this.attributes.get("precedence"));
        this.setScope((IValueInfo)this.attributes.get("scope"));
        this.setClassName((IValueInfo)this.attributes.get("class"));
        this.isClassNameGuessed = "true".equals(element.getAttribute("isClassNameGuessed"));
        if (this.className == null && this.id instanceof XModelObject) {
            XModelObject c = (XModelObject)this.id;
            if (c.getModelEntity().getName().equals("FileSeamComponent12")) {
                this.className = XMLScanner.getImpliedClassName(c, this.source);
                this.isClassNameGuessed = true;
            } else {
                XModelObject f = c;
                while (f != null && f.getFileType() != 1) {
                    f = f.getParent();
                }
                NamespaceMapping nm = NamespaceMapping.load((XModelObject)f);
                SeamProject sp = (SeamProject)context.get("seamProject");
                this.className = XMLScanner.getDefaultClassName(c, nm, sp);
                this.isClassNameGuessed = true;
            }
        }
    }
}

