/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core;

import java.util.List;
import java.util.Properties;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.project.ext.IValueInfo;
import org.jboss.tools.common.model.project.ext.event.Change;
import org.jboss.tools.common.model.util.FindObjectHelper;
import org.jboss.tools.seam.core.ISeamElement;
import org.jboss.tools.seam.core.ISeamXmlFactory;
import org.jboss.tools.seam.internal.core.AbstractContextVariable;
import org.w3c.dom.Element;

public class SeamXmlFactory
extends AbstractContextVariable
implements ISeamXmlFactory {
    static String METHOD = "method";
    static String VALUE = "value";
    String method = null;
    String value = null;

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setMethod(String method) {
        this.method = method;
    }

    public void setMethod(IValueInfo value) {
        this.attributes.put(METHOD, value);
        this.setMethod(value == null ? null : value.getValue());
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    public void setValue(IValueInfo value) {
        this.attributes.put(VALUE, value);
        this.setValue(value == null ? null : value.getValue());
    }

    @Override
    public List<Change> merge(ISeamElement s) {
        List changes = super.merge(s);
        SeamXmlFactory xf = (SeamXmlFactory)s;
        if (!this.stringsEqual(this.value, xf.value)) {
            changes = Change.addChange(changes, (Change)new Change((Object)this, VALUE, (Object)this.value, (Object)xf.value));
            this.value = xf.value;
        }
        if (!this.stringsEqual(this.method, xf.method)) {
            changes = Change.addChange((List)changes, (Change)new Change((Object)this, METHOD, (Object)this.method, (Object)xf.method));
            this.method = xf.method;
        }
        return changes;
    }

    @Override
    public SeamXmlFactory clone() throws CloneNotSupportedException {
        SeamXmlFactory c = (SeamXmlFactory)super.clone();
        return c;
    }

    @Override
    public String getXMLName() {
        return "factory";
    }

    @Override
    public String getXMLClass() {
        return "xml";
    }

    @Override
    public Element toXML(Element parent, Properties context) {
        Element element = super.toXML(parent, context);
        return element;
    }

    @Override
    public void loadXML(Element element, Properties context) {
        super.loadXML(element, context);
        if (this.attributes.get(METHOD) != null) {
            this.setMethod((IValueInfo)this.attributes.get(METHOD));
        }
        if (this.attributes.get(VALUE) != null) {
            this.setValue((IValueInfo)this.attributes.get(VALUE));
        }
    }

    @Override
    public void open() {
        if (this.id instanceof XModelObject) {
            XModelObject o = (XModelObject)this.id;
            FindObjectHelper.findModelObject((XModelObject)o, (int)FindObjectHelper.IN_EDITOR_ONLY);
        }
    }
}

