/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core.el;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.BadLocationException;
import org.jboss.tools.common.el.core.model.ELExpression;
import org.jboss.tools.common.el.core.model.ELInstance;
import org.jboss.tools.common.el.core.model.ELInvocationExpression;
import org.jboss.tools.common.el.core.model.ELModel;
import org.jboss.tools.common.el.core.parser.ELParser;
import org.jboss.tools.common.el.core.parser.ELParserUtil;
import org.jboss.tools.common.el.core.resolver.ELResolution;
import org.jboss.tools.common.el.core.resolver.ELSegment;
import org.jboss.tools.common.el.core.resolver.JavaMemberELSegmentImpl;
import org.jboss.tools.common.el.core.resolver.TypeInfoCollector;
import org.jboss.tools.common.java.IJavaSourceReference;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.seam.core.BijectedAttributeType;
import org.jboss.tools.seam.core.IBijectedAttribute;
import org.jboss.tools.seam.core.ISeamComponent;
import org.jboss.tools.seam.core.ISeamComponentMethod;
import org.jboss.tools.seam.core.ISeamContextShortVariable;
import org.jboss.tools.seam.core.ISeamContextVariable;
import org.jboss.tools.seam.core.ISeamJavaComponentDeclaration;
import org.jboss.tools.seam.core.ISeamMessages;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.ISeamXmlFactory;
import org.jboss.tools.seam.core.SeamComponentMethodType;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.internal.core.el.SeamELCompletionEngine;

public class SeamExpressionResolver {
    public static List<ISeamContextVariable> resolveVariables(ISeamProject project, IFile context, String name, boolean onlyEqualNames) {
        if (project == null || name == null) {
            return null;
        }
        ISeamProject parent = project.getParentProject();
        if (parent != null) {
            project = parent;
        }
        ISeamJavaComponentDeclaration declaration = null;
        if (context != null) {
            Set<ISeamComponent> cs = project.getComponentsByPath(context.getFullPath());
            for (ISeamComponent c : cs) {
                ISeamJavaComponentDeclaration d = c.getJavaDeclaration();
                if (d == null || !context.getFullPath().equals((Object)d.getSourcePath())) continue;
                declaration = d;
            }
        }
        return SeamExpressionResolver.internalResolveVariables(project, declaration, name, onlyEqualNames);
    }

    private static List<ISeamContextVariable> internalResolveVariables(ISeamProject project, ISeamJavaComponentDeclaration context, String name, boolean onlyEqualNames) {
        Set<ISeamContextVariable> variables = project.getVariables(context);
        return SeamExpressionResolver.internalResolveVariables(project, context, name, onlyEqualNames, variables);
    }

    private static List<ISeamContextVariable> internalResolveVariables(ISeamProject project, ISeamJavaComponentDeclaration context, String name, boolean onlyEqualNames, Set<ISeamContextVariable> variables) {
        ArrayList<ISeamContextVariable> resolvedVariables = new ArrayList<ISeamContextVariable>();
        if (onlyEqualNames) {
            variables = context != null ? context.getVariablesByName(name) : new HashSet<ISeamContextVariable>();
            if (variables.isEmpty()) {
                variables = project.getVariablesByName(name);
            }
            if (variables != null) {
                resolvedVariables.addAll(variables);
            }
            return resolvedVariables;
        }
        for (ISeamContextVariable variable : variables) {
            String n = variable.getName();
            if (!n.startsWith(name)) continue;
            resolvedVariables.add(variable);
        }
        return resolvedVariables;
    }

    public static IMember getMemberByVariable(ISeamContextVariable variable, boolean onlyEqualNames) {
        ISeamComponent component;
        ISeamJavaComponentDeclaration decl;
        IMember member = null;
        if (variable instanceof ISeamContextShortVariable) {
            return SeamExpressionResolver.getMemberByVariable(((ISeamContextShortVariable)variable).getOriginal(), onlyEqualNames);
        }
        if (variable instanceof ISeamComponent && (decl = (component = (ISeamComponent)variable).getJavaDeclaration()) != null) {
            member = decl.getSourceMember();
        }
        if (member == null && variable instanceof IBijectedAttribute) {
            member = ((IJavaSourceReference)variable).getSourceMember();
        }
        if (member == null && variable instanceof IJavaSourceReference) {
            member = ((IJavaSourceReference)variable).getSourceMember();
        }
        if (member == null && variable instanceof ISeamXmlFactory) {
            ISeamProject project;
            ISeamXmlFactory factory = (ISeamXmlFactory)variable;
            String value = factory.getValue();
            if (value != null && value.length() > 0) {
                if (value.startsWith("#{") || value.startsWith("${")) {
                    value = value.substring(2);
                }
                if (value.endsWith("}")) {
                    value = value.substring(0, value.length() - 1);
                }
            }
            if (value != null && value.length() > 0 && (project = factory.getSeamProject()) != null) {
                List<ISeamContextVariable> resolvedValues = SeamExpressionResolver.resolveVariables(project, null, value, onlyEqualNames);
                for (ISeamContextVariable var : resolvedValues) {
                    if (!var.getName().equals(value)) continue;
                    member = SeamExpressionResolver.getMemberByVariable(var, onlyEqualNames);
                    break;
                }
            }
        }
        return member;
    }

    public static TypeInfoCollector.MemberInfo getMemberInfoByVariable(ISeamContextVariable variable, boolean onlyEqualNames, SeamELCompletionEngine engine, int offset) {
        TypeInfoCollector.MemberInfo member = null;
        if (variable instanceof ISeamContextShortVariable) {
            return SeamExpressionResolver.getMemberInfoByVariable(((ISeamContextShortVariable)variable).getOriginal(), onlyEqualNames, engine, offset);
        }
        if (variable instanceof ISeamMessages) {
            MessagesInfo info = null;
            try {
                info = new MessagesInfo(null, (ISeamMessages)variable);
            }
            catch (JavaModelException e) {
                SeamCorePlugin.getPluginLog().logError((Throwable)e);
            }
            return info;
        }
        if (variable instanceof ISeamComponent) {
            ISeamComponent component = (ISeamComponent)variable;
            IMember unwrapSourceMember = null;
            for (ISeamComponentMethod method : component.getMethods()) {
                if (method.getTypes() == null || !method.getTypes().contains(SeamComponentMethodType.UNWRAP)) continue;
                unwrapSourceMember = method.getSourceMember();
                break;
            }
            if (unwrapSourceMember != null) {
                member = TypeInfoCollector.createMemberInfo(unwrapSourceMember);
            } else {
                ISeamJavaComponentDeclaration decl = component.getJavaDeclaration();
                if (decl != null) {
                    member = TypeInfoCollector.createMemberInfo((IMember)decl.getSourceMember());
                } else {
                    String className = component.getClassName();
                    if (className != null) {
                        IJavaProject project = EclipseResourceUtil.getJavaProject((IProject)component.getSeamProject().getProject());
                        try {
                            IType type = project.findType(className);
                            if (type != null) {
                                member = TypeInfoCollector.createMemberInfo((IMember)type);
                            }
                        }
                        catch (JavaModelException e) {
                            SeamCorePlugin.getDefault().logError(e);
                        }
                    }
                }
            }
        }
        if (member == null && variable instanceof IBijectedAttribute) {
            boolean isDataModel = false;
            BijectedAttributeType[] types = ((IBijectedAttribute)variable).getTypes();
            int i = 0;
            while (i < types.length) {
                if (types[i] == BijectedAttributeType.DATA_BINDER) {
                    isDataModel = true;
                    break;
                }
                ++i;
            }
            member = TypeInfoCollector.createMemberInfo((IMember)((IJavaSourceReference)variable).getSourceMember(), (boolean)isDataModel);
        }
        if (member == null && variable instanceof IJavaSourceReference) {
            member = TypeInfoCollector.createMemberInfo((IMember)((IJavaSourceReference)variable).getSourceMember());
        }
        if (member == null && variable instanceof ISeamXmlFactory) {
            ISeamProject project;
            ISeamXmlFactory factory = (ISeamXmlFactory)variable;
            String value = factory.getValue();
            if (value != null && value.length() > 0) {
                if (value.startsWith("#{") || value.startsWith("${")) {
                    value = value.substring(2);
                }
                if (value.endsWith("}")) {
                    value = value.substring(0, value.length() - 1);
                }
            }
            if (value != null && value.length() > 0 && (project = factory.getSeamProject()) != null) {
                List<ISeamContextVariable> resolvedValues = SeamExpressionResolver.resolveVariables(project, null, value, onlyEqualNames);
                for (ISeamContextVariable var : resolvedValues) {
                    if (!var.getName().equals(value)) continue;
                    member = SeamExpressionResolver.getMemberInfoByVariable(var, onlyEqualNames, engine, offset);
                    break;
                }
            }
            if (member == null) {
                ELExpression ex;
                ELParser p = ELParserUtil.getJbossFactory().createParser();
                ELModel m = p.parse(factory.getValue());
                ELInstance i = m.getInstances().isEmpty() ? null : (ELInstance)m.getInstances().get(0);
                ELExpression eLExpression = ex = i == null ? null : i.getExpression();
                if (ex instanceof ELInvocationExpression) {
                    ELInvocationExpression expr = (ELInvocationExpression)ex;
                    try {
                        ELSegment segment;
                        ELResolution resolution = engine.resolveEL(null, null, (ELExpression)expr, false, offset);
                        if (resolution != null && resolution.isResolved() && (segment = resolution.getLastSegment()) instanceof JavaMemberELSegmentImpl) {
                            member = ((JavaMemberELSegmentImpl)segment).getMemberInfo();
                        }
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        SeamCorePlugin.getDefault().logError(e);
                    }
                    catch (BadLocationException e) {
                        SeamCorePlugin.getDefault().logError(e);
                    }
                }
            }
        }
        return member;
    }

    public static class MessagesInfo
    extends TypeInfoCollector.TypeMemberInfo {
        private ISeamMessages messages;

        protected MessagesInfo(TypeInfoCollector.MemberInfo parentMember, ISeamMessages messages) throws JavaModelException {
            super(null, null, messages.getName(), 0, null, null, false, null);
            this.messages = messages;
            IMember member = (IMember)this.getJavaElement();
            if (member != null) {
                IType type = member.getDeclaringType();
                if (member instanceof IType) {
                    type = (IType)member;
                }
                if (type != null) {
                    this.setSourceType(type);
                    this.setDeclaringTypeQualifiedName(type == null ? null : type.getFullyQualifiedName());
                    this.setName(messages.getName());
                    this.setModifiers(type.getFlags());
                    this.setParentMember(parentMember);
                    if (parentMember == null || parentMember instanceof TypeInfoCollector.TypeMemberInfo) {
                        TypeInfoCollector.TypeInfo typeInfo = new TypeInfoCollector.TypeInfo(type, null, false);
                        this.setDeclaratedType(typeInfo);
                    } else {
                        this.setDeclaratedType((TypeInfoCollector.TypeInfo)parentMember);
                    }
                    this.setDataModel(false);
                    this.setType(type == null ? null : new TypeInfoCollector.Type(null, type));
                }
            }
        }

        public IJavaElement getJavaElement() {
            ISeamComponent c;
            ISeamJavaComponentDeclaration d;
            if (this.messages instanceof IJavaSourceReference) {
                return ((IJavaSourceReference)this.messages).getSourceMember();
            }
            if (this.messages instanceof ISeamComponent && (d = (c = (ISeamComponent)((Object)this.messages)).getJavaDeclaration()) != null) {
                return d.getSourceMember();
            }
            return null;
        }

        public ISeamMessages getMessages() {
            return this.messages;
        }

        public Collection<String> getKeys() {
            return this.messages.getPropertyNames();
        }

        public Map<String, List<XModelObject>> getPropertiesMap() {
            return this.messages.getPropertiesMap();
        }
    }
}

