/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core.project.facet;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import org.apache.tools.ant.types.FilterSet;
import org.apache.tools.ant.types.FilterSetCollection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.format.FormatProcessorXML;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.core.project.facet.SeamVersion;
import org.jboss.tools.seam.internal.core.project.facet.AntCopyUtils;
import org.jboss.tools.seam.internal.core.project.facet.Seam2FacetInstallDelegate;
import org.jboss.tools.seam.internal.core.project.facet.SeamFacetAbstractInstallDelegate;
import org.jboss.tools.seam.internal.core.project.facet.SeamFacetFilterSetFactory;
import org.jboss.tools.seam.internal.core.project.facet.SeamFacetInstallDataModelProvider;
import org.jboss.tools.seam.internal.core.project.facet.SeamLibFileSetProvider;
import org.jboss.tools.seam.internal.core.project.facet.SeamProjectCreator;
import org.jboss.tools.seam.internal.core.project.facet.WtpUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class Seam2ProjectCreator
extends SeamProjectCreator {
    private static final String STRICT = "strict";
    private static final String MODULE_ORDER = "module-order";
    private static AntCopyUtils.FileSet JBOSS_TEST_LIB_FILESET = new AntCopyUtils.FileSet().include("testng.*\\.jar").include("test/hibernate-all\\.jar").include("hibernate-all\\.jar").include("test/jboss-embedded-all.jar").include("jboss-embedded-all.jar").include("test/jboss-embedded-api.jar").include("jboss-embedded-api.jar").include("test/jboss-deployers.jar").include("jboss-deployers.jar").include("test/thirdparty-all\\.jar").include("thirdparty-all\\.jar").include("core.*\\.jar").include("ecj.*\\.jar").exclude(".*/CVS").exclude(".*/\\.svn");

    public Seam2ProjectCreator(IDataModel model, IProject seamWebProject, SeamLibFileSetProvider seamLibFileSetProvider) {
        super(model, seamWebProject, seamLibFileSetProvider);
        this.viewFilterSetCollection.addFilterSet(SeamFacetFilterSetFactory.createHibernateDialectFilterSet(model));
        this.droolsLibFolder = new File(this.seamHomePath, Seam2FacetInstallDelegate.DROOLS_LIB_SEAM_RELATED_PATH);
    }

    @Override
    protected void createEarProject() {
        super.createEarProject();
        if (!SeamCorePlugin.getDefault().hasM2Facet(this.seamWebProject) && this.shouldCopyLibrariesAndTemplates(this.model) && this.shouldCopyLibraries(this.model)) {
            File earContentsFolder = new File(this.earProjectFolder, "EarContent");
            File earLibFolder = new File(earContentsFolder, "lib");
            AntCopyUtils.copyFiles(this.seamLibFolder, earLibFolder, new AntCopyUtils.FileSetFileFilter(new AntCopyUtils.FileSet(this.seamLibFileSetProvider.getEarLibFileSet()).dir(this.seamLibFolder)));
        }
    }

    @Override
    protected boolean createTestProject() {
        AntCopyUtils.FileSet includeLibs;
        File testSrcDir;
        File testLibDir;
        block40: {
            File f;
            int n;
            int n2;
            File[] fileArray;
            if (!((Boolean)this.model.getProperty("seam.test.project.creating")).booleanValue() || !this.shouldCopyLibrariesAndTemplates(this.model)) {
                return false;
            }
            File testProjectDir = new File(this.seamWebProject.getLocation().removeLastSegments(1).toFile(), this.testProjectName);
            testProjectDir.mkdir();
            IVirtualComponent component = ComponentCore.createComponent((IProject)this.seamWebProject);
            IVirtualFolder webRootVirtFolder = component.getRootFolder().getFolder((IPath)new Path("/"));
            testLibDir = new File(testProjectDir, "lib");
            File embededEjbDir = new File(testProjectDir, "bootstrap");
            testSrcDir = new File(testProjectDir, "test-src");
            String seamGenResFolder = this.seamRuntime.getResourceTemplatesDir();
            File dataSourceFile = new File(seamGenResFolder, "datasource-ds.xml");
            File seamPropertiesFile = new File(seamGenResFolder, "seam.properties");
            FilterSet filterSet = new FilterSet();
            filterSet.addFilter("projectName", this.seamWebProject.getName());
            filterSet.addFilter("earProjectName", this.earProjectName);
            filterSet.addFilter("ejbProjectName", this.ejbProjectName);
            filterSet.addFilter("testProjectName", this.testProjectName);
            filterSet.addFilter("runtimeName", WtpUtils.getServerRuntimeName(this.seamWebProject));
            filterSet.addFilter("webRootFolder", webRootVirtFolder.getUnderlyingFolder().getFullPath().removeFirstSegments(1).toString());
            FilterSet jdbcFilterSet = SeamFacetFilterSetFactory.createJdbcFilterSet(this.model);
            filterSet.addConfiguredFilterSet(SeamFacetFilterSetFactory.createHibernateDialectFilterSet(this.model));
            includeLibs = new AntCopyUtils.FileSet(this.getJBossTestLibFileset()).dir(new File(this.seamRuntime.getHomeDir(), "lib"));
            AntCopyUtils.FileSet secondSetincludeLibs = new AntCopyUtils.FileSet(this.getJBossTestLibFileset()).dir(new File(this.seamRuntime.getHomeDir(), "lib/test"));
            File[] firstlibs = includeLibs.getDir().listFiles(new AntCopyUtils.FileSetFileFilter(includeLibs));
            File[] secondLibs = secondSetincludeLibs.getDir().listFiles(new AntCopyUtils.FileSetFileFilter(secondSetincludeLibs));
            HashSet<String> allLibs = new HashSet<String>();
            if (firstlibs != null) {
                fileArray = firstlibs;
                n2 = firstlibs.length;
                n = 0;
                while (n < n2) {
                    f = fileArray[n];
                    allLibs.add(f.getName());
                    ++n;
                }
            }
            if (secondLibs != null) {
                fileArray = secondLibs;
                n2 = secondLibs.length;
                n = 0;
                while (n < n2) {
                    f = fileArray[n];
                    allLibs.add(f.getName());
                    ++n;
                }
            }
            StringBuffer testLibraries = new StringBuffer();
            if (!SeamCorePlugin.getDefault().hasM2Facet(this.seamWebProject)) {
                for (String file : allLibs) {
                    testLibraries.append("\t<classpathentry kind=\"lib\" path=\"lib/" + file + "\"/>\n");
                }
            }
            StringBuffer requiredProjects = new StringBuffer();
            requiredProjects.append("\t<classpathentry combineaccessrules=\"false\" kind=\"src\" path=\"/" + this.seamWebProject.getName() + "\"/>");
            if (!SeamFacetAbstractInstallDelegate.isWarConfiguration(this.model)) {
                requiredProjects.append("\n\t<classpathentry combineaccessrules=\"false\" kind=\"src\" path=\"/" + this.ejbProjectName + "\"/>");
            }
            filterSet.addFilter("testLibraries", testLibraries.toString());
            filterSet.addFilter("requiredProjects", requiredProjects.toString());
            File testTemplateDir = null;
            try {
                testTemplateDir = new File(SeamFacetInstallDataModelProvider.getTemplatesFolder(), "test-seam2");
            }
            catch (IOException e) {
                SeamCorePlugin.getPluginLog().logError((Throwable)e);
                return false;
            }
            AntCopyUtils.FileSet excludeCvsSvn = new AntCopyUtils.FileSet(SeamFacetAbstractInstallDelegate.CVS_SVN).dir(testTemplateDir);
            AntCopyUtils.copyFilesAndFolders(testTemplateDir, testProjectDir, new AntCopyUtils.FileSetFileFilter(excludeCvsSvn), new FilterSetCollection(filterSet), true);
            excludeCvsSvn.dir(new File(this.seamRuntime.getHomeDir(), "bootstrap"));
            AntCopyUtils.copyFilesAndFolders(new File(this.seamRuntime.getHomeDir(), "bootstrap"), embededEjbDir, new AntCopyUtils.FileSetFileFilter(excludeCvsSvn), new FilterSetCollection(), true);
            FilterSetCollection f2 = new FilterSetCollection();
            f2.addFilterSet(filterSet);
            f2.addFilterSet(jdbcFilterSet);
            AntCopyUtils.copyFileToFile(dataSourceFile, new File(testProjectDir, "test-src/META-INF/" + this.seamWebProject.getName() + "-test-ds.xml"), f2, true);
            AntCopyUtils.copyFileToFolder(seamPropertiesFile, testSrcDir, new FilterSetCollection(filterSet), true);
            if (this.getVersion() == SeamVersion.SEAM_2_1 || this.getVersion() == SeamVersion.SEAM_2_2 || this.getVersion() == SeamVersion.SEAM_2_3) {
                FileOutputStream out;
                block42: {
                    Properties seamProperties = new Properties();
                    File testSeamPropertiesFile = new File(testSrcDir, "seam.properties");
                    FileInputStream inStream = null;
                    out = null;
                    try {
                        inStream = new FileInputStream(testSeamPropertiesFile);
                        seamProperties.load(inStream);
                        seamProperties.setProperty("org.jboss.seam.core.init.debug", "false");
                        out = new FileOutputStream(testSeamPropertiesFile);
                        seamProperties.store(out, "debug is explicitly disabled in test to avoid JBIDE-3623");
                    }
                    catch (FileNotFoundException e) {
                        SeamCorePlugin.getPluginLog().logError((Throwable)e);
                        if (inStream != null) {
                            try {
                                inStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block40;
                    }
                    catch (IOException e) {
                        block41: {
                            try {
                                SeamCorePlugin.getPluginLog().logError((Throwable)e);
                                if (inStream == null) break block41;
                            }
                            catch (Throwable throwable) {
                                if (inStream != null) {
                                    try {
                                        inStream.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                                if (out != null) {
                                    try {
                                        out.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                                throw throwable;
                            }
                            try {
                                inStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block40;
                    }
                    if (inStream == null) break block42;
                    try {
                        inStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (!SeamCorePlugin.getDefault().hasM2Facet(this.seamWebProject) && this.shouldCopyLibraries(this.model)) {
            AntCopyUtils.copyFiles(new File(this.seamRuntime.getHomeDir(), "lib"), testLibDir, new AntCopyUtils.FileSetFileFilter(includeLibs));
            AntCopyUtils.copyFiles(new File(this.seamRuntime.getHomeDir(), "lib/test"), testLibDir, new AntCopyUtils.FileSetFileFilter(includeLibs));
        }
        SeamFacetAbstractInstallDelegate.createComponentsProperties(testSrcDir, "", true);
        return true;
    }

    @Override
    protected void createEjbProject() {
        super.createEjbProject();
        if (this.shouldCopyLibrariesAndTemplates(this.model)) {
            AntCopyUtils.copyFileToFolder(new File(this.seamGenResFolder, "security.drl"), new File(this.ejbProjectFolder, "ejbModule/"), true);
        }
    }

    @Override
    protected void configureJBossAppXml() {
        IResource jbossAppXml;
        block25: {
            IStructuredModel model;
            block22: {
                Element root;
                IDOMDocument document;
                block23: {
                    block24: {
                        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.earProjectName);
                        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
                        IVirtualFolder folder = component.getRootFolder();
                        IFolder rootFolder = (IFolder)folder.getUnderlyingFolder();
                        jbossAppXml = rootFolder.findMember("META-INF/jboss-app.xml");
                        if (jbossAppXml == null || !(jbossAppXml instanceof IFile) || !jbossAppXml.exists()) {
                            return;
                        }
                        IModelManager manager = StructuredModelManager.getModelManager();
                        if (manager == null) {
                            return;
                        }
                        model = null;
                        model = manager.getModelForEdit((IFile)jbossAppXml);
                        if (!(model instanceof IDOMModel)) break block22;
                        IDOMModel domModel = (IDOMModel)model;
                        document = domModel.getDocument();
                        root = document.getDocumentElement();
                        if (root != null) break block23;
                        if (model == null) break block24;
                        model.releaseFromEdit();
                    }
                    return;
                }
                try {
                    NodeList children = root.getChildNodes();
                    boolean strictAdded = false;
                    Node firstChild = null;
                    int i = 0;
                    while (i < children.getLength()) {
                        Node currentNode = children.item(i);
                        if (1 == currentNode.getNodeType() && firstChild == null) {
                            firstChild = currentNode;
                        }
                        if (1 == currentNode.getNodeType() && MODULE_ORDER.equals(currentNode.getNodeName())) {
                            this.setValue((Document)document, currentNode, STRICT);
                            strictAdded = true;
                        }
                        ++i;
                    }
                    if (!strictAdded) {
                        Element moduleOrder = document.createElement(MODULE_ORDER);
                        this.setValue((Document)document, moduleOrder, STRICT);
                        if (firstChild != null) {
                            root.insertBefore(moduleOrder, firstChild);
                        } else {
                            root.appendChild(moduleOrder);
                        }
                    }
                    model.save();
                }
                catch (CoreException e) {
                    SeamCorePlugin.getDefault().logError(e);
                    if (model != null) {
                        model.releaseFromEdit();
                    }
                    break block25;
                }
                catch (IOException e) {
                    try {
                        SeamCorePlugin.getDefault().logError(e);
                        break block25;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (model != null) {
                            model.releaseFromEdit();
                        }
                    }
                }
            }
            if (model != null) {
                model.releaseFromEdit();
            }
        }
        try {
            new FormatProcessorXML().formatFile((IFile)jbossAppXml);
        }
        catch (IOException e) {
            SeamCorePlugin.getDefault().logError(e);
        }
        catch (CoreException e) {
            SeamCorePlugin.getDefault().logError(e);
        }
    }

    private void setValue(Document document, Node node, String value) {
        Text text = document.createTextNode(value);
        node.appendChild(text);
    }

    @Override
    protected AntCopyUtils.FileSet getJBossTestLibFileset() {
        return JBOSS_TEST_LIB_FILESET;
    }

    @Override
    protected AntCopyUtils.FileSet getJbossEarContent() {
        return Seam2FacetInstallDelegate.JBOSS_EAR_CONTENT;
    }
}

