/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core.project.facet;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.types.FilterSet;
import org.apache.tools.ant.types.FilterSetCollection;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jst.common.project.facet.core.ClasspathHelper;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.ApplicationFactory;
import org.eclipse.jst.j2ee.application.EjbModule;
import org.eclipse.jst.j2ee.componentcore.util.EARArtifactEdit;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.jst.javaee.core.DisplayName;
import org.eclipse.jst.javaee.core.JavaeeFactory;
import org.eclipse.jst.javaee.core.Listener;
import org.eclipse.jst.javaee.core.ParamValue;
import org.eclipse.jst.javaee.core.UrlPatternType;
import org.eclipse.jst.javaee.web.AuthConstraint;
import org.eclipse.jst.javaee.web.Filter;
import org.eclipse.jst.javaee.web.FilterMapping;
import org.eclipse.jst.javaee.web.SecurityConstraint;
import org.eclipse.jst.javaee.web.Servlet;
import org.eclipse.jst.javaee.web.ServletMapping;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.javaee.web.WebFactory;
import org.eclipse.jst.javaee.web.WebResourceCollection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.SeamCoreMessages;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.core.SeamUtil;
import org.jboss.tools.seam.core.project.facet.SeamProjectPreferences;
import org.jboss.tools.seam.core.project.facet.SeamRuntime;
import org.jboss.tools.seam.core.project.facet.SeamRuntimeManager;
import org.jboss.tools.seam.internal.core.project.facet.AntCopyUtils;
import org.jboss.tools.seam.internal.core.project.facet.ISeamFacetDataModelProperties;
import org.jboss.tools.seam.internal.core.project.facet.SeamFacetFilterSetFactory;
import org.jboss.tools.seam.internal.core.project.facet.SeamFacetInstallDataModelProvider;
import org.jboss.tools.seam.internal.core.project.facet.SeamLibFileSetProvider;
import org.jboss.tools.seam.internal.core.project.facet.SeamProjectCreator;
import org.jboss.tools.seam.internal.core.project.facet.WtpUtils;
import org.osgi.service.prefs.BackingStoreException;

public abstract class SeamFacetAbstractInstallDelegate
implements ILogListener,
IDelegate,
ISeamFacetDataModelProperties,
SeamLibFileSetProvider {
    public static final String MOJARRA_1_2 = "Mojarra-1.2";
    public static final String ORG_JBOSS_JBOSSFACES_JSF_CONFIG_NAME = "org.jboss.jbossfaces.JSF_CONFIG_NAME";
    public static String ORG_RICHFACES_SKIN = "org.richfaces.SKIN";
    public static String ORG_RICHFACES_SKIN_VALUE = "blueSky";
    public static String ORG_JBOSS_SEAM_SERVLET_SEAMLISTENER = "org.jboss.seam.servlet.SeamListener";
    public static String ORG_JBOSS_SEAM_SERVLET_SEAMFILTER = "org.jboss.seam.servlet.SeamFilter";
    public static String ORG_JBOSS_SEAM_SERVLET_SEAMFILTER_NAME = "Seam Filter";
    public static String ORG_JBOSS_SEAM_SERVLET_SEAMFILTER_MAPPING_VALUE = "/*";
    public static String ORG_JBOSS_SEAM_SERVLET_SEAMRESOURCESERVLET = "org.jboss.seam.servlet.SeamResourceServlet";
    public static String ORG_JBOSS_SEAM_SERVLET_SEAMRESOURCESERVLET_NAME = "Seam Resource Servlet";
    public static String ORG_JBOSS_SEAM_SERVLET_SEAMRESOURCESERVLET_VALUE = "/seam/resource/*";
    public static String FACELETS_DEVELOPMENT = "facelets.DEVELOPMENT";
    public static String JAVAX_FACES_DEFAULT_SUFFIX = "javax.faces.DEFAULT_SUFFIX";
    public static String JAVAX_FACES_DEFAULT_SUFFIX_VALUE = ".xhtml";
    public static String RESTRICT_RAW_XHTML = SeamCoreMessages.SeamFacetAbstractInstallDelegate_Restrict_raw_XHTML_Documents;
    public static String XHTML = "XHTML";
    public static String WEB_RESOURCE_COLLECTION_PATTERN = "*.xhtml";
    public static String SEAM_LIB_RELATED_PATH = "lib";
    public static final String DEV_WAR_PROFILE = "dev-war";
    public static final String DEV_EAR_PROFILE = "dev";
    protected IDataModel facetModel;
    public static AntCopyUtils.FileSet JBOOS_EJB_WEB_INF_CLASSES_SET = new AntCopyUtils.FileSet().include("import\\.sql").include("seam\\.properties").exclude(".*/WEB-INF");
    public static AntCopyUtils.FileSet VIEW_FILESET = new AntCopyUtils.FileSet().include("home\\.xhtml").include("error\\.xhtml").include("login\\.xhtml").include("login\\.page.xml").include("index\\.html").include("layout").include("layout/.*").include("stylesheet").include("stylesheet/.*").exclude(".*/.*\\.ftl").exclude(".*/CVS").exclude(".*/\\.svn");
    public static AntCopyUtils.FileSet DEFAULT_JBOOS_WAR_WEBINF_SET = new AntCopyUtils.FileSet().include("WEB-INF").include("WEB-INF/pages\\.xml").include("WEB-INF/jboss-web\\.xml").include("WEB-INF/componets\\.xml");
    public static AntCopyUtils.FileSet JBOOS_WAR_WEB_INF_CLASSES_SET = new AntCopyUtils.FileSet().include("import\\.sql").include("security\\.drl").include("seam\\.properties").include("messages_en\\.properties");
    public static String WEB_LIBRARIES_RELATED_PATH = "WEB-INF/lib";
    static AntCopyUtils.FileSet CVS_SVN = new AntCopyUtils.FileSet().include(".*").exclude(".*/CVS").exclude("CVS").exclude(".*\\.svn").exclude(".*/\\.svn");
    private static IOverwriteQuery OVERWRITE_ALL = new IOverwriteQuery(){

        public String queryOverwrite(String file) {
            return "ALL";
        }
    };
    private IVirtualFolder warDefaultSrcRootFolder;
    protected IVirtualFolder warModelSrcRootFolder;
    protected IVirtualFolder warActionSrcRootFolder;
    protected File seamHomeFolder;
    protected String seamHomePath;
    protected File seamLibFolder;
    protected File seamGenResFolder;
    protected File srcFolder;
    protected File webContentFolder;
    protected IPath webContentPath;
    protected File webLibFolder;
    protected IContainer webRootFolder;
    protected File seamGenHomeFolder;
    protected File seamGenViewSource;
    protected File dataSourceDsFile;
    protected File componentsFile;
    protected File webInfFolder;
    protected File webInfClasses;
    protected File webInfClassesMetaInf;
    protected File persistenceFile;
    protected File hibernateConsoleLaunchFile;
    protected File hibernateConsolePropsFile;
    protected File earContentsFolder;
    protected File earLibFolder;
    protected ProjectType projectType;
    protected FilterSet ejbFilterSet;
    protected FilterSetCollection viewFilterSetCollection;
    protected FilterSet jdbcFilterSet;
    protected FilterSet encodedJdbcFilterSet;
    protected FilterSet projectFilterSet;
    protected FilterSet encodedProjectFilterSet;
    protected FilterSet filtersFilterSet;
    private boolean errorOccurs = false;

    protected AntCopyUtils.FileSet getJBossWarWebinfSet() {
        return DEFAULT_JBOOS_WAR_WEBINF_SET;
    }

    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        try {
            IDataModel model;
            this.startListening();
            this.facetModel = model = (IDataModel)config;
            this.doExecute(project, fv, config, monitor);
            boolean createEarProjects = model.getBooleanProperty("create.ear.projects");
            if (createEarProjects) {
                this.getProjectCreator(model, project, this).execute(monitor);
            }
        }
        finally {
            this.stopListening();
        }
        if (this.errorOccurs) {
            this.errorOccurs = false;
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)SeamCoreMessages.SEAM_FACET_INSTALL_ABSTRACT_DELEGATE_ERROR, (String)SeamCoreMessages.SEAM_FACET_INSTALL_ABSTRACT_DELEGATE_CHECK_ERROR_LOG_VIEW, (IStatus)new Status(4, "org.jboss.tools.seam.core", SeamCoreMessages.SEAM_FACET_INSTALL_ABSTRACT_DELEGATE_ERRORS_OCCURED));
                }
            });
        }
    }

    public static boolean toggleHibernateOnProject(IProject project, String defaultConsoleName) {
        ProjectScope scope = new ProjectScope(project);
        IEclipsePreferences node = scope.getNode("org.hibernate.eclipse.console");
        if (node != null) {
            node.putBoolean("hibernate3.enabled", true);
            node.put("default.configuration", defaultConsoleName);
            try {
                node.flush();
            }
            catch (BackingStoreException e) {
                SeamCorePlugin.getDefault().logError(SeamCoreMessages.SeamFacetAbstractInstallDelegate_Could_not_save_changes_to_preferences, e);
                return false;
            }
        } else {
            return false;
        }
        try {
            SeamFacetAbstractInstallDelegate.addProjectNature(project, "org.hibernate.eclipse.console.hibernateNature", (IProgressMonitor)new NullProgressMonitor());
            return true;
        }
        catch (CoreException ce) {
            SeamCorePlugin.getDefault().logError(String.valueOf(SeamCoreMessages.SeamFacetAbstractInstallDelegate_Could_not_activate_Hibernate_nature_on_project) + project.getName(), ce);
            return false;
        }
    }

    public static boolean addProjectNature(IProject project, String nature, IProgressMonitor monitor) throws CoreException {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (!project.hasNature(nature)) {
            IProjectDescription description = project.getDescription();
            String[] prevNatures = description.getNatureIds();
            String[] newNatures = new String[prevNatures.length + 1];
            System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
            newNatures[prevNatures.length] = nature;
            description.setNatureIds(newNatures);
            project.setDescription(description, monitor);
            return true;
        }
        monitor.worked(1);
        return false;
    }

    public static boolean isWarConfiguration(IDataModel model) {
        return "war".equals(model.getProperty("seam.project.deployment.type"));
    }

    static void createComponentsProperties(File seamGenResFolder, String projectName, Boolean embedded) {
        Properties components = new Properties();
        String prefix = "".equals(projectName) ? "" : String.valueOf(projectName) + "/";
        components.put("embeddedEjb", embedded.toString());
        components.put("jndiPattern", String.valueOf(prefix) + "#{ejbName}/local");
        File componentsProps = new File(seamGenResFolder, "components.properties");
        try {
            componentsProps.createNewFile();
            components.store(new FileOutputStream(componentsProps), "");
        }
        catch (IOException e) {
            SeamCorePlugin.getPluginLog().logError((Throwable)e);
        }
    }

    protected void doExecuteForWar(IProject project, IProjectFacetVersion fv, IDataModel model, IProgressMonitor monitor) throws CoreException {
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        IVirtualFolder webRootVirtFolder = component.getRootFolder().getFolder((IPath)new Path("/"));
        this.warDefaultSrcRootFolder = component.getRootFolder().getFolder((IPath)new Path("/WEB-INF/classes"));
        IContainer[] roots = webRootVirtFolder.getUnderlyingFolders();
        this.webRootFolder = null;
        if (roots.length > 1) {
            IContainer[] iContainerArray = roots;
            int n = roots.length;
            int n2 = 0;
            while (n2 < n) {
                IContainer container = iContainerArray[n2];
                if (!container.getFullPath().toString().contains("/target/")) {
                    this.webRootFolder = container;
                    break;
                }
                ++n2;
            }
        }
        if (this.webRootFolder == null) {
            this.webRootFolder = webRootVirtFolder.getUnderlyingFolder();
        }
        this.webContentFolder = this.webRootFolder.getLocation().toFile();
        this.webContentPath = this.webRootFolder.getFullPath();
        this.webInfFolder = new File(this.webContentFolder, "WEB-INF");
        this.webInfClasses = new File(this.webInfFolder, "classes");
        this.webInfClassesMetaInf = new File(this.webInfClasses, "META-INF");
        this.webInfClassesMetaInf.mkdirs();
        this.webLibFolder = new File(this.webContentFolder, WEB_LIBRARIES_RELATED_PATH);
        File file = this.srcFolder = SeamFacetAbstractInstallDelegate.isWarConfiguration(model) ? new File(this.warDefaultSrcRootFolder.getUnderlyingFolder().getLocation().toFile(), "main") : this.warDefaultSrcRootFolder.getUnderlyingFolder().getLocation().toFile();
        if (model.getBooleanProperty("configure.war.project")) {
            Object runtimeName = model.getProperty("seam.runtime.name");
            if (runtimeName != null) {
                this.copyFilesToWarProject(project, fv, model, monitor);
            } else {
                this.configureWebXml(project);
            }
        }
    }

    protected String getFacesConfigPath(WebApp webApp) {
        if (webApp == null) {
            return "/WEB-INF/faces-config.xml";
        }
        File facesConfig = new File(this.webContentFolder, "/WEB-INF/faces-config.xml");
        if (facesConfig.exists()) {
            return "/WEB-INF/faces-config.xml";
        }
        String path = null;
        for (ParamValue cp : webApp.getContextParams()) {
            if (cp == null || cp.getParamName() == null || !cp.getParamName().trim().equals("javax.faces.CONFIG_FILES") || (path = cp.getParamValue().trim()).length() <= 0 || !(facesConfig = new File(this.webContentFolder, path)).exists()) continue;
            return path;
        }
        return "/WEB-INF/faces-config.xml";
    }

    protected void copyFilesToWarProject(IProject project, IProjectFacetVersion fv, IDataModel model, IProgressMonitor monitor) throws CoreException {
        block9: {
            if (!this.shouldCopyLibrariesAndTemplates(model)) {
                return;
            }
            AntCopyUtils.FileSet viewFileSet = new AntCopyUtils.FileSet(VIEW_FILESET).dir(this.seamGenViewSource);
            AntCopyUtils.copyFilesAndFolders(this.seamGenViewSource, this.webContentFolder, new AntCopyUtils.FileSetFileFilter(viewFileSet), this.viewFilterSetCollection, false);
            FileSystemStructureProvider structureProvider = FileSystemStructureProvider.INSTANCE;
            File rootDir = new File(this.seamGenViewSource, "img");
            IPath imgPath = this.webContentPath.append("img");
            try {
                ImportOperation op = new ImportOperation(imgPath, (Object)rootDir, (IImportStructureProvider)structureProvider, OVERWRITE_ALL);
                op.setCreateContainerStructure(false);
                op.run(monitor);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (!(t instanceof CoreException)) break block9;
                ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)SeamCoreMessages.SeamFacetAbstractInstallDelegate_Error, null, (IStatus)((CoreException)t).getStatus());
            }
        }
        AntCopyUtils.FileSet webInfSet = new AntCopyUtils.FileSet(this.getJBossWarWebinfSet()).dir(this.seamGenResFolder);
        WebApp webApp = this.configureWebXml(project);
        AntCopyUtils.copyFileToFile(this.componentsFile, new File(this.webInfFolder, "components.xml"), new FilterSetCollection(this.projectFilterSet), false);
        String facesConfigPath = this.getFacesConfigPath(webApp);
        this.configureFacesConfigXml(project, monitor, facesConfigPath);
        AntCopyUtils.copyFilesAndFolders(this.seamGenResFolder, this.webContentFolder, new AntCopyUtils.FileSetFileFilter(webInfSet), this.viewFilterSetCollection, false);
        FilterSetCollection hibernateDialectFilterSet = new FilterSetCollection();
        hibernateDialectFilterSet.addFilterSet(this.encodedJdbcFilterSet);
        hibernateDialectFilterSet.addFilterSet(this.encodedProjectFilterSet);
        hibernateDialectFilterSet.addFilterSet(SeamFacetFilterSetFactory.createHibernateDialectFilterSet(model, true));
        IContainer source = this.warDefaultSrcRootFolder.getUnderlyingFolder();
        if (SeamFacetAbstractInstallDelegate.isWarConfiguration(model)) {
            boolean sourcesDoesNotExist = this.warDefaultSrcRootFolder.members().length == 0;
            Path actionSrcPath = new Path(source.getFullPath().removeFirstSegments(1) + "/" + "hot");
            Path modelSrcPath = new Path(source.getFullPath().removeFirstSegments(1) + "/" + "main");
            if (sourcesDoesNotExist) {
                this.warDefaultSrcRootFolder.delete(256, monitor);
                WtpUtils.createSourceFolder(project, (IPath)actionSrcPath, source.getFullPath().removeFirstSegments(1), this.webRootFolder.getFullPath().removeFirstSegments(1).append("WEB-INF/dev"));
                WtpUtils.createSourceFolder(project, (IPath)modelSrcPath, source.getFullPath().removeFirstSegments(1), null);
                IVirtualComponent component = ComponentCore.createComponent((IProject)project);
                this.warModelSrcRootFolder = component.getRootFolder().getFolder((IPath)new Path("/WEB-INF/classes"));
                this.warActionSrcRootFolder = component.getRootFolder().getFolder((IPath)new Path("/WEB-INF/dev"));
                this.warModelSrcRootFolder.createLink((IPath)modelSrcPath, 0, null);
                this.warActionSrcRootFolder.createLink((IPath)actionSrcPath, 0, null);
            } else {
                modelSrcPath = actionSrcPath = source.getFullPath().removeFirstSegments(1);
                this.srcFolder = source.getLocation().toFile();
                this.warActionSrcRootFolder = this.warDefaultSrcRootFolder;
                this.warModelSrcRootFolder = this.warDefaultSrcRootFolder;
            }
            File actionsSrc = new File(project.getLocation().toFile(), actionSrcPath.toOSString());
            AntCopyUtils.FileSet webInfClassesSet = new AntCopyUtils.FileSet(JBOOS_WAR_WEB_INF_CLASSES_SET).dir(this.seamGenResFolder);
            AntCopyUtils.copyFilesAndFolders(this.seamGenResFolder, this.srcFolder, new AntCopyUtils.FileSetFileFilter(webInfClassesSet), this.viewFilterSetCollection, false);
            SeamFacetAbstractInstallDelegate.createComponentsProperties(this.srcFolder, "", false);
            AntCopyUtils.copyFileToFile(new File(this.seamGenHomeFolder, "src/Authenticator.java"), new File(actionsSrc, String.valueOf(model.getProperty("action.package").toString().replace('.', '/')) + "/" + "Authenticator.java"), new FilterSetCollection(this.filtersFilterSet), false);
            AntCopyUtils.copyFileToFile(this.persistenceFile, new File(this.srcFolder, "META-INF/persistence.xml"), this.viewFilterSetCollection, false);
            File resources = new File(project.getLocation().toFile(), "resources");
            AntCopyUtils.copyFileToFile(this.dataSourceDsFile, new File(resources, String.valueOf(project.getName()) + "-ds.xml"), this.viewFilterSetCollection, false);
            if (this.hibernateConsoleLaunchFile != null) {
                AntCopyUtils.copyFileToFile(this.hibernateConsoleLaunchFile, new File(project.getLocation().toFile(), String.valueOf(this.getLaunchCfgName(project.getName())) + ".launch"), this.viewFilterSetCollection, false);
            }
            AntCopyUtils.copyFileToFolder(this.hibernateConsolePropsFile, project.getLocation().toFile(), hibernateDialectFilterSet, false);
            WtpUtils.setClasspathEntryAsExported(project, (IPath)new Path("org.eclipse.jst.j2ee.internal.web.container"), monitor);
        } else {
            AntCopyUtils.copyFileToFolder(new File(this.seamGenResFolder, "messages_en.properties"), this.srcFolder, false);
            WtpUtils.createSourceFolder(project, source.getFullPath().removeFirstSegments(1), source.getFullPath().removeFirstSegments(1), this.webRootFolder.getFullPath().removeFirstSegments(1).append("WEB-INF/dev"));
        }
    }

    protected String getLaunchCfgName(String baseName) {
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        return lm.generateUniqueLaunchConfigurationNameFrom(baseName);
    }

    protected void doExecuteForEar(IProject project, IProjectFacetVersion fv, IDataModel model, IProgressMonitor monitor) throws CoreException {
        if (this.seamHomePath == null) {
            return;
        }
        model.setProperty("seam.ear.project", (Object)project.getName());
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        IVirtualFolder rootVirtFolder = component.getRootFolder().getFolder((IPath)new Path("/"));
        this.earContentsFolder = rootVirtFolder.getUnderlyingFolder().getLocation().toFile();
        this.earLibFolder = new File(this.earContentsFolder, "lib");
        File metaInfFolder = new File(this.earContentsFolder, "META-INF");
        File applicationXml = new File(metaInfFolder, "application.xml");
        File earProjectFolder = project.getLocation().toFile();
        FilterSet earFilterSet = new FilterSet();
        earFilterSet.addFilter("projectName", String.valueOf(project.getName()) + ".ear");
        if (this.shouldCopyLibrariesAndTemplates(model)) {
            AntCopyUtils.copyFileToFolder(new File(this.seamGenResFolder, "META-INF/jboss-app.xml"), metaInfFolder, new FilterSetCollection(earFilterSet), false);
        }
        if (applicationXml.exists()) {
            this.configureApplicationXml(project, monitor);
        }
        if (this.shouldCopyLibrariesAndTemplates(model)) {
            try {
                AntCopyUtils.copyFilesAndFolders(new File(SeamFacetInstallDataModelProvider.getTemplatesFolder(), "ear"), earProjectFolder, new FilterSetCollection(this.ejbFilterSet), false);
            }
            catch (IOException e) {
                SeamCorePlugin.getPluginLog().logError((Throwable)e);
            }
        }
        this.fillEarContents(project, model);
        if (this.shouldCopyLibrariesAndTemplates(model)) {
            File resources = new File(earProjectFolder, "resources");
            AntCopyUtils.copyFileToFile(this.dataSourceDsFile, new File(resources, String.valueOf(project.getName()) + "-ds.xml"), this.viewFilterSetCollection, false);
        }
    }

    protected void configureApplicationXml(IProject project, IProgressMonitor monitor) {
        EARArtifactEdit earArtifactEdit = null;
        try {
            earArtifactEdit = EARArtifactEdit.getEARArtifactEditForWrite((IProject)project);
            if (earArtifactEdit != null) {
                Application application = earArtifactEdit.getApplication();
                EList modules = application.getModules();
                boolean moduleExists = false;
                for (Object module : modules) {
                    EjbModule ejbModule;
                    if (!(module instanceof EjbModule) || !"jboss-seam.jar".equals((ejbModule = (EjbModule)module).getUri())) continue;
                    moduleExists = true;
                    break;
                }
                if (!moduleExists) {
                    EjbModule module = ApplicationFactory.eINSTANCE.createEjbModule();
                    module.setUri("jboss-seam.jar");
                    application.getModules().add((Object)module);
                }
                earArtifactEdit.save(monitor);
            }
        }
        finally {
            if (earArtifactEdit != null) {
                earArtifactEdit.dispose();
            }
        }
    }

    protected abstract void fillEarContents(IProject var1, IDataModel var2);

    protected IResource getSrcFolder(IProject project) throws JavaModelException {
        IJavaProject javaProject = EclipseResourceUtil.getJavaProject((IProject)project);
        IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
        IPackageFragmentRoot src = null;
        int i = 0;
        while (i < roots.length) {
            if (roots[i].getKind() == 1) {
                src = roots[i];
            }
            ++i;
        }
        if (src != null) {
            return src.getResource();
        }
        return null;
    }

    protected void doExecuteForEjb(IProject project, IProjectFacetVersion fv, IDataModel model, IProgressMonitor monitor) throws CoreException {
        if (this.seamHomePath == null) {
            return;
        }
        File ejbProjectFolder = project.getLocation().toFile();
        FilterSet filtersFilterSet = SeamFacetFilterSetFactory.createFiltersFilterSet(model);
        FilterSet jdbcFilterSet = SeamFacetFilterSetFactory.createJdbcFilterSet(model);
        FilterSet projectFilterSet = SeamFacetFilterSetFactory.createProjectFilterSet(model);
        FilterSetCollection hibernateDialectFilterSet = new FilterSetCollection();
        hibernateDialectFilterSet.addFilterSet(this.encodedJdbcFilterSet);
        hibernateDialectFilterSet.addFilterSet(this.encodedProjectFilterSet);
        hibernateDialectFilterSet.addFilterSet(SeamFacetFilterSetFactory.createHibernateDialectFilterSet(model, true));
        IResource src = this.getSrcFolder(project);
        if (src != null) {
            File ejbJarXml;
            File componentProperties;
            File persistentXml;
            this.viewFilterSetCollection = new FilterSetCollection();
            this.viewFilterSetCollection.addFilterSet(jdbcFilterSet);
            this.viewFilterSetCollection.addFilterSet(projectFilterSet);
            File srcFile = src.getLocation().toFile();
            if (this.shouldCopyLibrariesAndTemplates(model)) {
                AntCopyUtils.copyFileToFile(new File(this.seamGenHomeFolder, "src/Authenticator.java"), new File(srcFile, String.valueOf(model.getProperty("action.package").toString().replace('.', '/')) + "/" + "Authenticator.java"), new FilterSetCollection(filtersFilterSet), false);
            }
            if (!(persistentXml = new File(srcFile, "META-INF/persistence.xml")).exists() && this.shouldCopyLibrariesAndTemplates(model)) {
                AntCopyUtils.copyFileToFile(this.persistenceFile, new File(srcFile, "META-INF/persistence.xml"), this.viewFilterSetCollection, false);
            }
            if (!(componentProperties = new File(srcFile, "components.properties")).exists()) {
                SeamFacetAbstractInstallDelegate.createComponentsProperties(srcFile, project.getName(), false);
            }
            AntCopyUtils.FileSet ejbSrcResourcesSet = new AntCopyUtils.FileSet(JBOOS_EJB_WEB_INF_CLASSES_SET).dir(this.seamGenResFolder);
            if (this.shouldCopyLibrariesAndTemplates(model)) {
                AntCopyUtils.copyFilesAndFolders(this.seamGenResFolder, srcFile, new AntCopyUtils.FileSetFileFilter(ejbSrcResourcesSet), this.viewFilterSetCollection, false);
            }
            if (!(ejbJarXml = new File(srcFile, "META-INF/ejb-jar.xml")).exists() && this.shouldCopyLibrariesAndTemplates(model)) {
                AntCopyUtils.copyFileToFolder(new File(this.seamGenResFolder, "META-INF/ejb-jar.xml"), new File(srcFile, "META-INF"), this.viewFilterSetCollection, false);
            }
        }
        if (this.shouldCopyLibrariesAndTemplates(model)) {
            AntCopyUtils.copyFileToFile(this.hibernateConsoleLaunchFile, new File(ejbProjectFolder, String.valueOf(this.getLaunchCfgName(ejbProjectFolder.getName())) + ".launch"), new FilterSetCollection(this.ejbFilterSet), false);
            AntCopyUtils.copyFileToFolder(this.hibernateConsolePropsFile, ejbProjectFolder, hibernateDialectFilterSet, false);
        }
    }

    public void doExecute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        IDataModel model = (IDataModel)config;
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
        IProjectFacetVersion ejbVersion = facetedProject.getProjectFacetVersion(IJ2EEFacetConstants.EJB_FACET);
        IProjectFacetVersion webVersion = facetedProject.getProjectFacetVersion(IJ2EEFacetConstants.DYNAMIC_WEB_FACET);
        IProjectFacetVersion earVersion = facetedProject.getProjectFacetVersion(IJ2EEFacetConstants.ENTERPRISE_APPLICATION_FACET);
        IProjectFacetVersion jpaVersion = null;
        if (ProjectFacetsManager.isProjectFacetDefined((String)"jpt.jpa")) {
            jpaVersion = facetedProject.getProjectFacetVersion(ProjectFacetsManager.getProjectFacet((String)"jpt.jpa"));
        }
        this.initDefaultModelValues(model, webVersion != null);
        model.setProperty("project.name", (Object)project.getName());
        Boolean dbExists = (Boolean)model.getProperty("database.exists");
        Boolean dbRecreate = (Boolean)model.getProperty("database.drop");
        if (!dbExists.booleanValue() && !dbRecreate.booleanValue()) {
            model.setProperty("hibernate.hbm2ddl.auto", (Object)"update");
        } else if (dbExists.booleanValue() && !dbRecreate.booleanValue()) {
            model.setProperty("hibernate.hbm2ddl.auto", (Object)"validate");
        } else if (dbRecreate.booleanValue()) {
            model.setProperty("hibernate.hbm2ddl.auto", (Object)"create-drop");
        }
        this.jdbcFilterSet = SeamFacetFilterSetFactory.createJdbcFilterSet(model);
        this.encodedJdbcFilterSet = SeamFacetFilterSetFactory.createJdbcFilterSet(model, true);
        this.projectFilterSet = SeamFacetFilterSetFactory.createProjectFilterSet(model);
        this.encodedProjectFilterSet = SeamFacetFilterSetFactory.createProjectFilterSet(model, true);
        this.filtersFilterSet = SeamFacetFilterSetFactory.createFiltersFilterSet(model);
        new AntCopyUtils.FileSet(VIEW_FILESET).dir(this.seamGenViewSource);
        this.viewFilterSetCollection = new FilterSetCollection();
        this.viewFilterSetCollection.addFilterSet(this.jdbcFilterSet);
        this.viewFilterSetCollection.addFilterSet(this.projectFilterSet);
        this.viewFilterSetCollection.addFilterSet(SeamFacetFilterSetFactory.createHibernateDialectFilterSet(model));
        Object runtimeName = model.getProperty("seam.runtime.name");
        if (runtimeName != null) {
            ProjectScope context;
            IEclipsePreferences prefs;
            String platformId;
            SeamRuntime selectedRuntime = SeamRuntimeManager.getInstance().findRuntimeByName(runtimeName.toString());
            this.seamHomePath = selectedRuntime.getHomeDir();
            this.seamHomeFolder = new File(this.seamHomePath);
            this.seamLibFolder = new File(this.seamHomePath, SEAM_LIB_RELATED_PATH);
            this.seamGenResFolder = new File(this.seamHomePath, "seam-gen/resources");
            this.seamGenHomeFolder = new File(this.seamHomePath, "seam-gen");
            this.seamGenViewSource = new File(this.seamGenHomeFolder, "view");
            this.dataSourceDsFile = new File(this.seamGenResFolder, "datasource-ds.xml");
            this.componentsFile = new File(this.seamGenResFolder, "WEB-INF/components" + (SeamFacetAbstractInstallDelegate.isWarConfiguration(model) ? "-war" : "") + ".xml");
            this.hibernateConsolePropsFile = new File(this.seamGenHomeFolder, "hibernatetools/hibernate-console.properties");
            try {
                this.hibernateConsoleLaunchFile = new File(SeamFacetInstallDataModelProvider.getTemplatesFolder(), "hibernatetools/hibernate-console.launch");
            }
            catch (IOException e) {
                SeamCorePlugin.getPluginLog().logError((Throwable)e);
            }
            if (jpaVersion != null && "hibernate".equals(platformId = (prefs = (context = new ProjectScope(project)).getNode("org.eclipse.jpt.core")).get("org.eclipse.jpt.core.platform", null))) {
                ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
                ILaunchConfigurationType lct = lm.getLaunchConfigurationType("org.hibernate.eclipse.launch.ConsoleConfigurationLaunchConfigurationType");
                ILaunchConfiguration[] lcs = lm.getLaunchConfigurations(lct);
                ILaunchConfiguration lsForDelete = null;
                int i = 0;
                while (i < lcs.length && lcs[i].exists()) {
                    String lcProject = lcs[i].getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
                    if (project.getName().equals(lcProject)) {
                        lsForDelete = lcs[i];
                        break;
                    }
                    ++i;
                }
                if (lsForDelete != null) {
                    lsForDelete.delete();
                }
                try {
                    this.hibernateConsoleLaunchFile = new File(SeamFacetInstallDataModelProvider.getTemplatesFolder(), "hibernatetools/hibernate-console_jpa.launch");
                }
                catch (IOException e) {
                    SeamCorePlugin.getPluginLog().logError((Throwable)e);
                }
            }
            this.persistenceFile = new File(this.seamGenResFolder, "META-INF/persistence-" + (SeamFacetAbstractInstallDelegate.isWarConfiguration(model) ? DEV_WAR_PROFILE : DEV_EAR_PROFILE) + ".xml");
            this.ejbFilterSet = new FilterSet();
            this.ejbFilterSet.addFilter("projectName", project.getName());
            String serverRuntimeName = WtpUtils.getServerRuntimeName(project);
            if (serverRuntimeName != null) {
                this.ejbFilterSet.addFilter("runtimeName", serverRuntimeName);
            }
            if (model.getProperty("driver.files.array") != null) {
                File driver = new File(((String[])model.getProperty("driver.files.array"))[0]);
                this.ejbFilterSet.addFilter("driverJar", " " + driver.getName() + "\n");
                this.viewFilterSetCollection.addFilterSet(SeamFacetAbstractInstallDelegate.getDriverFilterSet(model));
            } else {
                this.ejbFilterSet.addFilter("driverJar", "");
            }
        } else {
            this.seamHomePath = null;
        }
        if (ejbVersion != null) {
            this.projectType = ProjectType.EJB;
            this.doExecuteForEjb(project, fv, model, monitor);
        } else if (webVersion != null) {
            this.projectType = ProjectType.WAR;
            this.doExecuteForWar(project, fv, model, monitor);
        } else if (earVersion != null) {
            this.projectType = ProjectType.EAR;
            this.doExecuteForEar(project, fv, model, monitor);
        }
        if (this.projectType != ProjectType.EAR) {
            ClasspathHelper.addClasspathEntries((IProject)project, (IProjectFacetVersion)fv);
            this.createSeamProjectPreferenes(project, model);
            SeamUtil.enableSeamSupport(project);
        }
        project.refreshLocal(2, monitor);
    }

    public static FilterSet getDriverFilterSet(IDataModel model) {
        if (model.getProperty("driver.files.array") != null) {
            File driver = new File(((String[])model.getProperty("driver.files.array"))[0]);
            FilterSet dbTypeFilterSet = new FilterSet();
            dbTypeFilterSet.addFilter("database.type", driver.getName());
            return dbTypeFilterSet;
        }
        return null;
    }

    private void initDefaultModelValues(IDataModel model, boolean warProject) {
        String runtimeName;
        if (model.getProperty("seam.project.deployment.type") == null) {
            model.setProperty("seam.project.deployment.type", (Object)(warProject ? "war" : "ear"));
        }
        String projectNamePackage = (String)model.getProperty("project.name");
        IStatus status = JavaConventions.validatePackageName((String)(projectNamePackage = SeamUtil.getSeamPackageName(projectNamePackage)), (String)"1.5", (String)"1.5");
        if (!status.isOK()) {
            projectNamePackage = "project";
        }
        if (model.getProperty("action.package") == null) {
            model.setProperty("action.package", (Object)("org.domain." + projectNamePackage + ".session"));
        }
        if (model.getProperty("model.package") == null) {
            model.setProperty("model.package", (Object)("org.domain." + projectNamePackage + ".entity"));
        }
        if (model.getProperty("seam.test.project.creating") == null) {
            model.setProperty("seam.test.project.creating", (Object)new Boolean(true));
        }
        if (model.getProperty("test.package") == null) {
            model.setProperty("test.package", (Object)("org.domain." + projectNamePackage + ".test"));
        }
        if (model.getProperty("seam.runtime.name") == null && model.getBooleanProperty("configure.default.seam.runtime") && (runtimeName = SeamFacetInstallDataModelProvider.getSeamRuntimeDefaultValue(model)) != null && runtimeName.length() > 0) {
            model.setProperty("seam.runtime.name", (Object)runtimeName);
        }
        if (model.getProperty("seam.project.connection.profile") == null) {
            String defaultDs = SeamProjectPreferences.getStringPreference("org.jboss.tools.seam.core.project.facet.default.conn.profile");
            IConnectionProfile[] profiles = ProfileManager.getInstance().getProfilesByCategory("org.eclipse.datatools.connectivity.db.category");
            ArrayList<String> names = new ArrayList<String>();
            IConnectionProfile[] iConnectionProfileArray = profiles;
            int n = profiles.length;
            int n2 = 0;
            while (n2 < n) {
                IConnectionProfile connectionProfile = iConnectionProfileArray[n2];
                names.add(connectionProfile.getName());
                ++n2;
            }
            if (names.contains(defaultDs)) {
                model.setProperty("seam.project.connection.profile", (Object)defaultDs);
            } else if (!names.isEmpty()) {
                model.setProperty("seam.project.connection.profile", names.get(0));
            }
        }
    }

    private void stopListening() {
        SeamCorePlugin.getDefault().getLog().removeLogListener((ILogListener)this);
    }

    private void startListening() {
        SeamCorePlugin.getDefault().getLog().addLogListener((ILogListener)this);
    }

    private boolean hasErrors() {
        return this.errorOccurs;
    }

    public Object create() throws CoreException {
        return null;
    }

    public void logging(IStatus status, String plugin) {
        if (status.getPlugin().equals("org.jboss.tools.seam.core")) {
            this.errorOccurs = true;
        }
    }

    protected void createSeamProjectPreferenes(IProject project, IDataModel model) {
        ISeamProject parentWebProject;
        ProjectScope projectScope = new ProjectScope(project);
        IEclipsePreferences prefs = projectScope.getNode("org.jboss.tools.seam.core");
        prefs.put("seam.project.settings.version", "1.1");
        boolean standaloneProject = true;
        if (this.projectType == ProjectType.EJB && (parentWebProject = SeamUtil.findReferencingSeamWarProjectForProject(project)) != null) {
            prefs.put("seam.parent.project", parentWebProject.getProject().getName());
            standaloneProject = false;
        }
        if (standaloneProject) {
            prefs.put("seam.project.deployment.type", model.getProperty("seam.project.deployment.type").toString());
            if (model.getProperty("seam.runtime.name") != null) {
                prefs.put("seam.runtime.name", model.getProperty("seam.runtime.name").toString());
            }
            if (model.getProperty("seam.project.connection.profile") != null) {
                prefs.put("seam.project.connection.profile", model.getProperty("seam.project.connection.profile").toString());
            }
            prefs.put("action.package", model.getProperty("action.package").toString());
            prefs.put("model.package", model.getProperty("model.package").toString());
            prefs.put("test.package", model.getProperty("test.package").toString());
            prefs.put("seam.test.creating", "false");
            prefs.put("seam.test.project", project.getName());
            IVirtualComponent component = ComponentCore.createComponent((IProject)project);
            IVirtualFolder rootFolder = component.getRootFolder();
            IContainer webRootFolder = rootFolder.getFolder((IPath)new Path("/")).getUnderlyingFolder();
            String webRootFolderPath = webRootFolder.getFullPath().toString();
            IPath srcRootFolder = null;
            if (this.projectType == ProjectType.WAR) {
                srcRootFolder = rootFolder.getFolder((IPath)new Path("/WEB-INF/classes")).getUnderlyingFolder().getFullPath();
            } else if (this.projectType == ProjectType.EJB) {
                try {
                    srcRootFolder = this.getSrcFolder(project).getFullPath();
                }
                catch (JavaModelException e) {
                    SeamCorePlugin.getPluginLog().logError((Throwable)e);
                    srcRootFolder = new Path("");
                }
            }
            if (this.projectType == ProjectType.WAR) {
                prefs.put("seam.project.web.root.folder", webRootFolderPath);
            } else {
                prefs.put("seam.project.web.root.folder", srcRootFolder.toString());
            }
            if (!SeamFacetAbstractInstallDelegate.isWarConfiguration(model)) {
                prefs.put("seam.ejb.project", project.getName());
                prefs.put("seam.ear.project", project.getName());
            }
            prefs.put("model.sources", srcRootFolder.toString());
            prefs.put("action.sources", srcRootFolder.toString());
            prefs.put("test.sources", srcRootFolder.toString());
        }
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            SeamCorePlugin.getPluginLog().logError((Throwable)e);
        }
    }

    protected void addSecurityConstraint(WebApp webApp) {
        SecurityConstraint securityConstraint = WebFactory.eINSTANCE.createSecurityConstraint();
        DisplayName displayName = JavaeeFactory.eINSTANCE.createDisplayName();
        displayName.setValue(RESTRICT_RAW_XHTML);
        securityConstraint.getDisplayNames().add(displayName);
        WebResourceCollection webResourceCollection = WebFactory.eINSTANCE.createWebResourceCollection();
        webResourceCollection.setWebResourceName(XHTML);
        UrlPatternType urlPattern = JavaeeFactory.eINSTANCE.createUrlPatternType();
        urlPattern.setValue(WEB_RESOURCE_COLLECTION_PATTERN);
        webResourceCollection.getUrlPatterns().add(urlPattern);
        AuthConstraint authConstraint = WebFactory.eINSTANCE.createAuthConstraint();
        securityConstraint.setAuthConstraint(authConstraint);
        securityConstraint.getWebResourceCollections().add(webResourceCollection);
        webApp.getSecurityConstraints().add(securityConstraint);
    }

    protected void createOrUpdateServletMapping(WebApp webApp, String name, String value) {
        if (name == null || value == null) {
            return;
        }
        List servletMappings = webApp.getServletMappings();
        boolean added = false;
        for (ServletMapping servletMapping : servletMappings) {
            if (servletMapping == null || !name.equals(servletMapping.getServletName())) continue;
            added = true;
        }
        if (!added) {
            ServletMapping mapping = WebFactory.eINSTANCE.createServletMapping();
            Servlet servlet = this.findServletByName(webApp, name);
            if (servlet != null) {
                mapping.setServletName(servlet.getServletName());
                UrlPatternType urlPattern = JavaeeFactory.eINSTANCE.createUrlPatternType();
                urlPattern.setValue(value);
                mapping.getUrlPatterns().add(urlPattern);
                webApp.getServletMappings().add(mapping);
            }
        }
    }

    private Servlet findServletByName(WebApp webApp, String name) {
        for (Servlet servlet : webApp.getServlets()) {
            if (servlet.getServletName() == null || !servlet.getServletName().trim().equals(name)) continue;
            return servlet;
        }
        return null;
    }

    protected void createOrUpdateServlet(WebApp webApp, String servletClass, String servletName) {
        if (servletClass == null || servletName == null) {
            return;
        }
        List servlets = webApp.getServlets();
        boolean added = false;
        for (Servlet servlet : servlets) {
            if (!servletName.equals(servlet.getServletName())) continue;
            servlet.setServletName(servletName);
            added = true;
            break;
        }
        if (!added) {
            Servlet servlet = WebFactory.eINSTANCE.createServlet();
            servlet.setServletName(servletName);
            servlet.setServletClass(servletClass);
            webApp.getServlets().add(servlet);
        }
    }

    protected void createOrUpdateFilterMapping(WebApp webApp, String mapping, String value) {
        if (mapping == null || value == null) {
            return;
        }
        webApp.getFilterMappings();
        boolean added = false;
        if (!added) {
            FilterMapping filterMapping = WebFactory.eINSTANCE.createFilterMapping();
            Filter filter = (Filter)this.getFilterByName(webApp, mapping);
            if (filter != null) {
                filterMapping.setFilterName(filter.getFilterName());
                UrlPatternType urlPattern = JavaeeFactory.eINSTANCE.createUrlPatternType();
                urlPattern.setValue(value);
                filterMapping.getUrlPatterns().add(urlPattern);
                webApp.getFilterMappings().add(filterMapping);
            }
        }
    }

    protected Object getFilterByName(WebApp webApp, String name) {
        if (webApp == null || name == null) {
            return null;
        }
        List filters = webApp.getFilters();
        for (Filter filter : filters) {
            if (filter == null || !name.equals(filter.getFilterName())) continue;
            return filter;
        }
        return null;
    }

    protected void createOrUpdateFilter(WebApp webApp, String name, String clazz) {
        if (name == null || clazz == null) {
            return;
        }
        List filters = webApp.getFilters();
        boolean added = false;
        for (Filter filter : filters) {
            if (filter == null || !name.endsWith(filter.getFilterName())) continue;
            filter.setFilterName(name);
            filter.setFilterClass(clazz);
            added = true;
            break;
        }
        if (!added) {
            Filter filter = WebFactory.eINSTANCE.createFilter();
            filter.setFilterName(name);
            filter.setFilterClass(clazz);
            webApp.getFilters().add(filter);
        }
    }

    protected void createOrUpdateListener(WebApp webApp, String name) {
        if (name == null) {
            return;
        }
        List listeners = webApp.getListeners();
        boolean added = false;
        for (Listener listener : listeners) {
            if (listener == null || !name.equals(listener.getListenerClass())) continue;
            listener.setListenerClass(name);
            added = true;
        }
        if (!added) {
            Listener listener = JavaeeFactory.eINSTANCE.createListener();
            listener.setListenerClass(name);
            webApp.getListeners().add(listener);
        }
    }

    protected void createOrUpdateContextParam(WebApp webApp, String name, String value) {
        if (name == null || value == null) {
            return;
        }
        List paramValues = webApp.getContextParams();
        boolean added = false;
        for (ParamValue paramValue : paramValues) {
            if (paramValue == null || !name.equals(paramValue.getParamName())) continue;
            paramValue.setParamValue(value);
            added = true;
            break;
        }
        if (!added) {
            ParamValue paramValue = JavaeeFactory.eINSTANCE.createParamValue();
            paramValue.setParamName(name);
            paramValue.setParamValue(value);
            webApp.getContextParams().add(paramValue);
        }
    }

    protected abstract void configureFacesConfigXml(IProject var1, IProgressMonitor var2, String var3);

    protected abstract void configure(WebApp var1, IProject var2);

    protected WebApp configureWebXml(final IProject project) {
        IModelProvider modelProvider = ModelProviderManager.getModelProvider((IProject)project);
        Object modelObject = modelProvider.getModelObject();
        if (!(modelObject instanceof WebApp)) {
            return null;
        }
        IPath modelPath = new Path("WEB-INF").append("web.xml");
        boolean exists = project.getProjectRelativePath().append(modelPath).toFile().exists();
        if (!exists) {
            modelPath = IModelProvider.FORCESAVE;
        }
        modelProvider.modify(new Runnable(){

            @Override
            public void run() {
                IModelProvider modelProvider = ModelProviderManager.getModelProvider((IProject)project);
                Object modelObject = modelProvider.getModelObject();
                if (!(modelObject instanceof WebApp)) {
                    return;
                }
                WebApp webApp = (WebApp)modelObject;
                SeamFacetAbstractInstallDelegate.this.configure(webApp, project);
            }
        }, modelPath);
        return (WebApp)modelObject;
    }

    protected abstract SeamProjectCreator getProjectCreator(IDataModel var1, IProject var2, SeamFacetAbstractInstallDelegate var3);

    protected boolean shouldCopyLibrariesAndTemplates(IDataModel model) {
        return model.getBooleanProperty("seam.templates.copying");
    }

    protected boolean shouldCopyLibraries(IDataModel model) {
        return model.getBooleanProperty("seam.runtime.libraries.copying");
    }

    public static IServer getServer(IDataModel model) {
        Object serverObject = model.getProperty("seam.project.deployment.target");
        IServer server = null;
        if (serverObject instanceof String) {
            IServer[] servers;
            IServer[] iServerArray = servers = ServerCore.getServers();
            int n = servers.length;
            int n2 = 0;
            while (n2 < n) {
                IServer i = iServerArray[n2];
                if (serverObject.equals(i.getName())) {
                    server = i;
                    break;
                }
                ++n2;
            }
        } else if (serverObject instanceof IServer) {
            server = (IServer)serverObject;
        }
        return server;
    }

    static enum ProjectType {
        EAR,
        EJB,
        WAR;

    }
}

