/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core.project.facet;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.common.componentcore.datamodel.FacetInstallDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.jboss.tools.common.zip.UnzipOperation;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.core.project.facet.SeamProjectPreferences;
import org.jboss.tools.seam.core.project.facet.SeamRuntime;
import org.jboss.tools.seam.core.project.facet.SeamRuntimeManager;
import org.jboss.tools.seam.core.project.facet.SeamVersion;
import org.jboss.tools.seam.internal.core.project.facet.ISeamFacetDataModelProperties;
import org.jboss.tools.seam.internal.core.project.facet.SeamFacetProjectCreationDataModelProvider;
import org.jboss.tools.seam.internal.core.project.facet.SeamValidatorFactory;
import org.osgi.framework.Bundle;

public class SeamFacetInstallDataModelProvider
extends FacetInstallDataModelProvider
implements ISeamFacetDataModelProperties {
    private static final String EMPTY_STRING = "";

    public Set getPropertyNames() {
        Set names = super.getPropertyNames();
        names.add("jboss.home");
        names.add("seam.home.folder");
        names.add("seam.project.deployment.type");
        names.add("seam.project.deployment.target");
        names.add("seam.project.deployment.runtime");
        names.add("database.type");
        names.add("hibernate.dialect");
        names.add("hibernate.connection.driver_class");
        names.add("hibernate.connection.url");
        names.add("hibernate.connection.username");
        names.add("hibernate.connection.password");
        names.add("schema.property");
        names.add("hibernate.default_schema");
        names.add("catalog.property");
        names.add("hibernate.default_catalog");
        names.add("database.exists");
        names.add("database.drop");
        names.add("driver.files.array");
        names.add("driver.file");
        names.add("action.sources");
        names.add("action.package");
        names.add("model.sources");
        names.add("model.package");
        names.add("seam.test.project.creating");
        names.add("test.sources");
        names.add("test.package");
        names.add("seam.test.creating");
        names.add("seam.project.web.root.folder");
        names.add("project.name");
        names.add("seam.project.connection.profile");
        names.add("seam.ear.project");
        names.add("seam.ejb.project");
        names.add("seam.test.project");
        names.add("seam.runtime.name");
        names.add("hibernate.hbm2ddl.auto");
        names.add("create.ear.projects");
        names.add("configure.default.seam.runtime");
        names.add("configure.war.project");
        names.add("seam.runtime.libraries.copying");
        names.add("seam.templates.copying");
        names.add("seam.runtime.library.provider");
        names.add("seam.project.already.exists");
        return names;
    }

    public Object getDefaultProperty(String propertyName) {
        if ("jboss.home".equals(propertyName)) {
            return null;
        }
        if ("seam.project.deployment.type".equals(propertyName)) {
            return null;
        }
        if (propertyName.equals("IFacetDataModelProperties.FACET_ID")) {
            return "jst.seam";
        }
        if ("seam.test.project".equals(propertyName)) {
            return EMPTY_STRING;
        }
        if ("seam.ejb.project".equals(propertyName)) {
            return EMPTY_STRING;
        }
        if ("seam.ear.project".equals(propertyName)) {
            return EMPTY_STRING;
        }
        if ("hibernate.default_catalog".equals(propertyName)) {
            return EMPTY_STRING;
        }
        if ("hibernate.default_schema".equals(propertyName)) {
            return EMPTY_STRING;
        }
        if ("seam.project.deployment.runtime".equals(propertyName)) {
            return null;
        }
        if ("seam.project.deployment.runtime".equals(propertyName)) {
            return null;
        }
        if ("configure.default.seam.runtime".equals(propertyName)) {
            return Boolean.TRUE;
        }
        if ("configure.war.project".equals(propertyName)) {
            return Boolean.TRUE;
        }
        if ("seam.runtime.libraries.copying".equals(propertyName)) {
            return Boolean.TRUE;
        }
        if ("seam.templates.copying".equals(propertyName)) {
            return Boolean.TRUE;
        }
        if ("seam.runtime.library.provider".equals(propertyName)) {
            return null;
        }
        return super.getDefaultProperty(propertyName);
    }

    public DataModelPropertyDescriptor[] getValidPropertyDescriptors(String propertyName) {
        String runtimeName;
        if ("seam.project.deployment.target".equals(propertyName) && (runtimeName = (String)this.getProperty("seam.project.deployment.runtime")) != null) {
            return SeamFacetProjectCreationDataModelProvider.getServerPropertyDescriptors(runtimeName);
        }
        return super.getValidPropertyDescriptors(propertyName);
    }

    public static File getTemplatesFolder() throws IOException {
        Bundle bundle = SeamCorePlugin.getDefault().getBundle();
        String version = bundle.getVersion().toString();
        IPath stateLocation = Platform.getStateLocation((Bundle)bundle);
        File templatesDir = FileLocator.getBundleFile((Bundle)bundle);
        if (templatesDir.isFile()) {
            File toCopy = new File(stateLocation.toFile(), version);
            if (!toCopy.exists()) {
                toCopy.mkdirs();
                UnzipOperation unZip = new UnzipOperation(templatesDir.getAbsolutePath());
                unZip.execute(toCopy, "templates.*");
            }
            templatesDir = toCopy;
        }
        return new File(templatesDir, "templates");
    }

    public static String getSeamRuntimeDefaultValue(IDataModel seamModel) {
        String seamFacetVersion = seamModel.getProperty("IFacetDataModelProperties.FACET_VERSION_STR").toString();
        SeamVersion seamVersion = SeamVersion.parseFromString(seamFacetVersion);
        SeamRuntime defaultRuntime = SeamRuntimeManager.getInstance().getDefaultRuntime(seamVersion);
        if (defaultRuntime == null) {
            return EMPTY_STRING;
        }
        return defaultRuntime.getName();
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        if ("IFacetDataModelProperties.FACET_PROJECT_NAME".equals(propertyName)) {
            this.setProperty("project.name", propertyValue);
            this.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", propertyValue);
        }
        return super.propertySet(propertyName, propertyValue);
    }

    public IStatus validate(String name) {
        IStatus status = OK_STATUS;
        Map errors = null;
        if (name.equals("seam.runtime.name")) {
            String seamRuntimeName = this.getStringProperty("seam.runtime.name");
            errors = SeamValidatorFactory.SEAM_RUNTIME_NAME_VALIDATOR.validate((Object)seamRuntimeName, null);
        } else if (name.equals("seam.project.connection.profile")) {
            String connectionName = this.getStringProperty("seam.project.connection.profile");
            errors = SeamValidatorFactory.CONNECTION_PROFILE_VALIDATOR.validate((Object)connectionName, null);
        } else if (name.equals("model.package")) {
            String packageName = this.getStringProperty("model.package");
            errors = SeamValidatorFactory.PACKAGE_NAME_VALIDATOR.validate((Object)packageName, null);
        } else if (name.equals("action.package")) {
            String packageName = this.getStringProperty("action.package");
            errors = SeamValidatorFactory.PACKAGE_NAME_VALIDATOR.validate((Object)packageName, null);
        }
        if (errors != null && !errors.isEmpty()) {
            status = (IStatus)errors.values().iterator().next();
        }
        return status;
    }

    public void init() {
        super.init();
        this.model.setProperty("database.type", (Object)SeamProjectPreferences.getStringPreference("org.jboss.tools.seam.core.hibernate.default.db.type"));
        this.model.setProperty("seam.project.connection.profile", (Object)SeamProjectPreferences.getStringPreference("org.jboss.tools.seam.core.project.facet.default.conn.profile"));
        this.model.setProperty("hibernate.default_schema", (Object)EMPTY_STRING);
        this.model.setProperty("hibernate.default_catalog", (Object)EMPTY_STRING);
        this.model.setProperty("database.exists", (Object)false);
        this.model.setProperty("database.drop", (Object)false);
    }
}

