/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core.project.facet;

import java.io.File;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.drivers.DriverInstance;
import org.eclipse.datatools.connectivity.drivers.DriverManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class SeamFacetPreInstallDelegate
implements IDelegate {
    public static final String PROP_INDENT = "\n         ";
    public static final String PROP_DECL = "<property name=\"{0}\" value=\"{1}\"/>";
    private static final String EMPTY_STRING = "";

    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        String defaultCatalog;
        String defaultSchema;
        IConnectionProfile connProfile;
        IDataModel model = (IDataModel)config;
        if (model.getProperty("seam.project.connection.profile") != null && (connProfile = ProfileManager.getInstance().getProfileByName(model.getProperty("seam.project.connection.profile").toString())) != null) {
            DriverInstance i;
            Properties props = connProfile.getBaseProperties();
            model.setProperty("hibernate.connection.username", (Object)(props.get("org.eclipse.datatools.connectivity.db.username") == null ? EMPTY_STRING : props.get("org.eclipse.datatools.connectivity.db.username").toString()));
            model.setProperty("hibernate.connection.driver_class", (Object)(props.get("org.eclipse.datatools.connectivity.db.driverClass") == null ? EMPTY_STRING : props.get("org.eclipse.datatools.connectivity.db.driverClass").toString()));
            model.setProperty("hibernate.connection.password", (Object)(props.get("org.eclipse.datatools.connectivity.db.password") == null ? EMPTY_STRING : props.get("org.eclipse.datatools.connectivity.db.password").toString()));
            model.setProperty("hibernate.connection.url", (Object)(props.get("org.eclipse.datatools.connectivity.db.URL") == null ? EMPTY_STRING : props.get("org.eclipse.datatools.connectivity.db.URL").toString()));
            if (props.get("org.eclipse.datatools.connectivity.driverDefinitionID") != null && (i = DriverManager.getInstance().getDriverInstanceByID(props.get("org.eclipse.datatools.connectivity.driverDefinitionID").toString())) != null) {
                String[] drivers = i.getJarListAsArray();
                model.setProperty("driver.files.array", (Object)drivers);
                if (drivers.length > 0) {
                    File file = new File(drivers[0]);
                    model.setProperty("driver.file", (Object)file.getName());
                }
            }
        }
        if (!EMPTY_STRING.equals(defaultSchema = (String)model.getProperty("hibernate.default_schema"))) {
            model.setStringProperty("schema.property", PROP_INDENT + NLS.bind((String)PROP_DECL, (Object[])new String[]{"hibernate.default_schema", defaultSchema}));
        }
        if (!EMPTY_STRING.equals(defaultCatalog = (String)model.getProperty("hibernate.default_catalog"))) {
            model.setStringProperty("catalog.property", PROP_INDENT + NLS.bind((String)PROP_DECL, (Object[])new String[]{"hibernate.default_catalog", defaultCatalog}));
        }
    }
}

