/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core.project.facet;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.core.project.facet.SeamRuntime;
import org.jboss.tools.seam.core.project.facet.SeamRuntimeListConverter;
import org.jboss.tools.seam.core.project.facet.SeamVersion;
import org.osgi.service.prefs.BackingStoreException;

public class SeamFacetPreferenceInitializer
extends AbstractPreferenceInitializer {
    public static String RUNTIME_CONFIG_FORMAT_VERSION = "1.0";
    public static final String SEAM_1_2_HOME = "../../../seam1";
    public static final String SEAM_2_0_HOME = "../../../seam";

    public void initializeDefaultPreferences() {
        File seamGen;
        IEclipsePreferences node = (IEclipsePreferences)Platform.getPreferencesService().getRootNode().node("default").node("org.jboss.tools.seam.core");
        node.put("org.jboss.tools.seam.core.runtime.config.format.version", RUNTIME_CONFIG_FORMAT_VERSION);
        node.put("org.jboss.tools.seam.core.project.default.deployment.type", "war");
        node.put("org.jboss.tools.seam.core.hibernate.default.db.type", "HSQL");
        node.put("org.jboss.tools.seam.core.project.facet.default.conn.profile", "DefaultDS");
        HashMap<String, SeamRuntime> map = new HashMap<String, SeamRuntime>();
        String seamGenBuildPath = this.getSeamGenBuildPath(SEAM_1_2_HOME);
        File seamFolder = new File(seamGenBuildPath);
        if (seamFolder.exists() && seamFolder.isDirectory()) {
            SeamRuntime rt = new SeamRuntime();
            rt.setHomeDir(seamGenBuildPath);
            rt.setName("Seam " + (Object)((Object)SeamVersion.SEAM_1_2) + ".AP");
            rt.setDefault(true);
            rt.setVersion(SeamVersion.SEAM_1_2);
            map.put(rt.getName(), rt);
        }
        if ((seamFolder = new File(seamGenBuildPath = this.getSeamGenBuildPath(SEAM_2_0_HOME))).exists() && seamFolder.isDirectory() && (seamGen = new File(seamFolder, "/seam-gen")).exists() && seamGen.isDirectory()) {
            SeamRuntime rt = new SeamRuntime();
            rt.setHomeDir(seamGenBuildPath);
            rt.setName("Seam " + (Object)((Object)SeamVersion.SEAM_2_1));
            rt.setDefault(true);
            rt.setVersion(SeamVersion.SEAM_2_1);
            map.put(rt.getName(), rt);
        }
        node.put("org.jboss.tools.seam.core.runtime.list", new SeamRuntimeListConverter().getString(map));
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            SeamCorePlugin.getPluginLog().logError((Throwable)e);
        }
    }

    private String getSeamGenBuildPath(String seamHomePath) {
        String pluginLocation = null;
        try {
            pluginLocation = FileLocator.resolve((URL)SeamCorePlugin.getDefault().getBundle().getEntry("/")).getFile();
        }
        catch (IOException e) {
            SeamCorePlugin.getPluginLog().logError((Throwable)e);
        }
        File seamGenDir = new File(pluginLocation, seamHomePath);
        Path p = new Path(seamGenDir.getPath());
        p.makeAbsolute();
        if (p.toFile().exists()) {
            return p.toOSString();
        }
        return "";
    }
}

