/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core.project.facet;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.tools.ant.types.FilterSet;
import org.apache.tools.ant.types.FilterSetCollection;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jst.common.project.facet.JavaFacetUtils;
import org.eclipse.jst.common.project.facet.core.ClasspathHelper;
import org.eclipse.jst.common.project.facet.core.JavaFacet;
import org.eclipse.jst.common.project.facet.core.internal.JavaFacetUtil;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.jboss.tools.common.util.ResourcesUtils;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.core.project.facet.SeamRuntime;
import org.jboss.tools.seam.core.project.facet.SeamRuntimeManager;
import org.jboss.tools.seam.core.project.facet.SeamVersion;
import org.jboss.tools.seam.internal.core.project.facet.AntCopyUtils;
import org.jboss.tools.seam.internal.core.project.facet.SeamFacetAbstractInstallDelegate;
import org.jboss.tools.seam.internal.core.project.facet.SeamFacetFilterSetFactory;
import org.jboss.tools.seam.internal.core.project.facet.SeamFacetInstallDataModelProvider;
import org.jboss.tools.seam.internal.core.project.facet.SeamFacetInstallDelegate;
import org.jboss.tools.seam.internal.core.project.facet.SeamLibFileSetProvider;
import org.jboss.tools.seam.internal.core.project.facet.WtpUtils;
import org.osgi.service.prefs.BackingStoreException;

public class SeamProjectCreator {
    protected static final String TEST_WAR_PROFILE = "test-war";
    protected static final String TEST_EAR_PROFILE = "test";
    protected static final String DEV_WAR_PROFILE = "dev-war";
    protected static final String DEV_EAR_PROFILE = "dev";
    private static AntCopyUtils.FileSet JBOSS_TEST_LIB_FILESET = new AntCopyUtils.FileSet().include("testng-.*-jdk15\\.jar").include("myfaces-api-.*\\.jar").include("myfaces-impl-.*\\.jar").include("servlet-api\\.jar").include("hibernate-all\\.jar").include("jboss-ejb3-all\\.jar").include("thirdparty-all\\.jar").exclude(".*/CVS").exclude(".*/\\.svn");
    protected IDataModel model;
    protected IProject seamWebProject;
    protected SeamLibFileSetProvider seamLibFileSetProvider;
    protected SeamRuntime seamRuntime;
    protected String seamHomePath;
    protected File seamHomeFolder;
    protected File seamLibFolder;
    protected File seamGenHomeFolder;
    protected String earProjectName;
    protected String ejbProjectName;
    protected String testProjectName;
    protected File earProjectFolder;
    protected File ejbProjectFolder;
    protected File earContentsFolder;
    protected FilterSet filtersFilterSet;
    protected File seamGenResFolder;
    protected File persistenceFile;
    protected File hibernateConsoleLaunchFile;
    protected File hibernateConsolePropsFile;
    protected FilterSet jdbcFilterSet;
    protected FilterSet encodedJdbcFilterSet;
    protected FilterSet projectFilterSet;
    protected FilterSet encodedProjectFilterSet;
    protected FilterSetCollection viewFilterSetCollection;
    protected FilterSetCollection hibernateDialectFilterSet;
    protected File dataSourceDsFile;
    protected File ejbTemplateDir;
    protected AntCopyUtils.FileSet excludeCvsSvn;
    protected FilterSet ejbFilterSet;
    protected File webMetaInf;
    protected File ejbMetaInf;
    protected File droolsLibFolder;
    private String jbossSeamPath;
    private static final Map<String, String> COMPILER_LEVEL_TO_EXEC_ENV = new HashMap<String, String>();
    private static final IPath CPE_PREFIX_FOR_EXEC_ENV;

    static {
        COMPILER_LEVEL_TO_EXEC_ENV.put("1.3", "J2SE-1.3");
        COMPILER_LEVEL_TO_EXEC_ENV.put("1.4", "J2SE-1.4");
        COMPILER_LEVEL_TO_EXEC_ENV.put("1.5", "J2SE-1.5");
        COMPILER_LEVEL_TO_EXEC_ENV.put("1.6", "JavaSE-1.6");
        COMPILER_LEVEL_TO_EXEC_ENV.put("1.7", "JavaSE-1.7");
        CPE_PREFIX_FOR_EXEC_ENV = new Path("org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType");
    }

    public SeamProjectCreator(IDataModel model, IProject seamWebProject, SeamLibFileSetProvider seamLibFileSetProvider) {
        this.model = model;
        this.seamWebProject = seamWebProject;
        this.seamLibFileSetProvider = seamLibFileSetProvider;
        this.earProjectName = model.getStringProperty("seam.ear.project");
        this.ejbProjectName = model.getStringProperty("seam.ejb.project");
        this.testProjectName = model.getStringProperty("seam.test.project");
        this.seamRuntime = SeamRuntimeManager.getInstance().findRuntimeByName(model.getProperty("seam.runtime.name").toString());
        if (this.seamRuntime == null) {
            throw new RuntimeException("Can't get seam runtime " + model.getProperty("seam.runtime.name").toString());
        }
        this.seamHomePath = this.seamRuntime.getHomeDir();
        this.seamHomeFolder = new File(this.seamHomePath);
        this.seamLibFolder = new File(this.seamHomePath, SeamFacetAbstractInstallDelegate.SEAM_LIB_RELATED_PATH);
        this.seamGenHomeFolder = new File(this.seamHomePath, "seam-gen");
        this.filtersFilterSet = SeamFacetFilterSetFactory.createFiltersFilterSet(model);
        this.seamGenResFolder = new File(this.seamGenHomeFolder, "resources");
        this.persistenceFile = new File(this.seamGenResFolder, "META-INF/persistence-" + (SeamFacetAbstractInstallDelegate.isWarConfiguration(model) ? DEV_WAR_PROFILE : DEV_EAR_PROFILE) + ".xml");
        try {
            this.hibernateConsoleLaunchFile = new File(SeamFacetInstallDataModelProvider.getTemplatesFolder(), "hibernatetools/hibernate-console.launch");
        }
        catch (IOException e) {
            SeamCorePlugin.getPluginLog().logError((Throwable)e);
        }
        this.hibernateConsolePropsFile = new File(this.seamGenHomeFolder, "hibernatetools/hibernate-console.properties");
        this.dataSourceDsFile = new File(this.seamGenResFolder, "datasource-ds.xml");
        IVirtualComponent component = ComponentCore.createComponent((IProject)seamWebProject);
        IVirtualFolder webRootVirtFolder = component.getRootFolder().getFolder((IPath)new Path("/"));
        IContainer webRootFolder = webRootVirtFolder.getUnderlyingFolder();
        File webContentFolder = webRootFolder.getLocation().toFile();
        this.webMetaInf = new File(webContentFolder, "META-INF");
        this.earProjectFolder = new File(seamWebProject.getLocation().removeLastSegments(1).toFile(), this.earProjectName);
        this.earContentsFolder = new File(this.earProjectFolder, "EarContent");
        this.ejbProjectFolder = new File(seamWebProject.getLocation().removeLastSegments(1).toFile(), this.ejbProjectName);
        this.ejbMetaInf = new File(this.ejbProjectFolder, "ejbModule/META-INF");
        this.jdbcFilterSet = SeamFacetFilterSetFactory.createJdbcFilterSet(model);
        this.encodedJdbcFilterSet = SeamFacetFilterSetFactory.createJdbcFilterSet(model, true);
        this.projectFilterSet = SeamFacetFilterSetFactory.createProjectFilterSet(model);
        this.encodedProjectFilterSet = SeamFacetFilterSetFactory.createProjectFilterSet(model, true);
        this.viewFilterSetCollection = new FilterSetCollection();
        this.viewFilterSetCollection.addFilterSet(this.jdbcFilterSet);
        this.viewFilterSetCollection.addFilterSet(this.projectFilterSet);
        FilterSet driverSet = SeamFacetAbstractInstallDelegate.getDriverFilterSet(model);
        if (driverSet != null) {
            this.viewFilterSetCollection.addFilterSet(driverSet);
        }
        this.hibernateDialectFilterSet = new FilterSetCollection();
        this.hibernateDialectFilterSet.addFilterSet(this.encodedJdbcFilterSet);
        this.hibernateDialectFilterSet.addFilterSet(this.encodedProjectFilterSet);
        this.hibernateDialectFilterSet.addFilterSet(SeamFacetFilterSetFactory.createHibernateDialectFilterSet(model, true));
        try {
            this.ejbTemplateDir = new File(SeamFacetInstallDataModelProvider.getTemplatesFolder(), "ejb");
        }
        catch (IOException e) {
            SeamCorePlugin.getPluginLog().logError((Throwable)e);
        }
        this.excludeCvsSvn = new AntCopyUtils.FileSet(SeamFacetAbstractInstallDelegate.CVS_SVN).dir(this.ejbTemplateDir);
        this.ejbFilterSet = new FilterSet();
        this.ejbFilterSet.addFilter("projectName", seamWebProject.getName());
        this.ejbFilterSet.addFilter("earProjectName", this.earProjectName);
        this.ejbFilterSet.addFilter("ejbProjectName", this.ejbProjectName);
        this.ejbFilterSet.addFilter("testProjectName", this.testProjectName);
        this.ejbFilterSet.addFilter("runtimeName", WtpUtils.getServerRuntimeName(seamWebProject));
        if (model.getProperty("driver.files.array") != null) {
            File driver = new File(((String[])model.getProperty("driver.files.array"))[0]);
            this.ejbFilterSet.addFilter("driverJar", " " + driver.getName() + "\n");
        } else {
            this.ejbFilterSet.addFilter("driverJar", "");
        }
        this.droolsLibFolder = new File(this.seamHomePath, SeamFacetInstallDelegate.DROOLS_LIB_SEAM_RELATED_PATH);
    }

    public SeamVersion getVersion() {
        String seamVersionString = this.getModel().getProperty("IFacetDataModelProperties.FACET_VERSION_STR").toString();
        return SeamVersion.parseFromString(seamVersionString);
    }

    public IDataModel getModel() {
        return this.model;
    }

    public void setModel(IDataModel model) {
        this.model = model;
    }

    protected AntCopyUtils.FileSet getJBossTestLibFileset() {
        return JBOSS_TEST_LIB_FILESET;
    }

    protected AntCopyUtils.FileSet getJbossEarContent() {
        return SeamFacetInstallDelegate.JBOSS_EAR_CONTENT;
    }

    public void execute(IProgressMonitor monitor) throws CoreException {
        String level;
        String consoleName;
        boolean testProjectCreated = this.createTestProject();
        String string = consoleName = SeamFacetAbstractInstallDelegate.isWarConfiguration(this.model) ? this.seamWebProject.getName() : this.ejbProjectName;
        if (!SeamFacetAbstractInstallDelegate.isWarConfiguration(this.model)) {
            this.createEjbProject();
            this.createEarProject();
            try {
                File[] earJars = this.earContentsFolder.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        if (SeamCorePlugin.getDefault().hasM2Facet(SeamProjectCreator.this.seamWebProject)) {
                            return false;
                        }
                        return name.lastIndexOf(".jar") > 0;
                    }
                });
                StringBuffer earJarsStrWar = new StringBuffer();
                StringBuffer earJarsStrEjb = new StringBuffer();
                if (earJars != null) {
                    File[] fileArray = earJars;
                    int n = earJars.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File file = fileArray[n2];
                        earJarsStrWar.append(" ").append(file.getName()).append(" \n");
                        if (this.isJBossSeamJar(file)) {
                            this.jbossSeamPath = file.getAbsolutePath();
                        } else {
                            earJarsStrEjb.append(" ").append(file.getName()).append(" \n");
                        }
                        ++n2;
                    }
                }
                if (earJarsStrEjb.length() > 0) {
                    earJarsStrEjb.insert(0, "Class-Path: ");
                }
                FilterSetCollection manifestFilterColWar = new FilterSetCollection(this.projectFilterSet);
                FilterSet manifestFilterWar = new FilterSet();
                manifestFilterWar.addFilter("earLibs", earJarsStrWar.toString());
                manifestFilterColWar.addFilterSet(manifestFilterWar);
                if (this.shouldCopyLibrariesAndTemplates(this.model)) {
                    AntCopyUtils.copyFileToFolder(new File(SeamFacetInstallDataModelProvider.getTemplatesFolder(), "war/META-INF/MANIFEST.MF"), this.webMetaInf, manifestFilterColWar, true);
                }
                FilterSetCollection manifestFilterColEjb = new FilterSetCollection(this.projectFilterSet);
                FilterSet manifestFilterEjb = new FilterSet();
                manifestFilterEjb.addFilter("earClasspath", earJarsStrEjb.toString());
                manifestFilterColEjb.addFilterSet(manifestFilterEjb);
                if (this.shouldCopyLibrariesAndTemplates(this.model)) {
                    AntCopyUtils.copyFileToFolder(new File(SeamFacetInstallDataModelProvider.getTemplatesFolder(), "ejb/ejbModule/META-INF/MANIFEST.MF"), this.ejbMetaInf, manifestFilterColEjb, true);
                }
            }
            catch (IOException e) {
                SeamCorePlugin.getPluginLog().logError((Throwable)e);
            }
        }
        SeamFacetAbstractInstallDelegate.toggleHibernateOnProject(this.seamWebProject, consoleName);
        String wsPath = this.seamWebProject.getLocation().removeLastSegments(1).toFile().getAbsoluteFile().getPath();
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        if (!SeamFacetAbstractInstallDelegate.isWarConfiguration(this.model)) {
            IJavaProject ejbJavaProject;
            IProject ejbProjectToBeImported = wsRoot.getProject(this.ejbProjectName);
            ResourcesUtils.importExistingProject((IProject)ejbProjectToBeImported, (String)(String.valueOf(wsPath) + "/" + this.ejbProjectName), (String)this.ejbProjectName, (IProgressMonitor)monitor, (boolean)false);
            level = JavaFacetUtils.getCompilerLevel((IProject)this.seamWebProject);
            String ejbLevel = JavaFacetUtils.getCompilerLevel((IProject)ejbProjectToBeImported);
            if (!ejbLevel.equals(level)) {
                JavaFacetUtils.setCompilerLevel((IProject)ejbProjectToBeImported, (String)level);
            }
            IFacetedProject.Action action = new IFacetedProject.Action(IFacetedProject.Action.Type.VERSION_CHANGE, JavaFacetUtils.compilerLevelToFacet((String)level), null);
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)ejbProjectToBeImported);
            facetedProject.modify(Collections.singleton(action), null);
            SeamFacetAbstractInstallDelegate.toggleHibernateOnProject(ejbProjectToBeImported, consoleName);
            IProjectFacet sf = ProjectFacetsManager.getProjectFacet((String)"jst.ejb");
            IProjectFacetVersion pfv = ProjectFacetsManager.create((IProject)ejbProjectToBeImported).getInstalledVersion(sf);
            IProjectFacet jf = JavaFacet.FACET;
            IProjectFacetVersion jfv = ProjectFacetsManager.create((IProject)ejbProjectToBeImported).getInstalledVersion(jf);
            JavaFacetUtil.resetClasspath((IProject)ejbProjectToBeImported, null, (IProjectFacetVersion)jfv);
            ClasspathHelper.addClasspathEntries((IProject)ejbProjectToBeImported, (IProjectFacetVersion)pfv);
            IProject earProjectToBeImported = wsRoot.getProject(this.earProjectName);
            ResourcesUtils.importExistingProject((IProject)earProjectToBeImported, (String)(String.valueOf(wsPath) + "/" + this.earProjectName), (String)this.earProjectName, (IProgressMonitor)monitor, (boolean)false);
            if (this.jbossSeamPath != null && this.jbossSeamPath.trim().length() > 0 && new File(this.jbossSeamPath).exists() && (ejbJavaProject = JavaCore.create((IProject)ejbProjectToBeImported)) != null) {
                if (!ejbJavaProject.isOpen()) {
                    ejbJavaProject.open(monitor);
                }
                IClasspathEntry[] cps = ejbJavaProject.getRawClasspath();
                IClasspathEntry[] entries = new IClasspathEntry[cps.length + 1];
                int i = 0;
                while (i < cps.length) {
                    entries[i] = cps[i];
                    ++i;
                }
                Path path = new Path(this.jbossSeamPath);
                IFile[] files = wsRoot.findFilesForLocation((IPath)path);
                IFile f = null;
                f = files != null && files.length > 0 ? files[0] : wsRoot.getFile((IPath)path);
                if (f.exists()) {
                    path = f.getFullPath();
                }
                entries[cps.length] = JavaCore.newLibraryEntry((IPath)path, null, null);
                ejbJavaProject.setRawClasspath(entries, monitor);
            }
            WtpUtils.reconfigure(ejbProjectToBeImported, monitor);
            this.configureJBossAppXml();
            WtpUtils.reconfigure(earProjectToBeImported, monitor);
        }
        IProject testProjectToBeImported = null;
        if (testProjectCreated) {
            testProjectToBeImported = wsRoot.getProject(this.testProjectName);
            ResourcesUtils.importExistingProject((IProject)testProjectToBeImported, (String)(String.valueOf(wsPath) + "/" + this.testProjectName), (String)this.testProjectName, (IProgressMonitor)monitor, (boolean)true);
            level = JavaFacetUtils.getCompilerLevel((IProject)this.seamWebProject);
            String testLevel = JavaFacetUtils.getCompilerLevel((IProject)testProjectToBeImported);
            if (!testLevel.equals(level)) {
                JavaFacetUtils.setCompilerLevel((IProject)testProjectToBeImported, (String)level);
            }
            testProjectToBeImported.refreshLocal(2, monitor);
            IVMInstall vm = JavaRuntime.getDefaultVMInstall();
            if (vm != null) {
                IClasspathEntry cpe = SeamProjectCreator.getJreContainer(this.seamWebProject);
                if (cpe == null) {
                    IPath path = CPE_PREFIX_FOR_EXEC_ENV.append(SeamProjectCreator.getCorrespondingExecutionEnvironment(level));
                    cpe = JavaCore.newContainerEntry((IPath)path);
                }
                IJavaProject javaProject = JavaCore.create((IProject)testProjectToBeImported);
                IClasspathEntry[] entries = javaProject.getRawClasspath();
                int jreIndex = SeamProjectCreator.getJreContainerIndex(testProjectToBeImported);
                if (jreIndex == -1) {
                    IClasspathEntry[] newEntries = new IClasspathEntry[entries.length + 1];
                    System.arraycopy(entries, 0, newEntries, 1, entries.length);
                    newEntries[0] = cpe;
                    javaProject.setRawClasspath(newEntries, null);
                } else {
                    entries[jreIndex] = cpe;
                    javaProject.setRawClasspath(entries, null);
                }
            }
            SeamFacetAbstractInstallDelegate.toggleHibernateOnProject(testProjectToBeImported, consoleName);
        }
        this.createSeamProjectPreferenes();
        WtpUtils.reconfigure(this.seamWebProject, monitor);
        if (testProjectToBeImported != null) {
            WtpUtils.reconfigure(testProjectToBeImported, monitor);
        }
    }

    private boolean isJBossSeamJar(File file) {
        String regex = "(jboss-seam){1}(-[0-9][0-9\\.]+){0,1}(.jar){1}";
        return Pattern.matches(regex, file.getName());
    }

    private static String getCorrespondingExecutionEnvironment(String compilerLevel) {
        String res = COMPILER_LEVEL_TO_EXEC_ENV.get(compilerLevel);
        if (res == null) {
            throw new IllegalArgumentException(compilerLevel);
        }
        return res;
    }

    public static int getJreContainerIndex(IProject proj) throws CoreException {
        IJavaProject jproj = JavaCore.create((IProject)proj);
        IClasspathEntry[] cp = jproj.getRawClasspath();
        int i = 0;
        while (i < cp.length) {
            IClasspathEntry cpe = cp[i];
            if (cpe.getEntryKind() == 5 && cpe.getPath().segment(0).equals(JavaRuntime.JRE_CONTAINER)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static IClasspathEntry getJreContainer(IProject proj) throws CoreException {
        IJavaProject jproj = JavaCore.create((IProject)proj);
        IClasspathEntry[] cp = jproj.getRawClasspath();
        int i = 0;
        while (i < cp.length) {
            IClasspathEntry cpe = cp[i];
            if (cpe.getEntryKind() == 5 && cpe.getPath().segment(0).equals(JavaRuntime.JRE_CONTAINER)) {
                return cpe;
            }
            ++i;
        }
        return null;
    }

    protected boolean createTestProject() {
        if (!((Boolean)this.model.getProperty("seam.test.project.creating")).booleanValue() || !this.shouldCopyLibrariesAndTemplates(this.model)) {
            return false;
        }
        File testProjectDir = new File(this.seamWebProject.getLocation().removeLastSegments(1).toFile(), this.testProjectName);
        testProjectDir.mkdir();
        IVirtualComponent component = ComponentCore.createComponent((IProject)this.seamWebProject);
        IVirtualFolder webRootVirtFolder = component.getRootFolder().getFolder((IPath)new Path("/"));
        File testLibDir = new File(testProjectDir, "lib");
        File embededEjbDir = new File(testProjectDir, "embedded-ejb");
        File testSrcDir = new File(testProjectDir, "test-src");
        FilterSet filterSet = new FilterSet();
        filterSet.addFilter("projectName", this.seamWebProject.getName());
        filterSet.addFilter("earProjectName", this.earProjectName);
        filterSet.addFilter("ejbProjectName", this.ejbProjectName);
        filterSet.addFilter("testProjectName", this.testProjectName);
        filterSet.addFilter("runtimeName", WtpUtils.getServerRuntimeName(this.seamWebProject));
        filterSet.addFilter("webRootFolder", webRootVirtFolder.getUnderlyingFolder().getFullPath().removeFirstSegments(1).toString());
        AntCopyUtils.FileSet includeLibs = new AntCopyUtils.FileSet(this.getJBossTestLibFileset()).dir(new File(this.seamRuntime.getHomeDir(), "lib"));
        File[] libs = includeLibs.getDir().listFiles(new AntCopyUtils.FileSetFileFilter(includeLibs));
        StringBuffer testLibraries = new StringBuffer();
        File[] fileArray = libs;
        int n = libs.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            testLibraries.append("\t<classpathentry kind=\"lib\" path=\"lib/" + file.getName() + "\"/>\n");
            ++n2;
        }
        StringBuffer requiredProjects = new StringBuffer();
        requiredProjects.append("\t<classpathentry combineaccessrules=\"false\" kind=\"src\" path=\"/" + this.seamWebProject.getName() + "\"/>");
        if (!SeamFacetAbstractInstallDelegate.isWarConfiguration(this.model)) {
            requiredProjects.append("\n\t<classpathentry combineaccessrules=\"false\" kind=\"src\" path=\"/" + this.ejbProjectName + "\"/>");
        }
        filterSet.addFilter("testLibraries", testLibraries.toString());
        filterSet.addFilter("requiredProjects", requiredProjects.toString());
        File testTemplateDir = null;
        try {
            testTemplateDir = new File(SeamFacetInstallDataModelProvider.getTemplatesFolder(), TEST_EAR_PROFILE);
        }
        catch (IOException e) {
            SeamCorePlugin.getPluginLog().logError((Throwable)e);
            return false;
        }
        AntCopyUtils.FileSet excludeCvsSvn = new AntCopyUtils.FileSet(SeamFacetAbstractInstallDelegate.CVS_SVN).dir(testTemplateDir);
        AntCopyUtils.copyFilesAndFolders(testTemplateDir, testProjectDir, new AntCopyUtils.FileSetFileFilter(excludeCvsSvn), new FilterSetCollection(filterSet), true);
        excludeCvsSvn.dir(new File(this.seamRuntime.getHomeDir(), "embedded-ejb/conf"));
        AntCopyUtils.copyFiles(new File(this.seamRuntime.getHomeDir(), "embedded-ejb/conf"), embededEjbDir, new AntCopyUtils.FileSetFileFilter(excludeCvsSvn));
        if (this.shouldCopyLibraries(this.model)) {
            AntCopyUtils.copyFiles(new File(this.seamRuntime.getHomeDir(), "lib"), testLibDir, new AntCopyUtils.FileSetFileFilter(includeLibs));
        }
        SeamFacetAbstractInstallDelegate.createComponentsProperties(testSrcDir, "", Boolean.TRUE);
        return true;
    }

    protected boolean createTestProject(String testProjectName) {
        if (testProjectName == null) {
            throw new IllegalArgumentException("Test project name must not be null");
        }
        this.testProjectName = testProjectName;
        return this.createTestProject();
    }

    protected void createEjbProject(String ejbProjectName) {
        if (ejbProjectName == null) {
            throw new IllegalArgumentException("EJB project name must not be null");
        }
        this.ejbProjectName = ejbProjectName;
        this.createEjbProject();
    }

    protected void createEjbProject() {
        if (!this.shouldCopyLibrariesAndTemplates(this.model)) {
            return;
        }
        this.ejbProjectFolder.mkdir();
        AntCopyUtils.copyFilesAndFolders(this.ejbTemplateDir, this.ejbProjectFolder, new AntCopyUtils.FileSetFileFilter(this.excludeCvsSvn), new FilterSetCollection(this.ejbFilterSet), true);
        AntCopyUtils.copyFileToFile(new File(this.seamGenHomeFolder, "src/Authenticator.java"), new File(this.ejbProjectFolder, "ejbModule/" + this.model.getProperty("action.package").toString().replace('.', '/') + "/" + "Authenticator.java"), new FilterSetCollection(this.filtersFilterSet), true);
        AntCopyUtils.copyFileToFile(this.persistenceFile, new File(this.ejbProjectFolder, "ejbModule/META-INF/persistence.xml"), this.viewFilterSetCollection, true);
        this.createComponentsProperties();
        AntCopyUtils.FileSet ejbSrcResourcesSet = new AntCopyUtils.FileSet(SeamFacetAbstractInstallDelegate.JBOOS_EJB_WEB_INF_CLASSES_SET).dir(this.seamGenResFolder);
        AntCopyUtils.copyFilesAndFolders(this.seamGenResFolder, new File(this.ejbProjectFolder, "ejbModule"), new AntCopyUtils.FileSetFileFilter(ejbSrcResourcesSet), this.viewFilterSetCollection, true);
        AntCopyUtils.copyFileToFolder(new File(this.seamGenResFolder, "META-INF/ejb-jar.xml"), new File(this.ejbProjectFolder, "ejbModule/META-INF/"), this.viewFilterSetCollection, true);
        FilterSet ejbFilterSet = new FilterSet();
        ejbFilterSet.addFilter("projectName", this.ejbProjectFolder.getName());
        ejbFilterSet.addFilter("earProjectName", this.earProjectName);
        ejbFilterSet.addFilter("ejbProjectName", this.ejbProjectName);
        ejbFilterSet.addFilter("testProjectName", this.testProjectName);
        ejbFilterSet.addFilter("connectionProfile", this.model.getStringProperty("seam.project.connection.profile"));
        AntCopyUtils.copyFileToFile(this.hibernateConsoleLaunchFile, new File(this.ejbProjectFolder, String.valueOf(this.getLaunchCfgName(this.ejbProjectFolder.getName())) + ".launch"), new FilterSetCollection(ejbFilterSet), true);
        AntCopyUtils.copyFileToFolder(this.hibernateConsolePropsFile, this.ejbProjectFolder, this.hibernateDialectFilterSet, true);
    }

    protected void createComponentsProperties() {
        SeamFacetAbstractInstallDelegate.createComponentsProperties(new File(this.ejbProjectFolder, "ejbModule"), this.earProjectName, false);
    }

    protected String getLaunchCfgName(String baseName) {
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        return lm.generateUniqueLaunchConfigurationNameFrom(baseName);
    }

    protected void copyJBossApp() {
        FilterSet earFilterSet = new FilterSet();
        earFilterSet.addFilter("projectName", String.valueOf(this.earProjectFolder.getName()) + ".ear");
        earFilterSet.addFilter("earProjectName", this.earProjectName);
        earFilterSet.addFilter("ejbProjectName", this.ejbProjectName);
        earFilterSet.addFilter("testProjectName", this.testProjectName);
        AntCopyUtils.copyFileToFolder(new File(this.seamGenResFolder, "META-INF/jboss-app.xml"), new File(this.earContentsFolder, "META-INF"), new FilterSetCollection(earFilterSet), true);
    }

    protected void createEarProject() {
        if (!this.shouldCopyLibrariesAndTemplates(this.model)) {
            return;
        }
        this.earProjectFolder.mkdir();
        File earContentsFolder = new File(this.earProjectFolder, "EarContent");
        this.copyJBossApp();
        try {
            AntCopyUtils.copyFilesAndFolders(new File(SeamFacetInstallDataModelProvider.getTemplatesFolder(), "ear"), this.earProjectFolder, new AntCopyUtils.FileSetFileFilter(this.excludeCvsSvn), new FilterSetCollection(this.ejbFilterSet), true);
        }
        catch (IOException e) {
            SeamCorePlugin.getPluginLog().logError((Throwable)e);
        }
        AntCopyUtils.copyFiles(this.seamHomeFolder, earContentsFolder, new AntCopyUtils.FileSetFileFilter(new AntCopyUtils.FileSet(this.getJbossEarContent()).dir(this.seamHomeFolder)));
        if (!SeamCorePlugin.getDefault().hasM2Facet(this.seamWebProject) && this.shouldCopyLibraries(this.model)) {
            AntCopyUtils.copyFiles(this.seamLibFolder, earContentsFolder, new AntCopyUtils.FileSetFileFilter(new AntCopyUtils.FileSet(this.getJbossEarContent()).dir(this.seamLibFolder)));
            AntCopyUtils.copyFiles(this.droolsLibFolder, earContentsFolder, new AntCopyUtils.FileSetFileFilter(new AntCopyUtils.FileSet(this.getJbossEarContent()).dir(this.droolsLibFolder)));
        }
        AntCopyUtils.copyFiles(this.seamGenResFolder, earContentsFolder, new AntCopyUtils.FileSetFileFilter(new AntCopyUtils.FileSet(this.getJbossEarContent()).dir(this.seamGenResFolder)));
        File resources = new File(this.earProjectFolder, "resources");
        AntCopyUtils.copyFileToFile(this.dataSourceDsFile, new File(resources, String.valueOf(this.seamWebProject.getName()) + "-ds.xml"), this.viewFilterSetCollection, true);
    }

    protected void createSeamProjectPreferenes() {
        ProjectScope projectScope = new ProjectScope(this.seamWebProject);
        IEclipsePreferences prefs = projectScope.getNode("org.jboss.tools.seam.core");
        String testSrcPath = this.seamWebProject.getFullPath().removeLastSegments(1).append(this.testProjectName).append("test-src").toString();
        prefs.put("seam.test.creating", ((Boolean)this.model.getProperty("seam.test.project.creating")).toString());
        prefs.put("seam.test.project", this.testProjectName);
        prefs.put("test.sources", testSrcPath);
        if (!SeamFacetAbstractInstallDelegate.isWarConfiguration(this.model)) {
            prefs.put("seam.ejb.project", this.ejbProjectName);
            prefs.put("seam.ear.project", this.earProjectName);
            String srcPath = this.seamWebProject.getFullPath().removeLastSegments(1).append(this.ejbProjectName).append("ejbModule").toString();
            prefs.put("model.sources", srcPath);
            prefs.put("action.sources", srcPath);
        } else {
            IVirtualComponent component = ComponentCore.createComponent((IProject)this.seamWebProject);
            IVirtualFolder rootFolder = component.getRootFolder();
            IContainer sourceFolder = rootFolder.getFolder((IPath)new Path("/WEB-INF/classes")).getUnderlyingFolder();
            IContainer parentFolder = sourceFolder.getParent();
            IPath srcRootFolder = parentFolder.getFullPath();
            IPath srcFolder = sourceFolder.getFullPath();
            IPath model = srcRootFolder.append("main");
            IPath action = srcRootFolder.append("hot");
            IResource modelFolder = parentFolder.findMember("main");
            IResource actionFolder = parentFolder.findMember("hot");
            if (modelFolder == null || !modelFolder.exists() || actionFolder == null || !actionFolder.exists()) {
                model = srcFolder;
                action = srcFolder;
            }
            prefs.put("model.sources", model.toString());
            prefs.put("action.sources", action.toString());
        }
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            SeamCorePlugin.getPluginLog().logError((Throwable)e);
        }
    }

    protected void configureJBossAppXml() {
    }

    protected boolean shouldCopyLibrariesAndTemplates(IDataModel model) {
        return model.getBooleanProperty("seam.templates.copying");
    }

    protected boolean shouldCopyLibraries(IDataModel model) {
        return model.getBooleanProperty("seam.runtime.libraries.copying");
    }
}

