/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.jboss.tools.seam.core.ISeamComponent;
import org.jboss.tools.seam.core.SeamCoreMessages;
import org.jboss.tools.seam.internal.core.refactoring.SeamRenameProcessor;

public class RenameComponentProcessor
extends SeamRenameProcessor {
    public RenameComponentProcessor(ISeamComponent component) {
        this.setComponent(component);
    }

    public ISeamComponent getComponent() {
        return this.component;
    }

    public void setComponent(ISeamComponent component) {
        this.component = component;
        this.setOldName(component.getName());
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        this.status = new RefactoringStatus();
        if (this.component != null) {
            this.checkDeclarations(this.component);
            if (this.status.hasFatalError()) {
                return this.status;
            }
            this.rootChange = new CompositeChange(SeamCoreMessages.RENAME_SEAM_COMPONENT_PROCESSOR_TITLE);
            this.renameComponent(pm, this.component);
        }
        return this.status;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus result = new RefactoringStatus();
        if (this.component == null) {
            result.addFatalError(SeamCoreMessages.RENAME_SEAM_COMPONENT_PROCESSOR_THIS_IS_NOT_A_SEAM_COMPONENT);
        }
        return result;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return this.rootChange;
    }

    public Object[] getElements() {
        return new ISeamComponent[]{this.component};
    }

    public String getIdentifier() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getProcessorName() {
        return SeamCoreMessages.RENAME_SEAM_COMPONENT_PROCESSOR_TITLE;
    }

    public boolean isApplicable() throws CoreException {
        return this.component != null;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        return EMPTY_REF_PARTICIPANT;
    }
}

