/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.ltk.core.refactoring.Change;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.internal.core.refactoring.SeamProjectChange;
import org.osgi.service.prefs.BackingStoreException;

public class SeamFolderMoveChange
extends SeamProjectChange {
    private IResource oldResource;
    private IContainer destination;
    private List<String> relevantProperties = new ArrayList<String>();

    public SeamFolderMoveChange(IProject project, IResource oldResource, IContainer destination) {
        super(project);
        this.oldResource = oldResource;
        this.destination = destination;
        if (oldResource.getProject().equals((Object)destination.getProject())) {
            IEclipsePreferences ps = this.getSeamPreferences();
            int i = 0;
            while (i < FOLDER_PROPERTIES.length) {
                String oldPathString;
                String propertyValue = ps.get(FOLDER_PROPERTIES[i], null);
                if (propertyValue != null && (propertyValue.equals(oldPathString = oldResource.getFullPath().toString()) || propertyValue.startsWith(String.valueOf(oldPathString) + "/"))) {
                    this.relevantProperties.add(FOLDER_PROPERTIES[i]);
                }
                ++i;
            }
            this.findPreferences(ps);
        }
    }

    private void findPreferences(IEclipsePreferences ps) {
        for (String propertyName : this.relevantProperties) {
            String propertyValue = ps.get(propertyName, "");
            String oldPathString = this.oldResource.getFullPath().toString();
            String newPath = this.destination.getFullPath().append(this.oldResource.getName()).toString();
            if (propertyValue.equals(oldPathString)) {
                this.preferences.put(propertyName, newPath);
                continue;
            }
            if (!propertyValue.startsWith(String.valueOf(oldPathString) + "/")) continue;
            newPath = String.valueOf(newPath) + propertyValue.substring(oldPathString.length());
            this.preferences.put(propertyName, newPath);
        }
    }

    @Override
    public boolean isRelevant() {
        return !this.relevantProperties.isEmpty();
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        if (!this.isRelevant()) {
            return null;
        }
        try {
            pm.beginTask(this.getName(), 1);
            IEclipsePreferences ps = this.getSeamPreferences();
            for (String key : this.preferences.keySet()) {
                ps.put(key, (String)this.preferences.get(key));
            }
            try {
                ps.flush();
            }
            catch (BackingStoreException e) {
                SeamCorePlugin.getPluginLog().logError((Throwable)e);
            }
            IFile newResource = this.destination.getFile((IPath)new Path(this.oldResource.getName()));
            IContainer oldContainer = this.oldResource.getParent();
            SeamFolderMoveChange seamFolderMoveChange = new SeamFolderMoveChange(this.project, (IResource)newResource, oldContainer);
            return seamFolderMoveChange;
        }
        finally {
            pm.done();
        }
    }
}

