/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core.scanner.java;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.jboss.tools.common.model.project.ext.impl.ValueInfo;
import org.jboss.tools.seam.internal.core.SeamImport;
import org.jboss.tools.seam.internal.core.SeamNamespace;
import org.jboss.tools.seam.internal.core.scanner.java.ComponentBuilder;
import org.jboss.tools.seam.internal.core.scanner.java.SeamAnnotations;

class PackageInfoVisitor
extends ASTVisitor
implements SeamAnnotations {
    List<SeamNamespace> namespaces = new ArrayList<SeamNamespace>();
    List<SeamImport> imports = new ArrayList<SeamImport>();
    String javaPackage = null;

    public boolean visit(PackageDeclaration node) {
        if (node.getName() != null) {
            this.javaPackage = node.getName().getFullyQualifiedName();
        }
        return true;
    }

    public boolean visit(NormalAnnotation node) {
        IAnnotationBinding b = node.resolveAnnotationBinding();
        if (b != null) {
            String type = b.getAnnotationType().getQualifiedName();
            if ("org.jboss.seam.annotations.Namespace".equals(type)) {
                ValueInfo value = ValueInfo.getValueInfo((Annotation)node, (String)"value");
                ValueInfo prefix = ValueInfo.getValueInfo((Annotation)node, (String)"prefix");
                SeamNamespace ns = new SeamNamespace();
                if (value != null) {
                    ns.setURI(value.getValue());
                }
                this.namespaces.add(ns);
            } else if ("org.jboss.seam.annotations.Import".equals(type)) {
                List<String> is = ComponentBuilder.getArrayValue((Annotation)node);
                for (String s : is) {
                    SeamImport i = new SeamImport();
                    i.setSeamPackage(s);
                    this.imports.add(i);
                }
            }
        }
        return true;
    }

    public boolean visit(SingleMemberAnnotation node) {
        String type;
        IAnnotationBinding b = node.resolveAnnotationBinding();
        if (b != null && "org.jboss.seam.annotations.Import".equals(type = b.getAnnotationType().getQualifiedName())) {
            List<String> is = ComponentBuilder.getArrayValue((Annotation)node);
            for (String s : is) {
                SeamImport i = new SeamImport();
                i.setSeamPackage(s);
                this.imports.add(i);
            }
        }
        return true;
    }
}

