/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core.scanner.lib;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.jboss.tools.common.model.XJob;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.filesystems.impl.LibsListener;
import org.jboss.tools.common.model.project.ext.AbstractClassPathMonitor;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.jst.web.model.helpers.InnerModelHelper;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.internal.core.SeamProject;
import org.jboss.tools.seam.internal.core.scanner.LoadedDeclarations;
import org.jboss.tools.seam.internal.core.scanner.ScannerException;
import org.jboss.tools.seam.internal.core.scanner.lib.LibraryScanner;

public class ClassPath
extends AbstractClassPathMonitor<SeamProject>
implements LibsListener {
    boolean isProcessed = false;

    public ClassPath(SeamProject project) {
        this.project = project;
    }

    public IProject getProjectResource() {
        return ((SeamProject)this.project).getProject();
    }

    public void init() {
        this.model = InnerModelHelper.createXModel((IProject)((SeamProject)this.project).getProject());
        super.init();
    }

    public void process() {
        this.isProcessed = true;
        try {
            this.doProcess();
        }
        finally {
            this.isProcessed = false;
        }
    }

    protected void doProcess() {
        for (String p : this.syncProcessedPaths()) {
            ((SeamProject)this.project).pathRemoved((IPath)new Path(p));
        }
        int i = 0;
        while (i < this.paths.size()) {
            String p = (String)this.paths.get(i);
            if (this.requestForLoad(p)) {
                XModelObject o;
                LibraryScanner scanner = new LibraryScanner();
                scanner.setClassPath(this);
                String fileName = new File(p).getName();
                if (!EclipseResourceUtil.SYSTEM_JAR_SET.contains(fileName) && (o = FileSystemsHelper.getLibs((XModel)this.model).getLibrary(p)) != null) {
                    LoadedDeclarations c = null;
                    try {
                        if (LibraryScanner.isLikelyComponentSource(o)) {
                            c = scanner.parse(o, (IPath)new Path(p), (ISeamProject)this.project);
                        }
                    }
                    catch (ScannerException e) {
                        SeamCorePlugin.getDefault().logError(e);
                    }
                    if (c == null) {
                        c = new LoadedDeclarations();
                    }
                    this.componentsLoaded(c, (IPath)new Path(p));
                }
            }
            ++i;
        }
        this.validateProjectDependencies();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitProcess() {
        int count = 0;
        while (this.isProcessed) {
            try {
                ClassPath classPath = this;
                synchronized (classPath) {
                    ((Object)((Object)this)).wait(100L);
                }
                if (++count < 50) continue;
                String message = "Failed to wait for class path build";
                SeamCorePlugin.getDefault().logWarning(message, new Exception(message));
            }
            catch (InterruptedException e) {
                SeamCorePlugin.getDefault().logError(e);
            }
            break;
        }
    }

    public void validateProjectDependencies() {
        List<SeamProject> ps = null;
        try {
            ps = this.getSeamProjects(((SeamProject)this.project).getProject());
        }
        catch (CoreException e) {
            SeamCorePlugin.getDefault().logError(e);
        }
        if (ps != null) {
            Set<SeamProject> set = ((SeamProject)this.project).getSeamProjects();
            HashSet<SeamProject> removable = new HashSet<SeamProject>();
            removable.addAll(set);
            removable.removeAll(ps);
            ps.removeAll(set);
            for (SeamProject p : ps) {
                ((SeamProject)this.project).addSeamProject(p);
            }
            for (SeamProject p : removable) {
                ((SeamProject)this.project).removeSeamProject(p);
            }
        }
    }

    public boolean hasToUpdateProjectDependencies() {
        List<SeamProject> ps = null;
        try {
            ps = this.getSeamProjects(((SeamProject)this.project).getProject());
        }
        catch (CoreException e) {
            SeamCorePlugin.getDefault().logError(e);
        }
        if (ps != null) {
            Set<SeamProject> set = ((SeamProject)this.project).getSeamProjects();
            HashSet<SeamProject> removable = new HashSet<SeamProject>();
            removable.addAll(set);
            removable.removeAll(ps);
            ps.removeAll(set);
            Iterator<SeamProject> iterator = ps.iterator();
            if (iterator.hasNext()) {
                iterator.next();
                return true;
            }
            iterator = removable.iterator();
            if (iterator.hasNext()) {
                iterator.next();
                return true;
            }
        }
        return false;
    }

    void componentsLoaded(LoadedDeclarations c, IPath path) {
        if (c == null) {
            return;
        }
        ((SeamProject)this.project).registerComponents(c, path);
    }

    List<SeamProject> getSeamProjects(IProject project) throws CoreException {
        ArrayList<SeamProject> list = new ArrayList<SeamProject>();
        if (project.isAccessible() && project.hasNature("org.eclipse.jdt.core.javanature")) {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IClasspathEntry[] es = javaProject.getResolvedClasspath(true);
            int i = 0;
            while (i < es.length) {
                ISeamProject sp;
                IProject p;
                if (es[i].getEntryKind() == 2 && (p = ResourcesPlugin.getWorkspace().getRoot().getProject(es[i].getPath().lastSegment())) != null && p.isAccessible() && (sp = SeamCorePlugin.getSeamProject(p, false)) != null) {
                    list.add((SeamProject)sp);
                }
                ++i;
            }
        }
        return list;
    }

    public void build() {
        this.waitProcess();
        if (this.update()) {
            this.process();
        } else if (this.hasToUpdateProjectDependencies()) {
            this.validateProjectDependencies();
        }
    }

    public void pathsChanged(List<String> paths) {
        super.pathsChanged(paths);
        if (((SeamProject)this.project).isStorageResolved()) {
            XJob.addRunnableWithPriority((XJob.XRunnable)new XJob.XRunnable(){

                public void run() {
                    if (!ClassPath.this.isProcessed && ClassPath.this.update()) {
                        ClassPath.this.process();
                    }
                }

                public String getId() {
                    return "Update class path of Seam project " + ((SeamProject)ClassPath.this.project).getProject().getName();
                }
            });
        }
    }
}

