/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.seam.core.international.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jboss.tools.cdi.seam.core.international.IBundle;
import org.jboss.tools.cdi.seam.core.international.IProperty;
import org.jboss.tools.cdi.seam.core.international.impl.LocalizedValue;
import org.jboss.tools.cdi.seam.core.international.impl.PropertyImpl;
import org.jboss.tools.common.model.XModelObject;

public class BundleImpl
implements IBundle {
    String name = "";
    Map<String, XModelObject> objects = new TreeMap<String, XModelObject>();
    Map<String, PropertyImpl> properties = null;

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        this.name = s;
    }

    @Override
    public Set<String> getPropertyNames() {
        this.initProperties();
        return this.properties.keySet();
    }

    public void initProperties() {
        if (this.properties == null) {
            HashMap<String, PropertyImpl> ps = new HashMap<String, PropertyImpl>();
            for (XModelObject o : this.objects.values()) {
                XModelObject[] os;
                XModelObject[] xModelObjectArray = os = o.getChildren();
                int n = os.length;
                int n2 = 0;
                while (n2 < n) {
                    XModelObject p = xModelObjectArray[n2];
                    String name = p.getAttributeValue("name");
                    PropertyImpl pi = this._getProperty(name, ps);
                    pi.addObject(p);
                    ++n2;
                }
            }
            this.properties = ps;
        }
    }

    public void addObject(XModelObject o) {
        this.objects.put(LocalizedValue.getLocale(o), o);
    }

    @Override
    public IProperty getProperty(String name) {
        this.initProperties();
        return this.properties.get(name);
    }

    private PropertyImpl _getProperty(String name, Map<String, PropertyImpl> properties) {
        PropertyImpl p = properties.get(name);
        if (p == null) {
            p = new PropertyImpl();
            p.setBundle(this);
            p.setName(name);
            properties.put(name, p);
        }
        return p;
    }

    public Map<String, XModelObject> getObjects() {
        return this.objects;
    }
}

