/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.jbpm.template;

import java.util.ArrayList;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractTemplate;
import org.jboss.tools.vpe.editor.template.VpeChildrenInfo;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMNodeList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JBPMDataForm
extends VpeAbstractTemplate {
    private static final String JBPM_FORM_HEADER_TYPE = "vpe-jbpm-form-header";

    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        nsIDOMElement element = visualDocument.createElement("table");
        Element sourceElement = (Element)sourceNode;
        element.setAttribute("style", String.valueOf(this.computeBaseTableStyleValue()) + (sourceElement.hasAttribute("style") ? sourceElement.getAttribute("style") : ""));
        VpeCreationData creationData = new VpeCreationData((nsIDOMNode)element);
        VpeChildrenInfo childrenInfo = new VpeChildrenInfo(element);
        NodeList children = sourceNode.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node childNode = children.item(i);
            if (childNode instanceof Element && (childNode.getNodeName().endsWith(":datacell") || childNode.getNodeName().endsWith(":facet"))) {
                childrenInfo.addSourceChild(childNode);
            }
            ++i;
        }
        creationData.addChildrenInfo(childrenInfo);
        return creationData;
    }

    public void validate(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument, VpeCreationData data) {
        nsIDOMNode visualNode = data.getNode();
        nsIDOMElement visualTable = (nsIDOMElement)visualNode.queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}");
        nsIDOMElement[] tableRows = this.getTableRows(visualTable);
        nsIDOMElement formHeader = this.getDataFormHeader(visualTable);
        while (visualTable.hasChildNodes()) {
            visualTable.removeChild(visualTable.getFirstChild());
        }
        nsIDOMElement colFroupElement = visualDocument.createElement("colgroup");
        colFroupElement.setAttribute("span", "2");
        visualTable.appendChild((nsIDOMNode)colFroupElement);
        nsIDOMElement theadElement = visualDocument.createElement("thead");
        nsIDOMElement trHeadElement = visualDocument.createElement("tr");
        theadElement.appendChild((nsIDOMNode)trHeadElement);
        visualTable.appendChild((nsIDOMNode)theadElement);
        if (formHeader != null) {
            trHeadElement.appendChild((nsIDOMNode)formHeader);
        }
        nsIDOMElement tbodyElement = visualDocument.createElement("tbody");
        visualTable.appendChild((nsIDOMNode)tbodyElement);
        int i = 0;
        while (i < tableRows.length) {
            tbodyElement.appendChild((nsIDOMNode)tableRows[i]);
            ++i;
        }
    }

    private nsIDOMElement[] getTableRows(nsIDOMElement tableElement) {
        ArrayList<nsIDOMElement> rowElements = new ArrayList<nsIDOMElement>(0);
        nsIDOMNodeList tableList = tableElement.getElementsByTagName("tr");
        if (tableList != null) {
            int i = 0;
            while ((long)i < tableList.getLength()) {
                rowElements.add((nsIDOMElement)tableList.item((long)i).queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}"));
                ++i;
            }
        }
        return rowElements.toArray(new nsIDOMElement[0]);
    }

    private nsIDOMElement getDataFormHeader(nsIDOMElement tableElement) {
        nsIDOMNodeList headsList = tableElement.getElementsByTagName("th");
        if (headsList == null) {
            return null;
        }
        int i = 0;
        while ((long)i < headsList.getLength()) {
            nsIDOMElement element = (nsIDOMElement)headsList.item((long)i).queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}");
            if (JBPM_FORM_HEADER_TYPE.equals(element.getAttribute("vpe-pseudo-type"))) {
                return element;
            }
            ++i;
        }
        return null;
    }

    private String computeBaseTableStyleValue() {
        StringBuilder builder = new StringBuilder("");
        builder.append("font-family:verdana,sans-serif;");
        builder.append("font-size:10pt;");
        builder.append("font-weight:normal;");
        builder.append("margin-right:auto;");
        builder.append("margin-left:auto;");
        builder.append("border-collapse:collapse;");
        builder.append("border:1px solid #000000");
        return builder.toString();
    }
}

