/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.seam.config.ui;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.cdi.seam.config.ui.CDISeamConfigUIPlugin;

public class CDISeamConfigUiImages {
    private static CDISeamConfigUiImages INSTANCE;
    public static final Image PACKAGE_IMAGE;
    private URL baseUrl;
    private CDISeamConfigUiImages parentRegistry;

    static {
        try {
            INSTANCE = new CDISeamConfigUiImages(new URL(CDISeamConfigUIPlugin.getDefault().getBundle().getEntry("/"), "icons/"));
        }
        catch (MalformedURLException e) {
            CDISeamConfigUIPlugin.getDefault().logError(e);
        }
        PACKAGE_IMAGE = CDISeamConfigUiImages.getImage("package.gif");
    }

    public static Image getImage(String key) {
        return INSTANCE.createImageDescriptor(key).createImage();
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        return INSTANCE.createImageDescriptor(key);
    }

    public static void setImageDescriptors(IAction action, String iconName) {
        action.setImageDescriptor(INSTANCE.createImageDescriptor(iconName));
    }

    public static CDISeamConfigUiImages getInstance() {
        return INSTANCE;
    }

    protected CDISeamConfigUiImages(URL registryUrl, CDISeamConfigUiImages parent) {
        if (registryUrl == null) {
            throw new IllegalArgumentException();
        }
        this.baseUrl = registryUrl;
        this.parentRegistry = parent;
    }

    protected CDISeamConfigUiImages(URL url) {
        this(url, null);
    }

    public Image getImageByFileName(String key) {
        return this.createImageDescriptor(key).createImage();
    }

    public ImageDescriptor createImageDescriptor(String key) {
        try {
            return ImageDescriptor.createFromURL((URL)this.makeIconFileURL(key));
        }
        catch (MalformedURLException malformedURLException) {
            if (this.parentRegistry == null) {
                return ImageDescriptor.getMissingImageDescriptor();
            }
            return this.parentRegistry.createImageDescriptor(key);
        }
    }

    private URL makeIconFileURL(String name) throws MalformedURLException {
        if (name == null) {
            throw new MalformedURLException();
        }
        return new URL(this.baseUrl, name);
    }
}

