/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.text.ext.hyperlink;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.jboss.tools.cdi.text.ext.CDIExtensionsMessages;
import org.jboss.tools.cdi.text.ext.CDIExtensionsPlugin;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlink;

public class DisposerHyperlink
extends AbstractHyperlink {
    IMethod method;

    public DisposerHyperlink(IRegion region, IMethod method, IDocument document) {
        this.method = method;
        this.setRegion(region);
        this.setDocument(document);
    }

    protected void doHyperlink(IRegion region) {
        IEditorPart part = null;
        if (this.method != null) {
            try {
                part = JavaUI.openInEditor((IJavaElement)this.method);
            }
            catch (JavaModelException ex) {
                CDIExtensionsPlugin.getDefault().logError(ex);
            }
            catch (PartInitException ex) {
                CDIExtensionsPlugin.getDefault().logError(ex);
            }
            if (part != null) {
                JavaUI.revealInEditor((IEditorPart)part, (IJavaElement)this.method);
            }
        }
        if (part == null) {
            this.openFileFailed();
        }
    }

    public String getHyperlinkText() {
        String text = String.valueOf(CDIExtensionsMessages.CDI_PRODUCER_DISPOSER_HYPERLINK_OPEN_BOUND_DISPOSER) + " ";
        if (this.method != null) {
            text = String.valueOf(text) + this.method.getElementName();
        }
        return text;
    }
}

