/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.text.ext.hyperlink;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.text.JavaWordFinder;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.jboss.tools.cdi.core.CDICoreNature;
import org.jboss.tools.cdi.core.CDIUtil;
import org.jboss.tools.cdi.core.IBean;
import org.jboss.tools.cdi.core.ICDIProject;
import org.jboss.tools.cdi.core.IClassBean;
import org.jboss.tools.cdi.core.IInjectionPoint;
import org.jboss.tools.cdi.core.IObserverMethod;
import org.jboss.tools.cdi.core.IParameter;
import org.jboss.tools.cdi.text.ext.CDIExtensionsPlugin;
import org.jboss.tools.cdi.text.ext.hyperlink.EventHyperlink;
import org.jboss.tools.cdi.text.ext.hyperlink.EventListHyperlink;
import org.jboss.tools.cdi.text.ext.hyperlink.ObserverMethodHyperlink;
import org.jboss.tools.cdi.text.ext.hyperlink.ObserverMethodListHyperlink;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlink;

public class EventAndObserverMethodHyperlinkDetector
extends AbstractHyperlinkDetector {
    protected IFile file;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        ITextEditor textEditor = (ITextEditor)this.getAdapter(ITextEditor.class);
        if (region == null) return null;
        if (!(textEditor instanceof JavaEditor)) {
            return null;
        }
        if (textEditor.getEditorInput() instanceof IFileEditorInput) {
            this.file = ((IFileEditorInput)textEditor.getEditorInput()).getFile();
        }
        int offset = region.getOffset();
        ITypeRoot input = EditorUtility.getEditorInputJavaElement((IEditorPart)textEditor, (boolean)true);
        if (input == null) {
            return null;
        }
        IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
        IRegion wordRegion = JavaWordFinder.findWord((IDocument)document, (int)offset);
        if (wordRegion == null) {
            return null;
        }
        IProject project = null;
        project = input.getJavaProject().getProject();
        if (project == null) {
            return null;
        }
        CDICoreNature cdiNature = CDIUtil.getCDINatureWithProgress((IProject)project);
        if (cdiNature == null) {
            return null;
        }
        IJavaElement[] elements = null;
        try {
            ArrayList<AbstractHyperlink> hyperlinks;
            block20: {
                Set<IParameter> param;
                ICDIProject cdiProject;
                block21: {
                    elements = input.codeSelect(wordRegion.getOffset(), wordRegion.getLength());
                    if (elements == null) {
                        return null;
                    }
                    if (elements.length != 1) {
                        return null;
                    }
                    hyperlinks = new ArrayList<AbstractHyperlink>();
                    int position = 0;
                    if (elements[0] instanceof IType) {
                        elements[0] = input.getElementAt(wordRegion.getOffset());
                        if (elements[0] == null) {
                            return null;
                        }
                        if (elements[0] instanceof IMethod) {
                            position = offset;
                        }
                    }
                    if ((cdiProject = CDIUtil.getCDIProject((IFile)this.file, (CDICoreNature)cdiNature, (boolean)textEditor.isDirty())) == null) break block20;
                    IInjectionPoint injectionPoint = this.findInjectedPoint(cdiProject, elements[0], position, input.getPath());
                    param = this.findObserverParameter(cdiProject, elements[0], offset, input.getPath());
                    if (injectionPoint == null) break block21;
                    Collection observerMethods = cdiProject.resolveObserverMethods(injectionPoint);
                    if (observerMethods.size() == 1) {
                        hyperlinks.add(new ObserverMethodHyperlink(region, (IObserverMethod)observerMethods.iterator().next(), document));
                        break block20;
                    } else if (observerMethods.size() > 0) {
                        hyperlinks.add(new ObserverMethodListHyperlink(textViewer, region, observerMethods, document));
                    }
                    break block20;
                }
                if (param != null) {
                    HashSet<IInjectionPoint> events = new HashSet<IInjectionPoint>();
                    Iterator<IParameter> iterator = param.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            if (events.size() != 1) break;
                            hyperlinks.add(new EventHyperlink(region, (IInjectionPoint)events.iterator().next(), document));
                            break block20;
                        }
                        IParameter p = iterator.next();
                        events.addAll(cdiProject.findObservedEvents(p));
                    }
                    if (events.size() > 0) {
                        hyperlinks.add(new EventListHyperlink(textViewer, region, events, document));
                    }
                }
            }
            if (hyperlinks == null) return null;
            if (hyperlinks.isEmpty()) return null;
            return hyperlinks.toArray(new IHyperlink[hyperlinks.size()]);
        }
        catch (JavaModelException jme) {
            CDIExtensionsPlugin.getDefault().logError(jme);
        }
        return null;
    }

    private IInjectionPoint findInjectedPoint(ICDIProject cdiProject, IJavaElement element, int offset, IPath path) {
        return CDIUtil.findInjectionPoint((Collection)cdiProject.getBeans(path), (IJavaElement)element, (int)offset);
    }

    private Set<IParameter> findObserverParameter(ICDIProject cdiProject, IJavaElement element, int offset, IPath path) throws JavaModelException {
        HashSet<IParameter> result = new HashSet<IParameter>();
        for (IBean bean : cdiProject.getBeans(path)) {
            if (!(bean instanceof IClassBean)) continue;
            for (IObserverMethod bm : ((IClassBean)bean).getObserverMethods()) {
                IObserverMethod obs;
                Collection ps;
                ISourceRange sr = bm.getMethod().getSourceRange();
                if (sr.getOffset() > offset || sr.getOffset() + sr.getLength() < offset || (ps = (obs = bm).getObservedParameters()).isEmpty()) continue;
                result.add((IParameter)ps.iterator().next());
            }
        }
        return result;
    }
}

