/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.text.ext.hyperlink;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.text.JavaWordFinder;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.jboss.tools.cdi.core.CDICoreNature;
import org.jboss.tools.cdi.core.CDIUtil;
import org.jboss.tools.cdi.core.IBean;
import org.jboss.tools.cdi.core.ICDIProject;
import org.jboss.tools.cdi.core.IInjectionPoint;
import org.jboss.tools.cdi.text.ext.CDIExtensionsPlugin;
import org.jboss.tools.cdi.text.ext.hyperlink.AssignableBeansHyperlink;
import org.jboss.tools.cdi.text.ext.hyperlink.InjectedPointHyperlink;

public class InjectedPointHyperlinkDetector
extends AbstractHyperlinkDetector {
    private IRegion region;
    protected IDocument document;
    protected ITextViewer viewer;
    protected IFile file;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        this.region = region;
        this.viewer = textViewer;
        ITextEditor textEditor = (ITextEditor)this.getAdapter(ITextEditor.class);
        if (region == null) return null;
        if (!(textEditor instanceof JavaEditor)) {
            return null;
        }
        if (textEditor.getEditorInput() instanceof IFileEditorInput) {
            this.file = ((IFileEditorInput)textEditor.getEditorInput()).getFile();
        }
        int offset = region.getOffset();
        ITypeRoot input = EditorUtility.getEditorInputJavaElement((IEditorPart)textEditor, (boolean)true);
        if (input == null) {
            return null;
        }
        this.document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
        IRegion wordRegion = JavaWordFinder.findWord((IDocument)this.document, (int)offset);
        if (wordRegion == null) {
            return null;
        }
        IProject project = null;
        project = input.getJavaProject().getProject();
        if (project == null) {
            return null;
        }
        CDICoreNature cdiNature = CDIUtil.getCDINatureWithProgress((IProject)project);
        if (cdiNature == null) {
            return null;
        }
        IJavaElement[] elements = null;
        try {
            elements = input.codeSelect(wordRegion.getOffset(), wordRegion.getLength());
            if (elements == null) {
                return null;
            }
            if (elements.length != 1) {
                return null;
            }
            ArrayList<IHyperlink> hyperlinks = new ArrayList<IHyperlink>();
            int position = 0;
            if (elements[0] instanceof IType) {
                elements[0] = input.getElementAt(wordRegion.getOffset());
                if (elements[0] == null) {
                    return null;
                }
                if (elements[0] instanceof IMethod) {
                    position = offset;
                }
            }
            this.findInjectedBeans(cdiNature, elements[0], position, input.getPath(), hyperlinks, textEditor.isDirty());
            if (hyperlinks == null) return null;
            if (hyperlinks.isEmpty()) return null;
            return hyperlinks.toArray(new IHyperlink[hyperlinks.size()]);
        }
        catch (JavaModelException jme) {
            CDIExtensionsPlugin.getDefault().logError(jme);
        }
        return null;
    }

    protected void findInjectedBeans(CDICoreNature nature, IJavaElement element, int offset, IPath path, ArrayList<IHyperlink> hyperlinks, boolean dirty) {
        ICDIProject cdiProject = CDIUtil.getCDIProject((IFile)this.file, (CDICoreNature)nature, (boolean)dirty);
        if (cdiProject == null) {
            return;
        }
        Collection beans = cdiProject.getBeans(path);
        IInjectionPoint injectionPoint = CDIUtil.findInjectionPoint((Collection)beans, (IJavaElement)element, (int)offset);
        if (injectionPoint == null) {
            return;
        }
        List resultBeans = CDIUtil.getSortedBeans((ICDIProject)cdiProject, (boolean)true, (IInjectionPoint)injectionPoint);
        Collection assignableBeans = cdiProject.getBeans(false, injectionPoint);
        if (assignableBeans.size() > 0) {
            if (resultBeans.size() > 0) {
                hyperlinks.add((IHyperlink)new InjectedPointHyperlink(this.region, (IBean)resultBeans.get(0), this.document, true));
            }
            if (assignableBeans.size() > 1) {
                hyperlinks.add((IHyperlink)new AssignableBeansHyperlink(this.region, injectionPoint, this.document));
            }
        }
    }
}

