/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.runtime.seam.detector.test;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.ide.eclipse.as.core.server.bean.JBossServerType;
import org.jboss.tools.runtime.core.JBossRuntimeLocator;
import org.jboss.tools.runtime.core.RuntimeCoreActivator;
import org.jboss.tools.runtime.core.model.IRuntimeDetector;
import org.jboss.tools.runtime.core.model.RuntimeDefinition;
import org.jboss.tools.runtime.core.model.RuntimePath;
import org.jboss.tools.runtime.seam.detector.test.IRuntimeDetectionConstants;
import org.jboss.tools.runtime.ui.RuntimeUIActivator;
import org.jboss.tools.seam.core.project.facet.SeamRuntime;
import org.jboss.tools.seam.core.project.facet.SeamRuntimeManager;
import org.jboss.tools.seam.core.project.facet.SeamVersion;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class SeamRuntimeDetectionTest
extends Assert {
    private static final String seamVersionAttributeName = "Seam-Version";
    private static final String SKIP_PRIVATE = "org.jboss.tools.tests.skipPrivateRequirements";

    @BeforeClass
    public static void create() {
        RuntimeCoreActivator.getDefault();
        RuntimeUIActivator.getDefault();
    }

    @Before
    public void setUp() {
        this.clearAll();
    }

    @After
    public void tearDown() {
        this.clearAll();
    }

    public void clearAll() {
        IServer[] s = ServerCore.getServers();
        int i = 0;
        while (i < s.length) {
            try {
                s[i].delete();
            }
            catch (CoreException ce) {
                ce.printStackTrace();
                SeamRuntimeDetectionTest.fail();
            }
            ++i;
        }
        IRuntime[] r = ServerCore.getRuntimes();
        int i2 = 0;
        while (i2 < r.length) {
            try {
                r[i2].delete();
            }
            catch (CoreException ce) {
                ce.printStackTrace();
                SeamRuntimeDetectionTest.fail();
            }
            ++i2;
        }
        SeamRuntime[] seamRuntimes = SeamRuntimeManager.getInstance().getRuntimes();
        int i3 = 0;
        while (i3 < seamRuntimes.length) {
            SeamRuntimeManager.getInstance().removeRuntime(seamRuntimes[i3]);
            ++i3;
        }
        SeamRuntimeManager.getInstance().save();
    }

    @Test
    public void testRuntimeDetectors() {
        Set detectors = RuntimeCoreActivator.getDefault().getRuntimeDetectors();
        SeamRuntimeDetectionTest.assertTrue((String)"Runtime detectors don't exist.", (detectors.size() > 0 ? 1 : 0) != 0);
        SeamRuntimeDetectionTest.assertTrue((boolean)this.handlerExists("org.jboss.tools.runtime.handlers.SeamHandler"));
    }

    private boolean handlerExists(String id) {
        Set detectors = RuntimeCoreActivator.getDefault().getRuntimeDetectors();
        boolean found = false;
        for (IRuntimeDetector next : detectors) {
            String nid = next.getId();
            if (!id.equals(nid)) continue;
            found = true;
        }
        return found;
    }

    @Test
    public void testJBossAs42() {
        this.testOneApplicationServer(IRuntimeDetectionConstants.JBOSS_42_HOME, "org.jboss.ide.eclipse.as.runtime.42");
    }

    @Test
    public void testJBossAs51() {
        this.testOneApplicationServer(IRuntimeDetectionConstants.JBOSS_51_HOME, "org.jboss.ide.eclipse.as.runtime.51");
    }

    @Test
    public void testJBossAs70() {
        this.testOneApplicationServer(IRuntimeDetectionConstants.JBOSS_70_HOME, "org.jboss.ide.eclipse.as.runtime.70");
    }

    public void testOneApplicationServer(String homeDir, String typeId) {
        List<RuntimeDefinition> runtimeDefinitions = this.initializeOnePath(homeDir);
        RuntimeDefinition def1 = runtimeDefinitions.get(0);
        def1.setEnabled(false);
        this.initializeDefinitions(runtimeDefinitions);
        int count = this.countRuntimesOfType(typeId);
        SeamRuntimeDetectionTest.assertEquals((long)0L, (long)count);
        def1.setEnabled(true);
        this.initializeDefinitions(runtimeDefinitions);
        count = this.countRuntimesOfType(typeId);
        SeamRuntimeDetectionTest.assertEquals((long)1L, (long)count);
    }

    private List<RuntimeDefinition> initializeOnePath(String homeDir) {
        RuntimePath path = this.createRuntimePath(homeDir, false);
        this.setRuntimePaths(path, true);
        File file = new File(path.getPath());
        SeamRuntimeDetectionTest.assertTrue((String)("The '" + file.getAbsolutePath() + "' path isn't valid."), (boolean)file.isDirectory());
        List<RuntimeDefinition> runtimeDefinitions = this.createDefinitionsForPath(path);
        SeamRuntimeDetectionTest.assertEquals((long)1L, (long)runtimeDefinitions.size());
        RuntimeDefinition def1 = runtimeDefinitions.get(0);
        File location = def1.getLocation();
        SeamRuntimeDetectionTest.assertTrue((String)("The '" + location.getAbsolutePath() + "' path isn't valid."), (boolean)location.isDirectory());
        return runtimeDefinitions;
    }

    @Test
    public void testJBossEap43() {
        if (Boolean.getBoolean(SKIP_PRIVATE)) {
            return;
        }
        List<RuntimeDefinition> runtimeDefinitions = this.initializeOnePath(IRuntimeDetectionConstants.EAP_43_HOME);
        RuntimeDefinition def1 = runtimeDefinitions.get(0);
        this.setServerDefinitionsEnabledRecurse(def1, false);
        this.initializeDefinitions(runtimeDefinitions);
        int count = this.countRuntimesOfType("org.jboss.ide.eclipse.as.runtime.eap.43");
        SeamRuntimeDetectionTest.assertEquals((long)0L, (long)count);
        count = this.countSeamRuntimesForVersion(SeamVersion.SEAM_1_2);
        SeamRuntimeDetectionTest.assertEquals((long)0L, (long)count);
        this.setServerDefinitionsEnabledRecurse(def1, true);
        this.initializeDefinitions(runtimeDefinitions);
        count = this.countRuntimesOfType("org.jboss.ide.eclipse.as.runtime.eap.43");
        SeamRuntimeDetectionTest.assertEquals((long)1L, (long)count);
        count = this.countSeamRuntimesForVersion(SeamVersion.SEAM_1_2);
        SeamRuntimeDetectionTest.assertEquals((long)1L, (long)count);
    }

    private void setServerDefinitionsEnabledRecurse(RuntimeDefinition def, boolean enabled) {
        def.setEnabled(enabled);
        List nested = def.getIncludedRuntimeDefinitions();
        Iterator i = nested.iterator();
        while (i.hasNext()) {
            this.setServerDefinitionsEnabledRecurse((RuntimeDefinition)i.next(), enabled);
        }
    }

    @Test
    public void testSeam20() throws Exception {
        this.testOneSeamLocation(IRuntimeDetectionConstants.SEAM_20_HOME, SeamVersion.SEAM_2_0, "2.0");
    }

    @Test
    public void testSeam22() throws Exception {
        this.testOneSeamLocation(IRuntimeDetectionConstants.SEAM_22_HOME, SeamVersion.SEAM_2_2, "2.2");
    }

    public void testOneSeamLocation(String homeDir, SeamVersion version, String versionString) throws Exception {
        this.testSeamHome(homeDir, versionString);
        List<RuntimeDefinition> runtimeDefinitions = this.initializeOnePath(homeDir);
        RuntimeDefinition def1 = runtimeDefinitions.get(0);
        def1.setEnabled(false);
        this.initializeDefinitions(runtimeDefinitions);
        int count = this.countSeamRuntimesForVersion(version);
        SeamRuntimeDetectionTest.assertEquals((long)0L, (long)count);
        def1.setEnabled(true);
        this.initializeDefinitions(runtimeDefinitions);
        count = this.countSeamRuntimesForVersion(version);
        SeamRuntimeDetectionTest.assertEquals((long)1L, (long)count);
        List nested = def1.getIncludedRuntimeDefinitions();
        System.out.println(nested.size());
    }

    private void testSeamHome(String seamHome, String seamVersion) throws IOException {
        File file = new File(seamHome);
        SeamRuntimeDetectionTest.assertTrue((String)("The '" + file.getAbsolutePath() + "' path isn't valid."), (boolean)file.isDirectory());
        String[] seamFiles = file.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if ("seam-gen".equals(name)) {
                    return true;
                }
                return "lib".equals(name);
            }
        });
        SeamRuntimeDetectionTest.assertTrue((String)("seamFiles : " + seamFiles), (seamFiles != null && seamFiles.length == 2 ? 1 : 0) != 0);
        File jarFile = new File(seamHome, "lib/jboss-seam.jar");
        SeamRuntimeDetectionTest.assertTrue((String)("The '" + jarFile.getAbsolutePath() + "' path isn't valid."), (boolean)jarFile.isFile());
        JarFile jar = new JarFile(jarFile);
        Attributes attributes = jar.getManifest().getMainAttributes();
        String version = attributes.getValue(seamVersionAttributeName);
        SeamRuntimeDetectionTest.assertTrue((String)("seamVersion: " + version), (version != null && version.startsWith(seamVersion) ? 1 : 0) != 0);
    }

    private void initializeDefinitions(List<RuntimeDefinition> runtimeDefinitions) {
        Set detectors = RuntimeCoreActivator.getDefault().getRuntimeDetectors();
        for (IRuntimeDetector detector : detectors) {
            if (!detector.isEnabled()) continue;
            detector.initializeRuntimes(runtimeDefinitions);
        }
    }

    private List<RuntimeDefinition> createDefinitionsForPath(RuntimePath runtimePath) {
        JBossRuntimeLocator locator = new JBossRuntimeLocator();
        List serverDefinitions = locator.searchForRuntimes(runtimePath.getPath(), (IProgressMonitor)new NullProgressMonitor());
        return serverDefinitions;
    }

    private RuntimePath createRuntimePath(String path, boolean enableForStartup) {
        RuntimePath runtimePath = new RuntimePath(path);
        runtimePath.setScanOnEveryStartup(enableForStartup);
        return runtimePath;
    }

    private void setRuntimePaths(RuntimePath runtimePath, boolean save) {
        if (save) {
            RuntimeUIActivator.getDefault().saveRuntimePreferences();
        }
    }

    private int countSeamRuntimesForVersion(SeamVersion version) {
        SeamRuntime[] seamRuntimes = SeamRuntimeManager.getInstance().getRuntimes();
        int count = 0;
        SeamRuntime[] seamRuntimeArray = seamRuntimes;
        int n = seamRuntimes.length;
        int n2 = 0;
        while (n2 < n) {
            SeamRuntime seamRuntime = seamRuntimeArray[n2];
            SeamVersion version2 = seamRuntime.getVersion();
            if (version.equals((Object)version2)) {
                ++count;
            }
            ++n2;
        }
        return count;
    }

    private int countRuntimesOfType(String typeId) {
        IRuntime[] runtimes = ServerCore.getRuntimes();
        int count = 0;
        IRuntime[] iRuntimeArray = runtimes;
        int n = runtimes.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntime runtime = iRuntimeArray[n2];
            IRuntimeType runtimeType = runtime.getRuntimeType();
            if (typeId.equals(runtimeType.getId())) {
                ++count;
            }
            ++n2;
        }
        return count;
    }

    public void testWtpRuntimes() {
        IRuntime[] runtimes = ServerCore.getRuntimes();
        SeamRuntimeDetectionTest.assertTrue((String)("runtimes.length\nExpected: 4\nWas: " + runtimes.length), (runtimes.length == 4 ? 1 : 0) != 0);
    }

    public void testIncludedDefinitions() {
        for (RuntimeDefinition serverDefinition : RuntimeUIActivator.getDefault().getServerDefinitions()) {
            String type = serverDefinition.getType();
            if (!JBossServerType.EAP.getId().equals(type)) continue;
            SeamRuntimeDetectionTest.assertTrue((String)"EAP has to include server definitions", (serverDefinition.getIncludedRuntimeDefinitions().size() > 0 ? 1 : 0) != 0);
            for (RuntimeDefinition included : serverDefinition.getIncludedRuntimeDefinitions()) {
                SeamRuntimeDetectionTest.assertTrue((String)"Invalid parent definition", (included.getParent() == serverDefinition ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void testSeamFoundTwice() {
        if (Boolean.getBoolean(SKIP_PRIVATE)) {
            return;
        }
        List<RuntimeDefinition> runtimeDefinitions = this.initializeOnePath(IRuntimeDetectionConstants.EAP_43_HOME);
        RuntimeDefinition def1 = runtimeDefinitions.get(0);
        File location = def1.getLocation();
        File serverDir = new File(location, "server");
        boolean exists = serverDir.exists();
        try {
            serverDir.mkdir();
            this.setServerDefinitionsEnabledRecurse(def1, true);
            this.initializeDefinitions(runtimeDefinitions);
            int count = def1.getIncludedRuntimeDefinitions().size();
            SeamRuntimeDetectionTest.assertEquals((long)2L, (long)count);
        }
        finally {
            if (!exists) {
                serverDir.delete();
            }
        }
    }
}

