/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.ui.editor.internal.extensions;

import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionException;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.jboss.tools.batch.ui.editor.internal.model.Flow;
import org.jboss.tools.batch.ui.editor.internal.model.Job;
import org.jboss.tools.batch.ui.editor.internal.model.Split;

public class BatchPathFunction
extends Function {
    private static final char SEPARATOR = '/';

    public String name() {
        return "BatchPath";
    }

    public FunctionResult evaluate(FunctionContext context) {
        return new FunctionResult(this, context){

            protected Object evaluate() throws FunctionException {
                StringBuilder path = new StringBuilder();
                try {
                    Element element = (Element)this.cast(this.operand(0), Element.class);
                    do {
                        path.insert(0, BatchPathFunction.label(element));
                        path.insert(0, '/');
                    } while (element.parent() != null && (element = element.parent().element()) != null);
                }
                catch (ClassCastException e) {
                    ((LoggingService)Sapphire.service(LoggingService.class)).log((Throwable)e);
                }
                return path.toString();
            }
        };
    }

    private static String label(Element element) {
        String id = null;
        if (element instanceof Job) {
            id = (String)((Job)element).getId().content();
        } else if (element instanceof Flow) {
            id = (String)((Flow)element).getId().content();
        } else if (element instanceof Split) {
            id = (String)((Split)element).getId().content();
        }
        if (id != null) {
            return id;
        }
        StringBuilder label = new StringBuilder("<");
        label.append(element.type().getSimpleName().toLowerCase());
        label.append(">");
        return label.toString();
    }
}

