/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.ui.editor.internal.services.diagram.layout.persistence;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.FileUtil;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.ValidateEditException;
import org.jboss.tools.batch.ui.editor.internal.model.Flow;
import org.jboss.tools.batch.ui.editor.internal.model.FlowElement;
import org.jboss.tools.batch.ui.editor.internal.model.Job;

class FileResourceStore2
extends ByteArrayResourceStore {
    static final String START = "{";
    static final String NAME_END = "-";
    static final String END = "}";
    static final String ROOT = "Root";
    private final File file;
    private String flowName;
    private Job job;

    public FileResourceStore2(File file, String flowName, Job job) throws ResourceStoreException {
        this.file = file;
        this.flowName = flowName;
        this.job = job;
        if (this.file.exists()) {
            int j;
            String contents = org.jboss.tools.common.util.FileUtil.readFile((File)file);
            int i = contents.indexOf(START + flowName + NAME_END);
            int n = j = i < 0 ? -1 : contents.indexOf(END, i);
            if (j > 0) {
                String c = contents.substring(i + flowName.length() + 2, j);
                this.setContents(new ByteArrayInputStream(c.getBytes()));
            }
        }
    }

    public File getFile() {
        return this.file;
    }

    public void save() throws ResourceStoreException {
        this.validateSave();
        try {
            FileUtil.mkdirs((File)this.file.getParentFile());
        }
        catch (IOException e) {
            throw new ResourceStoreException((Throwable)e);
        }
        String contents = org.jboss.tools.common.util.FileUtil.readFile((File)this.file);
        contents = this.cleanContents(contents);
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (FileOutputStream out = new FileOutputStream(this.file);){
                int i = contents.indexOf(START + this.flowName + NAME_END);
                int j = i < 0 ? -1 : contents.indexOf(END, i);
                contents = j > 0 ? String.valueOf(contents.substring(0, i + this.flowName.length() + 2)) + new String(this.getContents()) + contents.substring(j) : String.valueOf(contents) + "\n" + START + this.flowName + NAME_END + new String(this.getContents()) + END + "\n";
                ((OutputStream)out).write(contents.getBytes());
                out.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new ResourceStoreException((Throwable)e);
        }
    }

    public void validateSave() {
        if (this.file.exists() && !this.file.canWrite()) {
            throw new ValidateEditException();
        }
    }

    public <A> A adapt(Class<A> adapterType) {
        if (adapterType == File.class) {
            return adapterType.cast(this.file);
        }
        return (A)super.adapt(adapterType);
    }

    String cleanContents(String contents) {
        Set<String> flows = this.collectFlowIds(this.job);
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (contents.indexOf(START, i) >= 0) {
            String flow;
            int i1 = contents.indexOf(START, i);
            int i2 = contents.indexOf(NAME_END, i1);
            int i3 = contents.indexOf(END, i1);
            if (i3 < 0) {
                i3 = contents.length();
            }
            if (flows.contains(flow = contents.substring(i1 + 1, i2))) {
                result.append(contents.substring(i, i3 + 1));
            }
            i = i3 + 1;
        }
        result.append(contents.substring(i));
        return result.toString();
    }

    Set<String> collectFlowIds(Job job) {
        HashSet<String> result = new HashSet<String>();
        result.add(ROOT);
        this.collectFlowIds((ElementList<FlowElement>)job.getFlowElements(), result);
        return result;
    }

    void collectFlowIds(ElementList<FlowElement> es, Set<String> result) {
        for (FlowElement f : es) {
            if (!(f instanceof Flow)) continue;
            result.add((String)f.getId().content());
            this.collectFlowIds((ElementList<FlowElement>)((Flow)f).getFlowElements(), result);
        }
    }
}

