/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.ui.editor.internal.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.tools.batch.core.BatchArtifactType;
import org.jboss.tools.batch.ui.editor.internal.model.Analyzer;
import org.jboss.tools.batch.ui.editor.internal.model.Batchlet;
import org.jboss.tools.batch.ui.editor.internal.model.CheckpointAlgorithm;
import org.jboss.tools.batch.ui.editor.internal.model.Collector;
import org.jboss.tools.batch.ui.editor.internal.model.Decision;
import org.jboss.tools.batch.ui.editor.internal.model.JobListener;
import org.jboss.tools.batch.ui.editor.internal.model.Mapper;
import org.jboss.tools.batch.ui.editor.internal.model.Processor;
import org.jboss.tools.batch.ui.editor.internal.model.Reader;
import org.jboss.tools.batch.ui.editor.internal.model.Reducer;
import org.jboss.tools.batch.ui.editor.internal.model.RefAttributeElement;
import org.jboss.tools.batch.ui.editor.internal.model.StepListener;
import org.jboss.tools.batch.ui.editor.internal.model.Writer;

public class ModelToBatchArtifactsMapping {
    private static Map<Class<? extends RefAttributeElement>, List<BatchArtifactType>> mapping = new HashMap<Class<? extends RefAttributeElement>, List<BatchArtifactType>>();

    static {
        mapping.put(Batchlet.class, ModelToBatchArtifactsMapping.one(BatchArtifactType.BATCHLET));
        mapping.put(Decision.class, ModelToBatchArtifactsMapping.one(BatchArtifactType.DECIDER));
        mapping.put(Analyzer.class, ModelToBatchArtifactsMapping.one(BatchArtifactType.PARTITION_ANALYZER));
        mapping.put(Collector.class, ModelToBatchArtifactsMapping.one(BatchArtifactType.PARTITION_COLLECTOR));
        mapping.put(Mapper.class, ModelToBatchArtifactsMapping.one(BatchArtifactType.PARTITION_MAPPER));
        mapping.put(Reducer.class, ModelToBatchArtifactsMapping.one(BatchArtifactType.PARTITION_REDUCER));
        mapping.put(Processor.class, ModelToBatchArtifactsMapping.one(BatchArtifactType.ITEM_PROCESSOR));
        mapping.put(Reader.class, ModelToBatchArtifactsMapping.one(BatchArtifactType.ITEM_READER));
        mapping.put(Writer.class, ModelToBatchArtifactsMapping.one(BatchArtifactType.ITEM_WRITER));
        mapping.put(JobListener.class, ModelToBatchArtifactsMapping.one(BatchArtifactType.JOB_LISTENER));
        mapping.put(CheckpointAlgorithm.class, ModelToBatchArtifactsMapping.one(BatchArtifactType.CHECKPOINT_ALGORITHM));
        mapping.put(StepListener.class, ModelToBatchArtifactsMapping.all(BatchArtifactType.STEP_LISTENER, BatchArtifactType.CHUNK_LISTENER, BatchArtifactType.ITEM_READ_LISTENER, BatchArtifactType.ITEM_PROCESS_LISTENER, BatchArtifactType.ITEM_WRITE_LISTENER, BatchArtifactType.SKIP_READ_LISTENER, BatchArtifactType.SKIP_PROCESS_LISTENER, BatchArtifactType.SKIP_WRITE_LISTENER, BatchArtifactType.RETRY_READ_LISTENER, BatchArtifactType.RETRY_PROCESS_LISTENER, BatchArtifactType.RETRY_WRITE_LISTENER));
    }

    public static List<BatchArtifactType> getBatchArtifactTypes(Class<? extends RefAttributeElement> elementClass) {
        if (elementClass == null) {
            return Collections.emptyList();
        }
        List<BatchArtifactType> types = mapping.get(elementClass);
        if (types == null) {
            return Collections.emptyList();
        }
        return types;
    }

    private static List<BatchArtifactType> all(BatchArtifactType ... types) {
        return Collections.unmodifiableList(Arrays.asList(types));
    }

    private static List<BatchArtifactType> one(BatchArtifactType type) {
        return Collections.unmodifiableList(Collections.singletonList(type));
    }
}

