/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.ui.hyperlink;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.jboss.tools.batch.core.IBatchArtifact;
import org.jboss.tools.batch.core.IBatchProject;
import org.jboss.tools.batch.core.IBatchProperty;
import org.jboss.tools.batch.internal.core.impl.BatchProjectFactory;
import org.jboss.tools.batch.ui.BatchUIPlugin;
import org.jboss.tools.batch.ui.hyperlink.BatchHyperlinkMessages;
import org.jboss.tools.common.refactoring.MarkerResolutionUtils;
import org.jboss.tools.common.text.ext.hyperlink.OpenJavaElementHyperlink;
import org.jboss.tools.common.text.ext.hyperlink.xml.XMLJumpToHyperlink;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BatchHyperlinkDetector
extends AbstractHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        ArrayList<Object> links = new ArrayList<Object>();
        IBatchProject batchProject = this.getBatchProject(MarkerResolutionUtils.getFile());
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(textViewer.getDocument());
        try {
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Utils.AttrNodePair pair = Utils.findAttrNodePairForOffset((Node)xmlDocument, (int)region.getOffset());
            if (pair != null && pair.getNode() != null && pair.getAttribute() != null) {
                String ref;
                IRegion sourceRegion;
                if (batchProject != null && "ref".equalsIgnoreCase(pair.getAttribute().getNodeName())) {
                    IRegion sourceRegion2 = this.getAttributeValueSourceRegion(textViewer, region.getOffset(), (Attr)pair.getAttribute());
                    if (sourceRegion2 != null) {
                        Collection artifacts = batchProject.getArtifacts(pair.getAttribute().getNodeValue());
                        for (IBatchArtifact artifact : artifacts) {
                            IType type = artifact.getType();
                            links.add(new OpenJavaElementHyperlink(NLS.bind((String)BatchHyperlinkMessages.OPEN_JAVA_CLASS, (Object)type.getFullyQualifiedName()), textViewer.getDocument(), sourceRegion2, (IJavaElement)type));
                        }
                    }
                } else if ("next".equalsIgnoreCase(pair.getAttribute().getNodeName()) || "to".equalsIgnoreCase(pair.getAttribute().getNodeName()) || "restart".equalsIgnoreCase(pair.getAttribute().getNodeName())) {
                    IndexedRegion node;
                    IRegion sourceRegion3 = this.getAttributeValueSourceRegion(textViewer, region.getOffset(), (Attr)pair.getAttribute());
                    if (sourceRegion3 != null && (node = this.findNodeWithId(xmlDocument, null, pair.getAttribute().getNodeValue())) != null) {
                        Region targetRegion = new Region(node.getStartOffset(), ((IDOMElement)node).getStartEndOffset() - node.getStartOffset());
                        links.add(new XMLJumpToHyperlink(NLS.bind((String)BatchHyperlinkMessages.GO_TO_NODE, (Object)((Node)node).getNodeName(), (Object)pair.getAttribute().getNodeValue()), textViewer.getDocument(), sourceRegion3, (IRegion)targetRegion));
                    }
                } else if (batchProject != null && "property".equalsIgnoreCase(pair.getNode().getNodeName()) && "name".equalsIgnoreCase(pair.getAttribute().getNodeName()) && (sourceRegion = this.getAttributeValueSourceRegion(textViewer, region.getOffset(), (Attr)pair.getAttribute())) != null && (ref = this.findAttributeInAncestors((Node)pair.getNode(), "ref")) != null) {
                    Collection artifacts = batchProject.getArtifacts(ref);
                    for (IBatchArtifact artifact : artifacts) {
                        IBatchProperty property = artifact.getProperty(pair.getAttribute().getNodeValue());
                        if (property == null) continue;
                        IField field = property.getField();
                        links.add(new OpenJavaElementHyperlink(NLS.bind((String)BatchHyperlinkMessages.OPEN_JAVA_FIELD, (Object)(String.valueOf(field.getDeclaringType().getFullyQualifiedName()) + "." + field.getElementName())), textViewer.getDocument(), sourceRegion, (IJavaElement)field));
                    }
                }
            }
        }
        finally {
            smw.dispose();
        }
        if (links.size() == 0) {
            return null;
        }
        return links.toArray(new IHyperlink[links.size()]);
    }

    private IRegion getAttributeValueSourceRegion(ITextViewer textViewer, int offset, Attr attribute) {
        IRegion sourceRegion = null;
        try {
            sourceRegion = Utils.getAttributeValueRegion((IDocument)textViewer.getDocument(), (Attr)attribute);
        }
        catch (BadLocationException e) {
            BatchUIPlugin.getDefault().logError(e);
        }
        if (sourceRegion != null && offset >= sourceRegion.getOffset() && offset <= sourceRegion.getOffset() + sourceRegion.getLength()) {
            return sourceRegion;
        }
        return null;
    }

    private IBatchProject getBatchProject(IFile file) {
        IBatchProject batchProject;
        if (file != null && (batchProject = BatchProjectFactory.getBatchProjectWithProgress((IProject)file.getProject())) != null && batchProject.getDeclaredBatchJobs().contains(file)) {
            return batchProject;
        }
        return null;
    }

    private String findAttributeInAncestors(Node node, String attrName) {
        NamedNodeMap attributes;
        Node attr;
        if (node == null) {
            return null;
        }
        if (node.hasAttributes() && (attr = (attributes = node.getAttributes()).getNamedItem(attrName)) != null) {
            return attr.getNodeValue();
        }
        return this.findAttributeInAncestors(node.getParentNode(), attrName);
    }

    private IndexedRegion findNodeWithId(Node node, String nodeName, String id) {
        NamedNodeMap attributes;
        Node attr;
        if (node instanceof IndexedRegion && (nodeName == null || nodeName.equalsIgnoreCase(node.getNodeName())) && node.hasAttributes() && (attr = (attributes = node.getAttributes()).getNamedItem("id")) != null && id.equalsIgnoreCase(attr.getNodeValue())) {
            return (IndexedRegion)node;
        }
        NodeList list = node.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node child = list.item(i);
            IndexedRegion result = this.findNodeWithId(child, nodeName, id);
            if (result != null) {
                return result;
            }
            ++i;
        }
        return null;
    }
}

