/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.batch.ui.internal.contentassist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameRequestor;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.wst.sse.ui.contentassist.CompletionProposalInvocationContext;
import org.eclipse.wst.sse.ui.internal.contentassist.CustomCompletionProposal;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.contentassist.AbstractXMLModelQueryCompletionProposalComputer;
import org.eclipse.wst.xml.ui.internal.contentassist.ContentAssistRequest;
import org.eclipse.wst.xml.ui.internal.contentassist.XMLContentModelGenerator;
import org.jboss.tools.batch.core.BatchArtifactType;
import org.jboss.tools.batch.core.BatchConstants;
import org.jboss.tools.batch.core.BatchCorePlugin;
import org.jboss.tools.batch.core.IBatchArtifact;
import org.jboss.tools.batch.core.IBatchProject;
import org.jboss.tools.batch.core.IBatchProperty;
import org.jboss.tools.batch.ui.BatchUIPlugin;
import org.jboss.tools.batch.ui.JobImages;
import org.jboss.tools.common.ui.CommonUIImages;
import org.jboss.tools.common.xml.XMLUtilities;
import org.jboss.tools.jst.web.kb.PageContextFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BatchJobCompletionProposalComputer
extends AbstractXMLModelQueryCompletionProposalComputer
implements BatchConstants {
    CompletionProposalInvocationContext context;
    IFile file;
    IBatchProject bp;
    IProgressMonitor monitor;

    public List computeCompletionProposals(CompletionProposalInvocationContext context, IProgressMonitor monitor) {
        this.monitor = monitor;
        if (context.getDocument() != null && context.getDocument().get().indexOf("<job ") < 0) {
            return new ArrayList();
        }
        return super.computeCompletionProposals(context, monitor);
    }

    protected XMLContentModelGenerator getContentGenerator() {
        return new XMLContentModelGenerator();
    }

    protected boolean validModelQueryNode(CMNode node) {
        return false;
    }

    protected void addAttributeValueProposals(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context) {
        Node n;
        this.context = context;
        this.file = PageContextFactory.getResource((IDocument)context.getDocument());
        this.bp = BatchCorePlugin.getBatchProject((IProject)this.file.getProject(), (boolean)true);
        if (this.bp == null) {
            return;
        }
        IDOMNode node = (IDOMNode)contentAssistRequest.getNode();
        if (!(node instanceof Element)) {
            return;
        }
        Element current = (Element)node;
        int begin = contentAssistRequest.getReplacementBeginPosition();
        int length = contentAssistRequest.getReplacementLength();
        String matchString = contentAssistRequest.getMatchString();
        if (matchString.startsWith("\"")) {
            matchString = matchString.substring(1);
            ++begin;
            length -= 2;
        }
        if ((n = this.findNodeForOffset(node, context.getInvocationOffset())) instanceof Attr) {
            if ("ref".equals(n.getNodeName())) {
                this.addRefAttributeValueProposals(contentAssistRequest, context, current, matchString, begin, length);
            } else if ("next".equals(n.getNodeName())) {
                this.addTransitionAttributeValueProposals(contentAssistRequest, context, current, matchString, begin, length, false);
            } else if ("to".equals(n.getNodeName())) {
                if ((current = (Element)current.getParentNode()) != null) {
                    this.addTransitionAttributeValueProposals(contentAssistRequest, context, current, matchString, begin, length, false);
                }
            } else if ("restart".equals(n.getNodeName())) {
                while (current != null && current.getParentNode() != null && !current.getParentNode().getNodeName().equals("job")) {
                    current = (Element)current.getParentNode();
                }
                if (current != null && current.getParentNode() != null && current.getParentNode().getNodeName().equals("job")) {
                    this.addTransitionAttributeValueProposals(contentAssistRequest, context, current, matchString, begin, length, true);
                }
            } else if ("name".equals(n.getNodeName()) && "property".equals(current.getNodeName())) {
                this.addPropertyNameValueProposals(contentAssistRequest, context, current, matchString, begin, length);
            } else if ("class".equals(n.getNodeName())) {
                try {
                    this.addClassValueProposals(contentAssistRequest, context, current, matchString, begin, length);
                }
                catch (JavaModelException e) {
                    BatchUIPlugin.getDefault().logError(e);
                }
            }
        }
    }

    private void addRefAttributeValueProposals(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context, Element current, String matchString, int begin, int length) {
        String tag = current.getNodeName();
        Collection<IBatchArtifact> as = null;
        if (current.getParentNode() == null || !(current.getParentNode().getParentNode() instanceof Element)) {
            return;
        }
        if ("listener".equals(tag)) {
            Element p = (Element)current.getParentNode().getParentNode();
            if (p != null && p.getNodeName().equals("job")) {
                as = this.bp.getArtifacts(BatchArtifactType.JOB_LISTENER);
            } else {
                as = this.bp.getArtifacts(BatchArtifactType.STEP_LISTENER);
                Element chunk = XMLUtilities.getUniqueChild((Element)p, (String)"chunk");
                if (chunk != null) {
                    as = new HashSet();
                    for (IBatchArtifact a : this.bp.getAllArtifacts()) {
                        BatchArtifactType t = a.getArtifactType();
                        if (!"step".equals(t.getTag())) continue;
                        as.add(a);
                    }
                }
            }
        } else {
            BatchArtifactType[] batchArtifactTypeArray = BatchArtifactType.values();
            int a = batchArtifactTypeArray.length;
            int n = 0;
            while (n < a) {
                BatchArtifactType t = batchArtifactTypeArray[n];
                if (t.getTag().equals(tag)) {
                    as = this.bp.getArtifacts(t);
                }
                ++n;
            }
        }
        if (as != null) {
            for (IBatchArtifact a : as) {
                String value = a.getName();
                if (!value.startsWith(matchString)) continue;
                CustomCompletionProposal proposal = new CustomCompletionProposal(value, begin, length, value.length(), JobImages.getImageByElement(a.getArtifactType()), value, null, String.valueOf(value) + ": " + a.getType().getElementName(), 850);
                contentAssistRequest.addProposal((ICompletionProposal)proposal);
            }
        }
    }

    private void addTransitionAttributeValueProposals(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context, Element current, String matchString, int begin, int length, boolean currentAllowed) {
        String currentId = current.getAttribute("id");
        Element parent = (Element)current.getParentNode();
        HashMap<String, String> ids = new HashMap<String, String>();
        NodeList nl = parent.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            String id1;
            Node cn = nl.item(i);
            if (cn instanceof Element && (id1 = ((Element)cn).getAttribute("id")) != null && id1.length() > 0 && (currentAllowed || !id1.equals(currentId))) {
                ids.put(id1, cn.getNodeName());
            }
            ++i;
        }
        for (String s : ids.keySet()) {
            if (!s.startsWith(matchString)) continue;
            CustomCompletionProposal proposal = new CustomCompletionProposal(s, begin, length, s.length(), JobImages.getImage("flow.png"), s, null, "<" + (String)ids.get(s) + " id=\"" + s + "\"" + ">", 850);
            contentAssistRequest.addProposal((ICompletionProposal)proposal);
        }
    }

    private void addPropertyNameValueProposals(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context, Element current, String matchString, int begin, int length) {
        Element properties = (Element)current.getParentNode();
        if (properties != null && "properties".equals(properties.getNodeName())) {
            Collection a;
            HashSet<String> existing = new HashSet<String>();
            Element[] elementArray = XMLUtilities.getChildren((Element)properties, (String)"property");
            int n = elementArray.length;
            int n2 = 0;
            while (n2 < n) {
                Element e = elementArray[n2];
                if (e != current) {
                    existing.add(e.getAttribute("name"));
                }
                ++n2;
            }
            HashSet<String> variants = new HashSet<String>();
            Element artifactElement = (Element)properties.getParentNode();
            String ref = artifactElement.getAttribute("ref").trim();
            if (ref != null && ref.length() > 0 && !(a = this.bp.getArtifacts(ref)).isEmpty()) {
                for (IBatchProperty prop : ((IBatchArtifact)a.iterator().next()).getProperties()) {
                    String nm = prop.getPropertyName();
                    if (existing.contains(nm)) continue;
                    variants.add(nm);
                }
            }
            while (artifactElement.getParentNode() instanceof Element) {
                properties = XMLUtilities.getUniqueChild((Element)(artifactElement = (Element)artifactElement.getParentNode()), (String)"properties");
                if (properties == null) continue;
                Element[] elementArray2 = XMLUtilities.getChildren((Element)properties, (String)"property");
                int n3 = elementArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    Element prop = elementArray2[n4];
                    String nm = prop.getAttribute("name");
                    if (!existing.contains(nm)) {
                        variants.add(nm);
                    }
                    ++n4;
                }
            }
            for (String s : variants) {
                if (!s.startsWith(matchString)) continue;
                CustomCompletionProposal proposal = new CustomCompletionProposal(s, begin, length, s.length(), JobImages.getImage("property.png"), s, null, s, 850);
                contentAssistRequest.addProposal((ICompletionProposal)proposal);
            }
        }
    }

    Node findNodeForOffset(IDOMNode node, int offset) {
        int i;
        if (node == null) {
            return null;
        }
        if (!node.contains(offset)) {
            return null;
        }
        if (node.hasChildNodes()) {
            NodeList children = node.getChildNodes();
            i = 0;
            while (children != null && i < children.getLength()) {
                IDOMNode child = (IDOMNode)children.item(i);
                if (child.contains(offset)) {
                    return this.findNodeForOffset(child, offset);
                }
                ++i;
            }
        }
        if (node.hasAttributes()) {
            NamedNodeMap attributes = node.getAttributes();
            i = 0;
            while (attributes != null && i < attributes.getLength()) {
                IDOMNode attr = (IDOMNode)attributes.item(i);
                if (attr.contains(offset)) {
                    return attr;
                }
                ++i;
            }
        }
        return node;
    }

    private void addClassValueProposals(final ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context, Element current, String matchString, final int begin, final int length) throws JavaModelException {
        if (matchString.length() > 0) {
            int lastDot = matchString.lastIndexOf(46);
            String packageNameString = null;
            String classNameString = matchString;
            int packagePatern = 1;
            if (lastDot > 0) {
                if (matchString.length() > lastDot + 1 && Character.isUpperCase(matchString.charAt(lastDot + 1))) {
                    classNameString = matchString.substring(lastDot + 1);
                    packageNameString = matchString.substring(0, lastDot);
                    packagePatern = 0;
                } else {
                    classNameString = null;
                    packageNameString = matchString;
                }
            }
            char[] packageName = packageNameString != null ? packageNameString.toCharArray() : null;
            char[] className = classNameString != null ? classNameString.toCharArray() : null;
            IProject project = this.bp.getProject();
            IJavaProject jp = JavaCore.create((IProject)project);
            IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{jp});
            SearchEngine engine = new SearchEngine();
            engine.searchAllTypeNames(packageName, packagePatern, className, 1, 5, scope, new TypeNameRequestor(){

                public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
                    StringBuffer fullName = new StringBuffer();
                    fullName.append(packageName).append('.').append(simpleTypeName);
                    String fn = fullName.toString();
                    CustomCompletionProposal proposal = new CustomCompletionProposal(fn, begin, length, fn.length(), CommonUIImages.getImage((ImageDescriptor)JavaPluginImages.DESC_OBJS_CLASS), new String(simpleTypeName), fn, null, fn, 850, true);
                    contentAssistRequest.addProposal((ICompletionProposal)proposal);
                }
            }, 1, this.monitor);
        }
    }
}

