/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.facelets.test;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.jboss.tools.jst.web.ui.internal.editor.jspeditor.JSPMultiPageEditor;
import org.jboss.tools.vpe.base.test.TestUtil;
import org.jboss.tools.vpe.base.test.VpeTest;
import org.jboss.tools.vpe.xulrunner.util.XPCOM;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMText;
import org.mozilla.interfaces.nsISupports;

public class FaceletsComponentTest
extends VpeTest {
    private static final String PAGE_HEADER = "Page Header";
    private static final String USER = "#{user}";
    private static final String COMPONENT_S_CONTENT_IS_NOT_SHOWN = "Component's content is not shown";
    private static final String TEMPLATE_WITH_RELATED_PATH_IS_NOT_INCLUDED = "Template with related path is not included";
    private static final String TEMPLATE_WITH_ABSOLUTE_PATH_IS_NOT_INCLUDED = "Template with absolute path is not included";
    private static final String DEFINED_CONTENT_IS_NOT_SHOWN = "Defined content is not shown";

    public FaceletsComponentTest() {
        this.setCheckWarning(false);
    }

    @BeforeClass
    public static void validateEnv() {
    }

    public void _testDebug() throws Throwable {
        nsIDOMElement element = this.performTestForFaceletComponent("components/debug.xhtml");
        nsIDOMNode node = (nsIDOMNode)XPCOM.queryInterface((nsISupports)element, nsIDOMNode.class);
        ArrayList elements = new ArrayList();
        TestUtil.findAllElementsByName((nsIDOMNode)node, elements, (String)"div");
        Assert.assertEquals((long)5L, (long)elements.size());
        nsIDOMElement divElement = (nsIDOMElement)XPCOM.queryInterface((nsISupports)((nsISupports)elements.get(4)), nsIDOMElement.class);
        nsIDOMText text = (nsIDOMText)XPCOM.queryInterface((nsISupports)divElement.getFirstChild(), nsIDOMText.class);
        Assert.assertEquals((String)"Debug's content is not shown", (Object)text.getNodeValue(), (Object)"Ctrl+Shift+");
        if (this.getException() != null) {
            throw this.getException();
        }
    }

    public void testDefine() throws Throwable {
        Assume.assumeFalse((boolean)VpeTest.skipTests);
        nsIDOMElement element = this.performTestForFaceletComponent("components/define.xhtml");
        nsIDOMNode node = (nsIDOMNode)XPCOM.queryInterface((nsISupports)element, nsIDOMNode.class);
        ArrayList elements = new ArrayList();
        TestUtil.findAllElementsByName((nsIDOMNode)node, elements, (String)"span");
        Assert.assertEquals((long)3L, (long)elements.size());
        nsIDOMElement elementSpan0 = (nsIDOMElement)XPCOM.queryInterface((nsISupports)((nsISupports)elements.get(0)), nsIDOMElement.class);
        nsIDOMElement elementSpan1 = (nsIDOMElement)XPCOM.queryInterface((nsISupports)((nsISupports)elements.get(1)), nsIDOMElement.class);
        nsIDOMElement elementSpan2 = (nsIDOMElement)XPCOM.queryInterface((nsISupports)((nsISupports)elements.get(2)), nsIDOMElement.class);
        nsIDOMText text0 = (nsIDOMText)XPCOM.queryInterface((nsISupports)elementSpan0.getFirstChild(), nsIDOMText.class);
        nsIDOMText text1 = (nsIDOMText)XPCOM.queryInterface((nsISupports)elementSpan1.getFirstChild(), nsIDOMText.class);
        nsIDOMText text2 = (nsIDOMText)XPCOM.queryInterface((nsISupports)elementSpan2.getFirstChild(), nsIDOMText.class);
        Assert.assertEquals((String)DEFINED_CONTENT_IS_NOT_SHOWN, (Object)text0.getNodeValue(), (Object)"Greeting Page");
        Assert.assertEquals((String)DEFINED_CONTENT_IS_NOT_SHOWN, (Object)text1.getNodeValue(), (Object)USER);
        Assert.assertEquals((String)DEFINED_CONTENT_IS_NOT_SHOWN, (Object)text2.getNodeValue(), (Object)"#{person.name}!");
        if (this.getException() != null) {
            throw this.getException();
        }
    }

    @Test
    public void testComposition() throws Throwable {
        Assume.assumeFalse((boolean)VpeTest.skipTests);
        nsIDOMElement element = this.performTestForFaceletComponent("components/composition_absolute.xhtml");
        this.checkTemplatePage(element, PAGE_HEADER, TEMPLATE_WITH_ABSOLUTE_PATH_IS_NOT_INCLUDED);
        element = this.performTestForFaceletComponent("components/composition_related.xhtml");
        this.checkTemplatePage(element, PAGE_HEADER, TEMPLATE_WITH_RELATED_PATH_IS_NOT_INCLUDED);
        if (this.getException() != null) {
            throw this.getException();
        }
    }

    @Test
    public void testComponent() throws Throwable {
        Assume.assumeFalse((boolean)VpeTest.skipTests);
        nsIDOMElement element = this.performTestForFaceletComponent("components/component.xhtml");
        nsIDOMNode node = (nsIDOMNode)XPCOM.queryInterface((nsISupports)element, nsIDOMNode.class);
        ArrayList elements = new ArrayList();
        TestUtil.findAllElementsByName((nsIDOMNode)node, elements, (String)"div");
        Assert.assertEquals((long)1L, (long)elements.size());
        nsIDOMElement div = (nsIDOMElement)XPCOM.queryInterface((nsISupports)((nsISupports)elements.get(0)), nsIDOMElement.class);
        String title = div.getAttribute("title");
        Assert.assertEquals((String)COMPONENT_S_CONTENT_IS_NOT_SHOWN, (Object)title.replaceAll("\\s+", ""), (Object)"ui:componentbinding:#{backingBean.menu}");
        if (this.getException() != null) {
            throw this.getException();
        }
    }

    @Test
    public void testRemove() throws Throwable {
        Assume.assumeFalse((boolean)VpeTest.skipTests);
        nsIDOMElement element = this.performTestForFaceletComponent("components/remove.xhtml");
        nsIDOMNode node = (nsIDOMNode)XPCOM.queryInterface((nsISupports)element, nsIDOMNode.class);
        ArrayList elements = new ArrayList();
        TestUtil.findElementsByName((nsIDOMNode)node, elements, (String)"span");
        int i = 0;
        while (i < elements.size()) {
            nsIDOMElement elementSpan = (nsIDOMElement)XPCOM.queryInterface((nsISupports)((nsISupports)elements.get(i)), nsIDOMElement.class);
            nsIDOMText text = (nsIDOMText)XPCOM.queryInterface((nsISupports)elementSpan.getFirstChild(), nsIDOMText.class);
            if (text != null) {
                Assert.assertEquals((String)"Content inside ui:remove tag shouldn't be shown", (Object)false, (Object)text.getNodeValue().equals("\nThis will be removed.\n"));
            }
            ++i;
        }
        if (this.getException() != null) {
            throw this.getException();
        }
    }

    @Test
    public void testDecorate() throws Throwable {
        Assume.assumeFalse((boolean)VpeTest.skipTests);
        nsIDOMElement element = this.performTestForFaceletComponent("components/decorate_absolute.xhtml");
        this.checkTemplatePage(element, PAGE_HEADER, TEMPLATE_WITH_ABSOLUTE_PATH_IS_NOT_INCLUDED);
        element = this.performTestForFaceletComponent("components/decorate_related.xhtml");
        this.checkTemplatePage(element, PAGE_HEADER, TEMPLATE_WITH_RELATED_PATH_IS_NOT_INCLUDED);
        if (this.getException() != null) {
            throw this.getException();
        }
    }

    @Test
    public void testRepeat() throws Throwable {
        Assume.assumeFalse((boolean)VpeTest.skipTests);
        nsIDOMElement element = this.performTestForFaceletComponent("components/repeat.xhtml");
        nsIDOMNode node = (nsIDOMNode)XPCOM.queryInterface((nsISupports)element, nsIDOMNode.class);
        ArrayList elements = new ArrayList();
        TestUtil.findElementsByName((nsIDOMNode)node, elements, (String)"dl");
        Assert.assertEquals((long)1L, (long)elements.size());
        nsIDOMElement elementDL = (nsIDOMElement)XPCOM.queryInterface((nsISupports)((nsISupports)elements.get(0)), nsIDOMElement.class);
        elements.clear();
        TestUtil.findAllElementsByName((nsIDOMNode)elementDL, elements, (String)"dt");
        Assert.assertEquals((long)1L, (long)elements.size());
        if (this.getException() != null) {
            throw this.getException();
        }
    }

    @Test
    public void testInclude() throws Throwable {
        Assume.assumeFalse((boolean)VpeTest.skipTests);
        nsIDOMElement element = this.performTestForFaceletComponent("components/include_absolute.xhtml");
        this.checkTemplatePage(element, PAGE_HEADER, TEMPLATE_WITH_ABSOLUTE_PATH_IS_NOT_INCLUDED);
        element = this.performTestForFaceletComponent("components/include_related.xhtml");
        this.checkTemplatePage(element, PAGE_HEADER, TEMPLATE_WITH_RELATED_PATH_IS_NOT_INCLUDED);
        if (this.getException() != null) {
            throw this.getException();
        }
    }

    @Test
    public void testFragment() throws Throwable {
        Assume.assumeFalse((boolean)VpeTest.skipTests);
        nsIDOMElement element = this.performTestForFaceletComponent("components/fragment.xhtml");
        nsIDOMNode node = (nsIDOMNode)XPCOM.queryInterface((nsISupports)element, nsIDOMNode.class);
        ArrayList elements = new ArrayList();
        TestUtil.findAllElementsByName((nsIDOMNode)node, elements, (String)"div");
        Assert.assertEquals((long)4L, (long)elements.size());
        nsIDOMElement div = (nsIDOMElement)XPCOM.queryInterface((nsISupports)((nsISupports)elements.get(3)), nsIDOMElement.class);
        String title = div.getAttribute("title");
        Assert.assertEquals((String)"Fragment's content is not shown", (Object)title.replaceAll("\\s+", ""), (Object)"ui:fragmentbinding:#{uiCache['searchResult']}");
        if (this.getException() != null) {
            throw this.getException();
        }
    }

    @Test
    public void testInsert() throws Throwable {
        Assume.assumeFalse((boolean)VpeTest.skipTests);
        this.performTestForVpeComponent((IFile)TestUtil.getComponentPath((String)"components/insert.xhtml", (String)"faceletsTest"));
    }

    private nsIDOMElement performTestForFaceletComponent(String componentPage) throws Throwable {
        TestUtil.waitForJobs();
        this.setException(null);
        IFile file = (IFile)TestUtil.getComponentPath((String)componentPage, (String)"faceletsTest");
        Assert.assertNotNull((String)("Could not open specified file. componentPage = " + componentPage + ";projectName = " + "faceletsTest"), (Object)file);
        FileEditorInput input = new FileEditorInput(file);
        Assert.assertNotNull((String)"Editor input is null", (Object)input);
        JSPMultiPageEditor part = this.openEditor((IEditorInput)input);
        nsIDOMDocument document = TestUtil.getVpeVisualDocument((JSPMultiPageEditor)part);
        nsIDOMElement element = document.getDocumentElement();
        Assert.assertNotNull((Object)element);
        return element;
    }

    @Test
    public void testParam() throws Throwable {
        Assume.assumeFalse((boolean)VpeTest.skipTests);
        nsIDOMElement element = this.performTestForFaceletComponent("components/param.xhtml");
        nsIDOMNode node = (nsIDOMNode)XPCOM.queryInterface((nsISupports)element, nsIDOMNode.class);
        ArrayList elements = new ArrayList();
        TestUtil.findAllElementsByName((nsIDOMNode)node, elements, (String)"td");
        Assert.assertEquals((long)5L, (long)elements.size());
        nsIDOMElement td = (nsIDOMElement)XPCOM.queryInterface((nsISupports)((nsISupports)elements.get(1)), nsIDOMElement.class);
        nsIDOMElement span = (nsIDOMElement)XPCOM.queryInterface((nsISupports)td.getFirstChild(), nsIDOMElement.class);
        nsIDOMText text = (nsIDOMText)XPCOM.queryInterface((nsISupports)span.getFirstChild(), nsIDOMText.class);
        Assert.assertEquals((String)COMPONENT_S_CONTENT_IS_NOT_SHOWN, (Object)text.getNodeValue(), (Object)USER);
        if (this.getException() != null) {
            throw this.getException();
        }
    }

    private void checkTemplatePage(nsIDOMElement element, String contextString, String message) {
        nsIDOMNode node = (nsIDOMNode)XPCOM.queryInterface((nsISupports)element, nsIDOMNode.class);
        ArrayList elements = new ArrayList();
        TestUtil.findAllElementsByName((nsIDOMNode)node, elements, (String)"td");
        Assert.assertEquals((String)message, (long)5L, (long)elements.size());
        nsIDOMElement td = (nsIDOMElement)XPCOM.queryInterface((nsISupports)((nsISupports)elements.get(0)), nsIDOMElement.class);
        nsIDOMElement div = (nsIDOMElement)XPCOM.queryInterface((nsISupports)td.getFirstChild(), nsIDOMElement.class);
        nsIDOMElement span = (nsIDOMElement)XPCOM.queryInterface((nsISupports)div.getFirstChild(), nsIDOMElement.class);
        nsIDOMText text = (nsIDOMText)XPCOM.queryInterface((nsISupports)span.getFirstChild(), nsIDOMText.class);
        Assert.assertEquals((String)message, (Object)contextString, (Object)text.getNodeValue());
    }

    @Test
    public void testAllTags() throws Throwable {
        Assume.assumeFalse((boolean)VpeTest.skipTests);
        this.performTestForVpeComponent((IFile)TestUtil.getComponentPath((String)"components/faceletsTest.xhtml", (String)"faceletsTest"));
    }
}

