/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.richfaces;

import java.io.File;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.jboss.tools.jsf.vpe.richfaces.RichFacesTemplatesActivator;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.util.ElServiceUtil;
import org.jboss.tools.vpe.editor.util.FileUtil;
import org.jboss.tools.vpe.editor.util.SourceDomUtil;
import org.jboss.tools.vpe.editor.util.VisualDomUtil;
import org.jboss.tools.vpe.xulrunner.util.XPCOM;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMNodeList;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.xpcom.XPCOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ComponentUtil {
    private static final String EMPTY_SELECT_ITEM_VALUE = "<f:selectItem/>";
    private static final String EMPTY_SELECT_ITEMS_VALUE = "<f:selectItems/>";
    private static final String SELECT_ITEMS = "selectItems";
    private static final String SELECT_ITEM = "selectItem";

    public static Node getFacet(Element sourceElement, String facetName, boolean returnTextNode) {
        NodeList children = sourceElement.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Element element;
            String name;
            Node node = children.item(i);
            if (node instanceof Element && node.getNodeName() != null && node.getNodeName().indexOf(":facet") > 0 && facetName.equals(name = (element = (Element)node).getAttribute("name"))) {
                NodeList childNodes = element.getChildNodes();
                Text textNode = null;
                int j = 0;
                while (j < childNodes.getLength()) {
                    Node child = childNodes.item(j);
                    if (child instanceof Element) {
                        return child;
                    }
                    if (child instanceof Text) {
                        textNode = (Text)child;
                    }
                    ++j;
                }
                if (returnTextNode) {
                    return textNode;
                }
            }
            ++i;
        }
        return null;
    }

    public static ArrayList<Node> getFacets(Element sourceElement, boolean returnTextNode) {
        ArrayList<Node> facets = new ArrayList<Node>();
        NodeList children = sourceElement.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node node = children.item(i);
            if (node instanceof Element && "f:facet".equals(node.getNodeName())) {
                Element element = (Element)node;
                NodeList childNodes = element.getChildNodes();
                Text textNode = null;
                int j = 0;
                while (j < childNodes.getLength()) {
                    Node child = childNodes.item(j);
                    if (child instanceof Element) {
                        facets.add(child);
                        break;
                    }
                    if (child instanceof Text) {
                        textNode = (Text)child;
                    }
                    ++j;
                }
                if (returnTextNode && facets.isEmpty()) {
                    facets.add(textNode);
                }
            }
            ++i;
        }
        return facets;
    }

    public static Element getFacet(Element sourceElement, String facetName) {
        return (Element)ComponentUtil.getFacet(sourceElement, facetName, false);
    }

    public static Element getFacetElement(Element sourceElement, String facetName) {
        NodeList children = sourceElement.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Element facetElement;
            String name;
            Node node = children.item(i);
            if (node instanceof Element && node.getNodeName() != null && node.getNodeName().indexOf(":facet") > 0 && facetName.equals(name = (facetElement = (Element)node).getAttribute("name"))) {
                return facetElement;
            }
            ++i;
        }
        return null;
    }

    public static Element getFacetElement(Element parentElement, String facetName, boolean last) {
        NodeList children = parentElement.getChildNodes();
        if (children != null) {
            int index = last ? children.getLength() - 1 : 0;
            int step = last ? -1 : 1;
            int stopIndex = last ? -1 : children.getLength();
            while (index != stopIndex) {
                Node child = children.item(index);
                if (child.getNodeType() == 1 && "facet".equals(child.getLocalName()) && facetName.equals(((Element)child).getAttribute("name"))) {
                    return (Element)child;
                }
                index += step;
            }
        }
        return null;
    }

    public static boolean isRendered(Element sourceElement) {
        return !"false".equalsIgnoreCase(sourceElement.getAttribute("rendered"));
    }

    public static void setCSSLink(VpePageContext pageContext, String cssHref, String ext) {
        String pluginPath = RichFacesTemplatesActivator.getPluginResourcePath();
        Path pluginFile = new Path(pluginPath);
        File cssFile = pluginFile.append(cssHref).toFile();
        if (cssFile.exists()) {
            String cssPath = "file:///" + cssFile.getPath().replace('\\', '/');
            pageContext.getVisualBuilder().replaceLinkNodeToHead(cssPath, ext, true);
        }
    }

    public static String getAbsoluteResourcePath(String resourcePathInPlugin) {
        String pluginPath = RichFacesTemplatesActivator.getPluginResourcePath();
        Path pluginFile = new Path(pluginPath);
        File file = pluginFile.append(resourcePathInPlugin).toFile();
        if (file.exists()) {
            return file.getAbsolutePath();
        }
        throw new IllegalArgumentException("Can't get path for " + resourcePathInPlugin);
    }

    public static String getAbsoluteWorkspacePath(String resourcePathInWorkspace, VpePageContext pageContext) {
        String resolvedValue = resourcePathInWorkspace.replaceFirst("^\\s*(\\#|\\$)\\{facesContext.externalContext.requestContextPath\\}", "");
        IFile baseFile = null;
        if (pageContext.getVisualBuilder().getCurrentIncludeInfo() != null && pageContext.getVisualBuilder().getCurrentIncludeInfo().getStorage() instanceof IFile) {
            baseFile = (IFile)pageContext.getVisualBuilder().getCurrentIncludeInfo().getStorage();
        }
        if (baseFile == null) {
            return resolvedValue;
        }
        resolvedValue = ElServiceUtil.replaceEl(baseFile, (String)resolvedValue);
        URI uri = null;
        try {
            uri = new URI(resolvedValue);
        }
        catch (URISyntaxException uRISyntaxException) {}
        if (uri != null && (uri.isAbsolute() || new File(resolvedValue).exists())) {
            return resolvedValue;
        }
        IFile resolvedFile = FileUtil.getFile((String)resolvedValue, (IFile)baseFile);
        if (resolvedFile != null) {
            return "file://" + resolvedFile.getLocation().toPortableString();
        }
        return resolvedValue;
    }

    public static void setImg(nsIDOMElement img, String fileImageName) {
        img.setAttribute("src", "file://" + ComponentUtil.getAbsoluteResourcePath(fileImageName).replace('\\', '/'));
    }

    public static void applyAttributeValueOnChildren(String attrName, String attrValue, List<nsIDOMElement> children) {
        if (children == null || attrName == null || attrValue == null) {
            return;
        }
        for (nsIDOMElement child : children) {
            child.setAttribute(attrName, attrValue);
            ComponentUtil.applyAttributeValueOnChildren(attrName, attrValue, ComponentUtil.getElementChildren(child));
        }
    }

    public static List<nsIDOMElement> getElementChildren(nsIDOMElement element) {
        nsIDOMNodeList children;
        ArrayList<nsIDOMElement> result = new ArrayList<nsIDOMElement>();
        if (element.hasChildNodes() && (children = element.getChildNodes()) != null) {
            long len = children.getLength();
            int i = 0;
            while ((long)i < len) {
                nsIDOMNode item = children.item((long)i);
                try {
                    nsIDOMElement elem = (nsIDOMElement)XPCOM.queryInterface((nsISupports)item, nsIDOMElement.class);
                    result.add(elem);
                }
                catch (XPCOMException xPCOMException) {}
                ++i;
            }
        }
        return result;
    }

    public static List<Node> getChildren(Element sourceElement, boolean returnTextNodes) {
        ArrayList<Node> children = new ArrayList<Node>();
        NodeList nodeList = sourceElement.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node child = nodeList.item(i);
            if (child instanceof Element && !child.getNodeName().equals("f:facet") || returnTextNodes && child.getNodeValue() != null && child.getNodeValue().trim().length() > 0) {
                children.add(child);
            }
            ++i;
        }
        return children;
    }

    public static List<Node> getChildren(Element sourceElement) {
        return ComponentUtil.getChildren(sourceElement, false);
    }

    public static List<nsIDOMNode> getChildren(nsIDOMElement visualElement, boolean returnTextNodes) {
        ArrayList<nsIDOMNode> children = new ArrayList<nsIDOMNode>();
        nsIDOMNodeList nodeList = visualElement.getChildNodes();
        int i = 0;
        while ((long)i < nodeList.getLength()) {
            nsIDOMNode child = nodeList.item((long)i);
            if ((child instanceof nsIDOMElement || returnTextNodes) && !child.getNodeName().equals("f:facet")) {
                children.add(child);
            }
            ++i;
        }
        return children;
    }

    public static List<nsIDOMNode> getChildren(nsIDOMElement visualElement) {
        return ComponentUtil.getChildren(visualElement, false);
    }

    public static boolean isFacet(Node sourceNode, String facetName) {
        String name;
        return sourceNode != null && sourceNode instanceof Element && sourceNode.getNodeName().equals("f:facet") && facetName.equals(name = ((Element)sourceNode).getAttribute("name"));
    }

    public static String getHeaderBackgoundImgStyle() {
        return ComponentUtil.getBackgoundImgStyle("common/background.gif");
    }

    public static String getBackgoundImgStyle(String imagePath) {
        String imgPath = ComponentUtil.getAbsoluteResourcePath(imagePath);
        String style = "background-image: url(file:///" + imgPath.replace('\\', '/') + ");";
        return style;
    }

    public static String getAttribute(Element sourceElement, String attributeName) {
        String attribute = "";
        if (sourceElement.hasAttribute(attributeName)) {
            attribute = sourceElement.getAttribute(attributeName);
        }
        return attribute;
    }

    public static String getAttribute(Element sourceElement, String attributeName, String defaultValue) {
        return sourceElement.hasAttribute(attributeName) ? sourceElement.getAttribute(attributeName) : defaultValue;
    }

    public static String getAttribute(nsIDOMElement sourceElement, String attributeName) {
        String attribute = sourceElement.getAttribute(attributeName);
        if (attribute == null) {
            attribute = "";
        }
        return attribute;
    }

    public static boolean parameterPresent(String style, String name) {
        if (style != null && style.length() > 0) {
            String[] styles = style.split(";");
            int i = 0;
            while (i < styles.length) {
                String[] pair = styles[i].split(":");
                if (pair[0].trim().equals(name)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static String getStyleParametr(String style, String name) {
        if (style != null && style.length() > 0) {
            String[] styles = style.split(";");
            int i = 0;
            while (i < styles.length) {
                String[] pair = styles[i].split(":");
                if (pair[0].trim().equals(name)) {
                    return pair[1].trim();
                }
                ++i;
            }
        }
        return null;
    }

    public static String addParameter(String style, String element) {
        String s = style.trim();
        return String.valueOf(style) + (s.length() == 0 || s.endsWith(";") ? "" : ";") + element;
    }

    public static void setImgFromResources(VpePageContext pageContext, nsIDOMElement img, String fileImageName, String undefinedImgName) {
        IEditorInput input = pageContext.getEditPart().getEditorInput();
        IPath inputPath = ComponentUtil.getInputParentPath(input);
        if (pageContext.getVisualBuilder().getCurrentIncludeInfo() == null || !(pageContext.getVisualBuilder().getCurrentIncludeInfo().getStorage() instanceof IFile)) {
            return;
        }
        String path = ElServiceUtil.replaceEl((IFile)((IFile)pageContext.getVisualBuilder().getCurrentIncludeInfo().getStorage()), (String)fileImageName);
        File file = new File(String.valueOf(inputPath.toOSString()) + File.separator + path);
        if (file.exists()) {
            img.setAttribute("src", "file://" + inputPath.toString() + "/" + path.replace('\\', '/'));
        } else {
            img.setAttribute("src", undefinedImgName.replace('\\', '/'));
        }
    }

    public static File openFile(VpePageContext pageContext, String fileName) {
        IEditorInput input = pageContext.getEditPart().getEditorInput();
        IPath inputPath = ComponentUtil.getInputParentPath(input);
        File file = new File(String.valueOf(inputPath.toOSString()) + File.separator + fileName);
        return file;
    }

    public static IPath getInputParentPath(IEditorInput input) {
        IFile inputFile;
        IPath inputPath = null;
        if (input instanceof ILocationProvider) {
            inputPath = ((ILocationProvider)input).getPath((Object)input);
        } else if (input instanceof IFileEditorInput && (inputFile = ((IFileEditorInput)input).getFile()) != null) {
            inputPath = inputFile.getLocation();
        }
        if (inputPath != null && !inputPath.isEmpty()) {
            inputPath = inputPath.removeLastSegments(1);
        }
        return inputPath;
    }

    public static void correctAttribute(Element sourceNode, nsIDOMElement targetNode, String sourceAttrName, String targetAttrName, String prefValue, String defValue) {
        String attrValue;
        String string = attrValue = sourceNode.hasAttribute(sourceAttrName) ? sourceNode.getAttribute(sourceAttrName) : null;
        if (prefValue != null && prefValue.trim().length() > 0 && attrValue != null) {
            attrValue = String.valueOf(prefValue.trim()) + " " + attrValue;
        }
        if (attrValue != null) {
            targetNode.setAttribute(targetAttrName, attrValue);
        } else if (defValue != null) {
            targetNode.setAttribute(targetAttrName, defValue);
        } else {
            targetNode.removeAttribute(sourceAttrName);
        }
    }

    public static boolean string2boolean(String str) {
        return !"false".equals(str);
    }

    public static void findElementsByName(Node node, List<Node> elements, String name) {
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (name.equalsIgnoreCase(child.getNodeName())) {
                elements.add(child);
            } else {
                ComponentUtil.findElementsByName(child, elements, name);
            }
            ++i;
        }
    }

    public static void findAllElementsByName(nsIDOMNode node, List<nsIDOMNode> elements, String name) {
        try {
            nsIDOMNodeList list = node.getChildNodes();
            if (node.getNodeName().equalsIgnoreCase(name)) {
                elements.add(node);
            }
            int i = 0;
            while ((long)i < list.getLength()) {
                ComponentUtil.findAllElementsByName(list.item((long)i), elements, name);
                ++i;
            }
        }
        catch (XPCOMException xPCOMException) {
            return;
        }
    }

    public static Integer parseWidthHeightValue(String value) {
        Integer rst = null;
        if (value == null || value.trim().length() == 0) {
            throw new NumberFormatException("Passed value is empty ");
        }
        rst = value.endsWith("px") ? Integer.valueOf(Integer.parseInt(value.substring(0, value.length() - 2))) : Integer.valueOf(Integer.parseInt(value));
        return rst;
    }

    public static int parseSizeAttribute(Element sourceElement, String attributeName, int defaultValue) {
        if (sourceElement.hasAttribute(attributeName)) {
            String attrValue = sourceElement.getAttribute(attributeName);
            if (attrValue.endsWith("px")) {
                attrValue = attrValue.substring(0, attrValue.length() - "px".length());
            }
            try {
                int intValue = Integer.decode(attrValue);
                return intValue;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return defaultValue;
    }

    public static int parseNumberAttribute(Element sourceElement, String attributeName, int defaultValue) {
        if (sourceElement.hasAttribute(attributeName)) {
            String attrValue = sourceElement.getAttribute(attributeName);
            try {
                int intValue = Integer.decode(attrValue);
                return intValue;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return defaultValue;
    }

    public static boolean isBlank(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static boolean isNotBlank(String value) {
        return !ComponentUtil.isBlank(value);
    }

    public static List<Element> getSelectItems(NodeList children) {
        ArrayList<Element> selectItems = new ArrayList<Element>();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child instanceof Element && child.getNodeName().indexOf(SELECT_ITEM) > 1) {
                selectItems.add((Element)child);
            }
            ++i;
        }
        return selectItems;
    }

    public static String getSelectItemValue(Element e) {
        String value = e.getAttribute("itemLabel");
        if (ComponentUtil.isBlank(value) && ComponentUtil.isBlank(value = e.getAttribute("itemValue"))) {
            if (e.getNodeName().endsWith(SELECT_ITEMS)) {
                value = e.getAttribute("value");
                if (ComponentUtil.isBlank(value)) {
                    value = EMPTY_SELECT_ITEMS_VALUE;
                }
            } else if (e.getNodeName().endsWith(SELECT_ITEM)) {
                value = EMPTY_SELECT_ITEM_VALUE;
            }
        }
        return value;
    }

    public static String encodeStyleClass(Object parentPredefined, Object predefined, Object parent, Object custom) {
        StringBuilder styleClass = new StringBuilder();
        if (parentPredefined != null) {
            styleClass.append(parentPredefined).append(" ");
        } else if (predefined != null) {
            styleClass.append(predefined).append(" ");
        }
        if (parent != null) {
            styleClass.append(parent).append(" ");
        }
        if (custom != null) {
            styleClass.append(custom);
        }
        if (styleClass.length() > 0) {
            return styleClass.toString();
        }
        return null;
    }

    public static ArrayList<Element> getColumnsWithFacet(ArrayList<Element> columns, String facetName) {
        ArrayList<Element> columnsWithFacet = new ArrayList<Element>();
        for (Element column : columns) {
            Element body = ComponentUtil.getFacet(column, facetName);
            if (body == null) continue;
            columnsWithFacet.add(column);
        }
        return columnsWithFacet;
    }

    public static double parseWidth(String widthAttribute) {
        double widthDouble = -1.0;
        if (ComponentUtil.isNotBlank(widthAttribute)) {
            try {
                int widthInt = Integer.parseInt(widthAttribute);
                widthDouble = (double)widthInt / 13.33333;
                BigDecimal b = new BigDecimal(widthDouble).setScale(5, 4);
                widthDouble = b.doubleValue();
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return widthDouble;
    }

    public static Node getFacetBody(VpePageContext pageContext, Element sourceElement, String facetName) {
        Element facet = SourceDomUtil.getFacetByName((VpePageContext)pageContext, (Element)sourceElement, (String)facetName);
        Map facetChildren = VisualDomUtil.findFacetElements((Node)facet, (VpePageContext)pageContext);
        return ComponentUtil.getFacetBody(facetChildren);
    }

    public static Node getFacetBody(Map<String, List<Node>> facetChildren) {
        Node facetBody = null;
        if (facetChildren.get(VisualDomUtil.FACET_ODD_TAGS).size() > 0) {
            ArrayList oddTags = new ArrayList(0);
            oddTags.addAll(facetChildren.get(VisualDomUtil.FACET_ODD_TAGS));
            facetBody = (Node)oddTags.get(0);
        } else if (facetChildren.get(VisualDomUtil.FACET_JSF_TAG).size() > 0) {
            facetBody = facetChildren.get(VisualDomUtil.FACET_JSF_TAG).get(0);
        }
        return facetBody;
    }
}

