/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.richfaces.template;

import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.tools.jsf.vpe.richfaces.ComponentUtil;
import org.jboss.tools.vpe.editor.VpeVisualDomBuilder;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.mapping.AttributeData;
import org.jboss.tools.vpe.editor.mapping.NodeData;
import org.jboss.tools.vpe.editor.mapping.VpeElementData;
import org.jboss.tools.vpe.editor.template.VpeAbstractTemplate;
import org.jboss.tools.vpe.editor.template.VpeChildrenInfo;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.jboss.tools.vpe.editor.template.VpeToggableTemplate;
import org.jboss.tools.vpe.xulrunner.util.XPCOM;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMNodeList;
import org.mozilla.interfaces.nsIDOMText;
import org.mozilla.interfaces.nsISupports;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RichFacesCalendarTemplate
extends VpeAbstractTemplate
implements VpeToggableTemplate {
    private static final WeakHashMap<Node, Object> expandedCalendars = new WeakHashMap();
    static final int COLUMN = 8;
    static final String FILL_WIDTH = "100%";
    static final int NUM_DAYS_IN_WEEK = 7;
    static final int NUM_WEEK_ON_PAGE = 6;
    static final int NUM_MONTHS = 12;
    static final int CALENDAR_WIDTH = 200;
    static final int CALENDAR_INPUT_WIDTH = 180;
    static final int CALENDAR_IMAGE_WIDTH = 20;
    static final int CALENDAR_CUSTOM_IMAGE_WIDTH = 40;
    static final int CALENDAR_BUTTON_WIDTH = 80;
    static final String DEFAULT_DATE_PATTERN = "MMM dd,yyyy";
    static final String CSS_R_C_INPUT = "rich-calendar-input";
    static final String CSS_R_C_BUTTON = "rich-calendar-button";
    static final String CSS_R_C_EXTERIOR = "rich-calendar-exterior";
    static final String CSS_R_C_HEADER = "rich-calendar-header";
    static final String CSS_R_C_TOOL = "rich-calendar-tool";
    static final String CSS_R_C_MONTH = "rich-calendar-month";
    static final String CSS_R_C_TOOL_CLOSE = "rich-calendar-tool-close";
    static final String CSS_R_C_DAYS = "rich-calendar-days";
    static final String CSS_R_C_WEEKENDS = "rich-calendar-weekends";
    static final String CSS_R_C_WEEK = "rich-calendar-week";
    static final String CSS_R_C_CELL = "rich-calendar-cell";
    static final String CSS_R_C_CELL_SIZE = "rich-calendar-cell-size";
    static final String CSS_R_C_HOLLY = "rich-calendar-holly";
    static final String CSS_R_C_BOUNDARY_DATES = "rich-calendar-boundary-dates";
    static final String CSS_R_C_BTN = "rich-calendar-btn";
    static final String CSS_R_C_TODAY = "rich-calendar-today";
    static final String CSS_R_C_SELECT = "rich-calendar-select";
    static final String CSS_R_C_TOOLFOOTER = "rich-calendar-toolfooter";
    static final String CSS_R_C_FOOTER = "rich-calendar-footer";
    static final String CSS_R_C_HEADER_OPTIONAL = "rich-calendar-header-optional";
    static final String CSS_R_C_FOOTER_OPTIONAL = "rich-calendar-footer-optional";
    static final String CSS_R_C_TOOL_BTN = "rich-calendar-tool-btn";
    private static final String WEEK_DAY_HTML_CLASS_ATTR = "rich-calendar-days";
    private static final String HOL_WEEK_DAY_HTML_CLASS_ATTR = "rich-calendar-days rich-calendar-weekends";
    private static final String TODAY_HTML_CLASS_ATTR = "rich-calendar-cell-size rich-calendar-cell rich-calendar-today";
    private static final String CUR_MONTH_HTML_CLASS_ATTR = "rich-calendar-cell-size rich-calendar-cell";
    private static final String HOL_CUR_MONTH_HTML_CLASS_ATTR = "rich-calendar-cell-size rich-calendar-cell rich-calendar-holly";
    private static final String OTHER_MONTH_HTML_CLASS_ATTR = "rich-calendar-cell-size rich-calendar-cell rich-calendar-boundary-dates";
    private static final String HOL_OTHER_MONTH_HTML_CLASS_ATTR = "rich-calendar-cell-size rich-calendar-cell rich-calendar-holly rich-calendar-boundary-dates";
    private static final String DIRECTIONS_TOP_LEFT = "top-left";
    private static final String DIRECTIONS_TOP_RIGHT = "top-right";
    private static final String DIRECTIONS_BOTTOM_LEFT = "bottom-left";
    private static final String DIRECTIONS_BOTTOM_RIGHT = "bottom-right";
    static final String DIRECTION_PATTERN = "(top|bottom)-(left|right)";
    static final String UNDEFINED = "undefined";
    static final int DEFAULT_CELL_WIDTH = 25;
    static final int DEFAULT_CELL_HEIGHT = 22;
    static final int DEFAULT_OPTIONAL_CELL_HEIGHT = 26;
    static final int JOINT_POINT_BOTTOM = 5;
    static final int JOINT_POINT_TOP = -17;
    static final String TOP = "top";
    static final String LEFT = "left";
    static final String HIDDEN = "hidden";
    static final String ATTR_SHOW_SHOW_WEEKS_DAY_BAR = "showWeekDaysBar";
    static final String ATTR_SHOW_WEEKS_BAR = "showWeeksBar";
    static final String ATTR_SHOW_HEADER = "showHeader";
    static final String ATTR_SHOW_FOOTER = "showFooter";
    static final String ATTR_CELL_HEIGHT = "cellHeight";
    static final String ATTR_CELL_WIDTH = "cellWidth";
    static final String ATTR_BUTTON_LABEL = "buttonLabel";
    static final String ATTR_SHOW_APPLY_BUTTON = "showApplyButton";
    static final String ATTR_DATE_PATTERN = "datePattern";
    static final String ATTR_FIRST_WEEK_DAY = "firstWeekDay";
    static final String ATTR_WEEK_DAY_LABELS_SHORT = "weekDayLabelsShort";
    static final String ATTR_MONTH_LABELS = "monthLabels";
    static final String ATTR_ENABLE_MANUAL_INPUT = "enableManualInput";
    static final String ATTR_TODAY_CONTROL_MODE = "todayControlMode";
    static final String NAME_FACET_OPTIONAL_FOOTER = "optionalFooter";
    static final String NAME_FACET_OPTIONAL_HEADER = "optionalHeader";
    static final String NAME_FACET_WEEK_DAY = "weekDay";
    static final String NAME_FACET_WEEK_NUMBER = "weekNumber";
    static final boolean FACET_SEARCH_ORDER = true;
    private static final String DEFAULT_INPUT_STYLE = "vertical-align: middle;";
    private static final String POSITION_RELATIVE_STYLE = "position: relative;";
    private static final String POSITION_ABSOLUTE_STYLE = "position: absolute;";
    private static final String STYLE_PATH = "calendar/calendar.css";
    private static final String DEFAULT_BUTTON_ICON = "calendar/calendar.gif";
    private static final String DEFAULT_BUTTON_ICON_DISABLED = "calendar/disabled_button.gif";
    private static final String SPARATOR_IMG = "calendar/separator.gif";
    private static final String DEFAULT_BUTTON_STYLE = "vertical-align: middle;";
    private static final String NEXT_MONTH_CONTROL = ">";
    private static final String PREVIOUS_MONTH_CONTROL = "<";
    private static final String NEXT_YEAR_CONTROL = ">>";
    private static final String PREVIOUS_YEAR_CONTROL = "<<";
    private static final String APPLY_CONTROL = "Apply";
    private static final String TODAY_CONTROL = "Today";
    private static final String CLOSE_CONTROL = "X";
    private int tableWidth;
    private int tableHeight;
    private Calendar calendar;
    private Locale locale;
    private String[] weekDays;
    private String[] months;
    private int horizontalOffset;
    private int verticalOffset;
    private String currentMonthControl;
    private String currentDayControl;
    private DirectionData direction;
    private DirectionData jointPoint;
    private int cellHeight;
    private int cellWidth;
    private int zindex;
    private String value;
    private String inputStyle;
    private String inputClass;
    private String inputSize;
    private boolean disabled;
    private String buttonIcon;
    private String buttonLabel;
    private String buttonClass;
    private String style;
    private String styleClass;
    private boolean showInput;
    private boolean showWeekDaysBar;
    private boolean showWeeksBar;
    private boolean showHeader;
    private boolean showFooter;
    private boolean showApplyButton;
    private boolean showTodayControl;
    private boolean popup;
    private int firstWeekDay;
    private String datePattern;

    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        Element source = (Element)sourceNode;
        this.readAttributes(pageContext, sourceNode);
        ComponentUtil.setCSSLink(pageContext, STYLE_PATH, "calendar");
        nsIDOMElement wrapper = visualDocument.createElement("span");
        VpeCreationData creationData = new VpeCreationData((nsIDOMNode)wrapper, true);
        if (!this.popup) {
            nsIDOMElement calendar = this.disabled ? visualDocument.createElement("div") : this.createCalendar(visualDocument, creationData, source);
            wrapper.appendChild((nsIDOMNode)calendar);
        } else {
            nsIDOMElement calendarWithPopup = this.createPopupCalendar(visualDocument, source, creationData);
            wrapper.appendChild((nsIDOMNode)calendarWithPopup);
        }
        return creationData;
    }

    public boolean recreateAtAttrChange(VpePageContext pageContext, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMElement visualNode, Object data, String name, String value) {
        return true;
    }

    private nsIDOMElement createCalendar(nsIDOMDocument visualDocument, VpeCreationData creationData, Element sourceElement) {
        Element optionalFooterFacet;
        nsIDOMElement table = visualDocument.createElement("table");
        table.setAttribute("cellpadding", "0");
        table.setAttribute("border", "0");
        table.setAttribute("cellspacing", "0");
        table.setAttribute("class", "rich-calendar-exterior " + this.styleClass);
        table.setAttribute("style", this.style);
        nsIDOMElement tbody = visualDocument.createElement("tbody");
        nsIDOMElement optionalHeader = null;
        nsIDOMElement header = null;
        nsIDOMElement calendarBody = this.createCalendarBody(visualDocument, creationData, sourceElement);
        nsIDOMElement footer = null;
        nsIDOMElement optionalFooter = null;
        Element optionalHeaderFacet = ComponentUtil.getFacetElement(sourceElement, NAME_FACET_OPTIONAL_HEADER, true);
        if (optionalHeaderFacet != null) {
            optionalHeader = this.createCustomBlock(visualDocument, optionalHeaderFacet, creationData, CSS_R_C_HEADER_OPTIONAL);
            this.tableHeight += 26;
        }
        if (this.showHeader) {
            Element headerFacet = ComponentUtil.getFacetElement(sourceElement, "header", true);
            if (headerFacet != null) {
                header = this.createCustomBlock(visualDocument, headerFacet, creationData, CSS_R_C_HEADER);
            } else {
                ArrayList<Cell> headerContent = new ArrayList<Cell>();
                headerContent.add(new Cell(PREVIOUS_YEAR_CONTROL, CSS_R_C_TOOL));
                headerContent.add(new Cell(PREVIOUS_MONTH_CONTROL, CSS_R_C_TOOL));
                headerContent.add(new Cell(this.currentMonthControl, CSS_R_C_MONTH));
                headerContent.add(new Cell(NEXT_MONTH_CONTROL, CSS_R_C_TOOL));
                headerContent.add(new Cell(NEXT_YEAR_CONTROL, CSS_R_C_TOOL));
                if (this.popup) {
                    headerContent.add(new Cell(CLOSE_CONTROL, "rich-calendar-tool rich-calendar-tool-close", true, true));
                }
                header = this.createHeaderBlock(visualDocument, CSS_R_C_HEADER, headerContent);
            }
        }
        if (this.showFooter) {
            Element footerFacet = ComponentUtil.getFacetElement(sourceElement, "footer", true);
            if (footerFacet != null) {
                footer = this.createCustomBlock(visualDocument, footerFacet, creationData, CSS_R_C_FOOTER);
            } else {
                ArrayList<Cell> footerContent = new ArrayList<Cell>();
                if (this.showTodayControl) {
                    footerContent.add(new Cell(TODAY_CONTROL, CSS_R_C_TOOLFOOTER, this.showTodayControl && this.showApplyButton));
                }
                if (this.popup && this.showApplyButton) {
                    footerContent.add(new Cell(APPLY_CONTROL, CSS_R_C_TOOLFOOTER, false, true));
                }
                footer = this.createFooterBlock(visualDocument, CSS_R_C_FOOTER, footerContent);
            }
        }
        if ((optionalFooterFacet = ComponentUtil.getFacetElement(sourceElement, NAME_FACET_OPTIONAL_FOOTER, true)) != null) {
            optionalFooter = this.createCustomBlock(visualDocument, optionalFooterFacet, creationData, CSS_R_C_FOOTER_OPTIONAL);
            this.tableHeight += 26;
        }
        if (optionalHeader != null) {
            tbody.appendChild((nsIDOMNode)optionalHeader);
        }
        if (header != null) {
            tbody.appendChild((nsIDOMNode)header);
        }
        tbody.appendChild((nsIDOMNode)calendarBody);
        if (footer != null) {
            tbody.appendChild((nsIDOMNode)footer);
        }
        if (optionalFooter != null) {
            tbody.appendChild((nsIDOMNode)optionalFooter);
        }
        table.appendChild((nsIDOMNode)tbody);
        return table;
    }

    private nsIDOMElement createCalendarBody(nsIDOMDocument visualDocument, VpeCreationData creationData, Element sourceElement) {
        nsIDOMElement tbody = visualDocument.createElement("tbody");
        nsIDOMElement weekDaysTR = visualDocument.createElement("tr");
        if (this.showWeekDaysBar) {
            Element weekDayFacet = ComponentUtil.getFacetElement(sourceElement, NAME_FACET_WEEK_DAY, true);
            int i = 0;
            while (i < 8) {
                nsIDOMElement td = visualDocument.createElement("td");
                if (i == 0 && this.showWeeksBar) {
                    td.setAttribute("class", "rich-calendar-days");
                    weekDaysTR.appendChild((nsIDOMNode)td);
                } else if (i > 0) {
                    int dayIndex = (i - 1 + this.firstWeekDay) % 7;
                    if (dayIndex + 1 == 1 || dayIndex + 1 == 7) {
                        td.setAttribute("class", HOL_WEEK_DAY_HTML_CLASS_ATTR);
                    } else {
                        td.setAttribute("class", "rich-calendar-days");
                    }
                    if (weekDayFacet != null) {
                        VpeChildrenInfo childrenInfo = new VpeChildrenInfo(td);
                        childrenInfo.addSourceChild((Node)weekDayFacet);
                        creationData.addChildrenInfo(childrenInfo);
                    } else {
                        nsIDOMText weekDayNode = visualDocument.createTextNode(i == 0 ? "" : this.weekDays[dayIndex]);
                        td.appendChild((nsIDOMNode)weekDayNode);
                    }
                    weekDaysTR.appendChild((nsIDOMNode)td);
                }
                ++i;
            }
            tbody.appendChild((nsIDOMNode)weekDaysTR);
        }
        int month = this.calendar.get(2);
        int dayN = this.calendar.get(5);
        this.calendar.add(5, -dayN);
        this.calendar.add(5, -(this.calendar.get(7) - this.calendar.getFirstDayOfWeek()));
        Element weekNumberFacet = ComponentUtil.getFacetElement(sourceElement, NAME_FACET_WEEK_NUMBER, true);
        int i = 6;
        while (i > 0) {
            nsIDOMElement tr = visualDocument.createElement("tr");
            if (this.showWeeksBar) {
                nsIDOMElement weekTD = visualDocument.createElement("td");
                weekTD.setAttribute("class", CSS_R_C_WEEK);
                if (weekNumberFacet != null) {
                    VpeChildrenInfo childrenInfo = new VpeChildrenInfo(weekTD);
                    childrenInfo.addSourceChild((Node)weekNumberFacet);
                    creationData.addChildrenInfo(childrenInfo);
                } else {
                    nsIDOMText weekText = visualDocument.createTextNode(String.valueOf(this.calendar.get(3)));
                    weekTD.appendChild((nsIDOMNode)weekText);
                }
                tr.appendChild((nsIDOMNode)weekTD);
            }
            int j = 7;
            while (j > 0) {
                nsIDOMElement td = visualDocument.createElement("td");
                String currentAttr = "";
                int dayOfWeek = this.calendar.get(7);
                currentAttr = this.calendar.get(2) == month ? (this.calendar.get(5) == dayN && this.calendar.get(2) == month ? TODAY_HTML_CLASS_ATTR : (dayOfWeek == 7 || dayOfWeek == 1 ? HOL_CUR_MONTH_HTML_CLASS_ATTR : CUR_MONTH_HTML_CLASS_ATTR)) : (dayOfWeek == 7 || dayOfWeek == 1 ? HOL_OTHER_MONTH_HTML_CLASS_ATTR : OTHER_MONTH_HTML_CLASS_ATTR);
                td.setAttribute("class", currentAttr);
                td.setAttribute("style", "width:" + this.cellWidth + "px;" + "height" + ":" + this.cellHeight + "px;");
                nsIDOMText text = visualDocument.createTextNode("" + this.calendar.get(5));
                td.appendChild((nsIDOMNode)text);
                tr.appendChild((nsIDOMNode)td);
                this.calendar.add(5, 1);
                --j;
            }
            tbody.appendChild((nsIDOMNode)tr);
            --i;
        }
        this.calendar.set(2, month);
        this.calendar.set(5, dayN);
        return tbody;
    }

    public void setAttribute(VpePageContext pageContext, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMNode visualNode, Object data, String name, String value) {
        super.setAttribute(pageContext, sourceElement, visualDocument, visualNode, data, name, value);
        if (name.equalsIgnoreCase("value")) {
            String popup = sourceElement.getAttribute("popup");
            if (popup != null && popup.equalsIgnoreCase("false")) {
                return;
            }
            nsIDOMElement element = (nsIDOMElement)XPCOM.queryInterface((nsISupports)visualNode, nsIDOMElement.class);
            nsIDOMNodeList list = element.getChildNodes();
            nsIDOMNode tableNode = list.item(0L);
            nsIDOMElement input = (nsIDOMElement)XPCOM.queryInterface((nsISupports)tableNode, nsIDOMElement.class);
            input.setAttribute("value", value);
        }
    }

    private void readAttributes(VpePageContext pageContext, Node sourceNode) {
        Element sourceElement = (Element)sourceNode;
        this.style = sourceElement.getAttribute("style");
        this.styleClass = sourceElement.getAttribute("styleClass");
        this.showInput = !sourceElement.hasAttribute("showInput") || "true".equalsIgnoreCase(sourceElement.getAttribute("showInput"));
        this.inputStyle = "vertical-align: middle;;" + sourceElement.getAttribute("inputStyle");
        String inputClassAttrVal = sourceElement.hasAttribute("inputClass") ? sourceElement.getAttribute("inputClass") : null;
        this.inputClass = "rich-calendar-input " + inputClassAttrVal;
        this.inputSize = sourceElement.hasAttribute("inputSize") ? sourceElement.getAttribute("inputSize") : "";
        this.disabled = "true".equalsIgnoreCase(sourceElement.getAttribute("disabled"));
        this.buttonLabel = sourceElement.getAttribute(ATTR_BUTTON_LABEL);
        this.buttonIcon = this.disabled ? (sourceElement.hasAttribute("buttonIconDisabled") ? ComponentUtil.getAbsoluteWorkspacePath(sourceElement.getAttribute("buttonIconDisabled"), pageContext) : "file://" + ComponentUtil.getAbsoluteResourcePath(DEFAULT_BUTTON_ICON_DISABLED)) : (sourceElement.hasAttribute("buttonIcon") ? ComponentUtil.getAbsoluteWorkspacePath(sourceElement.getAttribute("buttonIcon"), pageContext) : "file://" + ComponentUtil.getAbsoluteResourcePath(DEFAULT_BUTTON_ICON));
        this.buttonIcon = this.buttonIcon.replace('\\', '/');
        this.buttonClass = sourceElement.hasAttribute("buttonClass") ? sourceElement.getAttribute("buttonClass") : null;
        this.showWeekDaysBar = !sourceElement.hasAttribute(ATTR_SHOW_SHOW_WEEKS_DAY_BAR) || "true".equalsIgnoreCase(sourceElement.getAttribute(ATTR_SHOW_SHOW_WEEKS_DAY_BAR));
        this.showWeeksBar = !sourceElement.hasAttribute(ATTR_SHOW_WEEKS_BAR) || "true".equalsIgnoreCase(sourceElement.getAttribute(ATTR_SHOW_WEEKS_BAR));
        this.showHeader = !sourceElement.hasAttribute(ATTR_SHOW_HEADER) || "true".equalsIgnoreCase(sourceElement.getAttribute(ATTR_SHOW_HEADER));
        this.showApplyButton = "true".equalsIgnoreCase(sourceElement.getAttribute(ATTR_SHOW_APPLY_BUTTON));
        this.showTodayControl = !HIDDEN.equalsIgnoreCase(sourceElement.getAttribute(ATTR_TODAY_CONTROL_MODE));
        this.showFooter = !(sourceElement.hasAttribute(ATTR_SHOW_FOOTER) && !"true".equalsIgnoreCase(sourceElement.getAttribute(ATTR_SHOW_FOOTER)) || !this.showApplyButton && !this.showTodayControl);
        this.popup = !sourceElement.hasAttribute("popup") || "true".equalsIgnoreCase(sourceElement.getAttribute("popup"));
        this.value = sourceElement.hasAttribute("value") ? sourceElement.getAttribute("value") : "";
        this.locale = this.getLocale(sourceElement);
        this.calendar = Calendar.getInstance(this.locale);
        this.weekDays = this.getWeekDays(sourceElement, this.locale);
        this.months = this.getMonths(sourceElement, this.locale);
        this.firstWeekDay = this.getFirstWeekDay(sourceElement, ATTR_FIRST_WEEK_DAY, this.calendar.getFirstDayOfWeek() - 1);
        this.calendar.setFirstDayOfWeek(this.firstWeekDay + 1);
        this.currentMonthControl = String.valueOf(this.months[this.calendar.get(2)]) + "," + " " + this.calendar.get(1);
        SimpleDateFormat sdf = new SimpleDateFormat(DEFAULT_DATE_PATTERN);
        if (sourceElement.hasAttribute(ATTR_DATE_PATTERN)) {
            this.datePattern = sourceElement.getAttribute(ATTR_DATE_PATTERN);
            try {
                sdf.applyPattern(this.datePattern);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        this.currentDayControl = sdf.format(this.calendar.getTime());
        this.cellWidth = ComponentUtil.parseSizeAttribute(sourceElement, ATTR_CELL_WIDTH, 25);
        this.cellHeight = ComponentUtil.parseSizeAttribute(sourceElement, ATTR_CELL_HEIGHT, 22);
        this.tableWidth = (this.showWeeksBar ? 25 : 0) + this.cellWidth * 7;
        this.tableHeight = (this.showHeader ? 22 : 0) + (this.showFooter ? 22 : 0) + (this.showWeekDaysBar ? 22 : 0) + this.cellHeight * 6;
        this.jointPoint = this.getDirection(sourceElement, "jointPoint", DIRECTIONS_BOTTOM_LEFT);
        this.direction = this.getDirection(sourceElement, "direction", DIRECTIONS_BOTTOM_RIGHT);
        this.zindex = ComponentUtil.parseNumberAttribute(sourceElement, "zindex", 3);
        this.horizontalOffset = ComponentUtil.parseNumberAttribute(sourceElement, "horizontalOffset", 0);
        this.verticalOffset = ComponentUtil.parseNumberAttribute(sourceElement, "verticalOffset", 0);
    }

    public void stopToggling(Node sourceNode) {
    }

    public void toggle(VpeVisualDomBuilder builder, Node sourceNode, String toggleId) {
        if (this.isExpanded(sourceNode)) {
            expandedCalendars.remove(sourceNode);
        } else {
            expandedCalendars.put(sourceNode, null);
        }
    }

    private boolean isExpanded(Node sourceNode) {
        return expandedCalendars.containsKey(sourceNode);
    }

    private nsIDOMElement createPopupCalendar(nsIDOMDocument visualDocument, Element sourceElement, VpeCreationData creationData) {
        nsIDOMElement button;
        nsIDOMElement popupCalendar = visualDocument.createElement("span");
        if (this.showInput) {
            nsIDOMElement input = visualDocument.createElement("input");
            input.setAttribute("type", "text");
            input.setAttribute("style", this.inputStyle);
            input.setAttribute("class", this.inputClass);
            input.setAttribute("size", this.inputSize);
            input.setAttribute("value", this.value);
            popupCalendar.appendChild((nsIDOMNode)input);
            VpeElementData elementData = new VpeElementData();
            if (sourceElement.hasAttribute("value")) {
                Attr attr = sourceElement.getAttributeNode("value");
                elementData.addNodeData((NodeData)new AttributeData(attr, (nsIDOMNode)input, true));
            } else {
                elementData.addNodeData((NodeData)new AttributeData("value", (nsIDOMNode)input, true));
            }
            creationData.setElementData(elementData);
        }
        if (this.buttonLabel == null || this.buttonLabel.length() == 0) {
            button = visualDocument.createElement("img");
            button.setAttribute("src", this.buttonIcon);
        } else {
            button = visualDocument.createElement("button");
            button.setAttribute("type", "button");
            nsIDOMText buttonText = visualDocument.createTextNode(this.buttonLabel);
            button.appendChild((nsIDOMNode)buttonText);
        }
        button.setAttribute("style", "vertical-align: middle;");
        button.setAttribute("class", "rich-calendar-button " + this.buttonClass);
        button.setAttribute("vpe-user-toggle-id", "true");
        popupCalendar.appendChild((nsIDOMNode)button);
        if (this.isExpanded(sourceElement)) {
            nsIDOMElement wrapper = visualDocument.createElement("span");
            wrapper.setAttribute("style", POSITION_RELATIVE_STYLE);
            nsIDOMElement calendar = this.createCalendar(visualDocument, creationData, sourceElement);
            int top = (this.jointPoint.isTop() ? -17 : 5) + (this.direction.isTop() ? -1 : 1) * ((this.direction.isTop() ? this.tableHeight : 0) + this.verticalOffset);
            int left = (this.direction.isLeft() ? -1 : 1) * ((this.direction.isLeft() ? this.tableWidth : 0) + this.horizontalOffset);
            calendar.setAttribute("style", "position: absolute;z-index:" + this.zindex + ";" + TOP + ":" + top + "px" + ";" + LEFT + ":" + left + "px" + ";" + "width" + ":" + this.tableWidth + "px" + ";" + calendar.getAttribute("style"));
            wrapper.appendChild((nsIDOMNode)calendar);
            if (this.jointPoint.isLeft()) {
                popupCalendar.insertBefore((nsIDOMNode)wrapper, popupCalendar.getFirstChild());
            } else {
                popupCalendar.appendChild((nsIDOMNode)wrapper);
            }
        }
        return popupCalendar;
    }

    public void setPseudoContent(VpePageContext pageContext, Node sourceContainer, nsIDOMNode visualContainer, nsIDOMDocument visualDocument) {
    }

    private Locale getLocale(Element sourceElement) {
        Locale locale;
        if (sourceElement.hasAttribute("locale")) {
            String localeAttr = sourceElement.getAttribute("locale");
            String[] localeInformation = localeAttr.split("_");
            String language = localeInformation[0];
            String country = localeInformation.length > 1 ? localeInformation[1] : "";
            locale = new Locale(language, country);
        } else {
            locale = Locale.getDefault();
        }
        return locale;
    }

    private int getFirstWeekDay(Element sourceElement, String attributeName, int defaultValue) {
        if (sourceElement.hasAttribute(attributeName)) {
            String stringValue = sourceElement.getAttribute(attributeName);
            try {
                int intValue = Integer.decode(stringValue);
                return intValue < 0 ? 7 + intValue % 7 : intValue % 7;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return defaultValue;
    }

    private String[] getWeekDays(Element sourceElement, Locale locale) {
        Object[] days = new String[7];
        if (sourceElement.hasAttribute(ATTR_WEEK_DAY_LABELS_SHORT)) {
            String attrValue = sourceElement.getAttribute(ATTR_WEEK_DAY_LABELS_SHORT);
            String[] parsedDays = attrValue.split(",");
            System.arraycopy(parsedDays, 0, days, 0, parsedDays.length);
            if (parsedDays.length < 7) {
                Arrays.fill(days, parsedDays.length, days.length - 1, "");
            }
        } else {
            DateFormatSymbols formatSymbols = new DateFormatSymbols(locale);
            System.arraycopy(formatSymbols.getShortWeekdays(), 1, days, 0, 7);
        }
        return days;
    }

    private String[] getMonths(Element sourceElement, Locale locale) {
        Object[] months;
        if (sourceElement.hasAttribute(ATTR_MONTH_LABELS)) {
            months = new String[12];
            String attrValue = sourceElement.getAttribute(ATTR_MONTH_LABELS);
            String[] parsedMonths = attrValue.split(",");
            System.arraycopy(parsedMonths, 0, months, 0, parsedMonths.length);
            if (parsedMonths.length < 12) {
                Arrays.fill(months, parsedMonths.length, months.length - 1, UNDEFINED);
            }
        } else {
            DateFormatSymbols formatSymbols = new DateFormatSymbols(locale);
            months = formatSymbols.getMonths();
        }
        return months;
    }

    private nsIDOMElement createCustomBlock(nsIDOMDocument visualDocument, Node customChild, VpeCreationData creationData, String blockClass) {
        nsIDOMElement blockTr = visualDocument.createElement("tr");
        nsIDOMElement blockTd = visualDocument.createElement("td");
        blockTd.setAttribute("colspan", String.valueOf(8));
        blockTd.setAttribute("class", blockClass);
        blockTr.appendChild((nsIDOMNode)blockTd);
        VpeChildrenInfo childrenInfo = new VpeChildrenInfo(blockTd);
        childrenInfo.addSourceChild(customChild);
        creationData.addChildrenInfo(childrenInfo);
        return blockTr;
    }

    private nsIDOMElement createHeaderBlock(nsIDOMDocument visualDocument, String blockClass, List<Cell> content) {
        nsIDOMElement blockTr = visualDocument.createElement("tr");
        nsIDOMElement blockTd = visualDocument.createElement("td");
        blockTd.setAttribute("colspan", String.valueOf(8));
        blockTd.setAttribute("class", blockClass);
        nsIDOMElement blockTable = visualDocument.createElement("table");
        blockTable.setAttribute("cellpadding", "0");
        blockTable.setAttribute("cellspacing", "0");
        blockTable.setAttribute("border", "0");
        blockTable.setAttribute("width", FILL_WIDTH);
        nsIDOMElement tbody = visualDocument.createElement("tbody");
        nsIDOMElement tr = visualDocument.createElement("tr");
        for (Cell cell : content) {
            nsIDOMElement td = visualDocument.createElement("td");
            td.setAttribute("class", cell.getCellClass());
            nsIDOMElement div = visualDocument.createElement("div");
            div.setAttribute("class", CSS_R_C_TOOL_BTN);
            nsIDOMText text1 = visualDocument.createTextNode(cell.getCellText());
            div.appendChild((nsIDOMNode)text1);
            if (cell.isToggle()) {
                div.setAttribute("vpe-user-toggle-id", "true");
            }
            if (cell.isSeparate()) {
                td.setAttribute("style", ComponentUtil.getBackgoundImgStyle(SPARATOR_IMG));
            }
            td.appendChild((nsIDOMNode)div);
            tr.appendChild((nsIDOMNode)td);
        }
        tbody.appendChild((nsIDOMNode)tr);
        blockTable.appendChild((nsIDOMNode)tbody);
        blockTd.appendChild((nsIDOMNode)blockTable);
        blockTr.appendChild((nsIDOMNode)blockTd);
        return blockTr;
    }

    private nsIDOMElement createFooterBlock(nsIDOMDocument visualDocument, String blockClass, List<Cell> content) {
        nsIDOMElement blockTr = visualDocument.createElement("tr");
        nsIDOMElement blockTd = visualDocument.createElement("td");
        blockTd.setAttribute("colspan", String.valueOf(8));
        blockTd.setAttribute("class", blockClass);
        nsIDOMElement blockTable = visualDocument.createElement("table");
        blockTable.setAttribute("cellpadding", "0");
        blockTable.setAttribute("cellspacing", "0");
        blockTable.setAttribute("border", "0");
        blockTable.setAttribute("width", FILL_WIDTH);
        nsIDOMElement tbody = visualDocument.createElement("tbody");
        nsIDOMElement tr = visualDocument.createElement("tr");
        nsIDOMElement fillingTd = visualDocument.createElement("td");
        fillingTd.setAttribute("width", FILL_WIDTH);
        tr.appendChild((nsIDOMNode)fillingTd);
        for (Cell cell : content) {
            nsIDOMElement td = visualDocument.createElement("td");
            td.setAttribute("class", cell.getCellClass());
            nsIDOMElement div = visualDocument.createElement("div");
            div.setAttribute("class", CSS_R_C_TOOL_BTN);
            nsIDOMText text = visualDocument.createTextNode(cell.getCellText());
            if (cell.isToggle()) {
                div.setAttribute("vpe-user-toggle-id", "true");
            }
            if (cell.isSeparate()) {
                td.setAttribute("style", ComponentUtil.getBackgoundImgStyle(SPARATOR_IMG));
            }
            div.appendChild((nsIDOMNode)text);
            td.appendChild((nsIDOMNode)div);
            tr.appendChild((nsIDOMNode)td);
        }
        tbody.appendChild((nsIDOMNode)tr);
        blockTable.appendChild((nsIDOMNode)tbody);
        blockTd.appendChild((nsIDOMNode)blockTable);
        blockTr.appendChild((nsIDOMNode)blockTd);
        return blockTr;
    }

    private DirectionData getDirection(Element sourceElement, String attributeName, String defaultDirection) {
        String value = defaultDirection;
        DirectionData directionData = new DirectionData();
        if (sourceElement.hasAttribute(attributeName)) {
            String attributeValue = sourceElement.getAttribute(attributeName).toLowerCase();
            Matcher matcher = Pattern.compile(DIRECTION_PATTERN).matcher(value);
            if (matcher.find()) {
                value = attributeValue;
            }
        }
        directionData.setTop(value.startsWith(TOP));
        directionData.setLeft(value.endsWith(LEFT));
        return directionData;
    }

    class Cell {
        private String cellText;
        private String cellClass;
        private boolean separate;
        private boolean toggle;

        public boolean isToggle() {
            return this.toggle;
        }

        public void setToggle(boolean toggle) {
            this.toggle = toggle;
        }

        public Cell(String cellText, String cellClass) {
            this.cellText = cellText;
            this.cellClass = cellClass;
            this.separate = false;
            this.toggle = false;
        }

        public Cell(String cellText, String cellClass, boolean separate) {
            this.cellText = cellText;
            this.cellClass = cellClass;
            this.separate = separate;
            this.toggle = false;
        }

        public Cell(String cellText, String cellClass, boolean separate, boolean toggle) {
            this.cellText = cellText;
            this.cellClass = cellClass;
            this.separate = separate;
            this.toggle = toggle;
        }

        public String getCellText() {
            return this.cellText;
        }

        public void setCellText(String cellText) {
            this.cellText = cellText;
        }

        public String getCellClass() {
            return this.cellClass;
        }

        public void setCellClass(String cellClass) {
            this.cellClass = cellClass;
        }

        public boolean isSeparate() {
            return this.separate;
        }

        public void setSeparate(boolean separate) {
            this.separate = separate;
        }
    }

    class DirectionData {
        private boolean top;
        private boolean left;

        DirectionData() {
        }

        public boolean isTop() {
            return this.top;
        }

        public void setTop(boolean top) {
            this.top = top;
        }

        public boolean isLeft() {
            return this.left;
        }

        public void setLeft(boolean left) {
            this.left = left;
        }
    }
}

