/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.richfaces.template;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.jboss.tools.jsf.vpe.richfaces.ComponentUtil;
import org.jboss.tools.jsf.vpe.richfaces.template.AttributeMap;
import org.jboss.tools.vpe.editor.VpeVisualDomBuilder;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.jboss.tools.vpe.editor.util.VpeStyleUtil;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RichFacesComboBoxTemplateHelper {
    private static final WeakHashMap<Node, Object> expandedComboBoxes = new WeakHashMap();
    private static final String DISABLED_ATTR_NAME = "disabled";
    private static final String BUTTON_ICON_CLASSES_DISABLED = "rich-combobox-font-inactive rich-combobox-button-icon-disabled rich-combobox-button-inactive";
    private static final String BUTTON_ICON_CLASSES = "rich-combobox-font-inactive rich-combobox-button-icon-inactive rich-combobox-button-inactive";
    private static final String SECOND_DIV = "secondDiv";
    private static final String THIRD_DIV = "thirdDiv";
    private static final String THIRD_EMPTY_DIV = "thirdEmptyDiv";
    private static final String TEXT_FIELD = "textField";
    private static final String BUTTON_ICON = "buttonIcon";
    private static final String CSS_FILE_NAME = "comboBox/comboBox.css";
    private static final String DEFAULT_LIST_WIDTH = "150px";
    private static final String IMAGE_NAME_DOWN = "/comboBox/down.gif";
    private static final String BUTTON_BACKGROUND = "buttonBackground";
    private static final String STYLE_EXT = "richFacesComboBox";
    private static final int LIST_ITEM_HEIGHT_DEFAULT_VALUE = 18;
    private final Map<String, String> styleClasess = new HashMap<String, String>();
    private String sourceButtonStyle;
    private String sourceDefaultLabel = null;
    private String sourceListHeight;
    private String sourceListWidth;
    private String sourceValue;
    private String sourceWidth;
    private String sourceStyle;
    private String sourceInputStyle;
    private String sourceInputClass;
    private String sourceListStyle;
    private String sourceListClass;
    private String sourceItemClass;
    private String sourceButtonIcon;
    private String sourceButtonIconInactive;
    private String sourceButtonIconDisabled;
    private boolean disabled;
    private boolean expanded;
    private final VpePageContext pageContext;
    private final Node sourceNode;
    private final nsIDOMDocument visualDocument;
    private final VpeCreationData vpeCreationData;

    public RichFacesComboBoxTemplateHelper(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        this.pageContext = pageContext;
        this.sourceNode = sourceNode;
        this.visualDocument = visualDocument;
        this.initDefaultClasses();
        this.vpeCreationData = this.create();
    }

    private static String calculateWithForDiv(String with, int minus) {
        try {
            Integer intValue = 0;
            intValue = with.endsWith("px") ? Integer.valueOf(Integer.parseInt(with.substring(0, with.length() - 2))) : Integer.valueOf(Integer.parseInt(with));
            return String.valueOf(String.valueOf(intValue - minus)) + "px";
        }
        catch (NumberFormatException numberFormatException) {
            return with;
        }
    }

    public VpeCreationData getVpeCreationData() {
        return this.vpeCreationData;
    }

    private VpeCreationData create() {
        String actualSourceButton;
        ComponentUtil.setCSSLink(this.pageContext, CSS_FILE_NAME, STYLE_EXT);
        Element source = (Element)this.sourceNode;
        this.prepareData(source);
        nsIDOMElement rootDiv = this.visualDocument.createElement("div");
        rootDiv.setAttribute("style", "width:" + this.sourceWidth);
        nsIDOMElement comboBoxDiv = this.visualDocument.createElement("div");
        nsIDOMElement secondDiv = this.visualDocument.createElement("div");
        secondDiv.setAttribute("class", this.styleClasess.get(SECOND_DIV));
        String secondDivSubStyle = "; position: {0}; z-index: {1} ;";
        secondDivSubStyle = this.expanded ? MessageFormat.format(secondDivSubStyle, "relative", "2") : MessageFormat.format(secondDivSubStyle, "static", "0");
        comboBoxDiv.setAttribute("style", "width:" + this.sourceListWidth + ";" + secondDivSubStyle);
        secondDiv.setAttribute("style", "width:" + this.sourceListWidth + ";" + secondDivSubStyle + this.sourceStyle);
        nsIDOMElement thirdDiv = this.visualDocument.createElement("div");
        thirdDiv.setAttribute("class", this.styleClasess.get(THIRD_DIV));
        thirdDiv.setAttribute("style", "width:" + this.sourceWidth + "; z-index: 1;");
        nsIDOMElement textField = this.visualDocument.createElement("input");
        textField.setAttribute("type", "text");
        textField.setAttribute("class", (String.valueOf(this.styleClasess.get(TEXT_FIELD)) + " " + this.sourceInputClass).trim());
        textField.setAttribute("autocomplete", "off");
        textField.setAttribute("style", "width:" + RichFacesComboBoxTemplateHelper.calculateWithForDiv(this.sourceWidth, 17) + ";" + this.sourceInputStyle);
        String value = null;
        if (ComponentUtil.isNotBlank(this.sourceDefaultLabel)) {
            value = this.sourceDefaultLabel;
        } else if (ComponentUtil.isNotBlank(this.sourceValue) && ComponentUtil.isBlank(this.sourceDefaultLabel)) {
            value = this.sourceValue;
        }
        if (value != null) {
            textField.setAttribute("value", value);
        }
        nsIDOMElement buttonBackground = this.visualDocument.createElement("input");
        buttonBackground.setAttribute("type", "text");
        if (this.disabled) {
            this.styleClasess.put(BUTTON_ICON, BUTTON_ICON_CLASSES_DISABLED);
        } else {
            this.styleClasess.put(BUTTON_ICON, BUTTON_ICON_CLASSES);
        }
        buttonBackground.setAttribute("class", this.styleClasess.get(BUTTON_BACKGROUND));
        buttonBackground.setAttribute("readonly", "true");
        buttonBackground.setAttribute("vpe-user-toggle-id", String.valueOf(0));
        if (this.sourceButtonStyle != null) {
            buttonBackground.setAttribute("style", this.sourceButtonStyle);
        }
        nsIDOMElement buttonIcon = this.visualDocument.createElement("input");
        buttonIcon.setAttribute("type", "text");
        buttonIcon.setAttribute("class", this.styleClasess.get(BUTTON_ICON));
        buttonIcon.setAttribute("readonly", "true");
        buttonIcon.setAttribute("vpe-user-toggle-id", String.valueOf(0));
        if (this.sourceButtonStyle != null) {
            buttonIcon.setAttribute("style", this.sourceButtonStyle);
        }
        if (ComponentUtil.isNotBlank(actualSourceButton = this.disabled ? this.sourceButtonIconDisabled : (this.expanded ? this.sourceButtonIcon : this.sourceButtonIconInactive)) && actualSourceButton != IMAGE_NAME_DOWN) {
            String buttonIconPath = VpeStyleUtil.addFullPathToImgSrc((String)actualSourceButton, (VpePageContext)this.pageContext, (boolean)true);
            buttonIconPath = buttonIconPath.replace('\\', '/');
            String style = "background-image: url(" + buttonIconPath + ")";
            buttonIcon.setAttribute("style", String.valueOf(buttonIcon.getAttribute("style")) + style);
        }
        nsIDOMElement forthEmptyDiv = this.visualDocument.createElement("div");
        forthEmptyDiv.setAttribute("class", this.styleClasess.get("forthEmptyDiv"));
        forthEmptyDiv.setAttribute("style", "width:" + RichFacesComboBoxTemplateHelper.calculateWithForDiv(this.sourceWidth, 10));
        forthEmptyDiv.appendChild((nsIDOMNode)this.visualDocument.createTextNode("Struts"));
        rootDiv.appendChild((nsIDOMNode)comboBoxDiv);
        comboBoxDiv.appendChild((nsIDOMNode)secondDiv);
        secondDiv.appendChild((nsIDOMNode)thirdDiv);
        if (this.expanded) {
            comboBoxDiv.appendChild(this.createToogleDiv());
        }
        thirdDiv.appendChild((nsIDOMNode)textField);
        thirdDiv.appendChild((nsIDOMNode)buttonBackground);
        thirdDiv.appendChild((nsIDOMNode)buttonIcon);
        thirdDiv.appendChild((nsIDOMNode)forthEmptyDiv);
        VpeCreationData creationData = new VpeCreationData((nsIDOMNode)rootDiv);
        return creationData;
    }

    private nsIDOMNode createToogleDiv() {
        nsIDOMElement thirdEmptyDiv = this.visualDocument.createElement("div");
        thirdEmptyDiv.setAttribute("style", String.valueOf(this.sourceListStyle) + ";" + " z-index: 3; position: absolute; visibility: visible; top: 16px; left: 0px;");
        thirdEmptyDiv.setAttribute("class", String.valueOf(this.styleClasess.get(THIRD_EMPTY_DIV)) + " " + this.sourceListClass);
        thirdEmptyDiv.setAttribute("style", "z-index: 3; position: absolute; visibility: visible; top: 16px; left: 0px;");
        nsIDOMElement shadovDiv = this.visualDocument.createElement("div");
        nsIDOMElement positionDiv = this.visualDocument.createElement("div");
        positionDiv.setAttribute("class", "rich-combobox-list-position");
        nsIDOMElement decorationDiv = this.visualDocument.createElement("div");
        decorationDiv.setAttribute("class", "rich-combobox-list-decoration");
        nsIDOMElement scrollDiv = this.visualDocument.createElement("div");
        scrollDiv.setAttribute("class", "rich-combobox-list-scroll");
        List<Element> items = ComponentUtil.getSelectItems(this.sourceNode.getChildNodes());
        int defaultHeight = 18;
        if (items != null && items.size() > 1) {
            defaultHeight = (items.size() - 1) * 18;
        }
        String listHeight = ComponentUtil.isNotBlank(this.sourceListHeight) ? this.sourceListHeight : String.valueOf(String.valueOf(defaultHeight)) + "px";
        scrollDiv.setAttribute("style", "max-height:" + listHeight + ";" + "width" + ":" + RichFacesComboBoxTemplateHelper.calculateWithForDiv(this.sourceListWidth, 2));
        List<Element> selectItems = ComponentUtil.getSelectItems(this.sourceNode.getChildNodes());
        if (selectItems.size() > 0) {
            for (Element e : selectItems) {
                scrollDiv.appendChild(this.createSelectItem(e));
            }
        }
        shadovDiv.setAttribute("class", "rich-combobox-shadow");
        nsIDOMElement table = this.visualDocument.createElement("table");
        table.setAttribute("cellpadding", "0");
        table.setAttribute("cellspacing", "0");
        table.setAttribute("border", "0");
        String width = "";
        try {
            int w = ComponentUtil.parseWidthHeightValue(this.sourceListWidth);
            width = String.valueOf(w += 7);
        }
        catch (NumberFormatException numberFormatException) {
            width = "217";
        }
        table.setAttribute("style", "width:" + width + "px" + ";" + "height" + ":" + "63px;");
        nsIDOMElement tr1 = this.visualDocument.createElement("tr");
        nsIDOMElement tr2 = this.visualDocument.createElement("tr");
        nsIDOMElement tr1_td1 = this.visualDocument.createElement("td");
        nsIDOMElement tr1_td2 = this.visualDocument.createElement("td");
        nsIDOMElement tr2_td1 = this.visualDocument.createElement("td");
        nsIDOMElement tr2_td2 = this.visualDocument.createElement("td");
        nsIDOMElement tr1_td1_img = this.visualDocument.createElement("img");
        nsIDOMElement tr1_td2_img = this.visualDocument.createElement("img");
        nsIDOMElement tr2_td1_img = this.visualDocument.createElement("img");
        nsIDOMElement tr2_td2_img = this.visualDocument.createElement("img");
        tr1_td1.setAttribute("class", "rich-combobox-shadow-tl");
        tr1_td2.setAttribute("class", "rich-combobox-shadow-tr");
        tr2_td1.setAttribute("class", "rich-combobox-shadow-bl");
        tr2_td2.setAttribute("class", "rich-combobox-shadow-br");
        RichFacesComboBoxTemplateHelper.setUpImg(tr1_td1_img, 10, 1, 0, "comboBox/spacer.gif");
        RichFacesComboBoxTemplateHelper.setUpImg(tr1_td2_img, 1, 10, 0, "comboBox/spacer.gif");
        RichFacesComboBoxTemplateHelper.setUpImg(tr2_td1_img, 1, 10, 0, "comboBox/spacer.gif");
        RichFacesComboBoxTemplateHelper.setUpImg(tr2_td2_img, 10, 1, 0, "comboBox/spacer.gif");
        thirdEmptyDiv.appendChild((nsIDOMNode)shadovDiv);
        shadovDiv.appendChild((nsIDOMNode)table);
        thirdEmptyDiv.appendChild((nsIDOMNode)positionDiv);
        positionDiv.appendChild((nsIDOMNode)decorationDiv);
        decorationDiv.appendChild((nsIDOMNode)scrollDiv);
        table.appendChild((nsIDOMNode)tr1);
        table.appendChild((nsIDOMNode)tr2);
        tr1.appendChild((nsIDOMNode)tr1_td1);
        tr1.appendChild((nsIDOMNode)tr1_td2);
        tr2.appendChild((nsIDOMNode)tr2_td1);
        tr2.appendChild((nsIDOMNode)tr2_td2);
        tr1_td1.appendChild((nsIDOMNode)tr1_td1_img);
        tr1_td1.appendChild((nsIDOMNode)this.visualDocument.createElement("br"));
        tr1_td2.appendChild((nsIDOMNode)tr1_td2_img);
        tr1_td2.appendChild((nsIDOMNode)this.visualDocument.createElement("br"));
        tr2_td1.appendChild((nsIDOMNode)tr2_td1_img);
        tr2_td1.appendChild((nsIDOMNode)this.visualDocument.createElement("br"));
        tr2_td2.appendChild((nsIDOMNode)tr2_td2_img);
        tr2_td2.appendChild((nsIDOMNode)this.visualDocument.createElement("br"));
        return thirdEmptyDiv;
    }

    private nsIDOMNode createSelectItem(Element e) {
        nsIDOMElement item = this.visualDocument.createElement("span");
        item.setAttribute("class", "rich-combobox-item " + this.sourceItemClass);
        item.appendChild((nsIDOMNode)this.visualDocument.createTextNode(ComponentUtil.getSelectItemValue(e)));
        return item;
    }

    private void initDefaultClasses() {
        this.styleClasess.put(SECOND_DIV, "rich-combobox-font rich-combobox");
        this.styleClasess.put(THIRD_DIV, "rich-combobox-font rich-combobox-shell");
        this.styleClasess.put(THIRD_EMPTY_DIV, "rich-combobox-list-cord");
        this.styleClasess.put(TEXT_FIELD, "rich-combobox-font-disabled rich-combobox-input-inactive");
        this.styleClasess.put(BUTTON_BACKGROUND, "rich-combobox-font-inactive rich-combobox-button-background rich-combobox-button-inactive");
        this.styleClasess.put(BUTTON_ICON, BUTTON_ICON_CLASSES);
        this.styleClasess.put("forthEmptyDiv", "rich-combobox-strut rich-combobox-font");
    }

    private void prepareData(Element source) {
        AttributeMap attributeMap = new AttributeMap(source);
        this.sourceListWidth = attributeMap.isBlank("listWidth") ? DEFAULT_LIST_WIDTH : attributeMap.getString("listWidth");
        this.sourceListHeight = attributeMap.getString("listHeight");
        if (attributeMap.isBlank("width")) {
            this.sourceWidth = DEFAULT_LIST_WIDTH;
        } else {
            this.sourceWidth = attributeMap.getString("width");
            if (this.sourceListWidth == DEFAULT_LIST_WIDTH) {
                this.sourceListWidth = this.sourceWidth;
            }
        }
        if (ComponentUtil.isNotBlank(this.sourceWidth) && this.sourceWidth != DEFAULT_LIST_WIDTH && !this.sourceWidth.endsWith("px")) {
            try {
                int intValue = Integer.parseInt(this.sourceWidth);
                this.sourceWidth = String.valueOf(String.valueOf(intValue)) + "px";
            }
            catch (NumberFormatException numberFormatException) {
                this.sourceWidth = DEFAULT_LIST_WIDTH;
                this.sourceListWidth = DEFAULT_LIST_WIDTH;
            }
        }
        this.sourceDefaultLabel = attributeMap.getString("defaultLabel");
        this.sourceValue = attributeMap.getString("value");
        this.sourceButtonStyle = attributeMap.getString("buttonStyle");
        String sourceStyleClasess = attributeMap.getString("styleClass");
        if (ComponentUtil.isNotBlank(sourceStyleClasess)) {
            this.styleClasess.put(SECOND_DIV, String.valueOf(this.styleClasess.get(SECOND_DIV)) + " " + sourceStyleClasess);
        }
        this.sourceStyle = attributeMap.getString("style");
        this.sourceInputStyle = attributeMap.getString("inputStyle");
        this.sourceInputClass = attributeMap.getString("inputClass");
        this.sourceListClass = attributeMap.getString("listClass");
        this.sourceListStyle = attributeMap.getString("listStyle");
        this.sourceItemClass = attributeMap.getString("itemClass");
        this.sourceButtonIcon = attributeMap.getString(BUTTON_ICON);
        this.sourceButtonIconInactive = attributeMap.getString("buttonIconInactive");
        this.sourceButtonIconDisabled = attributeMap.getString("buttonIconDisabled");
        this.disabled = RichFacesComboBoxTemplateHelper.isDisabled(attributeMap);
        this.expanded = RichFacesComboBoxTemplateHelper.isExpanded(source);
        if (ComponentUtil.isBlank(this.sourceButtonIcon)) {
            this.sourceButtonIcon = IMAGE_NAME_DOWN;
        }
    }

    protected static void setUpImg(nsIDOMElement img, int width, int height, int border, String image) {
        ComponentUtil.setImg(img, image);
        img.setAttribute("width", String.valueOf(width));
        img.setAttribute("height", String.valueOf(height));
        img.setAttribute("border", String.valueOf(border));
    }

    public static void toggle(VpeVisualDomBuilder builder, Node sourceNode, String toggleId) {
        AttributeMap attributes = new AttributeMap((Element)sourceNode);
        if (RichFacesComboBoxTemplateHelper.isDisabled(attributes) || RichFacesComboBoxTemplateHelper.isExpanded(sourceNode)) {
            expandedComboBoxes.remove(sourceNode);
        } else {
            expandedComboBoxes.put(sourceNode, null);
        }
    }

    public static void stopToggling(Node sourceNode) {
        expandedComboBoxes.remove(sourceNode);
    }

    public static boolean isDisabled(AttributeMap attributes) {
        return attributes.getBoolean(DISABLED_ATTR_NAME) == Boolean.TRUE;
    }

    private static boolean isExpanded(Node node) {
        return expandedComboBoxes.containsKey(node);
    }
}

