/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.richfaces.template;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jboss.tools.jsf.vpe.richfaces.ComponentUtil;
import org.jboss.tools.jsf.vpe.richfaces.RichFacesTemplatesActivator;
import org.jboss.tools.jsf.vpe.richfaces.template.RichFaces;
import org.jboss.tools.jsf.vpe.richfaces.template.RichFacesColumnGroupTemplate;
import org.jboss.tools.jsf.vpe.richfaces.template.RichFacesColumnTemplate;
import org.jboss.tools.jsf.vpe.richfaces.template.RichFacesSubTableTemplate;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeChildrenInfo;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.jboss.tools.vpe.editor.template.VpeCreatorUtil;
import org.jboss.tools.vpe.editor.util.SourceDomUtil;
import org.jboss.tools.vpe.editor.util.VisualDomUtil;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMNodeList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class RichFacesDataTableChildrenEncoder {
    private String firstRowClass = "dr-table-firstrow rich-table-firstrow";
    private String nonFirstRowClass = "dr-table-row rich-table-row";
    private static final String TAG_SUB_TABLE_OR_COLUMN_GROUP_CONTAINER = "subTableOrColumnGroup-container";
    private final VpeCreationData creationData;
    private final nsIDOMDocument visualDocument;
    private final Element tableSourceElement;
    private final nsIDOMElement tableVisualTag;
    private nsIDOMElement currentRow = null;
    private VpeChildrenInfo currentRowChildrenInfo = null;
    private int rowNumber = 0;

    public void setRowClasses(String firstRowClass, String nonFirstRowClass) {
        this.firstRowClass = firstRowClass;
        this.nonFirstRowClass = nonFirstRowClass;
    }

    public RichFacesDataTableChildrenEncoder(VpeCreationData creationData, nsIDOMDocument visualDocument, Element tableSourceElement, nsIDOMElement tableVisualTag) {
        this.creationData = creationData;
        this.visualDocument = visualDocument;
        this.tableSourceElement = tableSourceElement;
        this.tableVisualTag = tableVisualTag;
    }

    public void encodeChildren() {
        VpeChildrenInfo childInfo = new VpeChildrenInfo(null);
        this.creationData.addChildrenInfo(childInfo);
        List<Node> children = ComponentUtil.getChildren(this.tableSourceElement);
        boolean createNewRow = true;
        for (Node child : children) {
            String nodeName = child.getNodeName();
            if (nodeName.endsWith("column") || nodeName.endsWith("columns")) {
                this.addColumnToRow(child, createNewRow |= RichFacesColumnTemplate.isBreakBefore(child));
                createNewRow = false;
                continue;
            }
            if (nodeName.endsWith("subTable") || nodeName.endsWith("columnGroup")) {
                this.addSubTableOrColumnGroupToTable(child);
                createNewRow = true;
                continue;
            }
            if (VpeCreatorUtil.isFacet((Node)child)) continue;
            this.addElementToTable(child);
            createNewRow = true;
        }
    }

    public static void validateChildren(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument, VpeCreationData creationData) {
        nsIDOMNode visualNode = creationData.getNode();
        RichFacesDataTableChildrenEncoder.fixSubTables(visualNode);
    }

    private nsIDOMElement addSubTableOrColumnGroupToTable(Node subTableOrColumnGroupNode) {
        nsIDOMElement subTableOrColumnGroupContainer = this.visualDocument.createElement(TAG_SUB_TABLE_OR_COLUMN_GROUP_CONTAINER);
        this.tableVisualTag.appendChild((nsIDOMNode)subTableOrColumnGroupContainer);
        VpeChildrenInfo childInfo = new VpeChildrenInfo(subTableOrColumnGroupContainer);
        childInfo.addSourceChild(subTableOrColumnGroupNode);
        this.creationData.addChildrenInfo(childInfo);
        return subTableOrColumnGroupContainer;
    }

    private nsIDOMElement addColumnToRow(Node columnNode, boolean createNewRow) {
        if (createNewRow || this.currentRow == null) {
            this.currentRow = this.visualDocument.createElement("tr");
            this.tableVisualTag.appendChild((nsIDOMNode)this.currentRow);
            this.currentRowChildrenInfo = new VpeChildrenInfo(this.currentRow);
            this.creationData.addChildrenInfo(this.currentRowChildrenInfo);
            ++this.rowNumber;
            if (this.rowNumber == 1) {
                this.currentRow.setAttribute("class", this.firstRowClass);
            } else {
                this.currentRow.setAttribute("class", this.nonFirstRowClass);
            }
        }
        this.currentRowChildrenInfo.addSourceChild(columnNode);
        return this.currentRow;
    }

    private void addElementToTable(Node node) {
        nsIDOMElement tr = this.visualDocument.createElement("tr");
        this.tableVisualTag.appendChild((nsIDOMNode)tr);
        nsIDOMElement td = this.visualDocument.createElement("td");
        td.setAttribute("colspan", "100");
        tr.appendChild((nsIDOMNode)td);
        VpeChildrenInfo childInfo = new VpeChildrenInfo(td);
        childInfo.addSourceChild(node);
        this.creationData.addChildrenInfo(childInfo);
    }

    private static void fixSubTables(nsIDOMNode visualNode) {
        nsIDOMElement element = (nsIDOMElement)visualNode;
        nsIDOMNodeList subTableContainers = element.getElementsByTagName(TAG_SUB_TABLE_OR_COLUMN_GROUP_CONTAINER);
        long length = subTableContainers.getLength();
        int i = 0;
        while ((long)i < length) {
            nsIDOMNode subTableContainer = subTableContainers.item(0L);
            nsIDOMNodeList subTableContainerChildren = subTableContainer.getChildNodes();
            if (subTableContainerChildren == null || subTableContainerChildren.getLength() != 1L) {
                RuntimeException e = new RuntimeException("This is probably a bug. subTable-container should have one inner tag.");
                RichFacesTemplatesActivator.getPluginLog().logError((Throwable)e);
            }
            VisualDomUtil.replaceNodeByItsChildren((nsIDOMNode)subTableContainer);
            ++i;
        }
    }

    public void encodeColumnsFacets(VpePageContext pageContext, ArrayList<Element> columnsWithFacets, String facetName, nsIDOMElement visualParentTR, String visualElementForTD, String cellClass, String headerClass) {
        for (Element column : columnsWithFacets) {
            nsIDOMElement icon;
            Element facet = SourceDomUtil.getFacetByName((VpePageContext)pageContext, (Element)column, (String)facetName);
            if (facet == null) continue;
            String classAttribute = String.valueOf(facetName) + "Class";
            String columnHeaderClass = column.hasAttribute(classAttribute) ? column.getAttribute(classAttribute) : null;
            nsIDOMElement td = this.visualDocument.createElement(visualElementForTD);
            visualParentTR.appendChild((nsIDOMNode)td);
            String styleClass = ComponentUtil.encodeStyleClass(null, cellClass, headerClass, columnHeaderClass);
            if (!RichFacesColumnTemplate.isVisible(column)) {
                VisualDomUtil.setSubAttribute((nsIDOMElement)td, (String)"style", (String)"display", (String)"none");
            }
            td.setAttribute("class", styleClass);
            td.setAttribute("scope", "col");
            if (column.hasAttribute("colspan")) {
                String colspan = column.getAttribute("colspan");
                td.setAttribute("colspan", colspan);
            }
            if ("header".equals(facetName) && (icon = RichFacesColumnTemplate.getHeaderIcon(pageContext, column, this.visualDocument)) != null) {
                td.appendChild((nsIDOMNode)icon);
            }
            VpeChildrenInfo childrenInfo = new VpeChildrenInfo(td);
            childrenInfo.addSourceChild((Node)facet);
            this.creationData.addChildrenInfo(childrenInfo);
        }
    }

    public void encodeTableFacets(VpePageContext pageContext, nsIDOMElement visualTagForFacet, Element innerFacetSourceNode, String visualElementForTD, String facetTHeadClass, String firstRowClass, String rowClass, String cellClass) {
        if (innerFacetSourceNode == null) {
            RichFacesTemplatesActivator.getDefault().logError("Source element to be rendered inside facet is 'null' !");
        }
        boolean isColumnGroup = innerFacetSourceNode.getNodeName().endsWith("columnGroup");
        boolean isSubTable = innerFacetSourceNode.getNodeName().endsWith("subTable");
        if (isColumnGroup) {
            RichFacesColumnGroupTemplate.DEFAULT_INSTANCE.encodeSubTable(pageContext, this.creationData, innerFacetSourceNode, this.visualDocument, visualTagForFacet);
        } else if (isSubTable) {
            RichFacesSubTableTemplate.DEFAULT_INSTANCE.encodeSubTable(pageContext, this.creationData, innerFacetSourceNode, this.visualDocument, visualTagForFacet);
        } else {
            nsIDOMElement tr = this.visualDocument.createElement("tr");
            visualTagForFacet.appendChild((nsIDOMNode)tr);
            String styleClass = ComponentUtil.encodeStyleClass(null, firstRowClass, facetTHeadClass, null);
            if (styleClass != null) {
                tr.setAttribute("class", styleClass);
            }
            String style = ComponentUtil.getHeaderBackgoundImgStyle();
            tr.setAttribute("style", style);
            nsIDOMElement td = this.visualDocument.createElement(visualElementForTD);
            tr.appendChild((nsIDOMNode)td);
            styleClass = ComponentUtil.encodeStyleClass(null, cellClass, facetTHeadClass, null);
            if (styleClass != null) {
                td.setAttribute("class", styleClass);
            }
            td.setAttribute("colspan", "100");
            td.setAttribute("scope", "colgroup");
            VpeChildrenInfo child = new VpeChildrenInfo(td);
            child.addSourceChild((Node)innerFacetSourceNode);
            this.creationData.addChildrenInfo(child);
        }
    }

    public void encodeTableHeader(VpePageContext pageContext, nsIDOMElement visualParentForFacetTHead, String visualTagForFacetTHead, String visualElementForTD, String facetName, String customFacetClass, String facetTHeadClass, String firstRowClass, String rowClass, String cellClass) {
        Element facetSourceElement = SourceDomUtil.getFacetByName((VpePageContext)pageContext, (Element)this.tableSourceElement, (String)facetName);
        ArrayList<Element> columns = RichFaces.getColumns(this.tableSourceElement);
        RichFaces.getColumnsCount(this.tableSourceElement, columns);
        Map facetChildren = VisualDomUtil.findFacetElements((Node)facetSourceElement, (VpePageContext)pageContext);
        boolean headerJsfElementPresents = ((List)facetChildren.get(VisualDomUtil.FACET_JSF_TAG)).size() > 0;
        boolean hasColumnWithFacets = RichFaces.hasColumnWithFacet(columns, facetName);
        if (headerJsfElementPresents || hasColumnWithFacets) {
            nsIDOMElement createdVisualTagForFacetTHead = null;
            if (visualTagForFacetTHead == null || "".equalsIgnoreCase(visualTagForFacetTHead)) {
                createdVisualTagForFacetTHead = visualParentForFacetTHead;
            } else {
                createdVisualTagForFacetTHead = this.visualDocument.createElement(visualTagForFacetTHead);
                visualParentForFacetTHead.appendChild((nsIDOMNode)createdVisualTagForFacetTHead);
            }
            String facetClass = null;
            if (this.tableSourceElement.hasAttribute(String.valueOf(facetName) + "Class")) {
                facetClass = this.tableSourceElement.getAttribute(String.valueOf(facetName) + "Class");
            }
            if (headerJsfElementPresents) {
                Element node = (Element)((List)facetChildren.get(VisualDomUtil.FACET_JSF_TAG)).get(0);
                this.encodeTableFacets(pageContext, createdVisualTagForFacetTHead, node, visualElementForTD, facetTHeadClass, firstRowClass, rowClass, cellClass);
            }
            if (hasColumnWithFacets) {
                nsIDOMElement visualParentTR = this.visualDocument.createElement("tr");
                createdVisualTagForFacetTHead.appendChild((nsIDOMNode)visualParentTR);
                String styleClass = ComponentUtil.encodeStyleClass(null, customFacetClass, null, facetClass);
                if (styleClass != null) {
                    visualParentTR.setAttribute("class", styleClass);
                }
                this.encodeColumnsFacets(pageContext, columns, facetName, visualParentTR, visualElementForTD, cellClass, facetClass);
            }
        }
    }

    public void encodeTableFooter(VpePageContext pageContext, nsIDOMElement visualParentForFacetTHead, String visualTagForFacetTHead, String visualElementForTD, String facetName, String customFacetClass, String facetTHeadClass, String firstRowClass, String rowClass, String cellClass) {
        Element facetSourceElement = SourceDomUtil.getFacetByName((VpePageContext)pageContext, (Element)this.tableSourceElement, (String)facetName);
        ArrayList<Element> columns = RichFaces.getColumns(this.tableSourceElement);
        RichFaces.getColumnsCount(this.tableSourceElement, columns);
        Map facetChildren = VisualDomUtil.findFacetElements((Node)facetSourceElement, (VpePageContext)pageContext);
        boolean headerJsfElementPresents = ((List)facetChildren.get(VisualDomUtil.FACET_JSF_TAG)).size() > 0;
        boolean hasColumnWithFacets = RichFaces.hasColumnWithFacet(columns, facetName);
        if (headerJsfElementPresents || hasColumnWithFacets) {
            nsIDOMElement createdVisualTagForFacetTHead = null;
            if (visualTagForFacetTHead == null || "".equalsIgnoreCase(visualTagForFacetTHead)) {
                createdVisualTagForFacetTHead = visualParentForFacetTHead;
            } else {
                createdVisualTagForFacetTHead = this.visualDocument.createElement(visualTagForFacetTHead);
                visualParentForFacetTHead.appendChild((nsIDOMNode)createdVisualTagForFacetTHead);
            }
            String facetClass = null;
            if (this.tableSourceElement.hasAttribute(String.valueOf(facetName) + "Class")) {
                facetClass = this.tableSourceElement.getAttribute(String.valueOf(facetName) + "Class");
            }
            if (hasColumnWithFacets) {
                nsIDOMElement visualParentTR = this.visualDocument.createElement("tr");
                createdVisualTagForFacetTHead.appendChild((nsIDOMNode)visualParentTR);
                String styleClass = ComponentUtil.encodeStyleClass(null, customFacetClass, null, facetClass);
                if (styleClass != null) {
                    visualParentTR.setAttribute("class", styleClass);
                }
                this.encodeColumnsFacets(pageContext, columns, facetName, visualParentTR, visualElementForTD, cellClass, facetClass);
            }
            if (headerJsfElementPresents) {
                Element node = (Element)((List)facetChildren.get(VisualDomUtil.FACET_JSF_TAG)).get(0);
                this.encodeTableFacets(pageContext, createdVisualTagForFacetTHead, node, visualElementForTD, facetTHeadClass, firstRowClass, rowClass, cellClass);
            }
        }
    }
}

