/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.richfaces.template;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jboss.tools.jsf.vpe.richfaces.ComponentUtil;
import org.jboss.tools.jsf.vpe.richfaces.RichFacesTemplatesActivator;
import org.jboss.tools.jsf.vpe.richfaces.template.RichFaces;
import org.jboss.tools.jsf.vpe.richfaces.template.RichFacesColumnGroupTemplate;
import org.jboss.tools.jsf.vpe.richfaces.template.RichFacesColumnTemplate;
import org.jboss.tools.jsf.vpe.richfaces.template.RichFacesDataTableChildrenEncoder;
import org.jboss.tools.jsf.vpe.richfaces.template.RichFacesDataTableStyleClassesApplier;
import org.jboss.tools.jsf.vpe.richfaces.template.RichFacesSubTableTemplate;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractTemplate;
import org.jboss.tools.vpe.editor.template.VpeChildrenInfo;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.jboss.tools.vpe.editor.util.SourceDomUtil;
import org.jboss.tools.vpe.editor.util.VisualDomUtil;
import org.jboss.tools.vpe.xulrunner.util.XPCOM;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsISupports;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RichFacesDataTableTemplate
extends VpeAbstractTemplate {
    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        Element sourceElement = (Element)sourceNode;
        nsIDOMElement table = visualDocument.createElement("table");
        VisualDomUtil.copyAttributes((Node)sourceNode, (nsIDOMElement)table);
        VpeCreationData creationData = new VpeCreationData((nsIDOMNode)table);
        ComponentUtil.setCSSLink(pageContext, "dataTable/dataTable.css", "richFacesDataTable");
        String tableClass = "dr-table rich-table";
        if (sourceElement.hasAttribute("styleClass")) {
            tableClass = String.valueOf(tableClass) + " " + sourceElement.getAttribute("styleClass");
        }
        table.setAttribute("class", tableClass);
        ArrayList<Element> columns = RichFaces.getColumns(sourceElement);
        int columnsLength = RichFaces.getColumnsCount(sourceElement, columns);
        nsIDOMElement colgroup = visualDocument.createElement("colgroup");
        colgroup.setAttribute("span", String.valueOf(columnsLength));
        table.appendChild((nsIDOMNode)colgroup);
        if (sourceElement.hasAttribute("columnsWidth")) {
            String columnsWidth = sourceElement.getAttribute("columnsWidth");
            String[] widths = columnsWidth.split(",");
            int i = 0;
            while (i < widths.length) {
                nsIDOMElement col = visualDocument.createElement("col");
                col.setAttribute("width", widths[i]);
                colgroup.appendChild((nsIDOMNode)col);
                ++i;
            }
        }
        Element caption = SourceDomUtil.getFacetByName((VpePageContext)pageContext, (Element)sourceElement, (String)"caption");
        Map captionFacetChildren = VisualDomUtil.findFacetElements((Node)caption, (VpePageContext)pageContext);
        Node captionNode = null;
        if (((List)captionFacetChildren.get(VisualDomUtil.FACET_JSF_TAG)).size() > 0) {
            captionNode = (Node)((List)captionFacetChildren.get(VisualDomUtil.FACET_JSF_TAG)).get(0);
        }
        this.encodeCaption(pageContext, creationData, sourceElement, visualDocument, table, captionNode);
        Element header = SourceDomUtil.getFacetByName((VpePageContext)pageContext, (Element)sourceElement, (String)"header");
        boolean tableFacetHasChildren = false;
        if (header != null) {
            tableFacetHasChildren = header.getChildNodes().getLength() > 0;
        }
        boolean hasColumnWithHeader = RichFaces.hasColumnWithFacet(columns, "header");
        if (tableFacetHasChildren || hasColumnWithHeader) {
            String headerClass;
            nsIDOMElement thead = visualDocument.createElement("thead");
            table.appendChild((nsIDOMNode)thead);
            String string = headerClass = sourceElement.hasAttribute("headerClass") ? sourceElement.getAttribute("headerClass") : null;
            if (tableFacetHasChildren) {
                this.encodeTableHeaderOrFooterFacet(pageContext, creationData, thead, columnsLength, visualDocument, header, "dr-table-header rich-table-header", "dr-table-header-continue rich-table-header-continue", "dr-table-headercell rich-table-headercell", headerClass, "td", true);
            }
            if (hasColumnWithHeader) {
                nsIDOMElement tr = visualDocument.createElement("tr");
                thead.appendChild((nsIDOMNode)tr);
                String styleClass = ComponentUtil.encodeStyleClass(null, "dr-table-subheader rich-table-subheader", null, headerClass);
                if (styleClass != null) {
                    tr.setAttribute("class", styleClass);
                }
                RichFacesDataTableTemplate.encodeHeaderOrFooterFacets(pageContext, creationData, tr, visualDocument, columns, "dr-table-subheadercell rich-table-subheadercell", headerClass, "header", "td");
            }
        }
        Element footer = SourceDomUtil.getFacetByName((VpePageContext)pageContext, (Element)sourceElement, (String)"footer");
        tableFacetHasChildren = false;
        if (footer != null) {
            tableFacetHasChildren = footer.getChildNodes().getLength() > 0;
        }
        boolean hasColumnWithFooter = RichFaces.hasColumnWithFacet(columns, "footer");
        if (tableFacetHasChildren || hasColumnWithFooter) {
            String footerClass;
            nsIDOMElement tfoot = visualDocument.createElement("tfoot");
            table.appendChild((nsIDOMNode)tfoot);
            String string = footerClass = sourceElement.hasAttribute("footerClass") ? sourceElement.getAttribute("footerClass") : null;
            if (hasColumnWithFooter) {
                nsIDOMElement tr = visualDocument.createElement("tr");
                tfoot.appendChild((nsIDOMNode)tr);
                String styleClass = ComponentUtil.encodeStyleClass(null, "dr-table-subfooter rich-table-subfooter", null, footerClass);
                if (styleClass != null) {
                    tr.setAttribute("class", styleClass);
                }
                RichFacesDataTableTemplate.encodeHeaderOrFooterFacets(pageContext, creationData, tr, visualDocument, columns, "dr-table-subfootercell rich-table-subfootercell", footerClass, "footer", "td");
            }
            if (tableFacetHasChildren) {
                this.encodeTableHeaderOrFooterFacet(pageContext, creationData, tfoot, columnsLength, visualDocument, footer, "dr-table-footer rich-table-footer", "dr-table-footer-continue rich-table-footer-continue", "dr-table-footercell rich-table-footercell", footerClass, "td", true);
            }
        }
        new RichFacesDataTableChildrenEncoder(creationData, visualDocument, sourceElement, table).encodeChildren();
        return creationData;
    }

    protected void encodeCaption(VpePageContext pageContext, VpeCreationData creationData, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMElement table, Node captionBody) {
        if (captionBody != null) {
            nsIDOMElement caption = visualDocument.createElement("caption");
            table.appendChild((nsIDOMNode)caption);
            String defaultCaptionClass = "dr-table-caption rich-table-caption";
            String captionClass = table.hasAttribute("captionClass") ? String.valueOf(defaultCaptionClass) + " " + table.getAttribute("captionClass") : defaultCaptionClass;
            caption.setAttribute("class", captionClass);
            if (table.hasAttribute("captionStyle")) {
                String captionStyle = table.getAttribute("captionStyle");
                caption.setAttribute("style", captionStyle);
            }
            VpeChildrenInfo cap = new VpeChildrenInfo(caption);
            cap.addSourceChild(captionBody);
            creationData.addChildrenInfo(cap);
        }
    }

    public static void encodeHeaderOrFooterFacets(VpePageContext pageContext, VpeCreationData creationData, nsIDOMElement parentTr, nsIDOMDocument visualDocument, ArrayList<Element> headersOrFooters, String skinCellClass, String headerClass, String facetName, String element) {
        for (Element column : headersOrFooters) {
            nsIDOMElement icon;
            Element facet = SourceDomUtil.getFacetByName((VpePageContext)pageContext, (Element)column, (String)facetName);
            if (facet == null) continue;
            String classAttribute = String.valueOf(facetName) + "Class";
            String columnHeaderClass = column.hasAttribute(classAttribute) ? column.getAttribute(classAttribute) : null;
            nsIDOMElement td = visualDocument.createElement(element);
            parentTr.appendChild((nsIDOMNode)td);
            String styleClass = ComponentUtil.encodeStyleClass(null, skinCellClass, headerClass, columnHeaderClass);
            if (!RichFacesColumnTemplate.isVisible(column)) {
                VisualDomUtil.setSubAttribute((nsIDOMElement)td, (String)"style", (String)"display", (String)"none");
            }
            td.setAttribute("class", styleClass);
            td.setAttribute("scope", "col");
            if (column.hasAttribute("colspan")) {
                String colspan = column.getAttribute("colspan");
                td.setAttribute("colspan", colspan);
            }
            if ("header".equals(facetName) && (icon = RichFacesColumnTemplate.getHeaderIcon(pageContext, column, visualDocument)) != null) {
                td.appendChild((nsIDOMNode)icon);
            }
            VpeChildrenInfo childrenInfo = new VpeChildrenInfo(td);
            childrenInfo.addSourceChild((Node)facet);
            creationData.addChildrenInfo(childrenInfo);
        }
    }

    protected void encodeTableHeaderOrFooterFacet(VpePageContext pageContext, VpeCreationData creationData, nsIDOMElement parentTheadOrTfood, int columns, nsIDOMDocument visualDocument, Node facetBody, String skinFirstRowClass, String skinRowClass, String skinCellClass, String facetBodyClass, String facetVisualNode, boolean encodeAllFacetChildrenManually) {
        if (facetBody == null) {
            RichFacesTemplatesActivator.getDefault().logError("Facet Body is 'null' in <rich:dataTable> !!");
        }
        NodeList allFacetElements = facetBody.getChildNodes();
        int length = allFacetElements.getLength();
        Node child = null;
        boolean isColumnGroup = false;
        boolean isSubTable = false;
        if (length > 0) {
            int i = 0;
            while (i < length) {
                child = allFacetElements.item(i);
                if (child.getNodeName().endsWith("columnGroup")) {
                    isColumnGroup = true;
                    facetBody = child;
                    break;
                }
                if (child.getNodeName().endsWith("subTable")) {
                    isSubTable = true;
                    facetBody = child;
                    break;
                }
                ++i;
            }
        } else {
            isColumnGroup = facetBody.getNodeName().endsWith("columnGroup");
            isSubTable = facetBody.getNodeName().endsWith("subTable");
        }
        if (isColumnGroup) {
            RichFacesColumnGroupTemplate.DEFAULT_INSTANCE.encodeSubTable(pageContext, creationData, (Element)facetBody, visualDocument, parentTheadOrTfood);
        } else if (isSubTable) {
            RichFacesSubTableTemplate.DEFAULT_INSTANCE.encodeSubTable(pageContext, creationData, (Element)facetBody, visualDocument, parentTheadOrTfood);
        } else {
            nsIDOMElement tr = visualDocument.createElement("tr");
            parentTheadOrTfood.appendChild((nsIDOMNode)tr);
            String styleClass = ComponentUtil.encodeStyleClass(null, skinFirstRowClass, facetBodyClass, null);
            if (styleClass != null) {
                tr.setAttribute("class", styleClass);
            }
            String style = ComponentUtil.getHeaderBackgoundImgStyle();
            tr.setAttribute("style", style);
            nsIDOMElement td = visualDocument.createElement(facetVisualNode);
            tr.appendChild((nsIDOMNode)td);
            styleClass = ComponentUtil.encodeStyleClass(null, skinCellClass, facetBodyClass, null);
            if (styleClass != null) {
                td.setAttribute("class", styleClass);
            }
            td.setAttribute("colspan", "100");
            td.setAttribute("scope", "colgroup");
            VpeChildrenInfo childrenInfo = new VpeChildrenInfo(td);
            if (encodeAllFacetChildrenManually) {
                int i = 0;
                while (i < length) {
                    childrenInfo.addSourceChild(allFacetElements.item(i));
                    ++i;
                }
                creationData.addChildrenInfo(childrenInfo);
            } else {
                childrenInfo.addSourceChild(facetBody);
                creationData.addChildrenInfo(childrenInfo);
            }
        }
    }

    public void validate(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument, VpeCreationData data) {
        RichFacesDataTableChildrenEncoder.validateChildren(pageContext, sourceNode, visualDocument, data);
        RichFacesDataTableStyleClassesApplier styleClassesApplier = new RichFacesDataTableStyleClassesApplier(visualDocument, pageContext, sourceNode);
        styleClassesApplier.applyClasses((nsIDOMElement)data.getNode());
    }

    public void removeAttribute(VpePageContext pageContext, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMNode visualNode, Object data, String name) {
        nsIDOMElement visualElement = (nsIDOMElement)XPCOM.queryInterface((nsISupports)visualNode, nsIDOMElement.class);
        visualElement.removeAttribute(name);
    }

    public void setAttribute(VpePageContext pageContext, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMNode visualNode, Object data, String name, String value) {
        nsIDOMElement visualElement = (nsIDOMElement)XPCOM.queryInterface((nsISupports)visualNode, nsIDOMElement.class);
        visualElement.setAttribute(name, value);
    }
}

