/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.richfaces.template;

import java.util.List;
import org.jboss.tools.jsf.vpe.richfaces.ComponentUtil;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractTemplate;
import org.jboss.tools.vpe.editor.template.VpeChildrenInfo;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMText;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RichFacesDropDownMenuTemplate
extends VpeAbstractTemplate {
    private static final String COMPONENT_NAME = "dropDownMenu";
    private static final String STYLE_PATH = "dropDownMenu/dropDownMenu.css";
    private static final String CHILD_GROUP_NAME = ":menuGroup";
    private static final String CHILD_ITEM_NAME = ":menuItem";
    private static final String LABEL_FACET_NAME = "label";
    private static final String DEFAULT_DDM_TITLE = "rich:dropDownMenu";
    private static final String MENU_TOP_ID = "vpe-ddm-menu-title-ul";
    private static final String MENU_TOP_ITEM_ID = "vpe-ddm-menu-title-li";
    private static final String MENU_CHILDREN_LIST_ID = "vpe-ddm-menu-children-ul";
    private static final String CSS_RICH_DDMENU_LABEL = "rich-ddmenu-label";
    private static final String CSS_RICH_DDMENU_LABEL_UNSELECT = "rich-ddmenu-label-unselect";
    private static final String CSS_RICH_DDMENU_LABEL_SELECT = "rich-ddmenu-label-select";
    private static final String CSS_RICH_DDMENU_LABEL_DISABLED = "rich-ddmenu-label-disabled";
    private static final String CSS_RICH_LABEL_TEXT_DECOR = "rich-label-text-decor";
    private static final String CSS_RICH_MENU_LIST_BORDER = "rich-menu-list-border";
    private static final String CSS_RICH_MENU_LIST_BG = "rich-menu-list-bg";
    private static final String CSS_RICH_DDEMENU_LIST_DIV_STYLE = "";
    private static final String CSS_RICH_DDEMENU_BORDER_DIV_STYLE = "";
    private static final String CSS_MENU_TOP_DIV = "dr-menu-top-div";

    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        VpeCreationData creationData = null;
        Element sourceElement = (Element)sourceNode;
        ComponentUtil.setCSSLink(pageContext, STYLE_PATH, COMPONENT_NAME);
        Attributes attrs = new Attributes(sourceElement);
        nsIDOMElement ddmMainUL = visualDocument.createElement("ul");
        nsIDOMElement ddmMainLI = visualDocument.createElement("li");
        nsIDOMElement ddmChildrenUL = visualDocument.createElement("ul");
        nsIDOMElement ddmLabelDiv = visualDocument.createElement("div");
        nsIDOMElement ddmTextSpan = visualDocument.createElement("span");
        nsIDOMText ddmLabelText = visualDocument.createTextNode("");
        nsIDOMElement ddmListDiv = visualDocument.createElement("div");
        nsIDOMElement ddmListBorderDiv = visualDocument.createElement("div");
        nsIDOMElement ddmListBgDiv = visualDocument.createElement("div");
        creationData = new VpeCreationData((nsIDOMNode)ddmMainUL);
        ddmLabelDiv.appendChild((nsIDOMNode)ddmTextSpan);
        ddmListDiv.appendChild((nsIDOMNode)ddmListBorderDiv);
        ddmListBorderDiv.appendChild((nsIDOMNode)ddmListBgDiv);
        ddmMainUL.appendChild((nsIDOMNode)ddmMainLI);
        ddmMainLI.appendChild((nsIDOMNode)ddmLabelDiv);
        ddmMainUL.setAttribute(MENU_TOP_ID, "");
        ddmMainLI.setAttribute(MENU_TOP_ITEM_ID, "");
        ddmChildrenUL.setAttribute(MENU_CHILDREN_LIST_ID, "");
        String labelDivClass = "";
        String listBorderDivClass = "";
        labelDivClass = String.valueOf(labelDivClass) + " rich-ddmenu-label rich-ddmenu-label-unselect";
        listBorderDivClass = String.valueOf(listBorderDivClass) + " rich-menu-list-border";
        if (ComponentUtil.isNotBlank(attrs.getStyleClass())) {
            labelDivClass = String.valueOf(labelDivClass) + " " + attrs.getStyleClass();
            listBorderDivClass = String.valueOf(listBorderDivClass) + " " + attrs.getStyleClass();
        }
        ddmLabelDiv.setAttribute("class", CSS_MENU_TOP_DIV);
        ddmMainLI.setAttribute("class", labelDivClass);
        ddmTextSpan.setAttribute("class", CSS_RICH_LABEL_TEXT_DECOR);
        ddmChildrenUL.setAttribute("class", String.valueOf(listBorderDivClass) + " " + CSS_RICH_MENU_LIST_BG);
        String cssListDivStyle = "";
        String cssListBorderDivStyle = "";
        String cssLabelDivStyle = "";
        cssListDivStyle = String.valueOf(cssListDivStyle) + " ";
        cssListBorderDivStyle = String.valueOf(cssListBorderDivStyle) + " ";
        if (ComponentUtil.isNotBlank(attrs.getStyle())) {
            cssLabelDivStyle = String.valueOf(cssLabelDivStyle) + " " + attrs.getStyle();
        }
        ddmMainLI.setAttribute("style", String.valueOf(cssListDivStyle) + " " + cssListBorderDivStyle + " " + cssLabelDivStyle);
        ddmChildrenUL.setAttribute("style", String.valueOf(cssListDivStyle) + " " + cssListBorderDivStyle + " " + cssLabelDivStyle);
        Element labelFacet = ComponentUtil.getFacet(sourceElement, LABEL_FACET_NAME);
        if (labelFacet != null) {
            VpeChildrenInfo childrenInfo = new VpeChildrenInfo(ddmTextSpan);
            childrenInfo.addSourceChild((Node)labelFacet);
            creationData.addChildrenInfo(childrenInfo);
        } else {
            String labelValue = DEFAULT_DDM_TITLE;
            if (ComponentUtil.isNotBlank(attrs.getValue())) {
                labelValue = attrs.getValue();
            }
            ddmLabelText.setNodeValue(labelValue);
            ddmTextSpan.appendChild((nsIDOMNode)ddmLabelText);
        }
        List<Node> children = ComponentUtil.getChildren(sourceElement);
        boolean missingChildContainer = true;
        for (Node child : children) {
            if (child.getNodeType() != 1 || !child.getNodeName().endsWith(CHILD_GROUP_NAME) && !child.getNodeName().endsWith(CHILD_ITEM_NAME)) continue;
            if (missingChildContainer) {
                ddmMainLI.appendChild((nsIDOMNode)ddmChildrenUL);
                missingChildContainer = false;
            }
            VpeChildrenInfo childDivInfo = new VpeChildrenInfo(ddmChildrenUL);
            childDivInfo.addSourceChild(child);
            creationData.addChildrenInfo(childDivInfo);
        }
        return creationData;
    }

    public boolean recreateAtAttrChange(VpePageContext pageContext, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMElement visualNode, Object data, String name, String value) {
        return true;
    }

    class Attributes {
        private String DIRECTION = "direction";
        private String HORIZONTAL_OFFCET = "horizontalOffset";
        private String JOINT_POINT = "jontPoint";
        private String POPUP_WIDTH = "popupWidth";
        private String VERTICAL_OFFSET = "verticalOffset";
        private String DISABLED_ITEM_CLASS = "disabledItemClass";
        private String DISABLED_ITEM_STYLE = "disabledItemStyle";
        private String DISABLED_LABEL_CLASS = "disabledLabelClass";
        private String ITEM_CLASS = "itemClass";
        private String ITEM_STYLE = "itemStyle";
        private String SELECED_LABEL_CLASS = "selectedLabelClass";
        private String SELECT_ITEM_CLASS = "selectItemClass";
        private String ddm_direction;
        private String ddm_disabled;
        private String ddm_horizontalOffset;
        private String ddm_jointPoint;
        private String ddm_popupWidth;
        private String ddm_verticalOffset;
        private String ddm_disabledItemClass;
        private String ddm_disabledItemStyle;
        private String ddm_disabledLabelClass;
        private String ddm_itemClass;
        private String ddm_itemStyle;
        private String ddm_selectedLabelClass;
        private String ddm_selectItemClass;
        private String ddm_style;
        private String ddm_styleClass;
        private String ddm_value;

        public Attributes(Element sourceElement) {
            if (sourceElement == null) {
                return;
            }
            this.ddm_direction = sourceElement.getAttribute(this.DIRECTION);
            this.ddm_disabled = sourceElement.getAttribute("disabled");
            this.ddm_horizontalOffset = sourceElement.getAttribute(this.HORIZONTAL_OFFCET);
            this.ddm_jointPoint = sourceElement.getAttribute(this.JOINT_POINT);
            this.ddm_popupWidth = sourceElement.getAttribute(this.POPUP_WIDTH);
            this.ddm_verticalOffset = sourceElement.getAttribute(this.VERTICAL_OFFSET);
            this.ddm_disabledItemClass = sourceElement.getAttribute(this.DISABLED_ITEM_CLASS);
            this.ddm_disabledItemStyle = sourceElement.getAttribute(this.DISABLED_ITEM_STYLE);
            this.ddm_disabledLabelClass = sourceElement.getAttribute(this.DISABLED_LABEL_CLASS);
            this.ddm_itemClass = sourceElement.getAttribute(this.ITEM_CLASS);
            this.ddm_itemStyle = sourceElement.getAttribute(this.ITEM_STYLE);
            this.ddm_selectedLabelClass = sourceElement.getAttribute(this.SELECED_LABEL_CLASS);
            this.ddm_selectItemClass = sourceElement.getAttribute(this.SELECT_ITEM_CLASS);
            this.ddm_style = sourceElement.getAttribute("style");
            this.ddm_styleClass = sourceElement.getAttribute("styleClass");
            this.ddm_value = sourceElement.getAttribute("value");
        }

        public String getStyle() {
            return this.ddm_style;
        }

        public String getStyleClass() {
            return this.ddm_styleClass;
        }

        public String getDisabled() {
            return this.ddm_disabled;
        }

        public String getValue() {
            return this.ddm_value;
        }
    }
}

