/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.richfaces.template;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jboss.tools.jsf.vpe.richfaces.ComponentUtil;
import org.jboss.tools.vpe.editor.VpeSourceDomBuilder;
import org.jboss.tools.vpe.editor.VpeVisualDomBuilder;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractTemplate;
import org.jboss.tools.vpe.editor.template.VpeChildrenInfo;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.jboss.tools.vpe.editor.template.VpeToggableTemplate;
import org.jboss.tools.vpe.editor.util.ResourceUtil;
import org.jboss.tools.vpe.editor.util.VpeStyleUtil;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMText;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RichFacesPanelMenuGroupTemplate
extends VpeAbstractTemplate
implements VpeToggableTemplate {
    public static final String VPE_EXPANDED_TOGGLE_IDS = "vpe-expanded-toggle-ids";
    public static final String GROUP_COUNT_SEPARATOR = "-";
    public static final Map<String, String> DEFAULT_ICON_MAP = new HashMap<String, String>();
    private static final String DISABLED_CLASS = "disabledClass";
    private static final String DISABLED_STYLE = "disabledStyle";
    private static final String ICON_CLASS = "iconClass";
    private static final String ICON_STYLE = "iconStyle";
    private static final String ICON_EXPANDED = "iconExpanded";
    private static final String ICON_COLLAPSED = "iconCollapsed";
    private static final String ICON_DISABLED = "iconDisabled";
    private static final String LABEL = "label";
    private static final String STYLE = "style";
    private static final String STYLE_CLASS = "styleClass";
    private static final String CSS_DR_TOP_GROUP_DIV = "dr-pmenu-top-group-div";
    private static final String CSS_DR_TOP_GROUP = "dr-pmenu-top-group";
    private static final String CSS_DR_GROUP = "dr-pmenu-group";
    private static final String CSS_TOP_GROUP_ICON = "rich-pmenu-top-group-self-icon";
    private static final String CSS_TOP_GROUP_LABEL = "rich-pmenu-top-group-self-label";
    private static final String CSS_DR_GROUP_DIV = "dr-pmenu-group-div";
    private static final String CSS_GROUP = "rich-pmenu-group";
    private static final String CSS_TOP_GROUP = "rich-pmenu-top-group";
    private static final String CSS_TOP_GROUP_DIV = "rich-pmenu-top-group-div";
    private static final String CSS_GROUP_ICON = "rich-pmenu-group-self-icon";
    private static final String CSS_GROUP_LABEL = "rich-pmenu-group-self-label";
    private static final String CSS_HOVERED_ELEMENT = "rich-pmenu-hovered-element";
    private static final String CSS_DISABLED_ELEMENT = "rich-pmenu-disabled-element";
    private static final String NAME_COMPONENT = "panelMenuGroup";
    private static final String PANEL_MENU_END_TAG = ":panelMenu";
    private static final String PANEL_MENU_GROUP_END_TAG = ":panelMenuGroup";
    private static final String PANEL_MENU_ITEM_END_TAG = ":panelMenuItem";
    private static final String COMPONENT_ATTR_VPE_SUPPORT = "vpeSupport";
    private static final String PANEL_MENU_GROUP_ICON_SPACER_PATH = "/panelMenuGroup/spacer.gif";
    private static final String STYLE_PATH = "/panelMenuGroup/style.css";
    private static final String VSPACE = "vspace";
    private static final String HSPACE = "hspace";
    private static final String TRUE = "true";
    private static final String RIGHT = "right";
    private static final String LEFT = "right";
    private static final String WIDTH_100_PERSENTS = "width: 100%; ";
    private static final String DEFAULT_SIZE_VALUE = "16";
    private List<String> expandedIds = new ArrayList<String>();

    static {
        DEFAULT_ICON_MAP.put("chevron", "/panelMenuGroup/chevron.gif");
        DEFAULT_ICON_MAP.put("chevronUp", "/panelMenuGroup/chevronUp.gif");
        DEFAULT_ICON_MAP.put("chevronDown", "/panelMenuGroup/chevronDown.gif");
        DEFAULT_ICON_MAP.put("triangle", "/panelMenuGroup/triangle.gif");
        DEFAULT_ICON_MAP.put("triangleUp", "/panelMenuGroup/triangleUp.gif");
        DEFAULT_ICON_MAP.put("triangleDown", "/panelMenuGroup/triangleDown.gif");
        DEFAULT_ICON_MAP.put("disc", "/panelMenuGroup/disc.gif");
        DEFAULT_ICON_MAP.put("grid", "/panelMenuGroup/grid.gif");
    }

    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        Element groupSourceElement = (Element)sourceNode;
        this.expandedIds = (List)groupSourceElement.getUserData(VPE_EXPANDED_TOGGLE_IDS);
        String childId = (String)groupSourceElement.getUserData("vpe-user-toggle-id");
        int childGroupCount = 1;
        Element anySuitableParent = RichFacesPanelMenuGroupTemplate.getGroupParent(groupSourceElement, false);
        Element panelMenuParent = RichFacesPanelMenuGroupTemplate.getGroupParent(groupSourceElement, true);
        Attributes attrs = new Attributes(groupSourceElement, panelMenuParent);
        ComponentUtil.setCSSLink(pageContext, STYLE_PATH, NAME_COMPONENT);
        boolean expanded = false;
        if (this.expandedIds != null) {
            expanded = this.expandedIds.contains(childId);
        }
        nsIDOMElement div = visualDocument.createElement("div");
        VpeCreationData creationData = new VpeCreationData((nsIDOMNode)div);
        div.setAttribute(COMPONENT_ATTR_VPE_SUPPORT, NAME_COMPONENT);
        div.setAttribute("vpe-user-toggle-id", childId);
        this.buildTable(pageContext, anySuitableParent, panelMenuParent, groupSourceElement, visualDocument, div, expanded, childId, attrs);
        nsIDOMElement childSpan = visualDocument.createElement("span");
        VpeChildrenInfo childrenInfo = new VpeChildrenInfo(childSpan);
        List<Node> children = null;
        children = ComponentUtil.getChildren(groupSourceElement);
        if (expanded) {
            for (Node child : children) {
                boolean isGroup = child.getNodeName().endsWith(PANEL_MENU_GROUP_END_TAG);
                boolean isItem = child.getNodeName().endsWith(PANEL_MENU_ITEM_END_TAG);
                if (isGroup) {
                    String newLevelToggleId = String.valueOf(childId) + GROUP_COUNT_SEPARATOR + childGroupCount;
                    ++childGroupCount;
                    child.setUserData("vpe-user-toggle-id", newLevelToggleId, null);
                    child.setUserData(VPE_EXPANDED_TOGGLE_IDS, this.expandedIds, null);
                }
                if (isItem) {
                    child.setUserData("vpe-panel-menu-item-id", childId, null);
                }
                childrenInfo = new VpeChildrenInfo(div);
                childrenInfo.addSourceChild(child);
                creationData.addChildrenInfo(childrenInfo);
            }
        }
        if (childrenInfo.getSourceChildren() == null) {
            creationData.addChildrenInfo(childrenInfo);
        }
        return creationData;
    }

    private void buildTable(VpePageContext pageContext, Element anySuitableParent, Element panelMenuParent, Element groupSourceElement, nsIDOMDocument visualDocument, nsIDOMElement div, boolean expanded, String activeChildId, Attributes attrs) {
        String[] ids;
        String tableStyle = "";
        String tableClass = "";
        String iconCellClass = "";
        String iconCellStyle = "";
        String labelCellClass = "";
        String emptyCellClass = "";
        String divClass = "";
        nsIDOMElement table = visualDocument.createElement("table");
        div.appendChild((nsIDOMNode)table);
        table.setAttribute("cellspacing", "0");
        table.setAttribute("cellpadding", "0");
        table.setAttribute("border", "0");
        nsIDOMElement tableBodyRow = visualDocument.createElement("tr");
        table.appendChild((nsIDOMNode)tableBodyRow);
        ArrayList<nsIDOMElement> indentTds = new ArrayList<nsIDOMElement>();
        if (activeChildId != null && (ids = activeChildId.split(GROUP_COUNT_SEPARATOR)).length > 1) {
            int i = 1;
            while (i <= ids.length - 1) {
                nsIDOMElement spacerTd = visualDocument.createElement("td");
                nsIDOMElement spacerImg = visualDocument.createElement("img");
                spacerTd.appendChild((nsIDOMNode)spacerImg);
                ComponentUtil.setImg(spacerImg, PANEL_MENU_GROUP_ICON_SPACER_PATH);
                RichFacesPanelMenuGroupTemplate.setDefaultImgAttributes(spacerImg);
                tableBodyRow.appendChild((nsIDOMNode)spacerTd);
                indentTds.add(spacerTd);
                ++i;
            }
        }
        nsIDOMElement column1 = visualDocument.createElement("td");
        column1.setAttribute("vpe-user-toggle-id", activeChildId);
        tableBodyRow.appendChild((nsIDOMNode)column1);
        nsIDOMElement column2 = visualDocument.createElement("td");
        tableBodyRow.appendChild((nsIDOMNode)column2);
        column2.setAttribute(STYLE, WIDTH_100_PERSENTS);
        nsIDOMElement column3 = visualDocument.createElement("td");
        column3.setAttribute("vpe-user-toggle-id", activeChildId);
        tableBodyRow.appendChild((nsIDOMNode)column3);
        Attr labelAttr = null;
        String labelValue = "";
        String bundleValue = "";
        String resultValue = "";
        if (groupSourceElement.hasAttribute(LABEL)) {
            labelAttr = groupSourceElement.getAttributeNode(LABEL);
        }
        if (labelAttr != null) {
            labelValue = labelAttr.getNodeValue();
            bundleValue = ResourceUtil.getBundleValue((VpePageContext)pageContext, (String)labelAttr.getValue());
        }
        resultValue = ComponentUtil.isNotBlank(labelValue) ? (ComponentUtil.isNotBlank(bundleValue) ? (!labelValue.equals(bundleValue) ? bundleValue : labelValue) : labelValue) : (ComponentUtil.isNotBlank(bundleValue) ? bundleValue : "");
        nsIDOMText text = visualDocument.createTextNode(resultValue);
        column2.appendChild((nsIDOMNode)text);
        column2.setAttribute("vpe-user-toggle-id", activeChildId);
        boolean childOfPanelMenu = anySuitableParent != null ? anySuitableParent.getNodeName().endsWith(PANEL_MENU_END_TAG) : false;
        nsIDOMElement iconCell = column1;
        nsIDOMElement emptyCell = column3;
        if (!childOfPanelMenu && ComponentUtil.isNotBlank(attrs.getPm_iconGroupPosition()) && "right".equalsIgnoreCase(attrs.getPm_iconGroupPosition())) {
            iconCell = column3;
            emptyCell = column1;
        }
        if (childOfPanelMenu && ComponentUtil.isNotBlank(attrs.getPm_iconGroupTopPosition())) {
            if ("right".equalsIgnoreCase(attrs.getPm_iconGroupTopPosition())) {
                iconCell = column3;
                emptyCell = column1;
            } else if ("right".equalsIgnoreCase(attrs.getPm_iconGroupTopPosition())) {
                iconCell = column1;
                emptyCell = column3;
            }
        }
        nsIDOMElement imgIcon = visualDocument.createElement("img");
        nsIDOMElement imgSpacer = visualDocument.createElement("img");
        ComponentUtil.setImg(imgSpacer, PANEL_MENU_GROUP_ICON_SPACER_PATH);
        RichFacesPanelMenuGroupTemplate.setDefaultImgAttributes(imgSpacer);
        iconCell.appendChild((nsIDOMNode)imgIcon);
        emptyCell.appendChild((nsIDOMNode)imgSpacer);
        this.setIcon(pageContext, panelMenuParent, groupSourceElement, imgIcon, expanded, childOfPanelMenu, attrs);
        if (childOfPanelMenu) {
            tableClass = String.valueOf(tableClass) + " dr-pmenu-top-group rich-pmenu-top-group rich-pmenu-group";
            divClass = String.valueOf(divClass) + " dr-pmenu-top-group-div rich-pmenu-top-group-div";
        } else {
            tableClass = String.valueOf(tableClass) + " rich-pmenu-group dr-pmenu-group";
            divClass = String.valueOf(divClass) + " dr-pmenu-group-div";
        }
        if (TRUE.equalsIgnoreCase(attrs.getPm_disabled()) && childOfPanelMenu) {
            tableClass = String.valueOf(tableClass) + " rich-pmenu-disabled-element";
            if (ComponentUtil.isNotBlank(attrs.getPm_disabledGroupClass())) {
                tableClass = String.valueOf(tableClass) + " " + attrs.getPm_disabledGroupClass();
            }
            if (ComponentUtil.isNotBlank(attrs.getPm_topGroupStyle())) {
                tableStyle = String.valueOf(tableStyle) + " " + attrs.getPm_topGroupStyle();
            }
        }
        if (TRUE.equalsIgnoreCase(attrs.getPmg_disabled())) {
            if (!TRUE.equalsIgnoreCase(attrs.getPm_disabled())) {
                tableClass = String.valueOf(tableClass) + " rich-pmenu-disabled-element";
                if (ComponentUtil.isNotBlank(attrs.getPm_disabledGroupClass())) {
                    tableClass = String.valueOf(tableClass) + " " + attrs.getPm_disabledGroupClass();
                }
            }
            if (ComponentUtil.isNotBlank(attrs.getPmg_disabledClass())) {
                tableClass = String.valueOf(tableClass) + " " + attrs.getPmg_disabledClass();
            }
            if (ComponentUtil.isNotBlank(attrs.getPm_disabledGroupStyle())) {
                tableStyle = String.valueOf(tableStyle) + " " + attrs.getPm_disabledGroupStyle();
            }
            if (ComponentUtil.isNotBlank(attrs.getPmg_disabledStyle())) {
                tableStyle = String.valueOf(tableStyle) + " " + attrs.getPmg_disabledStyle();
            }
        }
        if (!TRUE.equalsIgnoreCase(attrs.getPm_disabled()) && !TRUE.equalsIgnoreCase(attrs.getPmg_disabled())) {
            tableClass = " dr-pmenu-group rich-pmenu-group";
            iconCellClass = " rich-pmenu-group-self-icon";
            labelCellClass = String.valueOf(labelCellClass) + " rich-pmenu-group-self-label";
            emptyCellClass = String.valueOf(emptyCellClass) + " rich-pmenu-group-self-icon";
            if (ComponentUtil.isNotBlank(attrs.getPmg_iconClass())) {
                iconCellClass = String.valueOf(iconCellClass) + " " + attrs.getPmg_iconClass();
            }
            if (ComponentUtil.isNotBlank(attrs.getPmg_iconStyle())) {
                iconCellStyle = String.valueOf(iconCellStyle) + " " + attrs.getPmg_iconStyle();
            }
            if (childOfPanelMenu) {
                tableClass = " dr-pmenu-top-group rich-pmenu-group";
                iconCellClass = " rich-pmenu-group-self-icon rich-pmenu-top-group-self-icon";
                labelCellClass = " rich-pmenu-top-group-self-label";
                emptyCellClass = " rich-pmenu-top-group-self-icon";
                if (ComponentUtil.isNotBlank(attrs.getPm_topGroupClass())) {
                    tableClass = String.valueOf(tableClass) + " " + attrs.getPm_topGroupClass();
                }
                if (ComponentUtil.isNotBlank(attrs.getPm_topGroupStyle())) {
                    tableStyle = String.valueOf(tableStyle) + attrs.getPm_topGroupStyle();
                }
                if (ComponentUtil.isNotBlank(attrs.getPmg_iconClass())) {
                    iconCellClass = String.valueOf(iconCellClass) + " " + attrs.getPmg_iconClass();
                }
                if (ComponentUtil.isNotBlank(attrs.getPmg_iconStyle())) {
                    iconCellStyle = String.valueOf(iconCellStyle) + " " + attrs.getPmg_iconStyle();
                }
            } else {
                if (ComponentUtil.isNotBlank(attrs.getPm_groupClass())) {
                    tableClass = String.valueOf(tableClass) + " " + attrs.getPm_groupClass();
                }
                if (ComponentUtil.isNotBlank(attrs.getPm_groupStyle())) {
                    tableStyle = String.valueOf(tableStyle) + " " + attrs.getPm_groupStyle();
                }
            }
        }
        if (ComponentUtil.isNotBlank(attrs.getPmg_styleClass())) {
            tableClass = String.valueOf(tableClass) + " " + attrs.getPmg_styleClass();
        }
        if (ComponentUtil.isNotBlank(attrs.getPmg_style())) {
            tableStyle = String.valueOf(tableStyle) + " " + attrs.getPmg_style();
        }
        iconCell.setAttribute("class", iconCellClass);
        for (nsIDOMElement indentTdCell : indentTds) {
            indentTdCell.setAttribute("class", iconCellClass);
        }
        column2.setAttribute("class", labelCellClass);
        emptyCell.setAttribute("class", emptyCellClass);
        div.setAttribute("class", divClass);
        table.setAttribute("class", tableClass);
        table.setAttribute(STYLE, tableStyle);
    }

    private static void setDefaultImgAttributes(nsIDOMElement element) {
        element.setAttribute("width", DEFAULT_SIZE_VALUE);
        element.setAttribute(VSPACE, "0");
        element.setAttribute(HSPACE, "0");
        element.setAttribute("height", DEFAULT_SIZE_VALUE);
    }

    private static final Element getGroupParent(Element sourceElement, boolean findOnlyPanelMenuParent) {
        Element parent = null;
        Element currentElement = sourceElement;
        while (currentElement.getParentNode() != null && currentElement.getParentNode().getNodeType() == 1) {
            currentElement = parent = (Element)currentElement.getParentNode();
            if (!findOnlyPanelMenuParent ? parent != null && parent.getNodeName().endsWith(PANEL_MENU_END_TAG) || parent.getNodeName().endsWith(PANEL_MENU_GROUP_END_TAG) : parent != null && parent.getNodeName().endsWith(PANEL_MENU_END_TAG)) break;
        }
        return parent;
    }

    private void setIcon(VpePageContext pageContext, Node panelMenuParent, Element groupSourceElement, nsIDOMElement imgIcon, boolean expanded, boolean childOfPanelMenu, Attributes attrs) {
        String pathIconExpanded = attrs.getPmg_iconExpanded();
        String pathIconCollapsed = attrs.getPmg_iconCollapsed();
        String pathIconDisabled = attrs.getPmg_iconDisabled();
        if (ComponentUtil.isBlank(pathIconExpanded)) {
            if (childOfPanelMenu) {
                pathIconExpanded = attrs.getPm_iconExpandedTopGroup();
            }
            pathIconExpanded = attrs.getPm_iconExpandedGroup();
        }
        if (ComponentUtil.isBlank(pathIconCollapsed)) {
            if (childOfPanelMenu) {
                pathIconCollapsed = attrs.getPm_iconCollapsedTopGroup();
            }
            pathIconCollapsed = attrs.getPm_iconCollapsedGroup();
        }
        if (ComponentUtil.isBlank(pathIconDisabled)) {
            if (childOfPanelMenu) {
                pathIconDisabled = attrs.getPm_iconTopDisabledGroup();
            }
            pathIconDisabled = attrs.getPm_iconDisabledGroup();
        }
        if (TRUE.equalsIgnoreCase(attrs.getPmg_disabled())) {
            if (ComponentUtil.isNotBlank(pathIconDisabled)) {
                if (DEFAULT_ICON_MAP.containsKey(pathIconDisabled)) {
                    pathIconDisabled = DEFAULT_ICON_MAP.get(pathIconDisabled);
                    ComponentUtil.setImg(imgIcon, pathIconDisabled);
                } else {
                    String imgFullPath = VpeStyleUtil.addFullPathToImgSrc((String)pathIconDisabled, (VpePageContext)pageContext, (boolean)true);
                    imgIcon.setAttribute("src", imgFullPath);
                }
            } else {
                ComponentUtil.setImg(imgIcon, PANEL_MENU_GROUP_ICON_SPACER_PATH);
            }
        } else if (expanded) {
            if (ComponentUtil.isNotBlank(pathIconExpanded)) {
                if (DEFAULT_ICON_MAP.containsKey(pathIconExpanded)) {
                    pathIconExpanded = DEFAULT_ICON_MAP.get(pathIconExpanded);
                    ComponentUtil.setImg(imgIcon, pathIconExpanded);
                } else {
                    String imgFullPath = VpeStyleUtil.addFullPathToImgSrc((String)pathIconExpanded, (VpePageContext)pageContext, (boolean)true);
                    imgIcon.setAttribute("src", imgFullPath);
                }
            } else {
                ComponentUtil.setImg(imgIcon, PANEL_MENU_GROUP_ICON_SPACER_PATH);
            }
        } else if (ComponentUtil.isNotBlank(pathIconCollapsed)) {
            if (DEFAULT_ICON_MAP.containsKey(pathIconCollapsed)) {
                pathIconCollapsed = DEFAULT_ICON_MAP.get(pathIconCollapsed);
                ComponentUtil.setImg(imgIcon, pathIconCollapsed);
            } else {
                String imgFullPath = VpeStyleUtil.addFullPathToImgSrc((String)pathIconCollapsed, (VpePageContext)pageContext, (boolean)true);
                imgIcon.setAttribute("src", imgFullPath);
            }
        } else {
            ComponentUtil.setImg(imgIcon, PANEL_MENU_GROUP_ICON_SPACER_PATH);
        }
    }

    public void toggle(VpeVisualDomBuilder builder, Node sourceNode, String toggleId) {
        Element groupSourceElement = (Element)sourceNode;
        Element panelMenuParent = RichFacesPanelMenuGroupTemplate.getGroupParent(groupSourceElement, true);
        String pmg_disabled = groupSourceElement.getAttribute("disabled");
        String pm_disabled = panelMenuParent.getAttribute("disabled");
        String pm_expandSingle = panelMenuParent.getAttribute("expandSingle");
        if (TRUE.equalsIgnoreCase(pm_disabled) || TRUE.equalsIgnoreCase(pmg_disabled)) {
            return;
        }
        this.expandedIds = (List)sourceNode.getUserData(VPE_EXPANDED_TOGGLE_IDS);
        if (this.expandedIds == null) {
            this.expandedIds = new ArrayList<String>();
        }
        if (TRUE.equalsIgnoreCase(pm_expandSingle)) {
            if (this.expandedIds.contains(toggleId)) {
                this.expandedIds.remove(toggleId);
                Iterator<String> iterator = this.expandedIds.iterator();
                while (iterator.hasNext()) {
                    String id = iterator.next();
                    if (!id.startsWith(toggleId)) continue;
                    iterator.remove();
                }
            } else {
                String[] toggleIds = toggleId.split(GROUP_COUNT_SEPARATOR);
                if (toggleIds != null && toggleIds.length > 0) {
                    Iterator<String> iterator = this.expandedIds.iterator();
                    while (iterator.hasNext()) {
                        String id = iterator.next();
                        String[] ids = id.split(GROUP_COUNT_SEPARATOR);
                        if (ids == null || ids.length <= 0) continue;
                        if (ids.length >= toggleIds.length) {
                            iterator.remove();
                            continue;
                        }
                        int i = 0;
                        while (i < ids.length) {
                            if (!ids[i].equalsIgnoreCase(toggleIds[i])) {
                                iterator.remove();
                            }
                            ++i;
                        }
                    }
                }
                this.expandedIds.add(toggleId);
            }
        } else if (this.expandedIds.contains(toggleId)) {
            this.expandedIds.remove(toggleId);
            Iterator<String> iterator = this.expandedIds.iterator();
            while (iterator.hasNext()) {
                String id = iterator.next();
                if (!id.startsWith(toggleId)) continue;
                iterator.remove();
            }
        } else {
            this.expandedIds.add(toggleId);
        }
        sourceNode.setUserData(VPE_EXPANDED_TOGGLE_IDS, this.expandedIds, null);
        panelMenuParent.setUserData(VPE_EXPANDED_TOGGLE_IDS, this.expandedIds, null);
        builder.updateNode((Node)panelMenuParent);
    }

    public void stopToggling(Node sourceNode) {
        if (this.expandedIds != null) {
            this.expandedIds.clear();
        }
    }

    public boolean recreateAtAttrChange(VpePageContext pageContext, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMElement visualNode, Object data, String name, String value) {
        return true;
    }

    public void setSourceAttributeSelection(VpePageContext pageContext, Element sourceElement, int offset, int length, Object data) {
        VpeSourceDomBuilder sourceBuilder = pageContext.getSourceBuilder();
        sourceBuilder.setSelection((Node)sourceElement, 0, 0);
    }

    class Attributes {
        private String pm_iconGroupPosition;
        private String pm_iconGroupTopPosition;
        private String pm_iconCollapsedGroup;
        private String pm_iconCollapsedTopGroup;
        private String pm_iconExpandedGroup;
        private String pm_iconExpandedTopGroup;
        private String pm_iconDisabledGroup;
        private String pm_iconTopDisabledGroup;
        private String pm_expandSingle;
        private String pm_disabled;
        private String pm_disabledGroupClass;
        private String pm_disabledGroupStyle;
        private String pm_topGroupClass;
        private String pm_topGroupStyle;
        private String pm_groupClass;
        private String pm_groupStyle;
        private String pm_style;
        private String pm_styleClass;
        private String pmg_disabledStyle;
        private String pmg_disabledClass;
        private String pmg_disabled;
        private String pmg_iconClass;
        private String pmg_iconStyle;
        private String pmg_iconExpanded;
        private String pmg_iconCollapsed;
        private String pmg_iconDisabled;
        private String pmg_style;
        private String pmg_styleClass;

        public Attributes(Element panelGroupElement, Element panelMenuElement) {
            this.readPanelMenuGroupAttributes(panelGroupElement);
            this.readPanelMenuAttributes(panelMenuElement);
        }

        private void readPanelMenuAttributes(Element sourceParentElement) {
            if (sourceParentElement == null) {
                return;
            }
            this.pm_iconGroupPosition = sourceParentElement.getAttribute("iconGroupPosition");
            this.pm_iconGroupTopPosition = sourceParentElement.getAttribute("iconGroupTopPosition");
            this.pm_iconCollapsedGroup = sourceParentElement.getAttribute("iconCollapsedGroup");
            this.pm_iconCollapsedTopGroup = sourceParentElement.getAttribute("iconCollapsedTopGroup");
            this.pm_iconExpandedGroup = sourceParentElement.getAttribute("iconExpandedGroup");
            this.pm_iconExpandedTopGroup = sourceParentElement.getAttribute("iconExpandedTopGroup");
            this.pm_iconDisabledGroup = sourceParentElement.getAttribute("iconDisabledGroup");
            this.pm_iconTopDisabledGroup = sourceParentElement.getAttribute("iconTopDisabledGroup");
            this.pm_expandSingle = sourceParentElement.getAttribute("expandSingle");
            this.pm_disabled = sourceParentElement.getAttribute("disabled");
            this.pm_disabledGroupClass = sourceParentElement.getAttribute("disabledGroupClass");
            this.pm_disabledGroupStyle = sourceParentElement.getAttribute("disabledGroupStyle");
            this.pm_topGroupClass = sourceParentElement.getAttribute("topGroupClass");
            this.pm_topGroupStyle = sourceParentElement.getAttribute("topGroupStyle");
            this.pm_groupClass = sourceParentElement.getAttribute("groupClass");
            this.pm_groupStyle = sourceParentElement.getAttribute("groupStyle");
            this.pm_style = sourceParentElement.getAttribute(RichFacesPanelMenuGroupTemplate.STYLE);
            this.pm_styleClass = sourceParentElement.getAttribute(RichFacesPanelMenuGroupTemplate.STYLE_CLASS);
        }

        private void readPanelMenuGroupAttributes(Element sourceElement) {
            if (sourceElement == null) {
                return;
            }
            this.pmg_disabledStyle = sourceElement.getAttribute(RichFacesPanelMenuGroupTemplate.DISABLED_STYLE);
            this.pmg_disabledClass = sourceElement.getAttribute(RichFacesPanelMenuGroupTemplate.DISABLED_CLASS);
            this.pmg_disabled = sourceElement.getAttribute("disabled");
            this.pmg_iconClass = sourceElement.getAttribute(RichFacesPanelMenuGroupTemplate.ICON_CLASS);
            this.pmg_iconStyle = sourceElement.getAttribute(RichFacesPanelMenuGroupTemplate.ICON_STYLE);
            this.pmg_iconExpanded = sourceElement.getAttribute(RichFacesPanelMenuGroupTemplate.ICON_EXPANDED);
            this.pmg_iconCollapsed = sourceElement.getAttribute(RichFacesPanelMenuGroupTemplate.ICON_COLLAPSED);
            this.pmg_iconDisabled = sourceElement.getAttribute(RichFacesPanelMenuGroupTemplate.ICON_DISABLED);
            this.pmg_style = sourceElement.getAttribute(RichFacesPanelMenuGroupTemplate.STYLE);
            this.pmg_styleClass = sourceElement.getAttribute(RichFacesPanelMenuGroupTemplate.STYLE_CLASS);
        }

        public String getPm_iconGroupPosition() {
            return this.pm_iconGroupPosition;
        }

        public String getPm_iconGroupTopPosition() {
            return this.pm_iconGroupTopPosition;
        }

        public String getPm_iconCollapsedGroup() {
            return this.pm_iconCollapsedGroup;
        }

        public String getPm_iconCollapsedTopGroup() {
            return this.pm_iconCollapsedTopGroup;
        }

        public String getPm_iconExpandedGroup() {
            return this.pm_iconExpandedGroup;
        }

        public String getPm_iconExpandedTopGroup() {
            return this.pm_iconExpandedTopGroup;
        }

        public String getPm_iconDisabledGroup() {
            return this.pm_iconDisabledGroup;
        }

        public String getPm_iconTopDisabledGroup() {
            return this.pm_iconTopDisabledGroup;
        }

        public String getPm_expandSingle() {
            return this.pm_expandSingle;
        }

        public String getPm_disabled() {
            return this.pm_disabled;
        }

        public String getPm_disabledGroupClass() {
            return this.pm_disabledGroupClass;
        }

        public String getPm_disabledGroupStyle() {
            return this.pm_disabledGroupStyle;
        }

        public String getPm_topGroupClass() {
            return this.pm_topGroupClass;
        }

        public String getPm_topGroupStyle() {
            return this.pm_topGroupStyle;
        }

        public String getPm_groupClass() {
            return this.pm_groupClass;
        }

        public String getPm_groupStyle() {
            return this.pm_groupStyle;
        }

        public String getPm_style() {
            return this.pm_style;
        }

        public String getPm_styleClass() {
            return this.pm_styleClass;
        }

        public String getPmg_disabledStyle() {
            return this.pmg_disabledStyle;
        }

        public String getPmg_disabledClass() {
            return this.pmg_disabledClass;
        }

        public String getPmg_disabled() {
            return this.pmg_disabled;
        }

        public String getPmg_iconClass() {
            return this.pmg_iconClass;
        }

        public String getPmg_iconStyle() {
            return this.pmg_iconStyle;
        }

        public String getPmg_iconExpanded() {
            return this.pmg_iconExpanded;
        }

        public String getPmg_iconCollapsed() {
            return this.pmg_iconCollapsed;
        }

        public String getPmg_iconDisabled() {
            return this.pmg_iconDisabled;
        }

        public String getPmg_style() {
            return this.pmg_style;
        }

        public String getPmg_styleClass() {
            return this.pmg_styleClass;
        }
    }
}

