/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.richfaces.template;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.tools.jsf.vpe.richfaces.ComponentUtil;
import org.jboss.tools.vpe.editor.VpeVisualDomBuilder;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractTemplate;
import org.jboss.tools.vpe.editor.template.VpeChildrenInfo;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.jboss.tools.vpe.editor.template.VpeToggableTemplate;
import org.jboss.tools.vpe.editor.util.SourceDomUtil;
import org.jboss.tools.vpe.editor.util.VisualDomUtil;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RichFacesSimpleTogglePanelTemplate
extends VpeAbstractTemplate
implements VpeToggableTemplate {
    private static final String CSS_STYLE_PATH = "simpleTogglePanel/simpleTogglePanel.css";
    private static final String COMPONENT_NAME = "richFacesSimpleTogglePanel";
    private static final String ATTR_LABEL = "label";
    private static final String ATTR_BODY_CLASS = "bodyClass";
    private static final String ATTR_OPENED = "opened";
    private static final String OPEN_MARKER_FACET_NAME = "openMarker";
    private static final String CLOSE_MARKER_FACET_NAME = "closeMarker";
    private static final String CSS_DR_STGLPANEL = "dr-stglpnl";
    private static final String CSS_DR_STGLPANEL_HEADER = "dr-stglpnl-h";
    private static final String CSS_DR_STGLPANEL_BODY = "dr-stglpnl-b";
    private static final String CSS_RICH_STGLPANEL = "rich-stglpanel";
    private static final String CSS_RICH_STGLPANEL_HEADER = "rich-stglpanel-header";
    private static final String CSS_RICH_STGLPNL_MARKER = "rich-stglpnl-marker";
    private static final String CSS_RICH_STGLPANEL_BODY = "rich-stglpanel-body";
    private static final String COLLAPSED_STYLE = "; display: none;";
    private static final String SWITCH_DIV_STYLE = "position : absolute; top: 0px; right: 5px;";
    private static Map toggleMap = new HashMap();
    private nsIDOMElement storedHeaderDiv = null;

    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        Element markerFacet;
        Element sourceElement = (Element)sourceNode;
        nsIDOMElement div = visualDocument.createElement("div");
        VpeCreationData creationData = new VpeCreationData((nsIDOMNode)div);
        ComponentUtil.setCSSLink(pageContext, CSS_STYLE_PATH, COMPONENT_NAME);
        div.setAttribute("class", "dr-stglpnl rich-stglpanel " + ComponentUtil.getAttribute(sourceElement, "styleClass"));
        div.setAttribute("style", "width: " + ComponentUtil.getAttribute(sourceElement, "width") + ";" + ComponentUtil.getAttribute(sourceElement, "style"));
        nsIDOMElement headerDiv = visualDocument.createElement("div");
        div.appendChild((nsIDOMNode)headerDiv);
        headerDiv.setAttribute("class", "dr-stglpnl-h rich-stglpanel-header " + ComponentUtil.getAttribute(sourceElement, "headerClass"));
        headerDiv.setAttribute("style", "position : relative; " + ComponentUtil.getHeaderBackgoundImgStyle());
        Map headerFacetChildren = null;
        Element headerFacet = SourceDomUtil.getFacetByName((VpePageContext)pageContext, (Element)sourceElement, (String)"header");
        if (headerFacet != null) {
            headerFacetChildren = VisualDomUtil.findFacetElements((Node)headerFacet, (VpePageContext)pageContext);
            headerDiv.setAttribute("VPE-FACET", "header");
            VpeChildrenInfo headerInfo = new VpeChildrenInfo(headerDiv);
            headerInfo.addSourceChild((Node)headerFacet);
            creationData.addChildrenInfo(headerInfo);
        } else {
            headerDiv.appendChild((nsIDOMNode)visualDocument.createTextNode(ComponentUtil.getAttribute(sourceElement, ATTR_LABEL)));
        }
        nsIDOMElement switchDiv = visualDocument.createElement("div");
        headerDiv.appendChild((nsIDOMNode)switchDiv);
        switchDiv.setAttribute("style", SWITCH_DIV_STYLE);
        String markerName = OPEN_MARKER_FACET_NAME;
        char defaultMarkerCode = '\u00bb';
        boolean opened = this.getActiveState(sourceElement);
        headerDiv.setAttribute("vpe-user-toggle-id", opened ? "false" : "true");
        this.storedHeaderDiv = headerDiv;
        if (opened) {
            markerName = CLOSE_MARKER_FACET_NAME;
            defaultMarkerCode = '\u00ab';
        }
        if ((markerFacet = ComponentUtil.getFacet(sourceElement, markerName)) == null) {
            switchDiv.appendChild((nsIDOMNode)visualDocument.createTextNode("" + defaultMarkerCode));
        } else {
            VpeChildrenInfo switchInfo = new VpeChildrenInfo(switchDiv);
            switchInfo.addSourceChild((Node)markerFacet);
            creationData.addChildrenInfo(switchInfo);
        }
        nsIDOMElement bodyDiv = visualDocument.createElement("div");
        div.appendChild((nsIDOMNode)bodyDiv);
        bodyDiv.setAttribute("style", "overflow: hidden; height: " + ComponentUtil.getAttribute(sourceElement, "height") + "; width: 100%;");
        nsIDOMElement table = visualDocument.createElement("table");
        bodyDiv.appendChild((nsIDOMNode)table);
        table.setAttribute("cellpadding", "0");
        table.setAttribute("style", "width: 100%");
        nsIDOMElement tr = visualDocument.createElement("tr");
        table.appendChild((nsIDOMNode)tr);
        nsIDOMElement td = visualDocument.createElement("td");
        tr.appendChild((nsIDOMNode)td);
        td.setAttribute("class", "dr-stglpnl-b rich-stglpanel-body " + ComponentUtil.getAttribute(sourceElement, ATTR_BODY_CLASS));
        boolean headerHtmlElementsPresents = headerFacetChildren != null && ((List)headerFacetChildren.get(VisualDomUtil.FACET_HTML_TAGS)).size() > 0;
        VpeChildrenInfo bodyInfo = new VpeChildrenInfo(td);
        if (headerHtmlElementsPresents) {
            for (Node node : (List)headerFacetChildren.get(VisualDomUtil.FACET_HTML_TAGS)) {
                bodyInfo.addSourceChild(node);
            }
        }
        List<Node> children = ComponentUtil.getChildren(sourceElement, true);
        for (Node child : children) {
            bodyInfo.addSourceChild(child);
        }
        creationData.addChildrenInfo(bodyInfo);
        if (!opened) {
            String newStyle = bodyDiv.getAttribute("style");
            newStyle = String.valueOf(newStyle) + COLLAPSED_STYLE;
            bodyDiv.setAttribute("style", newStyle);
        }
        return creationData;
    }

    public void validate(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument, VpeCreationData data) {
        super.validate(pageContext, sourceNode, visualDocument, data);
        if (this.storedHeaderDiv == null) {
            return;
        }
        String value = this.storedHeaderDiv.getAttribute("vpe-user-toggle-id");
        if ("true".equals(value) || "false".equals(value)) {
            ComponentUtil.applyAttributeValueOnChildren("vpe-user-toggle-id", value, ComponentUtil.getElementChildren(this.storedHeaderDiv));
            ComponentUtil.applyAttributeValueOnChildren("vpe-user-toggle-lookup-parent", "true", ComponentUtil.getElementChildren(this.storedHeaderDiv));
        }
    }

    private boolean getActiveState(Element sourceElement) {
        String opennedStr = (String)toggleMap.get(sourceElement);
        if (opennedStr == null) {
            opennedStr = ComponentUtil.getAttribute(sourceElement, ATTR_OPENED);
        }
        if (opennedStr == null || "".equals(opennedStr)) {
            opennedStr = "true";
        }
        return !"false".equals(opennedStr);
    }

    public void toggle(VpeVisualDomBuilder builder, Node sourceNode, String toggleId) {
        toggleMap.put(sourceNode, toggleId);
    }

    public void stopToggling(Node sourceNode) {
        toggleMap.remove(sourceNode);
    }

    public boolean recreateAtAttrChange(VpePageContext pageContext, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMElement visualNode, Object data, String name, String value) {
        return true;
    }
}

