/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.richfaces.template;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.jboss.tools.jsf.vpe.richfaces.ComponentUtil;
import org.jboss.tools.jsf.vpe.richfaces.template.RichFaces;
import org.jboss.tools.jsf.vpe.richfaces.template.RichFacesTogglePanelTemplate;
import org.jboss.tools.vpe.editor.VpeVisualDomBuilder;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.mapping.VpeElementMapping;
import org.jboss.tools.vpe.editor.template.VpeAbstractTemplate;
import org.jboss.tools.vpe.editor.template.VpeChildrenInfo;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.jboss.tools.vpe.editor.template.VpeTemplateSafeWrapper;
import org.jboss.tools.vpe.editor.template.VpeToggableTemplate;
import org.jboss.tools.vpe.xulrunner.util.XPCOM;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMText;
import org.mozilla.interfaces.nsISupports;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RichFacesToggleControlTemplate
extends VpeAbstractTemplate
implements VpeToggableTemplate {
    private static Map toggleMap = new HashMap();
    private static nsIDOMElement storedSwitchSpan = null;

    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        nsIDOMElement span;
        Element sourceElement = (Element)sourceNode;
        storedSwitchSpan = span = visualDocument.createElement("span");
        VpeCreationData creationData = new VpeCreationData((nsIDOMNode)span);
        ComponentUtil.correctAttribute(sourceElement, span, "styleClass", "class", "", "");
        ComponentUtil.correctAttribute(sourceElement, span, "style", "style", "color:blue;text-decoration:underline;", "color:blue;text-decoration:underline;");
        String switchToStateAttrName = "switchToState";
        String switchToState = sourceElement.hasAttribute(switchToStateAttrName) ? sourceElement.getAttribute(switchToStateAttrName).trim() : "";
        span.setAttribute("vpe-user-toggle-id", switchToState);
        List<Node> children = ComponentUtil.getChildren(sourceElement);
        VpeChildrenInfo bodyInfo = new VpeChildrenInfo(span);
        String valueAttrName = "value";
        String value = sourceElement.hasAttribute(valueAttrName) ? sourceElement.getAttribute(valueAttrName) : "";
        nsIDOMText valueText = visualDocument.createTextNode(value);
        span.appendChild((nsIDOMNode)valueText);
        for (Node child : children) {
            bodyInfo.addSourceChild(child);
        }
        creationData.addChildrenInfo(bodyInfo);
        return creationData;
    }

    public void validate(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument, VpeCreationData data) {
        super.validate(pageContext, sourceNode, visualDocument, data);
        if (storedSwitchSpan == null) {
            return;
        }
        String vpeToogleAttrName = "vpe-user-toggle-id";
        if (storedSwitchSpan.hasAttribute(vpeToogleAttrName)) {
            String value = storedSwitchSpan.getAttribute(vpeToogleAttrName);
            this.applyAttributeValueOnChildren("vpe-user-toggle-id", value, ComponentUtil.getChildren(storedSwitchSpan));
        }
        this.applyAttributeValueOnChildren("vpe-user-toggle-lookup-parent", "true", ComponentUtil.getChildren(storedSwitchSpan));
    }

    private void applyAttributeValueOnChildren(String attrName, String attrValue, List<nsIDOMNode> children) {
        if (children == null || attrName == null || attrValue == null) {
            return;
        }
        for (nsIDOMNode child : children) {
            if (!(child instanceof nsIDOMElement)) continue;
            nsIDOMElement childElement = (nsIDOMElement)XPCOM.queryInterface((nsISupports)child, nsIDOMElement.class);
            childElement.setAttribute(attrName, attrValue);
            this.applyAttributeValueOnChildren(attrName, attrValue, ComponentUtil.getChildren(childElement));
        }
    }

    public void toggle(VpeVisualDomBuilder builder, Node sourceNode, String toggleId) {
        toggleMap.put(sourceNode, toggleId);
        Element sourceElement = (Element)(sourceNode instanceof Element ? sourceNode : sourceNode.getParentNode());
        if (!sourceElement.hasAttribute("for")) {
            return;
        }
        String forIds = sourceElement.getAttribute("for");
        StringTokenizer st = new StringTokenizer(forIds.trim(), ",", false);
        while (st.hasMoreElements()) {
            String id = st.nextToken().trim();
            if (id == null) continue;
            id = id.trim();
            List<Element> sourceElements = RichFaces.findElementsById(sourceElement.getOwnerDocument().getDocumentElement(), id, ":togglePanel");
            for (Element el : sourceElements) {
                RichFacesTogglePanelTemplate tpTemplate;
                VpeElementMapping elementMapping;
                if (builder == null || (elementMapping = (VpeElementMapping)builder.getDomMapping().getNodeMapping((Node)el)) == null || (tpTemplate = (RichFacesTogglePanelTemplate)((Object)((VpeTemplateSafeWrapper)elementMapping.getTemplate()).getAdapter(RichFacesTogglePanelTemplate.class))) == null) continue;
                tpTemplate.toggle(el, toggleId);
                builder.updateNode((Node)el);
            }
        }
    }

    public void stopToggling(Node sourceNode) {
        toggleMap.remove(sourceNode);
    }
}

