/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.richfaces.template;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.jboss.tools.jsf.vpe.richfaces.ComponentUtil;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractTemplate;
import org.jboss.tools.vpe.editor.template.VpeChildrenInfo;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RichFacesTogglePanelTemplate
extends VpeAbstractTemplate {
    private static Map toggleMap = new HashMap();
    private Map states = null;

    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        Element sourceElement = (Element)sourceNode;
        nsIDOMElement div = visualDocument.createElement("div");
        VpeCreationData creationData = new VpeCreationData((nsIDOMNode)div);
        this.states = this.getStates(sourceElement);
        String state = this.getActiveState(sourceElement);
        Node bodyFacet = null;
        if (state != null) {
            bodyFacet = ComponentUtil.getFacet(sourceElement, state, true);
        } else {
            ArrayList<Node> facets = ComponentUtil.getFacets(sourceElement, true);
            if (!facets.isEmpty()) {
                bodyFacet = facets.get(0);
            }
        }
        if (bodyFacet != null) {
            VpeChildrenInfo bodyInfo = new VpeChildrenInfo(div);
            bodyInfo.addSourceChild(bodyFacet);
            creationData.addChildrenInfo(bodyInfo);
        }
        return creationData;
    }

    private Map getStates(Element sourceElement) {
        NodeList children = sourceElement.getChildNodes();
        HashMap<String, Element> states = new HashMap<String, Element>();
        int i = 0;
        while (children != null && i < children.getLength()) {
            Element facet;
            Node child = children.item(i);
            if (child instanceof Element && child.getNodeName().endsWith(":facet") && (facet = (Element)child).hasAttribute("name")) {
                String name = facet.getAttribute("name");
                states.put(name, facet);
            }
            ++i;
        }
        return states;
    }

    private String getInitialState(Element sourceElement) {
        String initialState;
        String string = initialState = sourceElement.hasAttribute("initialState") ? sourceElement.getAttribute("initialState") : null;
        if (sourceElement.hasAttribute("stateOrder")) {
            String stateOrder = sourceElement.getAttribute("stateOrder");
            StringTokenizer st = new StringTokenizer(stateOrder.trim(), ",", false);
            String firstState = null;
            while (st.hasMoreElements()) {
                String state = st.nextToken().trim();
                if (firstState == null) {
                    firstState = state;
                }
                if (initialState != null) {
                    if (!initialState.equals(state) || this.states == null || !this.states.containsKey(state)) continue;
                    return initialState;
                }
                if (this.states == null || !this.states.containsKey(state)) continue;
                return state;
            }
        } else if (initialState != null && this.states != null && this.states.containsKey(initialState)) {
            return initialState;
        }
        return this.states == null || this.states.keySet().isEmpty() ? null : (String)this.states.keySet().iterator().next();
    }

    private String getActiveState(Element sourceElement) {
        if (!sourceElement.hasAttribute("stateOrder")) {
            return null;
        }
        String activeStateStr = (String)toggleMap.get(sourceElement);
        if (activeStateStr == null) {
            activeStateStr = this.getInitialState(sourceElement);
        }
        return activeStateStr;
    }

    private String getNextState(Element sourceElement, String toggleId) {
        if (!sourceElement.hasAttribute("stateOrder")) {
            return null;
        }
        String stateOrder = sourceElement.getAttribute("stateOrder");
        String activeState = this.getActiveState(sourceElement);
        StringTokenizer st = new StringTokenizer(stateOrder.trim(), ",", false);
        String firstState = null;
        while (st.hasMoreElements()) {
            String state = st.nextToken();
            if (firstState == null) {
                firstState = state;
            }
            if (toggleId != null && toggleId.trim().length() != 0) {
                if (!toggleId.equals(state)) continue;
                return state;
            }
            if (activeState != null && activeState.equals(state)) break;
        }
        String newActiveState = null;
        if (st.hasMoreElements()) {
            newActiveState = st.nextToken();
        }
        if (newActiveState == null || newActiveState.trim().length() == 0) {
            newActiveState = firstState;
        }
        return newActiveState;
    }

    public void toggle(Node sourceNode, String toggleId) {
        Element sourceElement = (Element)(sourceNode instanceof Element ? sourceNode : sourceNode.getParentNode());
        if ((toggleId = toggleId == null || toggleId.trim().length() == 0 ? this.getNextState(sourceElement, null) : this.getNextState(sourceElement, toggleId)) == null) {
            return;
        }
        toggleMap.put(sourceNode, toggleId);
    }

    public void stopToggling(Node sourceNode) {
        toggleMap.remove(sourceNode);
    }
}

