/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.richfaces.template;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jboss.tools.jsf.vpe.richfaces.ComponentUtil;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractTemplate;
import org.jboss.tools.vpe.editor.template.VpeChildrenInfo;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMText;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RichFacesToolBarTemplate
extends VpeAbstractTemplate {
    public static final String TAG_NAME = "toolBar";
    public static final String ITEM_SEPARATOR_NONE = "none";
    public static final String ITEM_SEPARATOR_LINE = "line";
    public static final String ITEM_SEPARATOR_GRID = "grid";
    public static final String ITEM_SEPARATOR_DISC = "disc";
    public static final String ITEM_SEPARATOR_SQUARE = "square";
    public static final String ITEM_SEPARATOR_LINE_URL = "toolBar/separatorLine.gif";
    public static final String ITEM_SEPARATOR_GRID_URL = "toolBar/separatorGrid.gif";
    public static final String ITEM_SEPARATOR_DISC_URL = "toolBar/separatorDisc.gif";
    public static final String ITEM_SEPARATOR_SQUARE_URL = "toolBar/separatorSquare.gif";
    public static final String EXCEPTION_ATTR_STYLE_VALUE = "color: red; font-weight:bold;";
    static final String CONTENTCLASS_ATTR_NAME = "contentClass";
    static final String CONTENTSTYLE_ATTR_NAME = "contentStyle";
    static final String STYLEATTR_CLASS_NAME = "styleClass";
    static final String ATTR_STYLE_NAME = "style";
    static final String ITEMSEPARATOR_ATTR_NAME = "itemSeparator";
    static final String SEPARATORCLASS_ATTR_NAME = "separatorClass";
    static final String WIDTH_ATTR_NAME = "width";
    static final String HEIGHT_ATTR_NAME = "height";
    private static final String CSS_DR_TOOLBAR_INT = "dr-toolbar-int";
    private static final String CSS_DR_TOOLBAR_EXT = "dr-toolbar-ext";
    private static final String CSS_RICH_TOOLBAR = "rich-toolbar";
    private static final String CSS_RICH_TOOLBAR_ITEM = "rich-toolbar-item";
    private static final String SPACE = " ";

    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        nsIDOMElement separatorImage;
        VpeChildrenInfo childrenInfo;
        SourceToolBarItem toolBarItem;
        nsIDOMElement visualNode = visualDocument.createElement("table");
        VpeCreationData creationData = new VpeCreationData((nsIDOMNode)visualNode);
        Element sourceElement = (Element)sourceNode;
        String itemSeparator = sourceElement.getAttribute(ITEMSEPARATOR_ATTR_NAME);
        itemSeparator = RichFacesToolBarTemplate.checkAndUpdateItemSeparatorName(itemSeparator);
        SourceToolBarItems sourceToolBarItems = new SourceToolBarItems(sourceNode, itemSeparator);
        String itemSeparatorImageUrl = RichFacesToolBarTemplate.getSeparatorImageUrlString(sourceToolBarItems.getItemSeparator());
        ComponentUtil.setCSSLink(pageContext, "toolBar/toolBar.css", "richFacesToolBar");
        ComponentUtil.correctAttribute(sourceElement, visualNode, WIDTH_ATTR_NAME, WIDTH_ATTR_NAME, null, "100%");
        ComponentUtil.correctAttribute(sourceElement, visualNode, HEIGHT_ATTR_NAME, HEIGHT_ATTR_NAME, null, null);
        ComponentUtil.correctAttribute(sourceElement, visualNode, STYLEATTR_CLASS_NAME, "class", "dr-toolbar-ext rich-toolbar", "dr-toolbar-ext rich-toolbar");
        String style = String.valueOf(ComponentUtil.getHeaderBackgoundImgStyle()) + ";";
        ComponentUtil.correctAttribute(sourceElement, visualNode, ATTR_STYLE_NAME, ATTR_STYLE_NAME, style, style);
        nsIDOMElement body = null;
        nsIDOMElement row = null;
        nsIDOMElement cell = null;
        body = visualDocument.createElement("tbody");
        row = visualDocument.createElement("tr");
        row.setAttribute("valign", "middle");
        Iterator<SourceToolBarItem> iterator = sourceToolBarItems.getLeftItemsIterator();
        while (iterator.hasNext()) {
            toolBarItem = iterator.next();
            cell = visualDocument.createElement("td");
            if (toolBarItem.isItem()) {
                ComponentUtil.correctAttribute(sourceElement, cell, CONTENTCLASS_ATTR_NAME, "class", "dr-toolbar-int rich-toolbar-item", "dr-toolbar-int rich-toolbar-item");
                ComponentUtil.correctAttribute(sourceElement, cell, CONTENTSTYLE_ATTR_NAME, ATTR_STYLE_NAME, toolBarItem.isToolBarGroupItem() ? "padding: 0px 0px 0px 0px;" : null, toolBarItem.isToolBarGroupItem() ? "padding: 0px 0px 0px 0px;" : null);
                childrenInfo = new VpeChildrenInfo(cell);
                creationData.addChildrenInfo(childrenInfo);
                childrenInfo.addSourceChild(toolBarItem.getToolBarItem());
            } else if (itemSeparatorImageUrl != null) {
                cell = visualDocument.createElement("td");
                cell.setAttribute("align", "center");
                ComponentUtil.correctAttribute(sourceElement, cell, SEPARATORCLASS_ATTR_NAME, "class", null, null);
                separatorImage = visualDocument.createElement("img");
                ComponentUtil.setImg(separatorImage, itemSeparatorImageUrl);
                cell.appendChild((nsIDOMNode)separatorImage);
            }
            row.appendChild((nsIDOMNode)cell);
        }
        cell = visualDocument.createElement("td");
        cell.setAttribute(WIDTH_ATTR_NAME, "100%");
        row.appendChild((nsIDOMNode)cell);
        iterator = sourceToolBarItems.getRightItemsIterator();
        while (iterator.hasNext()) {
            toolBarItem = iterator.next();
            cell = visualDocument.createElement("td");
            if (toolBarItem.isItem()) {
                ComponentUtil.correctAttribute(sourceElement, cell, CONTENTCLASS_ATTR_NAME, "class", "dr-toolbar-int rich-toolbar-item", "dr-toolbar-int rich-toolbar-item");
                ComponentUtil.correctAttribute(sourceElement, cell, CONTENTSTYLE_ATTR_NAME, ATTR_STYLE_NAME, toolBarItem.isToolBarGroupItem() ? "padding: 0px;" : null, toolBarItem.isToolBarGroupItem() ? "padding: 0px;" : null);
                childrenInfo = new VpeChildrenInfo(cell);
                creationData.addChildrenInfo(childrenInfo);
                childrenInfo.addSourceChild(toolBarItem.getToolBarItem());
            } else if (itemSeparatorImageUrl != null) {
                cell = visualDocument.createElement("td");
                cell.setAttribute("align", "center");
                ComponentUtil.correctAttribute(sourceElement, cell, SEPARATORCLASS_ATTR_NAME, "class", null, null);
                separatorImage = visualDocument.createElement("img");
                ComponentUtil.setImg(separatorImage, itemSeparatorImageUrl);
                cell.appendChild((nsIDOMNode)separatorImage);
            }
            row.appendChild((nsIDOMNode)cell);
        }
        body.appendChild((nsIDOMNode)row);
        visualNode.appendChild((nsIDOMNode)body);
        return creationData;
    }

    static nsIDOMElement createExceptionNode(nsIDOMDocument visualDocument, String message) {
        nsIDOMElement visualNode = visualDocument.createElement("span");
        visualNode.setAttribute(ATTR_STYLE_NAME, EXCEPTION_ATTR_STYLE_VALUE);
        nsIDOMText text = visualDocument.createTextNode(message);
        visualNode.appendChild((nsIDOMNode)text);
        return visualNode;
    }

    public static String getSeparatorImageUrlString(String itemSeparator) {
        String separatorImageUrl = null;
        if (ITEM_SEPARATOR_DISC.equals(itemSeparator)) {
            separatorImageUrl = ITEM_SEPARATOR_DISC_URL;
        } else if (ITEM_SEPARATOR_GRID.equals(itemSeparator)) {
            separatorImageUrl = ITEM_SEPARATOR_GRID_URL;
        } else if (ITEM_SEPARATOR_LINE.equals(itemSeparator)) {
            separatorImageUrl = ITEM_SEPARATOR_LINE_URL;
        } else if (ITEM_SEPARATOR_SQUARE.equals(itemSeparator)) {
            separatorImageUrl = ITEM_SEPARATOR_SQUARE_URL;
        }
        return separatorImageUrl;
    }

    static String checkAndUpdateItemSeparatorName(String itemSeparator) {
        if (itemSeparator == null || itemSeparator != null && itemSeparator.length() == 0) {
            return ITEM_SEPARATOR_NONE;
        }
        if (ITEM_SEPARATOR_DISC.equals(itemSeparator) || ITEM_SEPARATOR_LINE.equals(itemSeparator) || ITEM_SEPARATOR_GRID.equals(itemSeparator) || ITEM_SEPARATOR_SQUARE.equals(itemSeparator) || ITEM_SEPARATOR_NONE.equals(itemSeparator)) {
            return itemSeparator;
        }
        return ITEM_SEPARATOR_NONE;
    }

    private class SourceToolBarItem {
        private Node toolBarItem;
        private String itemSeparator;
        private boolean isToolBarItemLocationRight;
        private boolean isToolBarGroupItem;

        public SourceToolBarItem(Node toolBarItem) {
            this.toolBarItem = toolBarItem;
            this.itemSeparator = null;
            this.isToolBarItemLocationRight = false;
            if (toolBarItem.getNodeType() == 1) {
                Element element = (Element)toolBarItem;
                this.isToolBarGroupItem = element.getNodeName().endsWith(":toolBarGroup");
                if (this.isToolBarGroupItem()) {
                    this.isToolBarItemLocationRight = "right".equals(element.getAttribute("location"));
                }
            }
        }

        public SourceToolBarItem(String itemSeparator) {
            this.toolBarItem = null;
            this.itemSeparator = itemSeparator;
        }

        public Node getToolBarItem() {
            return this.toolBarItem;
        }

        public String getItemSeparator() {
            return this.itemSeparator;
        }

        public boolean isItem() {
            return this.toolBarItem != null;
        }

        public boolean isToolBarItemLocationRight() {
            return this.isToolBarItemLocationRight;
        }

        public boolean isToolBarGroupItem() {
            return this.isToolBarGroupItem;
        }
    }

    private class SourceToolBarItems {
        private List<SourceToolBarItem> leftToolBarItems = new LinkedList<SourceToolBarItem>();
        private List<SourceToolBarItem> rightToolBarItems = new LinkedList<SourceToolBarItem>();
        private String itemSeparator;
        private boolean itemSeparatorExists;

        public SourceToolBarItems(Node sourceNode, String itemSeparator) {
            this.itemSeparator = itemSeparator;
            this.itemSeparatorExists = itemSeparator != null && itemSeparator.length() != 0 && !RichFacesToolBarTemplate.ITEMSEPARATOR_ATTR_NAME.equals(itemSeparator);
            this.init(sourceNode);
        }

        private void init(Node sourceNode) {
            NodeList childrenList = sourceNode.getChildNodes();
            int childrenCount = childrenList.getLength();
            int i = 0;
            while (i < childrenCount) {
                Node child = childrenList.item(i);
                if (this.isVisibleNode(child)) {
                    SourceToolBarItem toolBarItem = new SourceToolBarItem(child);
                    if (toolBarItem.isToolBarItemLocationRight()) {
                        if (this.isItemSeparatorExists()) {
                            this.rightToolBarItems.add(new SourceToolBarItem(this.itemSeparator));
                        }
                        this.rightToolBarItems.add(toolBarItem);
                    } else {
                        this.leftToolBarItems.add(toolBarItem);
                        if (this.isItemSeparatorExists()) {
                            this.leftToolBarItems.add(new SourceToolBarItem(this.itemSeparator));
                        }
                    }
                }
                ++i;
            }
            if (this.isItemSeparatorExists() && !this.leftToolBarItems.isEmpty()) {
                this.leftToolBarItems.remove(this.leftToolBarItems.size() - 1);
            }
            if (this.isItemSeparatorExists() && !this.rightToolBarItems.isEmpty()) {
                this.rightToolBarItems.remove(0);
            }
        }

        public Iterator<SourceToolBarItem> getLeftItemsIterator() {
            return this.leftToolBarItems.iterator();
        }

        public Iterator<SourceToolBarItem> getRightItemsIterator() {
            return this.rightToolBarItems.iterator();
        }

        private boolean isVisibleNode(Node node) {
            return node.getNodeType() == 1 || node.getNodeType() == 3 && node.getNodeValue() != null && node.getNodeValue().trim().length() > 0;
        }

        public boolean isItemSeparatorExists() {
            return this.itemSeparatorExists;
        }

        public String getItemSeparator() {
            return this.itemSeparator;
        }
    }
}

