/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.richfaces.template;

import org.jboss.tools.jsf.vpe.richfaces.ComponentUtil;
import org.jboss.tools.jsf.vpe.richfaces.template.RichFacesAbstractTreeTemplate;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeChildrenInfo;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.jboss.tools.vpe.xulrunner.util.XPCOM;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMNodeList;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.xpcom.XPCOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RichFacesTreeTemplate
extends RichFacesAbstractTreeTemplate {
    private static final String STYLE_PATH = "/tree/tree.css";
    private static final String ICON_ATTR = "icon";
    private static final String TREE_STYLE_CLASS_ATR_NAME = "styleClass";
    private static final String ICON_COLLAPSED_ATTR_NAME = "iconExpanded";

    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        ComponentUtil.setCSSLink(pageContext, STYLE_PATH, "tree");
        nsIDOMElement visualElement = visualDocument.createElement("div");
        Element sourceElement = (Element)sourceNode;
        if (sourceElement.hasAttribute("style")) {
            String style = sourceElement.getAttribute("style");
            visualElement.setAttribute("style", style);
        }
        if (sourceElement.hasAttribute("class")) {
            String styleClass = sourceElement.getAttribute("class");
            visualElement.setAttribute("class", styleClass);
        }
        VpeCreationData vpeCreationData = new VpeCreationData((nsIDOMNode)visualElement);
        vpeCreationData.addChildrenInfo(new VpeChildrenInfo(null));
        this.parseTree(pageContext, sourceNode, visualDocument, vpeCreationData, visualElement);
        this.setStylesAttributesToTree(visualElement, (Element)sourceNode);
        return vpeCreationData;
    }

    private void setStylesAttributesToTree(nsIDOMElement treeTable, Element sourceNode) {
        if (sourceNode.hasAttribute("style")) {
            String styleAttr = sourceNode.getAttribute("style");
            this.setAttributeToTree((nsIDOMNode)treeTable, "style", this.removeFromStyleWithAndHeight(styleAttr));
            treeTable.setAttribute("style", styleAttr);
        }
        if (sourceNode.hasAttribute(TREE_STYLE_CLASS_ATR_NAME)) {
            String styleClassAttr = sourceNode.getAttribute(TREE_STYLE_CLASS_ATR_NAME);
            this.setAttributeToTree((nsIDOMNode)treeTable, "class", styleClassAttr);
        }
    }

    private String removeFromStyleWithAndHeight(String styleArgs) {
        String[] mas;
        StringBuffer result = new StringBuffer();
        String[] stringArray = mas = styleArgs.split(";");
        int n = mas.length;
        int n2 = 0;
        while (n2 < n) {
            String styleAttr = stringArray[n2];
            if (styleAttr.indexOf("width") == -1 && styleAttr.indexOf("height") == -1) {
                result.append(String.valueOf(styleAttr) + ";");
            }
            ++n2;
        }
        return result.toString();
    }

    private void setAttributeToTree(nsIDOMNode node, String attrName, String attrValue) {
        try {
            nsIDOMElement element = (nsIDOMElement)XPCOM.queryInterface((nsISupports)node, nsIDOMElement.class);
            if (node.getNodeName().equalsIgnoreCase("table")) {
                element.setAttribute(attrName, attrValue);
            }
            nsIDOMNodeList list2 = node.getChildNodes();
            int i = 0;
            while ((long)i < list2.getLength()) {
                this.setAttributeToTree(list2.item((long)i), attrName, attrValue);
                ++i;
            }
        }
        catch (XPCOMException xPCOMException) {
            return;
        }
    }

    public void validate(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument, VpeCreationData data) {
        super.validate(pageContext, sourceNode, visualDocument, data);
        this.revertTableRows(data.getNode());
    }

    private void revertTableRows(nsIDOMNode node) {
        try {
            String id;
            nsIDOMNodeList list = node.getChildNodes();
            nsIDOMElement element = (nsIDOMElement)XPCOM.queryInterface((nsISupports)node, nsIDOMElement.class);
            String string = id = element.hasAttribute("ID") ? element.getAttribute("ID") : "";
            if (!(!node.getNodeName().equalsIgnoreCase("div") || list.getLength() != 2L || id.equalsIgnoreCase("treeNodesAdaptor") || id.equalsIgnoreCase("treeModelAdaptor") || id.equalsIgnoreCase("treeModelRecursiveAdaptor") || id.equalsIgnoreCase("recursiveTreeNodesAdaptor"))) {
                nsIDOMNode table1 = list.item(0L);
                nsIDOMNode table2 = list.item(1L);
                node.removeChild(table1);
                node.removeChild(table2);
                node.appendChild(table2);
                node.appendChild(table1);
            }
            nsIDOMNodeList list2 = node.getChildNodes();
            int i = 0;
            while ((long)i < list2.getLength()) {
                this.revertTableRows(list2.item((long)i));
                ++i;
            }
        }
        catch (XPCOMException xPCOMException) {
            return;
        }
    }

    @Override
    public void parseTree(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument, VpeCreationData vpeCreationData, nsIDOMElement parentDiv) {
        NodeList nodeList = sourceNode.getChildNodes();
        Element element = null;
        nsIDOMElement div = null;
        Object childTree = null;
        nsIDOMElement childLast = null;
        int lenght = nodeList.getLength();
        VpeChildrenInfo vpeChildrenInfo = null;
        int i = 0;
        while (i < lenght) {
            if (nodeList.item(i) instanceof Element) {
                element = (Element)nodeList.item(i);
                childTree = null;
                if (element.getNodeName().endsWith(":treeNode") || element.getNodeName().endsWith(":treeNodesAdaptor") || element.getNodeName().endsWith(":recursiveTreeNodesAdaptor") || element.getNodeName().endsWith(":treeModelAdaptor") || element.getNodeName().endsWith(":treeModelRecursiveAdaptor")) {
                    if (div == null) {
                        vpeChildrenInfo = new VpeChildrenInfo(parentDiv);
                        vpeCreationData.addChildrenInfo(vpeChildrenInfo);
                        vpeChildrenInfo.addSourceChild((Node)element);
                        div = this.createBasicTree(visualDocument);
                        childLast = parentDiv;
                    } else if (childTree == null) {
                        vpeChildrenInfo = new VpeChildrenInfo(div);
                        vpeCreationData.addChildrenInfo(vpeChildrenInfo);
                        vpeChildrenInfo.addSourceChild((Node)element);
                        childLast.appendChild((nsIDOMNode)div);
                        childLast = div;
                        div = this.createBasicTree(visualDocument);
                    }
                }
            }
            ++i;
        }
    }

    public boolean recreateAtAttrChange(VpePageContext pageContext, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMElement visualNode, Object data, String name, String value) {
        return ICON_COLLAPSED_ATTR_NAME.equals(name) || "showConnectingLines".equals(name) || ICON_ATTR.equals(name) || "iconLeaf".equals(name);
    }

    public void setAttribute(VpePageContext pageContext, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMNode visualNode, Object data, String name, String value) {
        if (TREE_STYLE_CLASS_ATR_NAME.equalsIgnoreCase(name)) {
            this.setAttributeToTree(visualNode, "class", value);
        } else if ("style".equalsIgnoreCase(name)) {
            this.setAttributeToTree(visualNode, "style", this.removeFromStyleWithAndHeight(value));
            nsIDOMElement visualElement = (nsIDOMElement)XPCOM.queryInterface((nsISupports)visualNode, nsIDOMElement.class);
            visualElement.setAttribute("style", value);
        }
    }

    public void removeAttribute(VpePageContext pageContext, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMNode visualNode, Object data, String name) {
        if (TREE_STYLE_CLASS_ATR_NAME.equalsIgnoreCase(name)) {
            this.setAttributeToTree(visualNode, "class", "");
        } else if ("style".equalsIgnoreCase(name)) {
            this.setAttributeToTree(visualNode, "style", "");
        }
    }

    private nsIDOMElement createBasicTree(nsIDOMDocument visualDocument) {
        nsIDOMElement div = visualDocument.createElement("div");
        div.setAttribute("class", "dr-tree-h-ic-div");
        return div;
    }
}

