/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.ui.wizard;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.participants.ProcessorBasedRefactoring;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SearchPattern;
import org.jboss.tools.cdi.core.CDIImages;
import org.jboss.tools.cdi.core.IBean;
import org.jboss.tools.cdi.core.ICDIElement;
import org.jboss.tools.cdi.core.IQualifier;
import org.jboss.tools.cdi.internal.core.refactoring.ValuedQualifier;
import org.jboss.tools.cdi.ui.CDIUIMessages;
import org.jboss.tools.cdi.ui.wizard.AbstractModifyInjectionPointWizard;
import org.jboss.tools.cdi.ui.wizard.AddQualifiersToBeanWizardPage;
import org.jboss.tools.common.model.ui.ModelUIImages;

public class SelectBeanWizard
extends AbstractModifyInjectionPointWizard {
    private SelectBeanWizardPage selectBeanPage;
    private AddQualifiersToBeanWizardPage addQualifiersPage;
    private Text pattern;

    public SelectBeanWizard(ProcessorBasedRefactoring refactoring) {
        super(refactoring);
        this.setWindowTitle(CDIUIMessages.SELECT_BEAN_WIZARD_TITLE);
        this.setDefaultPageImageDescriptor(ModelUIImages.getImageDescriptor((String)ModelUIImages.WIZARD_DEFAULT));
    }

    public void addUserInputPages() {
        this.selectBeanPage = new SelectBeanWizardPage("");
        this.addPage((IWizardPage)this.selectBeanPage);
        this.addQualifiersPage = new AddQualifiersToBeanWizardPage("");
        this.addPage((IWizardPage)this.addQualifiersPage);
    }

    public List<ValuedQualifier> getDeployedQualifiers() {
        return this.addQualifiersPage.getDeployedQualifiers();
    }

    public List<IQualifier> getAvailableQualifiers() {
        return this.addQualifiersPage.getAvailableQualifiers();
    }

    public void init() {
        this.addQualifiersPage.init();
    }

    public void deploy(ValuedQualifier qualifier) {
        this.addQualifiersPage.deploy(qualifier);
    }

    public boolean checkBeans() {
        return this.addQualifiersPage.checkBeans();
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        this.selectBeanPage.setDefaultSelection();
    }

    public class BeanFilter
    extends ViewerFilter {
        SearchPattern patternMatcher = new SearchPattern();

        public boolean isConsistentItem(Object item) {
            return true;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IBean) {
                int lastIndex;
                String pattern;
                String beanTypeName = ((IBean)element).getBeanClass().getFullyQualifiedName();
                if (SelectBeanWizard.this.pattern.getText().isEmpty()) {
                    this.patternMatcher.setPattern("*");
                } else {
                    this.patternMatcher.setPattern(SelectBeanWizard.this.pattern.getText());
                }
                boolean result = this.patternMatcher.matches(beanTypeName);
                if (!result && (pattern = this.patternMatcher.getPattern()).indexOf(".") < 0 && (lastIndex = beanTypeName.lastIndexOf(".")) >= 0 && lastIndex + 1 < beanTypeName.length()) {
                    return this.patternMatcher.matches(beanTypeName.substring(lastIndex + 1));
                }
                return result;
            }
            return false;
        }
    }

    class BeanListContentProvider
    implements IStructuredContentProvider {
        BeanListContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof ArrayList) {
                return ((ArrayList)inputElement).toArray();
            }
            return new Object[0];
        }
    }

    class BeanListLabelProvider
    implements ILabelProvider {
        BeanListLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getImage(Object element) {
            if (element instanceof IBean) {
                return CDIImages.getImageByElement((ICDIElement)((IBean)element));
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof IBean) {
                IBean bean = (IBean)element;
                String beanTypeName = bean.getBeanClass().getFullyQualifiedName();
                String beanPackage = beanTypeName.substring(0, beanTypeName.lastIndexOf("."));
                String name = bean.getElementName();
                return String.valueOf(name) + " - " + beanPackage;
            }
            return "";
        }
    }

    class SelectBeanWizardPage
    extends UserInputWizardPage {
        TableViewer tableViewer;

        protected SelectBeanWizardPage(String pageName) {
            super(pageName);
            this.setTitle(CDIUIMessages.SELECT_BEAN_TITLE);
            this.setPageComplete(false);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.horizontalSpacing = 4;
            layout.verticalSpacing = 10;
            layout.numColumns = 1;
            composite.setLayout((Layout)layout);
            composite.setFont(composite.getParent().getFont());
            Label label = new Label(composite, 0);
            label.setText(CDIUIMessages.SELECT_BEAN_WIZARD_ENTER_BEAN_NAME);
            SelectBeanWizard.this.pattern = new Text(composite, 2048);
            GridData data = new GridData(768);
            SelectBeanWizard.this.pattern.setLayoutData((Object)data);
            SelectBeanWizard.this.pattern.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SelectBeanWizardPage.this.tableViewer.refresh();
                }
            });
            label = new Label(composite, 0);
            label.setText(CDIUIMessages.SELECT_BEAN_WIZARD_SELECT_BEAN);
            Table availableList = new Table(composite, 2816);
            data = new GridData(1808);
            data.heightHint = 200;
            data.widthHint = 150;
            availableList.setLayoutData((Object)data);
            this.tableViewer = new TableViewer(availableList);
            final BeanListLabelProvider labelProvider = new BeanListLabelProvider();
            this.tableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
            BeanListContentProvider contentProvider = new BeanListContentProvider();
            this.tableViewer.setContentProvider((IContentProvider)contentProvider);
            this.tableViewer.setComparator(new ViewerComparator(){

                public int compare(Viewer viewer, Object o1, Object o2) {
                    if (o1 instanceof IBean && o2 instanceof IBean) {
                        IBean b1 = (IBean)o1;
                        IBean b2 = (IBean)o2;
                        return labelProvider.getText((Object)b1).compareToIgnoreCase(labelProvider.getText((Object)b2));
                    }
                    return super.compare(viewer, o1, o2);
                }
            });
            this.tableViewer.setInput(SelectBeanWizard.this.getBeans());
            this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IBean bean = SelectBeanWizardPage.this.getSelection();
                    if (bean != null) {
                        SelectBeanWizard.this.setSelectedBean(bean);
                        SelectBeanWizard.this.addQualifiersPage.init();
                        SelectBeanWizard.this.addQualifiersPage.setDeployedQualifiers(SelectBeanWizard.this.addQualifiersPage.getDeployedQualifiers());
                        SelectBeanWizardPage.this.setPageComplete(true);
                    } else {
                        SelectBeanWizardPage.this.setPageComplete(false);
                    }
                }
            });
            this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                }
            });
            this.tableViewer.addFilter((ViewerFilter)new BeanFilter());
            this.setControl((Control)composite);
        }

        public void setDefaultSelection() {
            if (SelectBeanWizard.this.getBeans().size() > 0) {
                IBean defaultBean = (IBean)this.tableViewer.getTable().getItem(0).getData();
                this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)defaultBean));
                this.tableViewer.getTable().select(0);
                SelectBeanWizard.this.setSelectedBean(defaultBean);
                SelectBeanWizard.this.addQualifiersPage.init();
                SelectBeanWizard.this.addQualifiersPage.setDeployedQualifiers(SelectBeanWizard.this.addQualifiersPage.getDeployedQualifiers());
                this.setPageComplete(true);
            }
        }

        protected IBean getSelection() {
            IStructuredSelection sel = (IStructuredSelection)this.tableViewer.getSelection();
            if (sel.isEmpty()) {
                return null;
            }
            return (IBean)sel.getFirstElement();
        }
    }
}

