/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.xml.beans.model;

import org.jboss.tools.cdi.xml.beans.model.CDIBeansConstants;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.XModelEntity;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.w3c.dom.Element;

public class CDIBeansLoaderUtil
extends XModelObjectLoaderUtil
implements CDIBeansConstants {
    protected boolean isSaveable(XModelEntity entity, String n, String v, String dv) {
        if (v == null) {
            return false;
        }
        if (v.length() == 0 || v.equals(dv)) {
            XAttribute attr = entity.getAttribute(n);
            return attr != null && "always".equals(attr.getProperty("save"));
        }
        return super.isSaveable(entity, n, v, dv);
    }

    public boolean save(Element parent, XModelObject o) {
        if (!this.needToSave(o)) {
            return true;
        }
        return super.save(parent, o);
    }

    protected boolean needToSave(XModelObject o) {
        String s = o.getModelEntity().getProperty("saveDefault");
        if (!"false".equals(s)) {
            return true;
        }
        if (this.hasSetAttributes(o)) {
            return true;
        }
        return o.getChildren().length > 0;
    }

    private boolean hasSetAttributes(XModelObject o) {
        XAttribute[] as = o.getModelEntity().getAttributes();
        int i = 0;
        while (i < as.length) {
            String v;
            String xml = as[i].getXMLName();
            if (xml != null && xml.length() != 0 && !"NAME".equals(xml) && (v = o.getAttributeValue(as[i].getName())) != null && v.length() > 0) {
                return true;
            }
            ++i;
        }
        String finalComment = o.get("#final-comment");
        return finalComment != null && finalComment.length() > 0;
    }

    public void loadAttributes(Element element, XModelObject o) {
        super.loadAttributes(element, o);
        String entity = o.getModelEntity().getName();
        if ("CDIWeldInclude".equals(entity) || "CDIWeldExclude".equals(entity)) {
            String pattern;
            String namePattern = "";
            String name = element.getAttribute("name");
            if (name != null && name.length() > 0) {
                namePattern = name;
                o.setAttributeValue("is regular expression", "false");
            }
            if ((pattern = element.getAttribute("pattern")) != null && pattern.length() > 0) {
                namePattern = pattern;
                o.setAttributeValue("is regular expression", "true");
            }
            o.setAttributeValue("name", namePattern);
        }
    }

    public void saveAttribute(Element element, String xmlname, String value) {
        int i = xmlname.indexOf(124);
        if (i >= 0) {
            return;
        }
        super.saveAttribute(element, xmlname, value);
    }

    public void saveAttributes(Element element, XModelObject o) {
        super.saveAttributes(element, o);
        String entity = o.getModelEntity().getName();
        if ("CDIWeldInclude".equals(entity) || "CDIWeldExclude".equals(entity)) {
            boolean isRegEx = "true".equals(o.getAttributeValue("is regular expression"));
            String attr = isRegEx ? "pattern" : "name";
            String name = o.getAttributeValue("name");
            element.setAttribute(attr, name);
        }
    }
}

